/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.UnencryptedDatabaseOnMobileCheckKt;

@K1only
@Rule(key="S6291")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/checks/UnencryptedDatabaseOnMobileCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitCallExpression", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nUnencryptedDatabaseOnMobileCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnencryptedDatabaseOnMobileCheck.kt\norg/sonarsource/kotlin/checks/UnencryptedDatabaseOnMobileCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1755#2,3:58\n*S KotlinDebug\n*F\n+ 1 UnencryptedDatabaseOnMobileCheck.kt\norg/sonarsource/kotlin/checks/UnencryptedDatabaseOnMobileCheck\n*L\n47#1:58,3\n*E\n"})
public final class UnencryptedDatabaseOnMobileCheck
extends AbstractCheck {
    @Override
    public void visitCallExpression(@NotNull KtCallExpression callExpression, @NotNull KotlinFileContext kotlinFileContext) {
        boolean bl;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        BindingContext bindingContext;
        block7: {
            Intrinsics.checkNotNullParameter(callExpression, "callExpression");
            Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
            bindingContext = kotlinFileContext.getBindingContext();
            resolvedCall2 = CallUtilKt.getResolvedCall(callExpression, bindingContext);
            Iterable $this$any$iv = UnencryptedDatabaseOnMobileCheckKt.access$getPROBLEMATIC_SIMPLE_CALLS$p();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FunMatcherImpl it = (FunMatcherImpl)element$iv;
                    boolean bl2 = false;
                    if (!FunMatcherKt.matches(resolvedCall2, it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = callExpression.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression, "Make sure using an unencrypted database is safe here.", null, null, 12, null);
        } else if (FunMatcherKt.matches(resolvedCall2, UnencryptedDatabaseOnMobileCheckKt.access$getPROBLEMATIC_REALM_CALL$p())) {
            Call call2 = CallUtilKt.getCall(callExpression, bindingContext);
            if ((call2 != null ? ApiExtensionsKt.findCallInPrecedingCallChain(call2, UnencryptedDatabaseOnMobileCheckKt.access$getREALM_ENC_KEY_FUN$p(), bindingContext) : null) == null) {
                AbstractCheck abstractCheck = this;
                KtExpression ktExpression = callExpression.getCalleeExpression();
                Intrinsics.checkNotNull(ktExpression);
                AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression, "Make sure using an unencrypted database is safe here.", null, null, 12, null);
            }
        }
    }
}

