/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@K1only
@Rule(key="S6615")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/checks/UselessAssignmentsCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nUselessAssignmentsCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UselessAssignmentsCheck.kt\norg/sonarsource/kotlin/checks/UselessAssignmentsCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1611#2,9:53\n1863#2:62\n1864#2:64\n1620#2:65\n1863#2,2:66\n1#3:63\n*S KotlinDebug\n*F\n+ 1 UselessAssignmentsCheck.kt\norg/sonarsource/kotlin/checks/UselessAssignmentsCheck\n*L\n32#1:53,9\n32#1:62\n32#1:64\n32#1:65\n49#1:66,2\n32#1:63\n*E\n"})
public final class UselessAssignmentsCheck
extends AbstractCheck {
    /*
     * WARNING - void declaration
     */
    @Override
    public void visitKtFile(@NotNull KtFile file2, @NotNull KotlinFileContext context) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(context, "context");
        Iterable $this$mapNotNull$iv = context.getDiagnostics();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair<PsiElement, String> pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Diagnostic diagnostic = (Diagnostic)element$iv$iv;
            boolean bl2 = false;
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual(diagnosticFactory, Errors.VARIABLE_WITH_REDUNDANT_INITIALIZER)) {
                pair = TuplesKt.to(diagnostic.getPsiElement(), "Remove this useless initializer.");
            } else if (Intrinsics.areEqual(diagnosticFactory, Errors.ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE)) {
                PsiElement psiElement = diagnostic.getPsiElement();
                Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
                PsiElement psiElement2 = ((KtNamedDeclaration)psiElement).getIdentifyingElement();
                Intrinsics.checkNotNull(psiElement2);
                pair = TuplesKt.to(psiElement2, "Remove this variable, which is assigned but never accessed.");
            } else {
                pair = Intrinsics.areEqual(diagnosticFactory, Errors.UNUSED_VALUE) ? TuplesKt.to(diagnostic.getPsiElement(), "The value assigned here is never used.") : (Intrinsics.areEqual(diagnosticFactory, Errors.UNUSED_CHANGED_VALUE) ? TuplesKt.to(diagnostic.getPsiElement(), "The value changed here is never used.") : null);
            }
            if (pair == null) continue;
            Pair<PsiElement, String> it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            PsiElement element = (PsiElement)pair.component1();
            String msg = (String)pair.component2();
            AbstractCheck.reportIssue$default((AbstractCheck)this, context, element, msg, null, null, 12, null);
        }
    }
}

