/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.K1only;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.Message;
import org.sonarsource.kotlin.checks.UselessNullCheckCheckKt;

@K1only
@Rule(key="S6619")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\tH\u0016J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J9\u0010\u0018\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00050\u001d\u00a2\u0006\u0002\b\u001fH\u0002J9\u0010 \u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00050\u001d\u00a2\u0006\u0002\b\u001fH\u0002JA\u0010!\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00050\u001d\u00a2\u0006\u0002\b\u001fH\u0002\u00a8\u0006$"}, d2={"Lorg/sonarsource/kotlin/checks/UselessNullCheckCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitBinaryExpression", "", "binaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitSafeQualifiedExpression", "safeDotExpression", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "kfc", "visitUnaryExpression", "unaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "visitCallExpression", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "operandComparedToNull", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bc", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "handleNullCheck", "expression", "issueLocation", "Lcom/intellij/psi/PsiElement;", "nullCheckTypeForMessage", "Lkotlin/Function1;", "Lorg/sonarsource/kotlin/api/reporting/Message;", "Lkotlin/ExtensionFunctionType;", "handleNonNullCheck", "raiseIssueIfUselessCheck", "comparesToNull", "", "sonar-kotlin-checks"})
public final class UselessNullCheckCheck
extends AbstractCheck {
    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression binaryExpression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(binaryExpression, "binaryExpression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        BindingContext bc = kotlinFileContext.getBindingContext();
        IElementType iElementType = binaryExpression.getOperationToken();
        if (Intrinsics.areEqual(iElementType, KtTokens.EQEQ)) {
            KtExpression ktExpression = this.operandComparedToNull(binaryExpression, bc);
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                this.handleNullCheck(kotlinFileContext, it, binaryExpression, UselessNullCheckCheck::visitBinaryExpression$lambda$1$lambda$0);
            }
        } else if (Intrinsics.areEqual(iElementType, KtTokens.EXCLEQ)) {
            KtExpression ktExpression = this.operandComparedToNull(binaryExpression, bc);
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                this.handleNonNullCheck(kotlinFileContext, it, binaryExpression, UselessNullCheckCheck::visitBinaryExpression$lambda$3$lambda$2);
            }
        } else if (Intrinsics.areEqual(iElementType, KtTokens.ELVIS)) {
            KtExpression ktExpression = binaryExpression.getLeft();
            Intrinsics.checkNotNull(ktExpression);
            KtOperationReferenceExpression ktOperationReferenceExpression = binaryExpression.getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
            this.handleNonNullCheck(kotlinFileContext, ktExpression, ktOperationReferenceExpression, UselessNullCheckCheck::visitBinaryExpression$lambda$4);
        }
    }

    @Override
    public void visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression safeDotExpression, @NotNull KotlinFileContext kfc) {
        Intrinsics.checkNotNullParameter(safeDotExpression, "safeDotExpression");
        Intrinsics.checkNotNullParameter(kfc, "kfc");
        KtExpression ktExpression = safeDotExpression.getReceiverExpression();
        PsiElement psiElement = safeDotExpression.getOperationTokenNode().getPsi();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getPsi(...)");
        this.handleNonNullCheck(kfc, ktExpression, psiElement, UselessNullCheckCheck::visitSafeQualifiedExpression$lambda$5);
    }

    @Override
    public void visitUnaryExpression(@NotNull KtUnaryExpression unaryExpression, @NotNull KotlinFileContext kfc) {
        Intrinsics.checkNotNullParameter(unaryExpression, "unaryExpression");
        Intrinsics.checkNotNullParameter(kfc, "kfc");
        if (Intrinsics.areEqual(unaryExpression.getOperationToken(), KtTokens.EXCLEXCL)) {
            KtExpression ktExpression = unaryExpression.getBaseExpression();
            Intrinsics.checkNotNull(ktExpression);
            KtSimpleNameExpression ktSimpleNameExpression = unaryExpression.getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "getOperationReference(...)");
            this.handleNonNullCheck(kfc, ktExpression, ktSimpleNameExpression, UselessNullCheckCheck::visitUnaryExpression$lambda$6);
        }
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression callExpression, @NotNull KotlinFileContext kfc) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(kfc, "kfc");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callExpression, kfc.getBindingContext());
        if (FunMatcherKt.matches(resolvedCall2, UselessNullCheckCheckKt.access$getNON_NULL_CHECK_FUNS$p())) {
            KtExpression ktExpression = CollectionsKt.first(ResolvedCallUtilKt.getArgumentByParameterIndex(callExpression, 0, kfc.getBindingContext())).getArgumentExpression();
            Intrinsics.checkNotNull(ktExpression);
            this.handleNonNullCheck(kfc, ktExpression, callExpression, arg_0 -> UselessNullCheckCheck.visitCallExpression$lambda$7(resolvedCall2, arg_0));
        }
    }

    private final KtExpression operandComparedToNull(KtBinaryExpression $this$operandComparedToNull, BindingContext bc) {
        KtExpression ktExpression = $this$operandComparedToNull.getLeft();
        if (ktExpression == null || (ktExpression = ApiExtensionsKt.predictRuntimeValueExpression$default(ktExpression, bc, null, 2, null)) == null) {
            return null;
        }
        KtExpression leftResolved = ktExpression;
        KtExpression ktExpression2 = $this$operandComparedToNull.getRight();
        if (ktExpression2 == null || (ktExpression2 = ApiExtensionsKt.predictRuntimeValueExpression$default(ktExpression2, bc, null, 2, null)) == null) {
            return null;
        }
        KtExpression rightResolved = ktExpression2;
        return PsiUtilsKt.isNull(leftResolved) ? $this$operandComparedToNull.getRight() : (PsiUtilsKt.isNull(rightResolved) ? $this$operandComparedToNull.getLeft() : null);
    }

    private final void handleNullCheck(KotlinFileContext kfc, KtExpression expression2, PsiElement issueLocation, Function1<? super Message, Unit> nullCheckTypeForMessage) {
        this.raiseIssueIfUselessCheck(kfc, expression2, issueLocation, true, nullCheckTypeForMessage);
    }

    private final void handleNonNullCheck(KotlinFileContext kfc, KtExpression expression2, PsiElement issueLocation, Function1<? super Message, Unit> nullCheckTypeForMessage) {
        this.raiseIssueIfUselessCheck(kfc, expression2, issueLocation, false, nullCheckTypeForMessage);
    }

    private final void raiseIssueIfUselessCheck(KotlinFileContext kfc, KtExpression expression2, PsiElement issueLocation, boolean comparesToNull, Function1<? super Message, Unit> nullCheckTypeForMessage) {
        String string2;
        if (UselessNullCheckCheckKt.access$mayBeAffectedByErrorInSemantics(kfc)) {
            return;
        }
        KtExpression resolvedExpression = ApiExtensionsKt.predictRuntimeValueExpression$default(expression2, kfc.getBindingContext(), null, 2, null);
        if (PsiUtilsKt.isNull(resolvedExpression)) {
            string2 = comparesToNull ? "succeeds" : "fails";
        } else if (UselessNullCheckCheckKt.access$isNotNullable(expression2, kfc.getBindingContext())) {
            string2 = comparesToNull ? "fails" : "succeeds";
        } else {
            return;
        }
        String result2 = string2;
        AbstractCheck.reportIssue$default((AbstractCheck)this, kfc, issueLocation, null, null, arg_0 -> UselessNullCheckCheck.raiseIssueIfUselessCheck$lambda$8(nullCheckTypeForMessage, result2, arg_0), 6, null);
    }

    private static final Unit visitBinaryExpression$lambda$1$lambda$0(Message $this$handleNullCheck) {
        Intrinsics.checkNotNullParameter($this$handleNullCheck, "$this$handleNullCheck");
        $this$handleNullCheck.unaryPlus("null check");
        return Unit.INSTANCE;
    }

    private static final Unit visitBinaryExpression$lambda$3$lambda$2(Message $this$handleNonNullCheck) {
        Intrinsics.checkNotNullParameter($this$handleNonNullCheck, "$this$handleNonNullCheck");
        $this$handleNonNullCheck.unaryPlus("non-null check");
        return Unit.INSTANCE;
    }

    private static final Unit visitBinaryExpression$lambda$4(Message $this$handleNonNullCheck) {
        Intrinsics.checkNotNullParameter($this$handleNonNullCheck, "$this$handleNonNullCheck");
        $this$handleNonNullCheck.unaryPlus("elvis operation ");
        $this$handleNonNullCheck.code("?:");
        return Unit.INSTANCE;
    }

    private static final Unit visitSafeQualifiedExpression$lambda$5(Message $this$handleNonNullCheck) {
        Intrinsics.checkNotNullParameter($this$handleNonNullCheck, "$this$handleNonNullCheck");
        $this$handleNonNullCheck.unaryPlus("null-safe access ");
        $this$handleNonNullCheck.code("?.");
        return Unit.INSTANCE;
    }

    private static final Unit visitUnaryExpression$lambda$6(Message $this$handleNonNullCheck) {
        Intrinsics.checkNotNullParameter($this$handleNonNullCheck, "$this$handleNonNullCheck");
        $this$handleNonNullCheck.unaryPlus("non-null assertion ");
        $this$handleNonNullCheck.code("!!");
        return Unit.INSTANCE;
    }

    private static final Unit visitCallExpression$lambda$7(ResolvedCall $resolvedCall, Message $this$handleNonNullCheck) {
        Intrinsics.checkNotNullParameter($this$handleNonNullCheck, "$this$handleNonNullCheck");
        $this$handleNonNullCheck.unaryPlus("non-null check ");
        ResolvedCall resolvedCall2 = $resolvedCall;
        Intrinsics.checkNotNull(resolvedCall2);
        String string2 = ((Named)resolvedCall2.getResultingDescriptor()).getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        $this$handleNonNullCheck.code(string2);
        return Unit.INSTANCE;
    }

    private static final Unit raiseIssueIfUselessCheck$lambda$8(Function1 $nullCheckTypeForMessage, String $result, Message $this$reportIssue) {
        Intrinsics.checkNotNullParameter($this$reportIssue, "$this$reportIssue");
        $this$reportIssue.unaryPlus("Remove this useless ");
        $nullCheckTypeForMessage.invoke($this$reportIssue);
        $this$reportIssue.unaryPlus(", it always " + $result + ".");
        return Unit.INSTANCE;
    }
}

