/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.externalreport.androidlint;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.sonarsource.analyzer.commons.xml.SafeStaxParserFactory;
import org.sonarsource.kotlin.externalreport.androidlint.AndroidLintXmlReportReaderKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/sonarsource/kotlin/externalreport/androidlint/AndroidLintXmlReportReader;", "", "consumer", "Lorg/sonarsource/kotlin/externalreport/androidlint/AndroidLintXmlReportReader$IssueConsumer;", "<init>", "(Lorg/sonarsource/kotlin/externalreport/androidlint/AndroidLintXmlReportReader$IssueConsumer;)V", "level", "", "id", "", "message", "file", "line", "read", "", "inputStream", "Ljava/io/InputStream;", "onEndElement", "onElement", "element", "Ljavax/xml/stream/events/StartElement;", "IssueConsumer", "Companion", "sonar-kotlin-external-linters"})
public final class AndroidLintXmlReportReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IssueConsumer consumer;
    private int level;
    @NotNull
    private String id;
    @NotNull
    private String message;
    @NotNull
    private String file;
    @NotNull
    private String line;

    private AndroidLintXmlReportReader(IssueConsumer consumer) {
        this.consumer = consumer;
        this.id = "";
        this.message = "";
        this.file = "";
        this.line = "";
    }

    private final void read(InputStream inputStream) throws XMLStreamException, IOException {
        XMLEventReader reader = SafeStaxParserFactory.createXMLInputFactory().createXMLEventReader(inputStream);
        while (reader.hasNext()) {
            int n;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                n = this.level;
                this.level = n + 1;
                StartElement startElement = event.asStartElement();
                Intrinsics.checkNotNullExpressionValue(startElement, "asStartElement(...)");
                this.onElement(startElement);
                continue;
            }
            if (!event.isEndElement()) continue;
            n = this.level;
            this.level = n + -1;
            this.onEndElement();
        }
    }

    private final void onEndElement() {
        if (this.level == 1) {
            this.consumer.onIssue(this.id, this.file, this.line, this.message);
            this.id = "";
            this.message = "";
            this.file = "";
            this.line = "";
        }
    }

    private final void onElement(StartElement element) {
        if (this.level == 1 && !Intrinsics.areEqual(AndroidLintXmlReportReaderKt.access$getISSUES_ELEMENT$p(), element.getName())) {
            throw new IOException("Unexpected document root '" + element.getName().getLocalPart() + "' instead of 'issues'.");
        }
        if (this.level == 2 && Intrinsics.areEqual(AndroidLintXmlReportReaderKt.access$getISSUE_ELEMENT$p(), element.getName())) {
            this.id = AndroidLintXmlReportReader.Companion.getAttributeValue(element, AndroidLintXmlReportReaderKt.access$getID_ATTRIBUTE$p());
            this.message = AndroidLintXmlReportReader.Companion.getAttributeValue(element, AndroidLintXmlReportReaderKt.access$getMESSAGE_ATTRIBUTE$p());
        } else if (this.level == 3 && Intrinsics.areEqual(AndroidLintXmlReportReaderKt.access$getLOCATION_ELEMENT$p(), element.getName()) && ((CharSequence)this.file).length() == 0) {
            this.file = AndroidLintXmlReportReader.Companion.getAttributeValue(element, AndroidLintXmlReportReaderKt.access$getFILE_ATTRIBUTE$p());
            this.line = AndroidLintXmlReportReader.Companion.getAttributeValue(element, AndroidLintXmlReportReaderKt.access$getLINE_ATTRIBUTE$p());
        }
    }

    public /* synthetic */ AndroidLintXmlReportReader(IssueConsumer consumer, DefaultConstructorMarker $constructor_marker) {
        this(consumer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/sonarsource/kotlin/externalreport/androidlint/AndroidLintXmlReportReader$Companion;", "", "<init>", "()V", "read", "", "inputStream", "Ljava/io/InputStream;", "consumer", "Lorg/sonarsource/kotlin/externalreport/androidlint/AndroidLintXmlReportReader$IssueConsumer;", "getAttributeValue", "", "element", "Ljavax/xml/stream/events/StartElement;", "attributeName", "Ljavax/xml/namespace/QName;", "sonar-kotlin-external-linters"})
    public static final class Companion {
        private Companion() {
        }

        public final void read(@NotNull InputStream inputStream, @NotNull IssueConsumer consumer) throws XMLStreamException, IOException {
            Intrinsics.checkNotNullParameter(inputStream, "inputStream");
            Intrinsics.checkNotNullParameter(consumer, "consumer");
            new AndroidLintXmlReportReader(consumer, null).read(inputStream);
        }

        private final String getAttributeValue(StartElement element, QName attributeName) {
            String string2;
            Attribute attribute;
            Attribute attribute2 = attribute = element.getAttributeByName(attributeName);
            if (attribute2 != null) {
                String string3 = attribute2.getValue();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "getValue(...)");
            } else {
                string2 = "";
            }
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H&\u00a8\u0006\t"}, d2={"Lorg/sonarsource/kotlin/externalreport/androidlint/AndroidLintXmlReportReader$IssueConsumer;", "", "onIssue", "", "id", "", "file", "line", "message", "sonar-kotlin-external-linters"})
    public static interface IssueConsumer {
        public void onIssue(@NotNull String var1, @NotNull String var2, @NotNull String var3, @NotNull String var4);
    }
}

