/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.externalreport.detekt;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.kotlin.api.frontend.AbstractPropertyHandlerSensor;
import org.sonarsource.kotlin.externalreport.common.CheckstyleFormatImporterWithRuleLoader;
import org.sonarsource.kotlin.externalreport.detekt.DetektRulesDefinition;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/sonarsource/kotlin/externalreport/detekt/DetektSensor;", "Lorg/sonarsource/kotlin/api/frontend/AbstractPropertyHandlerSensor;", "analysisWarnings", "Lorg/sonar/api/notifications/AnalysisWarnings;", "<init>", "(Lorg/sonar/api/notifications/AnalysisWarnings;)V", "reportConsumer", "Lkotlin/Function1;", "Ljava/io/File;", "", "context", "Lorg/sonar/api/batch/sensor/SensorContext;", "Companion", "sonar-kotlin-external-linters"})
public final class DetektSensor
extends AbstractPropertyHandlerSensor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOG = LoggerFactory.getLogger(DetektSensor.class);
    @NotNull
    public static final String LINTER_KEY = "detekt";
    @NotNull
    public static final String LINTER_NAME = "detekt";
    @NotNull
    private static final String DETEKT_PREFIX = "detekt.";
    @NotNull
    public static final String REPORT_PROPERTY_KEY = "sonar.kotlin.detekt.reportPaths";

    public DetektSensor(@NotNull AnalysisWarnings analysisWarnings) {
        Intrinsics.checkNotNullParameter(analysisWarnings, "analysisWarnings");
        super(analysisWarnings, "detekt", "detekt", REPORT_PROPERTY_KEY, "kotlin");
    }

    @Override
    @NotNull
    public Function1<File, Unit> reportConsumer(@NotNull SensorContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        return arg_0 -> DetektSensor.reportConsumer$lambda$0(context, arg_0);
    }

    private static final Unit reportConsumer$lambda$0(SensorContext $context, File reportPath) {
        Intrinsics.checkNotNullParameter(reportPath, "reportPath");
        new Companion.ReportImporter($context).importFile(reportPath);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/sonarsource/kotlin/externalreport/detekt/DetektSensor$Companion;", "", "<init>", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "LINTER_KEY", "", "LINTER_NAME", "DETEKT_PREFIX", "REPORT_PROPERTY_KEY", "ReportImporter", "sonar-kotlin-external-linters"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/externalreport/detekt/DetektSensor$Companion$ReportImporter;", "Lorg/sonarsource/kotlin/externalreport/common/CheckstyleFormatImporterWithRuleLoader;", "context", "Lorg/sonar/api/batch/sensor/SensorContext;", "<init>", "(Lorg/sonar/api/batch/sensor/SensorContext;)V", "createRuleKey", "Lorg/sonar/api/rule/RuleKey;", "source", "", "sonar-kotlin-external-linters"})
        private static final class ReportImporter
        extends CheckstyleFormatImporterWithRuleLoader {
            public ReportImporter(@NotNull SensorContext context) {
                Intrinsics.checkNotNullParameter(context, "context");
                super(context, "detekt", DetektRulesDefinition.Companion.getRULE_LOADER());
            }

            @Override
            @Nullable
            protected RuleKey createRuleKey(@NotNull String source) {
                Intrinsics.checkNotNullParameter(source, "source");
                if (!StringsKt.startsWith$default(source, DetektSensor.DETEKT_PREFIX, false, 2, null)) {
                    LOG.debug("Unexpected rule key without '{}' suffix: '{}'", (Object)DetektSensor.DETEKT_PREFIX, (Object)source);
                    return null;
                }
                String string2 = source.substring(7);
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                return super.createRuleKey(string2);
            }
        }
    }
}

