/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.gradle;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.slf4j.Logger;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scanner.fs.InputProject;
import org.sonarsource.analyzer.commons.ProgressReport;
import org.sonarsource.kotlin.api.common.KotlinLanguage;
import org.sonarsource.kotlin.api.sensors.AbstractKotlinSensor;
import org.sonarsource.kotlin.api.sensors.AbstractKotlinSensorExecuteContext;
import org.sonarsource.kotlin.api.visiting.KtChecksVisitor;
import org.sonarsource.kotlin.gradle.KotlinGradleCheckListKt;
import org.sonarsource.kotlin.gradle.KotlinGradleSensorKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J4\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/sonarsource/kotlin/gradle/KotlinGradleSensor;", "Lorg/sonarsource/kotlin/api/sensors/AbstractKotlinSensor;", "checkFactory", "Lorg/sonar/api/batch/rule/CheckFactory;", "language", "Lorg/sonarsource/kotlin/api/common/KotlinLanguage;", "<init>", "(Lorg/sonar/api/batch/rule/CheckFactory;Lorg/sonarsource/kotlin/api/common/KotlinLanguage;)V", "describe", "", "descriptor", "Lorg/sonar/api/batch/sensor/SensorDescriptor;", "getExecuteContext", "Lorg/sonarsource/kotlin/api/sensors/AbstractKotlinSensorExecuteContext;", "sensorContext", "Lorg/sonar/api/batch/sensor/SensorContext;", "filesToAnalyze", "", "Lorg/sonar/api/batch/fs/InputFile;", "progressReport", "Lorg/sonarsource/analyzer/commons/ProgressReport;", "filenames", "", "", "getFilesToAnalyse", "checkForMissingGradleSettings", "rootDirFile", "Ljava/io/File;", "sonar-kotlin-gradle"})
public final class KotlinGradleSensor
extends AbstractKotlinSensor {
    public KotlinGradleSensor(@NotNull CheckFactory checkFactory, @NotNull KotlinLanguage language) {
        Intrinsics.checkNotNullParameter(checkFactory, "checkFactory");
        Intrinsics.checkNotNullParameter((Object)language, "language");
        super(checkFactory, language, KotlinGradleCheckListKt.getKOTLIN_GRADLE_CHECKS());
    }

    public void describe(@NotNull SensorDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        descriptor2.onlyOnLanguage(this.getLanguage().getKey()).name("Gradle Sensor");
    }

    @Override
    @NotNull
    public AbstractKotlinSensorExecuteContext getExecuteContext(@NotNull SensorContext sensorContext, @NotNull Iterable<? extends InputFile> filesToAnalyze, @NotNull ProgressReport progressReport, @NotNull List<String> filenames) {
        Intrinsics.checkNotNullParameter(sensorContext, "sensorContext");
        Intrinsics.checkNotNullParameter(filesToAnalyze, "filesToAnalyze");
        Intrinsics.checkNotNullParameter(progressReport, "progressReport");
        Intrinsics.checkNotNullParameter(filenames, "filenames");
        List<KtChecksVisitor> list = CollectionsKt.listOf(new KtChecksVisitor(this.getChecks()));
        Logger logger = KotlinGradleSensorKt.access$getLOG$p();
        return new AbstractKotlinSensorExecuteContext(sensorContext, filesToAnalyze, progressReport, filenames, list, logger){
            private final BindingContext bindingContext;
            private final boolean doResolve;
            {
                Intrinsics.checkNotNull($super_call_param$2);
                super($sensorContext, $filesToAnalyze, $progressReport, $super_call_param$1, $filenames, $super_call_param$2);
                BindingContext bindingContext = BindingContext.EMPTY;
                Intrinsics.checkNotNullExpressionValue(bindingContext, "EMPTY");
                this.bindingContext = bindingContext;
            }

            public BindingContext getBindingContext() {
                return this.bindingContext;
            }

            public boolean getDoResolve() {
                return this.doResolve;
            }
        };
    }

    @Override
    @NotNull
    public Iterable<InputFile> getFilesToAnalyse(@NotNull SensorContext sensorContext) {
        Intrinsics.checkNotNullParameter(sensorContext, "sensorContext");
        FileSystem fileSystem = sensorContext.fileSystem();
        Intrinsics.checkNotNullExpressionValue(fileSystem, "fileSystem(...)");
        FileSystem fileSystem2 = fileSystem;
        FilePredicate[] filePredicateArray = new FilePredicate[]{fileSystem2.predicates().or(fileSystem2.predicates().hasFilename("build.gradle.kts"), fileSystem2.predicates().hasFilename("settings.gradle.kts"))};
        FilePredicate mainFilePredicate = fileSystem2.predicates().and(filePredicateArray);
        sensorContext.config().get("sonar.kotlin.gradleProjectRoot").ifPresent(arg_0 -> KotlinGradleSensor.getFilesToAnalyse$lambda$1(arg_0 -> KotlinGradleSensor.getFilesToAnalyse$lambda$0(this, sensorContext, arg_0), arg_0));
        Iterable iterable = fileSystem2.inputFiles(mainFilePredicate);
        Intrinsics.checkNotNullExpressionValue(iterable, "inputFiles(...)");
        return iterable;
    }

    private final void checkForMissingGradleSettings(File rootDirFile, SensorContext sensorContext) {
        RuleKey missingSettingsRuleKey = RuleKey.of((String)"kotlin", (String)"S6631");
        if (sensorContext.activeRules().find(missingSettingsRuleKey) == null) {
            return;
        }
        if (!FilesKt.resolve(rootDirFile, "settings.gradle").exists() && !FilesKt.resolve(rootDirFile, "settings.gradle.kts").exists()) {
            InputProject project = sensorContext.project();
            SensorContext $this$checkForMissingGradleSettings_u24lambda_u242 = sensorContext;
            boolean bl = false;
            $this$checkForMissingGradleSettings_u24lambda_u242.newIssue().forRule(missingSettingsRuleKey).at($this$checkForMissingGradleSettings_u24lambda_u242.newIssue().newLocation().on((InputComponent)project).message("Add a missing \"settings.gradle\" or \"settings.gradle.kts\" file.")).save();
        }
    }

    private static final Unit getFilesToAnalyse$lambda$0(KotlinGradleSensor this$0, SensorContext $sensorContext, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.checkForMissingGradleSettings(new File(it), $sensorContext);
        return Unit.INSTANCE;
    }

    private static final void getFilesToAnalyse$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

