/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.metrics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenEntry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0016H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/sonarsource/kotlin/metrics/CyclomaticComplexityVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "<init>", "()V", "complexityTrees", "", "Lcom/intellij/psi/PsiElement;", "", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitIfExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitLoopExpression", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "visitWhenEntry", "whenEntry", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "sonar-kotlin-metrics"})
public final class CyclomaticComplexityVisitor
extends KtTreeVisitorVoid {
    @NotNull
    private final List<PsiElement> complexityTrees = new ArrayList();

    @NotNull
    public final List<PsiElement> complexityTrees() {
        return CollectionsKt.toList((Iterable)this.complexityTrees);
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        if (function2.hasBody() && function2.getName() != null) {
            this.complexityTrees.add(function2);
        }
        super.visitNamedFunction(function2);
    }

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        PsiElement psiElement = expression2.getIfKeyword();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getIfKeyword(...)");
        this.complexityTrees.add(psiElement);
        super.visitIfExpression(expression2);
    }

    @Override
    public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
        Intrinsics.checkNotNullParameter(loopExpression, "loopExpression");
        this.complexityTrees.add(loopExpression);
        super.visitLoopExpression(loopExpression);
    }

    @Override
    public void visitWhenEntry(@NotNull KtWhenEntry whenEntry) {
        Intrinsics.checkNotNullParameter(whenEntry, "whenEntry");
        this.complexityTrees.add(whenEntry);
        super.visitWhenEntry(whenEntry);
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.ANDAND) || Intrinsics.areEqual(expression2.getOperationToken(), KtTokens.OROR)) {
            this.complexityTrees.add(expression2);
        }
        super.visitBinaryExpression(expression2);
    }
}

