/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.plugin.caching;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.logging.LoggerExtensionsKt;
import org.sonarsource.kotlin.plugin.caching.ContentHashCacheKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001d\u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/sonarsource/kotlin/plugin/caching/ContentHashCache;", "", "readCache", "Lorg/sonar/api/batch/sensor/cache/ReadCache;", "writeCache", "Lorg/sonar/api/batch/sensor/cache/WriteCache;", "<init>", "(Lorg/sonar/api/batch/sensor/cache/ReadCache;Lorg/sonar/api/batch/sensor/cache/WriteCache;)V", "hasDifferentContentCached", "", "inputFile", "Lorg/sonar/api/batch/fs/InputFile;", "write", "", "key", "", "hash", "", "read", "getHash", "kotlin.jvm.PlatformType", "(Lorg/sonar/api/batch/fs/InputFile;)[B", "Companion", "sonar-kotlin-plugin"})
@SourceDebugExtension(value={"SMAP\nContentHashCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentHashCache.kt\norg/sonarsource/kotlin/plugin/caching/ContentHashCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class ContentHashCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReadCache readCache;
    @NotNull
    private final WriteCache writeCache;

    private ContentHashCache(ReadCache readCache, WriteCache writeCache) {
        this.readCache = readCache;
        this.writeCache = writeCache;
    }

    public final boolean hasDifferentContentCached(@NotNull InputFile inputFile) {
        Intrinsics.checkNotNullParameter(inputFile, "inputFile");
        String key = ContentHashCacheKt.contentHashKey(inputFile);
        byte[] byArray = this.read(key);
        if (byArray != null) {
            byte[] cachedFileHash = byArray;
            boolean bl = false;
            byte[] inputFileHash = this.getHash(inputFile);
            boolean cacheContentIsEqual = MessageDigest.isEqual(inputFileHash, cachedFileHash);
            if (cacheContentIsEqual) {
                try {
                    this.writeCache.copyFromPrevious(key);
                    Logger logger = ContentHashCacheKt.access$getLOG$p();
                    Intrinsics.checkNotNullExpressionValue(logger, "access$getLOG$p(...)");
                    LoggerExtensionsKt.trace(logger, () -> ContentHashCache.hasDifferentContentCached$lambda$1$lambda$0(inputFile));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ContentHashCacheKt.access$getLOG$p().warn("Cannot copy key " + key + " from cache as it has already been written");
                }
                return false;
            }
        }
        byte[] byArray2 = this.getHash(inputFile);
        Intrinsics.checkNotNullExpressionValue(byArray2, "getHash(...)");
        this.write(key, byArray2);
        Logger logger = ContentHashCacheKt.access$getLOG$p();
        Intrinsics.checkNotNullExpressionValue(logger, "access$getLOG$p(...)");
        LoggerExtensionsKt.trace(logger, () -> ContentHashCache.hasDifferentContentCached$lambda$2(inputFile));
        return true;
    }

    private final void write(String key, byte[] hash) {
        try {
            this.writeCache.write(key, hash);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ContentHashCacheKt.access$getLOG$p().warn("Cache already contains key " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] read(String key) {
        byte[] byArray;
        if (this.readCache.contains(key)) {
            Closeable closeable = this.readCache.read(key);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                byte[] byArray2 = it.readAllBytes();
                byArray = byArray2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        } else {
            byArray = null;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] getHash(InputFile inputFile) {
        String string2 = inputFile.contents();
        Intrinsics.checkNotNullExpressionValue(string2, "contents(...)");
        Object object = string2;
        Object object2 = Charsets.UTF_8;
        byte[] byArray = ((String)object).getBytes((Charset)object2);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        object = new ByteArrayInputStream(byArray);
        object2 = null;
        try {
            Object it = (ByteArrayInputStream)object;
            boolean bl = false;
            it = ((ByteArrayInputStream)it).readAllBytes();
        }
        catch (Throwable it) {
            object2 = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        Object it = it;
        boolean bl = false;
        return ContentHashCacheKt.access$getMessageDigest$p().digest((byte[])it);
    }

    private static final String hasDifferentContentCached$lambda$1$lambda$0(InputFile $inputFile) {
        return "Cache contained same hash for file " + $inputFile.filename();
    }

    private static final String hasDifferentContentCached$lambda$2(InputFile $inputFile) {
        return "Cache contained a different hash for file " + $inputFile.filename();
    }

    public /* synthetic */ ContentHashCache(ReadCache readCache, WriteCache writeCache, DefaultConstructorMarker $constructor_marker) {
        this(readCache, writeCache);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/sonarsource/kotlin/plugin/caching/ContentHashCache$Companion;", "", "<init>", "()V", "of", "Lorg/sonarsource/kotlin/plugin/caching/ContentHashCache;", "ctx", "Lorg/sonar/api/batch/sensor/SensorContext;", "sonar-kotlin-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ContentHashCache of(@NotNull SensorContext ctx) {
            ContentHashCache contentHashCache;
            Intrinsics.checkNotNullParameter(ctx, "ctx");
            if (ApiExtensionsKt.hasCacheEnabled(ctx)) {
                ContentHashCacheKt.access$getLOG$p().debug("Content hash cache was initialized");
                ReadCache readCache = ctx.previousCache();
                Intrinsics.checkNotNullExpressionValue(readCache, "previousCache(...)");
                WriteCache writeCache = ctx.nextCache();
                Intrinsics.checkNotNullExpressionValue(writeCache, "nextCache(...)");
                contentHashCache = new ContentHashCache(readCache, writeCache, null);
            } else {
                ContentHashCacheKt.access$getLOG$p().debug("Content hash cache is disabled");
                contentHashCache = null;
            }
            return contentHashCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

