/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.surefire;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonarsource.kotlin.surefire.KotlinResourcesLocator;
import org.sonarsource.kotlin.surefire.StaxParser;
import org.sonarsource.kotlin.surefire.data.UnitTestClassReport;
import org.sonarsource.kotlin.surefire.data.UnitTestIndex;

@ScannerSide
public class KotlinSurefireParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(KotlinSurefireParser.class);
    private final KotlinResourcesLocator kotlinResourcesLocator;

    public KotlinSurefireParser(KotlinResourcesLocator kotlinResourcesLocator) {
        this.kotlinResourcesLocator = kotlinResourcesLocator;
    }

    public void collect(SensorContext context, List<File> reportsDirs, boolean reportDirSetByUser) {
        List<File> xmlFiles = KotlinSurefireParser.getReports(reportsDirs, reportDirSetByUser);
        if (!xmlFiles.isEmpty()) {
            this.parseFiles(context, xmlFiles);
        }
    }

    private static List<File> getReports(List<File> dirs, boolean reportDirSetByUser) {
        return dirs.stream().map(dir -> KotlinSurefireParser.getReports(dir, reportDirSetByUser)).flatMap(Arrays::stream).collect(Collectors.toList());
    }

    private static File[] getReports(File dir, boolean reportDirSetByUser) {
        if (!dir.isDirectory()) {
            if (reportDirSetByUser) {
                LOGGER.error("Reports path not found or is not a directory: {}", (Object)dir.getAbsolutePath());
            }
            return new File[0];
        }
        File[] unitTestResultFiles = KotlinSurefireParser.findXMLFilesStartingWith(dir, "TEST-");
        if (unitTestResultFiles.length == 0) {
            unitTestResultFiles = KotlinSurefireParser.findXMLFilesStartingWith(dir, "TESTS-");
        }
        if (unitTestResultFiles.length == 0) {
            LOGGER.warn("Reports path contains no files matching TEST-.*.xml : {}", (Object)dir.getAbsolutePath());
        }
        return unitTestResultFiles;
    }

    private static File[] findXMLFilesStartingWith(File dir, String fileNameStart) {
        return dir.listFiles((parentDir, name) -> name.startsWith(fileNameStart) && name.endsWith(".xml"));
    }

    private void parseFiles(SensorContext context, List<File> reports) {
        UnitTestIndex index = new UnitTestIndex();
        KotlinSurefireParser.parseFiles(reports, index);
        KotlinSurefireParser.sanitize(index);
        this.save(index, context);
    }

    private static void parseFiles(List<File> reports, UnitTestIndex index) {
        StaxParser parser = new StaxParser(index);
        for (File report2 : reports) {
            try {
                parser.parse(report2);
            }
            catch (XMLStreamException e) {
                throw new IllegalStateException("Fail to parse the Surefire report: " + report2, e);
            }
        }
    }

    private static void sanitize(UnitTestIndex index) {
        for (String classname : index.getClassnames()) {
            if (!classname.contains("$")) continue;
            String parentClassName = classname.substring(0, classname.indexOf(36));
            index.merge(classname, parentClassName);
        }
    }

    private void save(UnitTestIndex index, SensorContext context) {
        long negativeTimeTestNumber = 0L;
        for (Map.Entry<String, UnitTestClassReport> entry : index.getIndexByClassname().entrySet()) {
            UnitTestClassReport report2 = entry.getValue();
            if (report2.getTests() <= 0) continue;
            negativeTimeTestNumber += report2.getNegativeTimeTestNumber();
            Optional<InputFile> inputFile = this.kotlinResourcesLocator.findResourceByClassName(entry.getKey());
            if (inputFile.isPresent()) {
                KotlinSurefireParser.save(report2, inputFile.get(), context);
                continue;
            }
            LOGGER.warn("Resource not found: {} under the directory {} while reading test reports. Please, make sure your \"sonar.junit.reportPaths\" property is configured properly", (Object)entry.getKey(), (Object)context.fileSystem().baseDir().getPath());
        }
        if (negativeTimeTestNumber > 0L) {
            LOGGER.warn("There is {} test(s) reported with negative time by surefire, total duration may not be accurate.", (Object)negativeTimeTestNumber);
        }
    }

    private static void save(UnitTestClassReport report2, InputFile inputFile, SensorContext context) {
        int testsCount = report2.getTests() - report2.getSkipped();
        KotlinSurefireParser.saveMeasure(context, inputFile, CoreMetrics.SKIPPED_TESTS, report2.getSkipped());
        KotlinSurefireParser.saveMeasure(context, inputFile, CoreMetrics.TESTS, testsCount);
        KotlinSurefireParser.saveMeasure(context, inputFile, CoreMetrics.TEST_ERRORS, report2.getErrors());
        KotlinSurefireParser.saveMeasure(context, inputFile, CoreMetrics.TEST_FAILURES, report2.getFailures());
        KotlinSurefireParser.saveMeasure(context, inputFile, CoreMetrics.TEST_EXECUTION_TIME, report2.getDurationMilliseconds());
    }

    private static <T extends Serializable> void saveMeasure(SensorContext context, InputFile inputFile, Metric<T> metric, T value2) {
        context.newMeasure().forMetric(metric).on((InputComponent)inputFile).withValue(value2).save();
    }
}

