/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.surefire;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.sonarsource.analyzer.commons.xml.SafeStaxParserFactory;
import org.sonarsource.kotlin.surefire.data.SurefireStaxHandler;
import org.sonarsource.kotlin.surefire.data.UnitTestIndex;

public class StaxParser {
    private SMInputFactory inf;
    private SurefireStaxHandler streamHandler;

    public StaxParser(UnitTestIndex index) {
        this.streamHandler = new SurefireStaxHandler(index);
        XMLInputFactory xmlInputFactory = SafeStaxParserFactory.createXMLInputFactory();
        if (xmlInputFactory instanceof WstxInputFactory) {
            WstxInputFactory wstxInputfactory = (WstxInputFactory)xmlInputFactory;
            wstxInputfactory.configureForLowMemUsage();
            wstxInputfactory.getConfig().setUndeclaredEntityResolver((publicID, systemID, baseURI, namespace) -> namespace);
            wstxInputfactory.setProperty("com.ctc.wstx.maxAttributeSize", Integer.MAX_VALUE);
        }
        this.inf = new SMInputFactory(xmlInputFactory);
    }

    public void parse(File xmlFile) throws XMLStreamException {
        try (FileInputStream input = new FileInputStream(xmlFile);){
            this.parse(this.inf.rootElementCursor(input));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    private void parse(SMHierarchicCursor rootCursor) throws XMLStreamException {
        try {
            this.streamHandler.stream(rootCursor);
        }
        finally {
            rootCursor.getStreamReader().closeCompletely();
        }
    }
}

