/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.surefire.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sonarsource.kotlin.surefire.data.UnitTestClassReport;

public class UnitTestIndex {
    private Map<String, UnitTestClassReport> indexByClassname = new HashMap<String, UnitTestClassReport>();

    public UnitTestClassReport index(String classname) {
        return this.indexByClassname.computeIfAbsent(classname, name -> new UnitTestClassReport());
    }

    public UnitTestClassReport get(String classname) {
        return this.indexByClassname.get(classname);
    }

    public Set<String> getClassnames() {
        return new HashSet<String>(this.indexByClassname.keySet());
    }

    public Map<String, UnitTestClassReport> getIndexByClassname() {
        return this.indexByClassname;
    }

    public int size() {
        return this.indexByClassname.size();
    }

    public UnitTestClassReport merge(String classname, String intoClassname) {
        UnitTestClassReport from2 = this.indexByClassname.get(classname);
        if (from2 != null) {
            UnitTestClassReport to = this.index(intoClassname);
            to.add(from2);
            this.indexByClassname.remove(classname);
            return to;
        }
        return null;
    }

    public void remove(String classname) {
        this.indexByClassname.remove(classname);
    }
}

