/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.Weigher;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

final class SerializationProxy<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    boolean async;
    boolean weakKeys;
    boolean weakValues;
    boolean softValues;
    boolean isRecordingStats;
    long refreshAfterWriteNanos;
    long expiresAfterWriteNanos;
    long expiresAfterAccessNanos;
    long maximumSize = -1L;
    long maximumWeight = -1L;
    Ticker ticker;
    Expiry<?, ?> expiry;
    Weigher<?, ?> weigher;
    CacheWriter<?, ?> writer;
    AsyncCacheLoader<?, ?> loader;
    RemovalListener<?, ?> removalListener;

    SerializationProxy() {
    }

    Caffeine<Object, Object> recreateCaffeine() {
        Caffeine<Object, Object> builder2 = Caffeine.newBuilder();
        if (this.ticker != null) {
            builder2.ticker(this.ticker);
        }
        if (this.isRecordingStats) {
            builder2.recordStats();
        }
        if (this.maximumSize != -1L) {
            builder2.maximumSize(this.maximumSize);
        }
        if (this.weigher != null) {
            builder2.maximumWeight(this.maximumWeight);
            builder2.weigher(this.weigher);
        }
        if (this.expiry != null) {
            builder2.expireAfter(this.expiry);
        }
        if (this.expiresAfterWriteNanos > 0L) {
            builder2.expireAfterWrite(this.expiresAfterWriteNanos, TimeUnit.NANOSECONDS);
        }
        if (this.expiresAfterAccessNanos > 0L) {
            builder2.expireAfterAccess(this.expiresAfterAccessNanos, TimeUnit.NANOSECONDS);
        }
        if (this.refreshAfterWriteNanos > 0L) {
            builder2.refreshAfterWrite(this.refreshAfterWriteNanos, TimeUnit.NANOSECONDS);
        }
        if (this.weakKeys) {
            builder2.weakKeys();
        }
        if (this.weakValues) {
            builder2.weakValues();
        }
        if (this.softValues) {
            builder2.softValues();
        }
        if (this.removalListener != null) {
            builder2.removalListener(this.removalListener);
        }
        if (this.writer != null && this.writer != CacheWriter.disabledWriter()) {
            if (this.writer instanceof Caffeine.CacheWriterAdapter) {
                builder2.evictionListener(((Caffeine.CacheWriterAdapter)this.writer).delegate);
            } else {
                builder2.writer(this.writer);
            }
        }
        return builder2;
    }

    Object readResolve() {
        Caffeine<Object, Object> builder2 = this.recreateCaffeine();
        if (this.async) {
            if (this.loader == null) {
                return builder2.buildAsync();
            }
            AsyncCacheLoader<?, ?> cacheLoader = this.loader;
            return builder2.buildAsync(cacheLoader);
        }
        if (this.loader == null) {
            return builder2.build();
        }
        CacheLoader cacheLoader = (CacheLoader)this.loader;
        return builder2.build(cacheLoader);
    }
}

