/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import java.util.Optional;
import java.util.Set;

public interface ValueGraph<N, V> {
    public Set<N> nodes();

    public Set<EndpointPair<N>> edges();

    public Graph<N> asGraph();

    public boolean isDirected();

    public boolean allowsSelfLoops();

    public ElementOrder<N> nodeOrder();

    public ElementOrder<N> incidentEdgeOrder();

    public Set<N> adjacentNodes(N var1);

    public Set<N> predecessors(N var1);

    public Set<N> successors(N var1);

    public Set<EndpointPair<N>> incidentEdges(N var1);

    public int degree(N var1);

    public int inDegree(N var1);

    public int outDegree(N var1);

    public boolean hasEdgeConnecting(N var1, N var2);

    public boolean hasEdgeConnecting(EndpointPair<N> var1);

    public Optional<V> edgeValue(N var1, N var2);

    public Optional<V> edgeValue(EndpointPair<N> var1);

    public V edgeValueOrDefault(N var1, N var2, V var3);

    public V edgeValueOrDefault(EndpointPair<N> var1, V var2);

    public boolean equals(Object var1);

    public int hashCode();
}

