/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.Node;
import com.google.gwt.dev.js.rhino.TokenStream;

public class IRFactory {
    private TokenStream ts;

    public IRFactory(TokenStream ts) {
        this.ts = ts;
    }

    public Node createScript(Node body2) {
        Node result2 = new Node(147);
        Node children2 = body2.getFirstChild();
        if (children2 != null) {
            result2.addChildrenToBack(children2);
        }
        return result2;
    }

    public Node createLeaf(int nodeType, CodePosition location) {
        return new Node(nodeType, location);
    }

    public Node createLeaf(int nodeType, int nodeOp, CodePosition location) {
        return new Node(nodeType, nodeOp, location);
    }

    public int getLeafType(Node leaf) {
        return leaf.getType();
    }

    public Node createSwitch(CodePosition location) {
        return new Node(115, location);
    }

    public Node createVariables(CodePosition location) {
        return new Node(123, location);
    }

    public Node createExprStatement(Object expr, CodePosition location) {
        return new Node(140, (Node)expr, location);
    }

    public Node createName(String name, CodePosition location) {
        return Node.newString(44, name, location);
    }

    public Node createString(String string2, CodePosition location) {
        return Node.newString(string2, location);
    }

    public Node createIntNumber(double number, CodePosition location) {
        return Node.newIntNumber(number, location);
    }

    public Node createNumber(double number, CodePosition location) {
        return Node.newNumber(number, location);
    }

    public Node createCatch(Node varName, Node catchCond, Node stmts, CodePosition location) {
        if (catchCond == null) {
            catchCond = new Node(109, 52, location);
        }
        return new Node(125, varName, catchCond, stmts, location);
    }

    public Node createThrow(Node expr, CodePosition location) {
        return new Node(62, expr, location);
    }

    public Node createReturn(Node expr, CodePosition location) {
        return expr == null ? new Node(5, location) : new Node(5, expr, location);
    }

    public Node createLabel(Node label, CodePosition location) {
        Node result2 = new Node(136, location);
        result2.addChildToBack(label);
        return result2;
    }

    public Node createBreak(Node label, CodePosition location) {
        Node result2 = new Node(121, location);
        if (label == null) {
            return result2;
        }
        result2.addChildToBack(label);
        return result2;
    }

    public Node createContinue(Node label, CodePosition location) {
        Node result2 = new Node(122, location);
        if (label == null) {
            return result2;
        }
        result2.addChildToBack(label);
        return result2;
    }

    public Node createDebugger(CodePosition location) {
        Node result2 = new Node(146, location);
        return result2;
    }

    public Node createBlock(CodePosition location) {
        return new Node(133, location);
    }

    public Node createFunction(Node name, Node args, Node statements, boolean isGenerator, CodePosition location) {
        if (name == null) {
            name = this.createName("", location);
        }
        return new Node(isGenerator ? 149 : 110, name, args, statements, location);
    }

    public Node createWhile(Node cond, Node body2, CodePosition location) {
        return new Node(118, cond, body2, location);
    }

    public Node createDoWhile(Node body2, Node cond, CodePosition location) {
        return new Node(119, body2, cond, location);
    }

    public Node createFor(Node init, Node test, Node incr, Node body2, CodePosition location) {
        return new Node(120, init, test, incr, body2, location);
    }

    public Node createForIn(Node lhs, Node obj, Node body2, CodePosition location) {
        return new Node(120, lhs, obj, body2, location);
    }

    public Node createTryCatchFinally(Node tryblock, Node catchblocks, Node finallyblock, CodePosition location) {
        if (finallyblock == null) {
            return new Node(75, tryblock, catchblocks, location);
        }
        return new Node(75, tryblock, catchblocks, finallyblock, location);
    }

    public Node createWith(Node obj, Node body2, CodePosition location) {
        return new Node(124, obj, body2, location);
    }

    public Node createArrayLiteral(Node obj) {
        return obj;
    }

    public Node createObjectLiteral(Node obj) {
        return obj;
    }

    public Node createRegExp(String string2, String flags, CodePosition location) {
        return flags.length() == 0 ? new Node(56, Node.newString(string2, location), location) : new Node(56, Node.newString(string2, location), Node.newString(flags, location), location);
    }

    public Node createIf(Node cond, Node ifTrue, Node ifFalse, CodePosition location) {
        if (ifFalse == null) {
            return new Node(113, cond, ifTrue, location);
        }
        return new Node(113, cond, ifTrue, ifFalse, location);
    }

    public Node createTernary(Node cond, Node ifTrue, Node ifFalse, CodePosition location) {
        return new Node(98, cond, ifTrue, ifFalse, location);
    }

    public Node createUnary(int nodeType, Node child, CodePosition location) {
        return new Node(nodeType, child, location);
    }

    public Node createUnary(int nodeType, int nodeOp, Node child, CodePosition location) {
        return new Node(nodeType, child, nodeOp, location);
    }

    public Node createBinary(int nodeType, Node left, Node right, CodePosition location) {
        switch (nodeType) {
            case 108: {
                nodeType = 39;
                right.setType(46);
                break;
            }
            case 90: {
                nodeType = 41;
            }
        }
        return new Node(nodeType, left, right, location);
    }

    public Node createBinary(int nodeType, int nodeOp, Node left, Node right, CodePosition location) {
        if (nodeType == 97) {
            return this.createAssignment(nodeOp, left, right, location);
        }
        return new Node(nodeType, left, right, nodeOp, location);
    }

    public Node createAssignment(int nodeOp, Node left, Node right, CodePosition location) {
        int nodeType = left.getType();
        switch (nodeType) {
            case 39: 
            case 41: 
            case 44: {
                break;
            }
            default: {
                this.ts.reportSyntaxError("msg.bad.lhs.assign", null);
            }
        }
        return new Node(97, left, right, nodeOp, location);
    }
}

