/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DataLoader;
import com.intellij.util.lang.ZipFilePool;
import java.io.InputStream;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0007\u001a\u00020\u00068\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0019"}, d2={"Lcom/intellij/ide/plugins/ImmutableZipFileDataLoader;", "Lcom/intellij/ide/plugins/DataLoader;", "Lcom/intellij/util/lang/ZipFilePool$EntryResolver;", "resolver", "Ljava/nio/file/Path;", "zipPath", "Lcom/intellij/util/lang/ZipFilePool;", "pool", "<init>", "(Lcom/intellij/util/lang/ZipFilePool$EntryResolver;Ljava/nio/file/Path;Lcom/intellij/util/lang/ZipFilePool;)V", "jarFile", "", "isExcludedFromSubSearch", "(Ljava/nio/file/Path;)Z", "", "path", "Ljava/io/InputStream;", "load", "(Ljava/lang/String;)Ljava/io/InputStream;", "toString", "()Ljava/lang/String;", "Lcom/intellij/util/lang/ZipFilePool;", "getPool", "()Lcom/intellij/util/lang/ZipFilePool;", "Lcom/intellij/util/lang/ZipFilePool$EntryResolver;", "Ljava/nio/file/Path;"})
public final class ImmutableZipFileDataLoader
implements DataLoader {
    @NotNull
    private final ZipFilePool.EntryResolver resolver;
    @NotNull
    private final Path zipPath;
    @NotNull
    private final ZipFilePool pool;

    public ImmutableZipFileDataLoader(@NotNull ZipFilePool.EntryResolver resolver, @NotNull Path zipPath, @NotNull ZipFilePool pool) {
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Intrinsics.checkNotNullParameter(zipPath, "zipPath");
        Intrinsics.checkNotNullParameter(pool, "pool");
        this.resolver = resolver;
        this.zipPath = zipPath;
        this.pool = pool;
    }

    @Override
    @NotNull
    public ZipFilePool getPool() {
        return this.pool;
    }

    @Override
    @Nullable
    public InputStream load(@NotNull String path) {
        String string2;
        Intrinsics.checkNotNullParameter(path, "path");
        if (path.charAt(0) == '/') {
            String string3 = path.substring(1);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        } else {
            string2 = path;
        }
        return this.resolver.loadZipEntry(string2);
    }

    @Override
    public boolean isExcludedFromSubSearch(@NotNull Path jarFile) {
        Intrinsics.checkNotNullParameter(jarFile, "jarFile");
        return jarFile == this.zipPath;
    }

    @Override
    @NotNull
    public String toString() {
        return this.resolver.toString();
    }
}

