/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DataLoader;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.RawPluginDescriptor;
import com.intellij.ide.plugins.ReadModuleContext;
import com.intellij.ide.plugins.XmlReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.lang.ZipFilePool;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J9\u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J9\u0010\u0014\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0012J1\u0010\u0016\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017J3\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0017R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0019"}, d2={"Lcom/intellij/ide/plugins/PluginXmlPathResolver;", "Lcom/intellij/ide/plugins/PathResolver;", "", "Ljava/nio/file/Path;", "pluginJarFiles", "<init>", "(Ljava/util/List;)V", "Lcom/intellij/ide/plugins/RawPluginDescriptor;", "readInto", "Lcom/intellij/ide/plugins/ReadModuleContext;", "readContext", "Lcom/intellij/ide/plugins/DataLoader;", "dataLoader", "", "relativePath", "includeBase", "", "findInJarFiles", "(Lcom/intellij/ide/plugins/RawPluginDescriptor;Lcom/intellij/ide/plugins/ReadModuleContext;Lcom/intellij/ide/plugins/DataLoader;Ljava/lang/String;Ljava/lang/String;)Z", "base", "loadXIncludeReference", "path", "resolveModuleFile", "(Lcom/intellij/ide/plugins/ReadModuleContext;Lcom/intellij/ide/plugins/DataLoader;Ljava/lang/String;Lcom/intellij/ide/plugins/RawPluginDescriptor;)Lcom/intellij/ide/plugins/RawPluginDescriptor;", "resolvePath", "Ljava/util/List;", "Companion"})
public final class PluginXmlPathResolver
implements PathResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Path> pluginJarFiles;
    @NotNull
    public static final PathResolver DEFAULT_PATH_RESOLVER;

    public PluginXmlPathResolver(@NotNull List<? extends Path> pluginJarFiles) {
        Intrinsics.checkNotNullParameter(pluginJarFiles, "pluginJarFiles");
        this.pluginJarFiles = pluginJarFiles;
    }

    @Override
    public boolean loadXIncludeReference(@NotNull RawPluginDescriptor readInto, @NotNull ReadModuleContext readContext, @NotNull DataLoader dataLoader, @Nullable String base, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter(readInto, "readInto");
        Intrinsics.checkNotNullParameter(readContext, "readContext");
        Intrinsics.checkNotNullParameter(dataLoader, "dataLoader");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        String path = Companion.toLoadPath$intellij_platform_core_impl(relativePath, base);
        try {
            Object object = dataLoader.load(path);
            if (object != null) {
                InputStream it = object;
                boolean bl = false;
                XmlReader.readModuleDescriptor(it, readContext, (PathResolver)this, dataLoader, Companion.getChildBase$intellij_platform_core_impl(base, relativePath), readInto, null);
                return true;
            }
            object = Companion.getChildBase$intellij_platform_core_impl(base, relativePath);
            if (this.findInJarFiles(readInto, readContext, dataLoader, path, (String)object)) {
                return true;
            }
            if (StringsKt.startsWith$default(path, "META-INF/", false, 2, null) && (object = PluginXmlPathResolver.class.getClassLoader().getResourceAsStream(path)) != null) {
                Object it = object;
                boolean bl = false;
                XmlReader.readModuleDescriptor((InputStream)it, readContext, (PathResolver)this, dataLoader, null, readInto, null);
                return true;
            }
        }
        catch (Throwable e) {
            throw new IOException("Exception " + e.getMessage() + " while loading " + path, e);
        }
        return false;
    }

    @Override
    @Nullable
    public RawPluginDescriptor resolvePath(@NotNull ReadModuleContext readContext, @NotNull DataLoader dataLoader, @NotNull String relativePath, @Nullable RawPluginDescriptor readInto) {
        RawPluginDescriptor result2;
        Intrinsics.checkNotNullParameter(readContext, "readContext");
        Intrinsics.checkNotNullParameter(dataLoader, "dataLoader");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        String path = Companion.toLoadPath$intellij_platform_core_impl(relativePath, null);
        InputStream inputStream = dataLoader.load(path);
        if (inputStream != null) {
            InputStream it = inputStream;
            boolean bl = false;
            return XmlReader.readModuleDescriptor(it, readContext, (PathResolver)this, dataLoader, null, readInto, null);
        }
        RawPluginDescriptor rawPluginDescriptor = readInto;
        if (rawPluginDescriptor == null) {
            rawPluginDescriptor = new RawPluginDescriptor();
        }
        if (this.findInJarFiles(result2 = rawPluginDescriptor, readContext, dataLoader, path, null)) {
            return result2;
        }
        if (StringsKt.startsWith$default(relativePath, "intellij.", false, 2, null)) {
            throw new RuntimeException("Cannot resolve " + path + " (dataLoader=" + dataLoader + ')');
        }
        return null;
    }

    @Override
    @NotNull
    public RawPluginDescriptor resolveModuleFile(@NotNull ReadModuleContext readContext, @NotNull DataLoader dataLoader, @NotNull String path, @Nullable RawPluginDescriptor readInto) {
        Intrinsics.checkNotNullParameter(readContext, "readContext");
        Intrinsics.checkNotNullParameter(dataLoader, "dataLoader");
        Intrinsics.checkNotNullParameter(path, "path");
        InputStream input = dataLoader.load(path);
        if (input == null) {
            if (Intrinsics.areEqual(path, "intellij.profiler.clion")) {
                RawPluginDescriptor descriptor2 = new RawPluginDescriptor();
                descriptor2.package = "com.intellij.profiler.clion";
                return descriptor2;
            }
            throw new RuntimeException("Cannot resolve " + path + " (dataLoader=" + dataLoader + ", pluginJarFiles=" + CollectionsKt.joinToString$default(this.pluginJarFiles, "\n  ", null, null, 0, null, null, 62, null) + ')');
        }
        return XmlReader.readModuleDescriptor(input, readContext, (PathResolver)this, dataLoader, null, readInto, null);
    }

    private final boolean findInJarFiles(RawPluginDescriptor readInto, ReadModuleContext readContext, DataLoader dataLoader, String relativePath, String includeBase) {
        ZipFilePool pool = dataLoader.getPool();
        for (Path jarFile : this.pluginJarFiles) {
            ZipFilePool.EntryResolver entryResolver;
            if (dataLoader.isExcludedFromSubSearch(jarFile)) continue;
            if (pool == null) {
                if (!PluginXmlPathResolver.Companion.loadUsingZipFile(readInto, readContext, this, dataLoader, jarFile, relativePath, includeBase)) continue;
                return true;
            }
            try {
                entryResolver = pool.load(jarFile);
            }
            catch (IOException e) {
                Logger.getInstance(PluginXmlPathResolver.class).error("Corrupted jar file: " + jarFile, e);
                continue;
            }
            Object object = entryResolver;
            Intrinsics.checkNotNull(object);
            Object resolver = object;
            if ((object = resolver.loadZipEntry(relativePath)) == null) continue;
            Object it = object;
            boolean bl = false;
            XmlReader.readModuleDescriptor((InputStream)it, readContext, (PathResolver)this, dataLoader, includeBase, readInto, ((Object)jarFile).toString());
            return true;
        }
        return false;
    }

    static {
        List list = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list, "emptyList(...)");
        DEFAULT_PATH_RESOLVER = new PluginXmlPathResolver(list);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\tJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\fJB\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0002J\u001f\u0010\u0019\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u001aR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/plugins/PluginXmlPathResolver$Companion;", "", "()V", "DEFAULT_PATH_RESOLVER", "Lcom/intellij/ide/plugins/PathResolver;", "getChildBase", "", "base", "relativePath", "getChildBase$intellij_platform_core_impl", "getParentPath", "path", "getParentPath$intellij_platform_core_impl", "loadUsingZipFile", "", "readInto", "Lcom/intellij/ide/plugins/RawPluginDescriptor;", "readContext", "Lcom/intellij/ide/plugins/ReadModuleContext;", "pathResolver", "dataLoader", "Lcom/intellij/ide/plugins/DataLoader;", "jarFile", "Ljava/nio/file/Path;", "includeBase", "toLoadPath", "toLoadPath$intellij_platform_core_impl", "intellij.platform.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean loadUsingZipFile(RawPluginDescriptor readInto, ReadModuleContext readContext, PathResolver pathResolver, DataLoader dataLoader, Path jarFile, String relativePath, String includeBase) {
            try (ZipFile zipFile = new ZipFile(jarFile.toFile());){
                String string2;
                if (StringsKt.startsWith$default(relativePath, "/", false, 2, null)) {
                    String string3 = relativePath.substring(1);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                } else {
                    string2 = relativePath;
                }
                ZipEntry zipEntry = zipFile.getEntry(string2);
                if (zipEntry == null) {
                    boolean bl = false;
                    return bl;
                }
                ZipEntry entry = zipEntry;
                InputStream inputStream = zipFile.getInputStream(entry);
                Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
                XmlReader.readModuleDescriptor(inputStream, readContext, pathResolver, dataLoader, includeBase, readInto, ((Object)jarFile).toString());
                boolean bl = true;
                return bl;
            }
        }

        @NotNull
        public final String toLoadPath$intellij_platform_core_impl(@NotNull String relativePath, @Nullable String base) {
            String string2;
            Intrinsics.checkNotNullParameter(relativePath, "relativePath");
            if (relativePath.charAt(0) == '/') {
                String string3 = relativePath.substring(1);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            } else {
                string2 = StringsKt.startsWith$default(relativePath, "intellij.", false, 2, null) ? relativePath : (base == null ? "META-INF/" + relativePath : base + '/' + relativePath);
            }
            return string2;
        }

        @Nullable
        public final String getChildBase$intellij_platform_core_impl(@Nullable String base, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter(relativePath, "relativePath");
            int end = StringsKt.lastIndexOf$default((CharSequence)relativePath, '/', 0, false, 6, null);
            if (end <= 0 || StringsKt.startsWith$default(relativePath, "/META-INF/", false, 2, null)) {
                return base;
            }
            String string2 = relativePath.substring(0, end);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String childBase = string2;
            return base == null ? childBase : base + '/' + childBase;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

