/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.lang.java.parser.BasicJavaParser;
import com.intellij.lang.java.parser.BasicJavaParserUtil;
import com.intellij.lang.java.parser.BasicReferenceParser;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import com.intellij.psi.impl.source.BasicElementTypes;
import com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicDeclarationParser {
    private static final TokenSet BEFORE_LBRACE_ELEMENTS_SET = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.IMPLEMENTS_KEYWORD, JavaTokenType.LPARENTH);
    private static final TokenSet APPEND_TO_METHOD_SET = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.THROWS_KEYWORD);
    private static final TokenSet PARAM_LIST_STOPPERS = TokenSet.create(JavaTokenType.RPARENTH, JavaTokenType.LBRACE, JavaTokenType.ARROW);
    private static final TokenSet METHOD_PARAM_LIST_STOPPERS = TokenSet.create(JavaTokenType.RPARENTH, JavaTokenType.LBRACE, JavaTokenType.ARROW, JavaTokenType.SEMICOLON);
    private final TokenSet TYPE_START;
    private final TokenSet RESOURCE_EXPRESSIONS;
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder;

    public BasicDeclarationParser(@NotNull BasicJavaParser javaParser) {
        if (javaParser == null) {
            BasicDeclarationParser.$$$reportNull$$$0(0);
        }
        this.myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;
        this.myParser = javaParser;
        this.myJavaElementTypeContainer = javaParser.getJavaElementTypeFactory().getContainer();
        this.TYPE_START = TokenSet.orSet(BasicElementTypes.BASIC_PRIMITIVE_TYPE_BIT_SET, TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.AT, JavaTokenType.VAR_KEYWORD));
        this.RESOURCE_EXPRESSIONS = TokenSet.create(this.myJavaElementTypeContainer.REFERENCE_EXPRESSION, this.myJavaElementTypeContainer.THIS_EXPRESSION, this.myJavaElementTypeContainer.METHOD_CALL_EXPRESSION, this.myJavaElementTypeContainer.NEW_EXPRESSION);
    }

    public void parseClassBodyWithBraces(PsiBuilder builder2, boolean isAnnotation, boolean isEnum) {
        assert (builder2.getTokenType() == JavaTokenType.LBRACE) : builder2.getTokenType();
        builder2.advanceLexer();
        PsiBuilder builderWrapper = BasicJavaParserUtil.braceMatchingBuilder(builder2);
        if (isEnum) {
            this.parseEnumConstants(builderWrapper);
        }
        this.parseClassBodyDeclarations(builderWrapper, isAnnotation);
        BasicJavaParserUtil.expectOrError(builder2, JavaTokenType.RBRACE, "expected.rbrace");
    }

    @Nullable
    private PsiBuilder.Marker parseClassFromKeyword(PsiBuilder builder2, PsiBuilder.Marker declaration, boolean isAnnotation, BaseContext context) {
        boolean isEnum;
        IElementType keywordTokenType = builder2.getTokenType();
        boolean isRecord = BasicDeclarationParser.isRecordToken(builder2, keywordTokenType);
        if (isRecord) {
            if (builder2.lookAhead(1) != JavaTokenType.IDENTIFIER) {
                declaration.drop();
                return null;
            }
            IElementType afterIdent = builder2.lookAhead(2);
            if (context == BaseContext.CODE_BLOCK && afterIdent != JavaTokenType.LPARENTH && afterIdent != JavaTokenType.LT) {
                PsiBuilderUtil.advance(builder2, 2);
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.lt.or.lparen", new Object[0]));
                declaration.drop();
                return null;
            }
            builder2.remapCurrentToken(JavaTokenType.RECORD_KEYWORD);
            keywordTokenType = JavaTokenType.RECORD_KEYWORD;
        }
        assert (BasicElementTypes.BASIC_CLASS_KEYWORD_BIT_SET.contains(keywordTokenType)) : keywordTokenType;
        builder2.advanceLexer();
        boolean bl = isEnum = keywordTokenType == JavaTokenType.ENUM_KEYWORD;
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
            declaration.drop();
            return null;
        }
        BasicReferenceParser refParser = this.myParser.getReferenceParser();
        refParser.parseTypeParameters(builder2);
        if (builder2.getTokenType() == JavaTokenType.LPARENTH) {
            this.parseElementList(builder2, ListType.RECORD_COMPONENTS);
        }
        refParser.parseReferenceList(builder2, JavaTokenType.EXTENDS_KEYWORD, this.myJavaElementTypeContainer.EXTENDS_LIST, JavaTokenType.COMMA);
        refParser.parseReferenceList(builder2, JavaTokenType.IMPLEMENTS_KEYWORD, this.myJavaElementTypeContainer.IMPLEMENTS_LIST, JavaTokenType.COMMA);
        if (builder2.getTokenType() == JavaTokenType.IDENTIFIER && "permits".equals(builder2.getTokenText())) {
            builder2.remapCurrentToken(JavaTokenType.PERMITS_KEYWORD);
        }
        if (builder2.getTokenType() == JavaTokenType.PERMITS_KEYWORD) {
            refParser.parseReferenceList(builder2, JavaTokenType.PERMITS_KEYWORD, this.myJavaElementTypeContainer.PERMITS_LIST, JavaTokenType.COMMA);
        }
        if (builder2.getTokenType() != JavaTokenType.LBRACE) {
            PsiBuilder.Marker error = builder2.mark();
            while (BEFORE_LBRACE_ELEMENTS_SET.contains(builder2.getTokenType())) {
                builder2.advanceLexer();
            }
            error.error(JavaPsiBundle.message("expected.lbrace", new Object[0]));
        }
        if (builder2.getTokenType() == JavaTokenType.LBRACE) {
            this.parseClassBodyWithBraces(builder2, isAnnotation, isEnum);
        }
        BasicJavaParserUtil.done(declaration, this.myJavaElementTypeContainer.CLASS, this.myWhiteSpaceAndCommentSetHolder);
        return declaration;
    }

    private void parseEnumConstants(PsiBuilder builder2) {
        boolean first2 = true;
        while (builder2.getTokenType() != null) {
            IElementType next;
            if (PsiBuilderUtil.expect(builder2, JavaTokenType.SEMICOLON)) {
                return;
            }
            if (builder2.getTokenType() == JavaTokenType.PRIVATE_KEYWORD || builder2.getTokenType() == JavaTokenType.PROTECTED_KEYWORD) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.semicolon", new Object[0]));
                return;
            }
            PsiBuilder.Marker enumConstant = this.parseEnumConstant(builder2);
            if (enumConstant == null && builder2.getTokenType() == JavaTokenType.COMMA && first2 && (next = builder2.lookAhead(1)) != JavaTokenType.SEMICOLON && next != JavaTokenType.RBRACE) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
            }
            first2 = false;
            int commaCount = 0;
            while (builder2.getTokenType() == JavaTokenType.COMMA) {
                if (commaCount > 0) {
                    BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
                }
                builder2.advanceLexer();
                ++commaCount;
            }
            if (commaCount != 0 || builder2.getTokenType() == null || builder2.getTokenType() == JavaTokenType.SEMICOLON) continue;
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.comma.or.semicolon", new Object[0]));
            return;
        }
    }

    @Nullable
    public PsiBuilder.Marker parseEnumConstant(PsiBuilder builder2) {
        PsiBuilder.Marker constant = builder2.mark();
        this.parseModifierList(builder2);
        if (PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
            if (builder2.getTokenType() == JavaTokenType.LPARENTH) {
                this.myParser.getExpressionParser().parseArgumentList(builder2);
            } else {
                BasicJavaParserUtil.emptyElement(builder2, this.myJavaElementTypeContainer.EXPRESSION_LIST);
            }
            if (builder2.getTokenType() == JavaTokenType.LBRACE) {
                PsiBuilder.Marker constantInit = builder2.mark();
                this.parseClassBodyWithBraces(builder2, false, false);
                BasicJavaParserUtil.done(constantInit, this.myJavaElementTypeContainer.ENUM_CONSTANT_INITIALIZER, this.myWhiteSpaceAndCommentSetHolder);
            }
            BasicJavaParserUtil.done(constant, this.myJavaElementTypeContainer.ENUM_CONSTANT, this.myWhiteSpaceAndCommentSetHolder);
            return constant;
        }
        constant.rollbackTo();
        return null;
    }

    public void parseClassBodyDeclarations(PsiBuilder builder2, boolean isAnnotation) {
        IElementType tokenType;
        BaseContext context = isAnnotation ? BaseContext.ANNOTATION_INTERFACE : BaseContext.CLASS;
        SyntaxTreeBuilder.Marker invalidElements = null;
        while ((tokenType = builder2.getTokenType()) != null && tokenType != JavaTokenType.RBRACE) {
            PsiBuilder.Marker ref;
            if (tokenType == JavaTokenType.SEMICOLON) {
                if (invalidElements != null) {
                    invalidElements.error(JavaPsiBundle.message("unexpected.token", new Object[0]));
                    invalidElements = null;
                }
                builder2.advanceLexer();
                continue;
            }
            PsiBuilder.Marker declaration = this.parse(builder2, context);
            if (declaration != null) {
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), declaration);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder2.mark();
            }
            if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder2, true, true, false, false)) != null) continue;
            builder2.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(JavaPsiBundle.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder2, BaseContext context) {
        IElementType tokenType;
        if (builder2 == null) {
            BasicDeclarationParser.$$$reportNull$$$0(1);
        }
        if ((tokenType = builder2.getTokenType()) == null) {
            return null;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            if (context == BaseContext.FILE || context == BaseContext.CODE_BLOCK) {
                return null;
            }
        } else if (!(BasicDeclarationParser.isRecordToken(builder2, tokenType) || BasicDeclarationParser.isSealedToken(builder2, tokenType) || BasicDeclarationParser.isNonSealedToken(builder2, tokenType) || this.TYPE_START.contains(tokenType) && tokenType != JavaTokenType.AT)) {
            if (tokenType instanceof ILazyParseableElementType) {
                builder2.advanceLexer();
                return null;
            }
            if (!(BasicElementTypes.BASIC_MODIFIER_BIT_SET.contains(tokenType) || BasicElementTypes.BASIC_CLASS_KEYWORD_BIT_SET.contains(tokenType) || tokenType == JavaTokenType.AT || context != BaseContext.CODE_BLOCK && tokenType == JavaTokenType.LT)) {
                return null;
            }
        }
        PsiBuilder.Marker declaration = builder2.mark();
        int declarationStart = builder2.getCurrentOffset();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder2);
        PsiBuilder.Marker modList = (PsiBuilder.Marker)modListInfo.first;
        if (PsiBuilderUtil.expect(builder2, JavaTokenType.AT)) {
            if (builder2.getTokenType() == JavaTokenType.INTERFACE_KEYWORD) {
                PsiBuilder.Marker result2 = this.parseClassFromKeyword(builder2, declaration, true, context);
                return result2 != null ? result2 : modList;
            }
            declaration.rollbackTo();
            return null;
        }
        if (BasicElementTypes.BASIC_CLASS_KEYWORD_BIT_SET.contains(builder2.getTokenType()) || BasicDeclarationParser.isRecordToken(builder2, builder2.getTokenType())) {
            PsiBuilder.Marker result3 = this.parseClassFromKeyword(builder2, declaration, false, context);
            return result3 != null ? result3 : modList;
        }
        PsiBuilder.Marker typeParams = null;
        if (builder2.getTokenType() == JavaTokenType.LT && context != BaseContext.CODE_BLOCK) {
            typeParams = this.myParser.getReferenceParser().parseTypeParameters(builder2);
        }
        if (builder2.getTokenType() == JavaTokenType.LBRACE) {
            if (context == BaseContext.CODE_BLOCK) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier.or.type", new Object[0]), null);
                declaration.drop();
                return modList;
            }
            PsiBuilder.Marker codeBlock = this.myParser.getStatementParser().parseCodeBlock(builder2);
            assert (codeBlock != null) : builder2.getOriginalText();
            if (typeParams != null) {
                PsiBuilder.Marker error = typeParams.precede();
                error.errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), codeBlock);
            }
            BasicJavaParserUtil.done(declaration, this.myJavaElementTypeContainer.CLASS_INITIALIZER, this.myWhiteSpaceAndCommentSetHolder);
            return declaration;
        }
        BasicReferenceParser.TypeInfo type2 = null;
        if (this.TYPE_START.contains(builder2.getTokenType())) {
            PsiBuilder.Marker pos = builder2.mark();
            int flags = 5;
            if (context == BaseContext.CODE_BLOCK) {
                flags |= 0x80;
            }
            if ((type2 = this.myParser.getReferenceParser().parseTypeInfo(builder2, flags)) == null) {
                pos.rollbackTo();
            } else {
                if (builder2.getTokenType() == JavaTokenType.LPARENTH || builder2.getTokenType() == JavaTokenType.LBRACE) {
                    if (context == BaseContext.CODE_BLOCK) {
                        declaration.rollbackTo();
                        return null;
                    }
                    pos.rollbackTo();
                    if (typeParams == null) {
                        BasicJavaParserUtil.emptyElement(builder2, this.myJavaElementTypeContainer.TYPE_PARAMETER_LIST);
                    }
                    this.parseAnnotations(builder2);
                    if (!PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
                        PsiBuilder.Marker primitive = builder2.mark();
                        builder2.advanceLexer();
                        primitive.error(JavaPsiBundle.message("expected.identifier", new Object[0]));
                    }
                    if (builder2.getTokenType() == JavaTokenType.LPARENTH) {
                        return this.parseMethodFromLeftParenth(builder2, declaration, false, true);
                    }
                    if (builder2.getTokenType() == JavaTokenType.LBRACE) {
                        BasicJavaParserUtil.emptyElement(builder2, this.myJavaElementTypeContainer.THROWS_LIST);
                        return this.parseMethodBody(builder2, declaration, false);
                    }
                    declaration.rollbackTo();
                    return null;
                }
                pos.drop();
            }
        }
        if (type2 == null) {
            PsiBuilder.Marker error = typeParams != null ? typeParams.precede() : builder2.mark();
            error.error(JavaPsiBundle.message("expected.identifier.or.type", new Object[0]));
            declaration.drop();
            return modList;
        }
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
            if (context != BaseContext.CODE_BLOCK || Boolean.FALSE.equals(modListInfo.second) || type2.isPrimitive && builder2.getTokenType() != JavaTokenType.DOT) {
                if (typeParams != null) {
                    typeParams.precede().errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), type2.marker);
                }
                builder2.error(JavaPsiBundle.message("expected.identifier", new Object[0]));
                declaration.drop();
                return modList;
            }
            declaration.rollbackTo();
            return null;
        }
        if (builder2.getTokenType() == JavaTokenType.LPARENTH && (context == BaseContext.CLASS || context == BaseContext.ANNOTATION_INTERFACE || context == BaseContext.FILE)) {
            if (typeParams == null) {
                BasicJavaParserUtil.emptyElement(type2.marker, this.myJavaElementTypeContainer.TYPE_PARAMETER_LIST);
            }
            return this.parseMethodFromLeftParenth(builder2, declaration, context == BaseContext.ANNOTATION_INTERFACE, false);
        }
        if (typeParams != null) {
            typeParams.precede().errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), type2.marker);
        }
        return this.parseFieldOrLocalVariable(builder2, declaration, declarationStart, context);
    }

    static boolean isRecordToken(PsiBuilder builder2, IElementType tokenType) {
        if (tokenType == JavaTokenType.IDENTIFIER && "record".equals(builder2.getTokenText()) && builder2.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            LanguageLevel level = BasicJavaParserUtil.getLanguageLevel(builder2);
            return level.isAtLeast(LanguageLevel.JDK_16);
        }
        return false;
    }

    private static boolean isSealedToken(PsiBuilder builder2, IElementType tokenType) {
        return BasicJavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_17) && tokenType == JavaTokenType.IDENTIFIER && "sealed".equals(builder2.getTokenText());
    }

    private static boolean isNonSealedToken(PsiBuilder builder2, IElementType tokenType) {
        if (!BasicJavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_17) || tokenType != JavaTokenType.IDENTIFIER || !"non".equals(builder2.getTokenText()) || builder2.lookAhead(1) != JavaTokenType.MINUS || builder2.lookAhead(2) != JavaTokenType.IDENTIFIER) {
            return false;
        }
        PsiBuilder.Marker maybeNonSealed = builder2.mark();
        PsiBuilderUtil.advance(builder2, 2);
        boolean isNonSealed = "sealed".equals(builder2.getTokenText());
        maybeNonSealed.rollbackTo();
        return isNonSealed;
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder2) {
        Pair<PsiBuilder.Marker, Boolean> pair = this.parseModifierList(builder2, BasicElementTypes.BASIC_MODIFIER_BIT_SET);
        if (pair == null) {
            BasicDeclarationParser.$$$reportNull$$$0(2);
        }
        return pair;
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder2, TokenSet modifiers) {
        IElementType tokenType;
        PsiBuilder.Marker modList = builder2.mark();
        boolean isEmpty = true;
        while ((tokenType = builder2.getTokenType()) != null) {
            if (BasicDeclarationParser.isSealedToken(builder2, tokenType)) {
                builder2.remapCurrentToken(JavaTokenType.SEALED_KEYWORD);
                tokenType = JavaTokenType.SEALED_KEYWORD;
            }
            if (BasicDeclarationParser.isNonSealedToken(builder2, tokenType)) {
                PsiBuilder.Marker nonSealed = builder2.mark();
                PsiBuilderUtil.advance(builder2, 3);
                nonSealed.collapse(JavaTokenType.NON_SEALED_KEYWORD);
                isEmpty = false;
                continue;
            }
            if (modifiers.contains(tokenType)) {
                builder2.advanceLexer();
                isEmpty = false;
                continue;
            }
            if (tokenType != JavaTokenType.AT || BasicElementTypes.BASIC_KEYWORD_BIT_SET.contains(builder2.lookAhead(1))) break;
            this.parseAnnotation(builder2);
            isEmpty = false;
        }
        BasicJavaParserUtil.done(modList, this.myJavaElementTypeContainer.MODIFIER_LIST, this.myWhiteSpaceAndCommentSetHolder);
        Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(modList, isEmpty);
        if (pair == null) {
            BasicDeclarationParser.$$$reportNull$$$0(3);
        }
        return pair;
    }

    private PsiBuilder.Marker parseMethodFromLeftParenth(PsiBuilder builder2, PsiBuilder.Marker declaration, boolean anno, boolean constructor) {
        this.parseParameterList(builder2);
        this.eatBrackets(builder2, constructor ? "expected.semicolon" : null);
        this.myParser.getReferenceParser().parseReferenceList(builder2, JavaTokenType.THROWS_KEYWORD, this.myJavaElementTypeContainer.THROWS_LIST, JavaTokenType.COMMA);
        if (anno && PsiBuilderUtil.expect(builder2, JavaTokenType.DEFAULT_KEYWORD)) {
            this.parseAnnotationValue(builder2);
        }
        return this.parseMethodBody(builder2, declaration, anno);
    }

    @NotNull
    private PsiBuilder.Marker parseMethodBody(PsiBuilder builder2, PsiBuilder.Marker declaration, boolean anno) {
        IElementType tokenType = builder2.getTokenType();
        if (tokenType != JavaTokenType.SEMICOLON && tokenType != JavaTokenType.LBRACE) {
            PsiBuilder.Marker error = builder2.mark();
            CharSequence text = builder2.getOriginalText();
            block0: do {
                for (int i = builder2.getCurrentOffset() - 1; i >= 0; --i) {
                    char ch = text.charAt(i);
                    if (ch == '\n') break block0;
                    if (ch != ' ' && ch != '\t') continue block0;
                }
            } while (PsiBuilderUtil.expect(builder2, APPEND_TO_METHOD_SET));
            error.error(JavaPsiBundle.message("expected.lbrace.or.semicolon", new Object[0]));
        }
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.SEMICOLON) && builder2.getTokenType() == JavaTokenType.LBRACE) {
            this.myParser.getStatementParser().parseCodeBlock(builder2);
        }
        BasicJavaParserUtil.done(declaration, anno ? this.myJavaElementTypeContainer.ANNOTATION_METHOD : this.myJavaElementTypeContainer.METHOD, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = declaration;
        if (marker == null) {
            BasicDeclarationParser.$$$reportNull$$$0(4);
        }
        return marker;
    }

    public void parseParameterList(PsiBuilder builder2) {
        this.parseElementList(builder2, ListType.METHOD);
    }

    public void parseResourceList(PsiBuilder builder2) {
        this.parseElementList(builder2, ListType.RESOURCE);
    }

    public void parseLambdaParameterList(PsiBuilder builder2, boolean typed) {
        this.parseElementList(builder2, typed ? ListType.LAMBDA_TYPED : ListType.LAMBDA_UNTYPED);
    }

    private void parseElementList(PsiBuilder builder2, ListType type2) {
        boolean lambda = type2 == ListType.LAMBDA_TYPED || type2 == ListType.LAMBDA_UNTYPED;
        boolean resources = type2 == ListType.RESOURCE;
        PsiBuilder.Marker elementList = builder2.mark();
        boolean leftParenth = PsiBuilderUtil.expect(builder2, JavaTokenType.LPARENTH);
        assert (lambda || leftParenth) : builder2.getTokenType();
        IElementType delimiter = resources ? JavaTokenType.SEMICOLON : JavaTokenType.COMMA;
        String noDelimiterMsg = resources ? "expected.semicolon" : "expected.comma";
        String noElementMsg = resources ? "expected.resource" : "expected.parameter";
        SyntaxTreeBuilder.Marker invalidElements = null;
        String errorMessage2 = null;
        boolean delimiterExpected = false;
        boolean noElements = true;
        while (true) {
            PsiBuilder.Marker ref;
            IElementType tokenType;
            if ((tokenType = builder2.getTokenType()) == null || type2.getStopperTypes().contains(tokenType)) {
                boolean noLastElement;
                boolean bl = noLastElement = !delimiterExpected && (!noElements && !resources || noElements && resources);
                if (noLastElement) {
                    String key = lambda ? "expected.parameter" : "expected.identifier.or.type";
                    BasicJavaParserUtil.error(builder2, JavaPsiBundle.message(key, new Object[0]));
                }
                if (tokenType == JavaTokenType.RPARENTH) {
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage2);
                        invalidElements = null;
                    }
                    builder2.advanceLexer();
                    break;
                }
                if (noLastElement && !resources) break;
                if (invalidElements != null) {
                    invalidElements.error(errorMessage2);
                }
                invalidElements = null;
                if (!leftParenth) break;
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rparen", new Object[0]));
                break;
            }
            if (delimiterExpected) {
                if (builder2.getTokenType() == delimiter) {
                    delimiterExpected = false;
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage2);
                        invalidElements = null;
                    }
                    builder2.advanceLexer();
                    continue;
                }
            } else {
                PsiBuilder.Marker listElement;
                PsiBuilder.Marker marker = type2 == ListType.RECORD_COMPONENTS ? this.parseParameterOrRecordComponent(builder2, true, false, false, false) : (resources ? this.parseResource(builder2) : (lambda ? this.parseLambdaParameter(builder2, type2 == ListType.LAMBDA_TYPED) : (listElement = this.parseParameter(builder2, true, false, false))));
                if (listElement != null) {
                    delimiterExpected = true;
                    if (invalidElements != null) {
                        invalidElements.errorBefore(errorMessage2, listElement);
                        invalidElements = null;
                    }
                    noElements = false;
                    continue;
                }
            }
            if (invalidElements == null) {
                if (builder2.getTokenType() == delimiter) {
                    BasicJavaParserUtil.error(builder2, JavaPsiBundle.message(noElementMsg, new Object[0]));
                    builder2.advanceLexer();
                    if (!noElements || !resources) continue;
                    noElements = false;
                    continue;
                }
                invalidElements = builder2.mark();
                errorMessage2 = JavaPsiBundle.message(delimiterExpected ? noDelimiterMsg : noElementMsg, new Object[0]);
            }
            if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder2, true, true, false, false)) != null || builder2.getTokenType() == null) continue;
            builder2.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(errorMessage2);
        }
        BasicJavaParserUtil.done(elementList, type2.getNodeType(this.myJavaElementTypeContainer), this.myWhiteSpaceAndCommentSetHolder);
    }

    @Nullable
    public PsiBuilder.Marker parseParameter(PsiBuilder builder2, boolean ellipsis, boolean disjunctiveType, boolean varType) {
        return this.parseParameterOrRecordComponent(builder2, ellipsis, disjunctiveType, varType, true);
    }

    @Nullable
    public PsiBuilder.Marker parseParameterOrRecordComponent(PsiBuilder builder2, boolean ellipsis, boolean disjunctiveType, boolean varType, boolean isParameter) {
        int typeFlags = 0;
        if (ellipsis) {
            typeFlags |= 2;
        }
        if (disjunctiveType) {
            typeFlags |= 0x10;
        }
        if (varType) {
            typeFlags |= 0x80;
        }
        return this.parseListElement(builder2, true, typeFlags, isParameter ? this.myJavaElementTypeContainer.PARAMETER : this.myJavaElementTypeContainer.RECORD_COMPONENT);
    }

    @Nullable
    public PsiBuilder.Marker parseResource(PsiBuilder builder2) {
        PsiBuilder.Marker marker = builder2.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder2);
        if (expr != null && this.RESOURCE_EXPRESSIONS.contains(BasicJavaParserUtil.exprType(expr)) && builder2.getTokenType() != JavaTokenType.IDENTIFIER) {
            marker.done(this.myJavaElementTypeContainer.RESOURCE_EXPRESSION);
            return marker;
        }
        marker.rollbackTo();
        return this.parseListElement(builder2, true, 128, this.myJavaElementTypeContainer.RESOURCE_VARIABLE);
    }

    @Nullable
    public PsiBuilder.Marker parseLambdaParameter(PsiBuilder builder2, boolean typed) {
        int flags = 2;
        if (BasicJavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_11)) {
            flags |= 0x80;
        }
        return this.parseListElement(builder2, typed, flags, this.myJavaElementTypeContainer.PARAMETER);
    }

    @Nullable
    private PsiBuilder.Marker parseListElement(PsiBuilder builder2, boolean typed, int typeFlags, IElementType type2) {
        IElementType tokenType;
        PsiBuilder.Marker param = builder2.mark();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder2);
        if (typed) {
            int flags = 5 | typeFlags;
            BasicReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder2, flags);
            if (typeInfo == null) {
                if (Boolean.TRUE.equals(modListInfo.second)) {
                    param.rollbackTo();
                    return null;
                }
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.type", new Object[0]));
                BasicJavaParserUtil.emptyElement(builder2, this.myJavaElementTypeContainer.TYPE);
            }
        }
        if (typed && ((tokenType = builder2.getTokenType()) == JavaTokenType.THIS_KEYWORD || tokenType == JavaTokenType.IDENTIFIER && builder2.lookAhead(1) == JavaTokenType.DOT)) {
            PsiBuilder.Marker mark = builder2.mark();
            PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder2);
            if (expr != null && BasicJavaParserUtil.exprType(expr) == this.myJavaElementTypeContainer.THIS_EXPRESSION) {
                mark.drop();
                BasicJavaParserUtil.done(param, this.myJavaElementTypeContainer.RECEIVER_PARAMETER, this.myWhiteSpaceAndCommentSetHolder);
                return param;
            }
            mark.rollbackTo();
        }
        if (PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
            if (type2 == this.myJavaElementTypeContainer.PARAMETER || type2 == this.myJavaElementTypeContainer.RECORD_COMPONENT) {
                this.eatBrackets(builder2, null);
                BasicJavaParserUtil.done(param, type2, this.myWhiteSpaceAndCommentSetHolder);
                return param;
            }
        } else {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
            param.drop();
            return (PsiBuilder.Marker)modListInfo.first;
        }
        if (BasicJavaParserUtil.expectOrError(builder2, JavaTokenType.EQ, "expected.eq") && this.myParser.getExpressionParser().parse(builder2) == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
        }
        BasicJavaParserUtil.done(param, this.myJavaElementTypeContainer.RESOURCE_VARIABLE, this.myWhiteSpaceAndCommentSetHolder);
        return param;
    }

    @Nullable
    private PsiBuilder.Marker parseFieldOrLocalVariable(PsiBuilder builder2, PsiBuilder.Marker declaration, int declarationStart, BaseContext context) {
        boolean shouldRollback;
        IElementType varType;
        if (context == BaseContext.CLASS || context == BaseContext.ANNOTATION_INTERFACE || context == BaseContext.FILE) {
            varType = this.myJavaElementTypeContainer.FIELD;
        } else if (context == BaseContext.CODE_BLOCK) {
            varType = this.myJavaElementTypeContainer.LOCAL_VARIABLE;
        } else {
            declaration.drop();
            assert (false) : "Unexpected context: " + (Object)((Object)context);
            return null;
        }
        PsiBuilder.Marker variable = declaration;
        boolean unclosed = false;
        boolean eatSemicolon = true;
        boolean openMarker = true;
        while (true) {
            shouldRollback = true;
            if (!this.eatBrackets(builder2, null)) {
                unclosed = true;
            }
            if (PsiBuilderUtil.expect(builder2, JavaTokenType.EQ)) {
                PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder2);
                if (expr != null) {
                    shouldRollback = false;
                } else {
                    BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
                    unclosed = true;
                    break;
                }
            }
            if (builder2.getTokenType() != JavaTokenType.COMMA) break;
            BasicJavaParserUtil.done(variable, varType, this.myWhiteSpaceAndCommentSetHolder);
            builder2.advanceLexer();
            if (builder2.getTokenType() != JavaTokenType.IDENTIFIER) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
                unclosed = true;
                eatSemicolon = false;
                openMarker = false;
                break;
            }
            variable = builder2.mark();
            builder2.advanceLexer();
        }
        if (builder2.getTokenType() == JavaTokenType.SEMICOLON && eatSemicolon) {
            builder2.advanceLexer();
        } else {
            if (!builder2.eof() && shouldRollback) {
                CharSequence text = builder2.getOriginalText();
                int spaceEnd = builder2.getCurrentOffset();
                int spaceStart = CharArrayUtil.shiftBackward(text, spaceEnd - 1, "\n\r \t");
                int lineStart = CharArrayUtil.shiftBackwardUntil(text, spaceEnd, "\n\r");
                if (declarationStart < lineStart && lineStart < spaceStart) {
                    int newBufferEnd = CharArrayUtil.shiftForward(text, lineStart, "\n\r \t");
                    declaration.rollbackTo();
                    return this.parse(BasicJavaParserUtil.stoppingBuilder(builder2, newBufferEnd), context);
                }
            }
            if (!unclosed) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.semicolon", new Object[0]));
            }
        }
        if (openMarker) {
            BasicJavaParserUtil.done(variable, varType, this.myWhiteSpaceAndCommentSetHolder);
        }
        return declaration;
    }

    private boolean eatBrackets(PsiBuilder builder2, @Nullable String errorKey) {
        boolean paired;
        IElementType tokenType = builder2.getTokenType();
        if (tokenType != JavaTokenType.LBRACKET && tokenType != JavaTokenType.AT) {
            return true;
        }
        PsiBuilder.Marker marker = builder2.mark();
        int count2 = 0;
        while (true) {
            this.parseAnnotations(builder2);
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.LBRACKET)) break;
            ++count2;
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RBRACKET)) break;
            ++count2;
        }
        if (count2 == 0) {
            marker.rollbackTo();
            return true;
        }
        if (errorKey != null) {
            marker.error(JavaPsiBundle.message(errorKey, new Object[0]));
        } else {
            marker.drop();
        }
        boolean bl = paired = count2 % 2 == 0;
        if (!paired) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rbracket", new Object[0]));
        }
        return paired;
    }

    @Nullable
    public PsiBuilder.Marker parseAnnotations(PsiBuilder builder2) {
        PsiBuilder.Marker firstAnno = null;
        while (builder2.getTokenType() == JavaTokenType.AT) {
            PsiBuilder.Marker anno = this.parseAnnotation(builder2);
            if (firstAnno != null) continue;
            firstAnno = anno;
        }
        return firstAnno;
    }

    @NotNull
    public PsiBuilder.Marker parseAnnotation(PsiBuilder builder2) {
        assert (builder2.getTokenType() == JavaTokenType.AT) : builder2.getTokenType();
        PsiBuilder.Marker anno = builder2.mark();
        builder2.advanceLexer();
        PsiBuilder.Marker classRef = null;
        if (builder2.getTokenType() == JavaTokenType.IDENTIFIER) {
            classRef = this.myParser.getReferenceParser().parseJavaCodeReference(builder2, true, false, false, false);
        }
        if (classRef == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.class.reference", new Object[0]));
        }
        this.parseAnnotationParameterList(builder2);
        BasicJavaParserUtil.done(anno, this.myJavaElementTypeContainer.ANNOTATION, this.myWhiteSpaceAndCommentSetHolder);
        PsiBuilder.Marker marker = anno;
        if (marker == null) {
            BasicDeclarationParser.$$$reportNull$$$0(5);
        }
        return marker;
    }

    private void parseAnnotationParameterList(PsiBuilder builder2) {
        PsiBuilder.Marker list = builder2.mark();
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.LPARENTH)) {
            BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.ANNOTATION_PARAMETER_LIST, this.myWhiteSpaceAndCommentSetHolder);
            return;
        }
        if (PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) {
            BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.ANNOTATION_PARAMETER_LIST, this.myWhiteSpaceAndCommentSetHolder);
            return;
        }
        boolean isFirstParamNamed = this.parseAnnotationParameter(builder2, true);
        boolean isFirstParamWarned = false;
        boolean afterBad = false;
        while (true) {
            IElementType tokenType;
            if ((tokenType = builder2.getTokenType()) == null) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.parameter", new Object[0]));
                break;
            }
            if (PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) break;
            if (tokenType == JavaTokenType.COMMA) {
                PsiBuilder.Marker errorStart = builder2.mark();
                PsiBuilder.Marker errorEnd = builder2.mark();
                builder2.advanceLexer();
                boolean hasParamName = this.parseAnnotationParameter(builder2, false);
                if (!isFirstParamNamed && hasParamName && !isFirstParamWarned) {
                    errorStart.errorBefore(JavaPsiBundle.message("annotation.name.is.missing", new Object[0]), errorEnd);
                    isFirstParamWarned = true;
                } else {
                    errorStart.drop();
                }
                errorEnd.drop();
                continue;
            }
            if (!afterBad) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.comma.or.rparen", new Object[0]));
                builder2.advanceLexer();
                afterBad = true;
                continue;
            }
            afterBad = false;
            this.parseAnnotationParameter(builder2, false);
        }
        BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.ANNOTATION_PARAMETER_LIST, this.myWhiteSpaceAndCommentSetHolder);
    }

    private boolean parseAnnotationParameter(PsiBuilder builder2, boolean mayBeSimple) {
        PsiBuilder.Marker pair = builder2.mark();
        if (mayBeSimple) {
            this.parseAnnotationValue(builder2);
            if (builder2.getTokenType() != JavaTokenType.EQ) {
                BasicJavaParserUtil.done(pair, this.myJavaElementTypeContainer.NAME_VALUE_PAIR, this.myWhiteSpaceAndCommentSetHolder);
                return false;
            }
            pair.rollbackTo();
            pair = builder2.mark();
        }
        boolean hasName = BasicJavaParserUtil.expectOrError(builder2, JavaTokenType.IDENTIFIER, "expected.identifier");
        BasicJavaParserUtil.expectOrError(builder2, JavaTokenType.EQ, "expected.eq");
        this.parseAnnotationValue(builder2);
        BasicJavaParserUtil.done(pair, this.myJavaElementTypeContainer.NAME_VALUE_PAIR, this.myWhiteSpaceAndCommentSetHolder);
        return hasName;
    }

    public void parseAnnotationValue(PsiBuilder builder2) {
        PsiBuilder.Marker result2 = this.doParseAnnotationValue(builder2);
        if (result2 == null) {
            result2 = builder2.mark();
            result2.error(JavaPsiBundle.message("expected.value", new Object[0]));
        }
    }

    @Nullable
    private PsiBuilder.Marker doParseAnnotationValue(PsiBuilder builder2) {
        IElementType tokenType = builder2.getTokenType();
        PsiBuilder.Marker result2 = tokenType == JavaTokenType.AT ? this.parseAnnotation(builder2) : (tokenType == JavaTokenType.LBRACE ? this.myParser.getExpressionParser().parseArrayInitializer(builder2, this.myJavaElementTypeContainer.ANNOTATION_ARRAY_INITIALIZER, this::doParseAnnotationValue, "expected.value") : this.myParser.getExpressionParser().parseConditional(builder2));
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/BasicDeclarationParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/BasicDeclarationParser";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseModifierList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMethodBody";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum BaseContext {
        FILE,
        CLASS,
        CODE_BLOCK,
        ANNOTATION_INTERFACE;

    }

    private static enum ListType {
        METHOD,
        RESOURCE,
        LAMBDA_TYPED,
        LAMBDA_UNTYPED,
        RECORD_COMPONENTS;


        IElementType getNodeType(AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer javaElementTypeContainer) {
            if (this == RESOURCE) {
                return javaElementTypeContainer.RESOURCE_LIST;
            }
            if (this == RECORD_COMPONENTS) {
                return javaElementTypeContainer.RECORD_HEADER;
            }
            return javaElementTypeContainer.PARAMETER_LIST;
        }

        TokenSet getStopperTypes() {
            if (this == METHOD) {
                return METHOD_PARAM_LIST_STOPPERS;
            }
            return PARAM_LIST_STOPPERS;
        }
    }
}

