/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TokenList {
    public int getTokenCount();

    @NotNull
    public CharSequence getTokenizedText();

    public int getTokenStart(int var1);

    public int getTokenEnd(int var1);

    public IElementType getTokenType(int var1);

    @NotNull
    default public Lexer asLexer() {
        return new WrappingLexer(this);
    }

    public static class WrappingLexer
    extends LexerBase {
        private final TokenList myTokens;
        private int myIndex;

        WrappingLexer(TokenList tokens) {
            this.myTokens = tokens;
        }

        public TokenList getTokens() {
            return this.myTokens;
        }

        @Override
        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            if (buffer == null) {
                WrappingLexer.$$$reportNull$$$0(0);
            }
            assert (Comparing.equal(buffer, this.myTokens.getTokenizedText()));
            assert (startOffset == 0);
            assert (endOffset == buffer.length());
            assert (initialState == 0);
            this.myIndex = 0;
        }

        @Override
        public int getState() {
            return this.myIndex;
        }

        @Override
        @Nullable
        public IElementType getTokenType() {
            return this.myTokens.getTokenType(this.myIndex);
        }

        @Override
        public int getTokenStart() {
            return this.myTokens.getTokenStart(this.myIndex);
        }

        @Override
        public int getTokenEnd() {
            return this.myTokens.getTokenEnd(this.myIndex);
        }

        @Override
        public void advance() {
            ++this.myIndex;
        }

        @Override
        @NotNull
        public CharSequence getBufferSequence() {
            CharSequence charSequence = this.myTokens.getTokenizedText();
            if (charSequence == null) {
                WrappingLexer.$$$reportNull$$$0(1);
            }
            return charSequence;
        }

        @Override
        public int getBufferEnd() {
            return this.myTokens.getTokenizedText().length();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lexer/TokenList$WrappingLexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lexer/TokenList$WrappingLexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBufferSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

