/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationManager {
    protected static Application ourApplication;
    private static final List<Runnable> cleaners;

    public static Application getApplication() {
        return ourApplication;
    }

    public static void setApplication(@Nullable Application instance) {
        ourApplication = instance;
        for (Runnable cleaner : cleaners) {
            cleaner.run();
        }
    }

    public static void setApplication(@NotNull Application instance, @NotNull Disposable parent2) {
        if (instance == null) {
            ApplicationManager.$$$reportNull$$$0(0);
        }
        if (parent2 == null) {
            ApplicationManager.$$$reportNull$$$0(1);
        }
        Application old = ourApplication;
        Disposer.register(parent2, () -> {
            if (old != null) {
                ApplicationManager.setApplication(old);
            }
        });
        ApplicationManager.setApplication(instance);
    }

    public static void setApplication(@NotNull Application instance, @NotNull Supplier<? extends FileTypeRegistry> fileTypeRegistryGetter, @NotNull Disposable parent2) {
        if (instance == null) {
            ApplicationManager.$$$reportNull$$$0(2);
        }
        if (fileTypeRegistryGetter == null) {
            ApplicationManager.$$$reportNull$$$0(3);
        }
        if (parent2 == null) {
            ApplicationManager.$$$reportNull$$$0(4);
        }
        Application old = ourApplication;
        ApplicationManager.setApplication(instance);
        Supplier<? extends FileTypeRegistry> oldFileTypeRegistry = FileTypeRegistry.setInstanceSupplier(fileTypeRegistryGetter);
        Disposer.register(parent2, () -> {
            if (old != null) {
                ApplicationManager.setApplication(old);
                FileTypeRegistry.setInstanceSupplier(oldFileTypeRegistry);
            }
        });
    }

    public static void registerCleaner(Runnable cleaner) {
        cleaners.add(cleaner);
    }

    static {
        cleaners = ContainerUtil.createLockFreeCopyOnWriteList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "instance";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "fileTypeRegistryGetter";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/application/ApplicationManager";
        objectArray[2] = "setApplication";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

