/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionDescriptor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAdapter;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointPriorityListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExtensionPointImpl<T>
implements ExtensionPoint<T>,
Iterable<T> {
    static final Logger LOG = Logger.getInstance(ExtensionPointImpl.class);
    private static Set<ExtensionPointImpl<?>> POINTS_IN_READONLY_MODE;
    private static final ArrayFactory<ExtensionPointListener<?>> LISTENER_ARRAY_FACTORY;
    private final String name;
    private final String className;
    private volatile List<T> cachedExtensions;
    private volatile T @Nullable [] cachedExtensionsAsArray;
    private final ComponentManager componentManager;
    @NotNull
    protected final PluginDescriptor pluginDescriptor;
    @NotNull
    private volatile List<ExtensionComponentAdapter> adapters;
    private volatile boolean adaptersAreSorted;
    private ExtensionPointListener<T> @NotNull [] listeners;
    @Nullable
    private Class<T> extensionClass;
    private final boolean isDynamic;
    private final AtomicReference<ConcurrentMap<?, Map<?, ?>>> keyMapperToCacheRef;
    private static Runnable CHECK_CANCELED;

    ExtensionPointImpl(@NotNull String name, @NotNull String className, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager, @Nullable Class<T> extensionClass, boolean dynamic) {
        if (name == null) {
            ExtensionPointImpl.$$$reportNull$$$0(0);
        }
        if (className == null) {
            ExtensionPointImpl.$$$reportNull$$$0(1);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(2);
        }
        if (componentManager == null) {
            ExtensionPointImpl.$$$reportNull$$$0(3);
        }
        this.adapters = Collections.emptyList();
        this.adaptersAreSorted = true;
        this.listeners = ExtensionPointListener.Companion.emptyArray();
        this.keyMapperToCacheRef = new AtomicReference();
        this.name = name;
        this.className = className;
        this.pluginDescriptor = pluginDescriptor;
        this.componentManager = componentManager;
        this.extensionClass = extensionClass;
        this.isDynamic = dynamic;
    }

    @NotNull
    public final String getName() {
        String string2 = this.name;
        if (string2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public final String getClassName() {
        String string2 = this.className;
        if (string2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Override
    public final void registerExtension(@NotNull T extension) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(7);
        }
        this.doRegisterExtension(extension, LoadingOrder.ANY, this.getPluginDescriptor(), null);
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(8);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(9);
        }
        this.registerExtension(extension, this.getPluginDescriptor(), parentDisposable);
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull PluginDescriptor pluginDescriptor, @NotNull Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(10);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(11);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(12);
        }
        this.doRegisterExtension(extension, LoadingOrder.ANY, pluginDescriptor, parentDisposable);
    }

    @NotNull
    public final PluginDescriptor getPluginDescriptor() {
        PluginDescriptor pluginDescriptor = this.pluginDescriptor;
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(13);
        }
        return pluginDescriptor;
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull LoadingOrder order, @NotNull Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(14);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(15);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(16);
        }
        this.doRegisterExtension(extension, order, this.getPluginDescriptor(), parentDisposable);
    }

    public final ComponentManager getComponentManager() {
        return this.componentManager;
    }

    private synchronized void doRegisterExtension(@NotNull T extension, @NotNull LoadingOrder order, @NotNull PluginDescriptor pluginDescriptor, @Nullable Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(17);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(18);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(19);
        }
        this.assertNotReadOnlyMode();
        this.checkExtensionType(extension, this.getExtensionClass(), null);
        for (ExtensionComponentAdapter adapter : this.adapters) {
            if (!(adapter instanceof ObjectComponentAdapter) || ((ObjectComponentAdapter)adapter).componentInstance != extension) continue;
            LOG.error("Extension was already added: " + extension);
            return;
        }
        ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension, pluginDescriptor, order);
        this.addExtensionAdapter(adapter);
        this.notifyListeners(false, Collections.singletonList(adapter), this.listeners);
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> {
                ExtensionPointImpl extensionPointImpl = this;
                synchronized (extensionPointImpl) {
                    int index2 = ContainerUtil.indexOfIdentity(this.adapters, adapter);
                    if (index2 < 0) {
                        LOG.error("Extension to be removed not found: " + adapter.componentInstance);
                    }
                    ArrayList<ExtensionComponentAdapter> list = new ArrayList<ExtensionComponentAdapter>(this.adapters);
                    list.remove(index2);
                    this.adapters = list;
                    this.clearCache();
                    this.notifyListeners(true, Collections.singletonList(adapter), this.listeners);
                }
            });
        }
    }

    private void checkExtensionType(@NotNull T extension, @NotNull Class<T> extensionClass, @Nullable ExtensionComponentAdapter adapter) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(24);
        }
        if (extensionClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(25);
        }
        if (!extensionClass.isInstance(extension)) {
            String message = "Extension " + extension.getClass().getName() + " does not implement " + extensionClass;
            if (adapter == null) {
                throw new RuntimeException(message);
            }
            message = message + " (adapter=" + adapter + ")";
            throw this.componentManager.createError(message, null, adapter.pluginDescriptor.getPluginId(), Collections.singletonMap("threadDump", ThreadDumper.dumpThreadsToString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public final List<T> getExtensionList() {
        List<T> result2 = this.cachedExtensions;
        if (result2 == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                result2 = this.cachedExtensions;
                if (result2 == null) {
                    T[] array = this.processAdapters();
                    this.cachedExtensionsAsArray = array;
                    result2 = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList(array);
                    this.cachedExtensions = result2;
                }
            }
        }
        List<T> list = result2;
        if (list == null) {
            ExtensionPointImpl.$$$reportNull$$$0(26);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T @NotNull [] getExtensions() {
        T[] array = this.cachedExtensionsAsArray;
        if (array == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                array = this.cachedExtensionsAsArray;
                if (array == null) {
                    this.cachedExtensionsAsArray = array = this.processAdapters();
                    this.cachedExtensions = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList(array);
                }
            }
        }
        Object[] objectArray = array.length == 0 ? array : (Object[])array.clone();
        if (objectArray == null) {
            ExtensionPointImpl.$$$reportNull$$$0(27);
        }
        return objectArray;
    }

    @Override
    public final @NotNull Iterator<@Nullable T> iterator() {
        List<T> result2 = this.cachedExtensions;
        Iterator<T> iterator2 = result2 == null ? this.createIterator() : result2.iterator();
        if (iterator2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(28);
        }
        return iterator2;
    }

    private @NotNull Iterator<@Nullable T> createIterator() {
        final List<ExtensionComponentAdapter> adapters = this.getSortedAdapters();
        final int size = adapters.size();
        if (size == 0) {
            Iterator iterator2 = Collections.emptyIterator();
            if (iterator2 == null) {
                ExtensionPointImpl.$$$reportNull$$$0(32);
            }
            return iterator2;
        }
        return new Iterator<T>(){
            private int currentIndex;

            @Override
            public boolean hasNext() {
                return this.currentIndex < size;
            }

            @Override
            @Nullable
            public T next() {
                do {
                    Object extension;
                    if ((extension = ExtensionPointImpl.this.processAdapter((ExtensionComponentAdapter)adapters.get(this.currentIndex++))) == null) continue;
                    return extension;
                } while (this.hasNext());
                return null;
            }
        };
    }

    @Override
    public final Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 1281);
    }

    @Override
    public final int size() {
        T[] cache2 = this.cachedExtensionsAsArray;
        return cache2 == null ? this.adapters.size() : cache2.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final List<ExtensionComponentAdapter> getSortedAdapters() {
        if (this.adaptersAreSorted) {
            List<ExtensionComponentAdapter> list = this.adapters;
            if (list == null) {
                ExtensionPointImpl.$$$reportNull$$$0(34);
            }
            return list;
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            if (this.adaptersAreSorted) {
                List<ExtensionComponentAdapter> list = this.adapters;
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                if (list == null) {
                    ExtensionPointImpl.$$$reportNull$$$0(35);
                }
                return list;
            }
            if (this.adapters.size() > 1) {
                ArrayList<ExtensionComponentAdapter> list = new ArrayList<ExtensionComponentAdapter>(this.adapters);
                LoadingOrder.Companion.sort(list);
                this.adapters = list;
            }
            this.adaptersAreSorted = true;
        }
        List<ExtensionComponentAdapter> list = this.adapters;
        if (list == null) {
            ExtensionPointImpl.$$$reportNull$$$0(36);
        }
        return list;
    }

    private T @NotNull [] processAdapters() {
        this.assertNotReadOnlyMode();
        CHECK_CANCELED.run();
        long startTime = System.nanoTime();
        List<ExtensionComponentAdapter> adapters = this.getSortedAdapters();
        int totalSize = adapters.size();
        Class<T> extensionClass = this.getExtensionClass();
        T[] result2 = ArrayUtil.newArray(extensionClass, totalSize);
        if (totalSize == 0) {
            if (result2 == null) {
                ExtensionPointImpl.$$$reportNull$$$0(37);
            }
            return result2;
        }
        HashSet duplicates = this instanceof BeanExtensionPoint ? null : new HashSet(totalSize);
        ExtensionPointListener<T>[] listeners = this.listeners;
        int extensionIndex = 0;
        for (int i = 0; i < adapters.size(); ++i) {
            @Nullable T extension = this.processAdapter(adapters.get(i), listeners, result2, duplicates, extensionClass, adapters);
            if (extension == null) continue;
            result2[extensionIndex++] = extension;
        }
        if (extensionIndex != result2.length) {
            result2 = Arrays.copyOf(result2, extensionIndex);
        }
        ActivityCategory category = this.componentManager.getActivityCategory(true);
        StartUpMeasurer.addCompletedActivity(startTime, extensionClass, category, null, StartUpMeasurer.MEASURE_THRESHOLD);
        if (result2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(38);
        }
        return result2;
    }

    @Nullable
    private synchronized T processAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(39);
        }
        try {
            if (!ExtensionPointImpl.checkThatClassloaderIsActive(adapter)) {
                return null;
            }
            @Nullable T instance = adapter.createInstance(this.componentManager);
            if (instance == null && LOG.isDebugEnabled()) {
                LOG.debug(adapter + " not loaded because it reported that not applicable");
            }
            return instance;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return null;
        }
    }

    @Nullable
    private T processAdapter(@NotNull ExtensionComponentAdapter adapter, ExtensionPointListener<T> @Nullable [] listeners, T @Nullable [] result2, @Nullable Set<T> duplicates, @NotNull Class<T> extensionClassForCheck, @NotNull List<? extends ExtensionComponentAdapter> adapters) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(40);
        }
        if (extensionClassForCheck == null) {
            ExtensionPointImpl.$$$reportNull$$$0(41);
        }
        if (adapters == null) {
            ExtensionPointImpl.$$$reportNull$$$0(42);
        }
        try {
            Object duplicate;
            if (!ExtensionPointImpl.checkThatClassloaderIsActive(adapter)) {
                return null;
            }
            boolean isNotifyThatAdded = listeners != null && listeners.length != 0 && !adapter.isInstanceCreated$intellij_platform_extensions() && !this.isDynamic;
            @Nullable T extension = adapter.createInstance(this.componentManager);
            if (extension == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(adapter + " not loaded because it reported that not applicable");
                }
                return null;
            }
            if (duplicates != null && !duplicates.add(extension)) {
                duplicate = null;
                for (T value2 : duplicates) {
                    if (!value2.equals(extension)) continue;
                    duplicate = value2;
                    break;
                }
                assert (result2 != null);
            } else {
                this.checkExtensionType(extension, extensionClassForCheck, adapter);
                if (isNotifyThatAdded) {
                    this.notifyListeners(false, Collections.singletonList(adapter), listeners);
                }
                return extension;
            }
            LOG.error("Duplicate extension found:\n                   " + extension + ";\n  prev extension:  " + duplicate + ";\n  adapter:         " + adapter + ";\n  extension class: " + extensionClassForCheck + ";\n  result:          " + Arrays.asList(result2) + ";\n  adapters:        " + adapters);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return null;
    }

    private static boolean checkThatClassloaderIsActive(@NotNull ExtensionComponentAdapter adapter) {
        ClassLoader classLoader;
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(43);
        }
        if ((classLoader = adapter.pluginDescriptor.getPluginClassLoader()) instanceof PluginAwareClassLoader && ((PluginAwareClassLoader)((Object)classLoader)).getState() != 1) {
            LOG.warn(adapter + " not loaded because classloader is being unloaded");
            return false;
        }
        return true;
    }

    @Override
    public final void unregisterExtension(@NotNull Class<? extends T> extensionClass) {
        String classNameToUnregister;
        if (extensionClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(49);
        }
        if (!this.unregisterExtensions((arg_0, arg_1) -> ExtensionPointImpl.lambda$unregisterExtension$7(classNameToUnregister = extensionClass.getCanonicalName(), arg_0, arg_1), true)) {
            LOG.warn("Extension to be removed not found: " + extensionClass);
        }
    }

    public final boolean unregisterExtensions(@NotNull BiPredicate<String, ExtensionComponentAdapter> extensionClassNameFilter, boolean stopAfterFirstMatch) {
        if (extensionClassNameFilter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(50);
        }
        ArrayList listenerCallbacks = new ArrayList();
        ArrayList priorityListenerCallbacks = new ArrayList();
        boolean result2 = this.unregisterExtensions(stopAfterFirstMatch, priorityListenerCallbacks, listenerCallbacks, adapter -> extensionClassNameFilter.test(adapter.getAssignableToClassName(), (ExtensionComponentAdapter)adapter));
        for (Runnable callback : priorityListenerCallbacks) {
            callback.run();
        }
        for (Runnable callback : listenerCallbacks) {
            callback.run();
        }
        return result2;
    }

    final synchronized boolean unregisterExtensions(boolean stopAfterFirstMatch, @NotNull List<? super Runnable> priorityListenerCallbacks, @NotNull List<? super Runnable> listenerCallbacks, @NotNull Predicate<? super ExtensionComponentAdapter> extensionToKeepFilter) {
        if (priorityListenerCallbacks == null) {
            ExtensionPointImpl.$$$reportNull$$$0(51);
        }
        if (listenerCallbacks == null) {
            ExtensionPointImpl.$$$reportNull$$$0(52);
        }
        if (extensionToKeepFilter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(53);
        }
        ExtensionPointListener<T>[] listeners = this.listeners;
        ArrayList<ExtensionComponentAdapter> removedAdapters = null;
        List<ExtensionComponentAdapter> adapters = this.adapters;
        for (int i = adapters.size() - 1; i >= 0; --i) {
            ExtensionComponentAdapter adapter = adapters.get(i);
            if (extensionToKeepFilter.test(adapter)) continue;
            if (adapters == this.adapters) {
                adapters = new ArrayList<ExtensionComponentAdapter>(adapters);
            }
            adapters.remove(i);
            if (listeners.length != 0) {
                if (removedAdapters == null) {
                    removedAdapters = new ArrayList<ExtensionComponentAdapter>();
                }
                removedAdapters.add(adapter);
            }
            if (stopAfterFirstMatch) break;
        }
        if (adapters == this.adapters) {
            return false;
        }
        this.clearCache();
        this.adapters = adapters;
        if (removedAdapters == null) {
            return true;
        }
        List<ExtensionPointListener> priorityListeners = ContainerUtil.filter(listeners, listener2 -> listener2 instanceof ExtensionPointPriorityListener);
        List<ExtensionPointListener> regularListeners = ContainerUtil.filter(listeners, listener2 -> !(listener2 instanceof ExtensionPointPriorityListener));
        ArrayList<ExtensionComponentAdapter> finalRemovedAdapters = removedAdapters;
        if (!priorityListeners.isEmpty()) {
            priorityListenerCallbacks.add(() -> this.notifyListeners(true, finalRemovedAdapters, priorityListeners.toArray(ExtensionPointListener.Companion.emptyArray())));
        }
        if (!regularListeners.isEmpty()) {
            listenerCallbacks.add(() -> this.notifyListeners(true, finalRemovedAdapters, regularListeners.toArray(ExtensionPointListener.Companion.emptyArray())));
        }
        return true;
    }

    private void notifyListeners(boolean isRemoved, @NotNull List<? extends ExtensionComponentAdapter> adapters, @NotNull @NotNull ExtensionPointListener<T> @NotNull [] listeners) {
        if (adapters == null) {
            ExtensionPointImpl.$$$reportNull$$$0(54);
        }
        if (listeners == null) {
            ExtensionPointImpl.$$$reportNull$$$0(55);
        }
        for (ExtensionPointListener listener2 : listeners) {
            if (listener2 instanceof ExtensionPointAdapter) {
                try {
                    ((ExtensionPointAdapter)listener2).extensionListChanged();
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                    continue;
                }
            }
            for (ExtensionComponentAdapter extensionComponentAdapter : adapters) {
                if (isRemoved && !extensionComponentAdapter.isInstanceCreated$intellij_platform_extensions()) continue;
                try {
                    @Nullable T extension = extensionComponentAdapter.createInstance(this.componentManager);
                    if (extension == null) continue;
                    if (isRemoved) {
                        listener2.extensionRemoved(extension, extensionComponentAdapter.pluginDescriptor);
                        continue;
                    }
                    listener2.extensionAdded(extension, extensionComponentAdapter.pluginDescriptor);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    @Override
    public final void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener2, boolean invokeForLoadedExtensions, @Nullable Disposable parentDisposable) {
        boolean isAdded;
        if (listener2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(56);
        }
        if (!(isAdded = this.addListener(listener2))) {
            return;
        }
        if (invokeForLoadedExtensions) {
            this.notifyListeners(false, this.getSortedAdapters(), new ExtensionPointListener[]{listener2});
        }
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> this.removeExtensionPointListener(listener2));
        }
    }

    @NotNull
    private static <T> ArrayFactory<ExtensionPointListener<T>> listenerArrayFactory() {
        ArrayFactory<ExtensionPointListener<T>> arrayFactory = LISTENER_ARRAY_FACTORY;
        if (arrayFactory == null) {
            ExtensionPointImpl.$$$reportNull$$$0(57);
        }
        return arrayFactory;
    }

    private synchronized boolean addListener(@NotNull ExtensionPointListener<T> listener2) {
        if (listener2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(58);
        }
        if (ArrayUtilRt.indexOf(this.listeners, listener2, 0, this.listeners.length) != -1) {
            return false;
        }
        this.listeners = listener2 instanceof ExtensionPointPriorityListener ? ArrayUtil.prepend(listener2, this.listeners, ExtensionPointImpl.listenerArrayFactory()) : ArrayUtil.append(this.listeners, listener2, ExtensionPointImpl.listenerArrayFactory());
        return true;
    }

    public final synchronized void addChangeListener(final @NotNull Runnable listener2, @Nullable Disposable parentDisposable) {
        if (listener2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(59);
        }
        ExtensionPointAdapter listenerAdapter = new ExtensionPointAdapter<T>(){

            @Override
            public void extensionListChanged() {
                listener2.run();
            }
        };
        this.listeners = ArrayUtil.append(this.listeners, listenerAdapter, ExtensionPointImpl.listenerArrayFactory());
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> this.removeExtensionPointListener(listenerAdapter));
        }
    }

    @Override
    public final synchronized void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener2) {
        if (listener2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(60);
        }
        this.listeners = ArrayUtil.remove(this.listeners, listener2, ExtensionPointImpl.listenerArrayFactory());
    }

    @NotNull
    public final Class<T> getExtensionClass() {
        Class<T> extensionClass = this.extensionClass;
        if (extensionClass == null) {
            try {
                this.extensionClass = extensionClass = this.componentManager.loadClass(this.className, this.pluginDescriptor);
            }
            catch (ClassNotFoundException e) {
                throw this.componentManager.createError(e, this.pluginDescriptor.getPluginId());
            }
        }
        Class<T> clazz = extensionClass;
        if (clazz == null) {
            ExtensionPointImpl.$$$reportNull$$$0(61);
        }
        return clazz;
    }

    public final String toString() {
        return this.getName();
    }

    final synchronized void addExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(62);
        }
        ArrayList<ExtensionComponentAdapter> list = new ArrayList<ExtensionComponentAdapter>(this.adapters.size() + 1);
        list.addAll(this.adapters);
        list.add(adapter);
        this.adapters = list;
        this.clearCache();
    }

    final void clearUserCache() {
        ConcurrentMap<?, Map<?, ?>> map2 = this.keyMapperToCacheRef.get();
        if (map2 != null) {
            map2.clear();
        }
    }

    private void clearCache() {
        this.cachedExtensions = null;
        this.cachedExtensionsAsArray = null;
        this.adaptersAreSorted = false;
        this.clearUserCache();
        this.assertNotReadOnlyMode();
    }

    private void assertNotReadOnlyMode() {
        if (this.isInReadOnlyMode()) {
            throw new IllegalStateException(this + " in a read-only mode and cannot be modified");
        }
    }

    @NotNull
    abstract ExtensionComponentAdapter createAdapter(@NotNull ExtensionDescriptor var1, @NotNull PluginDescriptor var2, @NotNull ComponentManager var3);

    public final synchronized void registerExtensions(@NotNull List<ExtensionDescriptor> extensionElements, @NotNull PluginDescriptor pluginDescriptor, @Nullable List<? super Runnable> listenerCallbacks) {
        List<ExtensionComponentAdapter> adapters;
        if (extensionElements == null) {
            ExtensionPointImpl.$$$reportNull$$$0(63);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(64);
        }
        if ((adapters = this.adapters) == Collections.emptyList()) {
            this.adapters = adapters = new ArrayList<ExtensionComponentAdapter>(extensionElements.size());
            this.adaptersAreSorted = false;
        } else {
            ((ArrayList)adapters).ensureCapacity(adapters.size() + extensionElements.size());
        }
        int oldSize = adapters.size();
        for (ExtensionDescriptor extensionElement : extensionElements) {
            if (extensionElement.os != null && !this.componentManager.isSuitableForOs(extensionElement.os)) continue;
            adapters.add(this.createAdapter(extensionElement, pluginDescriptor, this.componentManager));
        }
        int newSize = adapters.size();
        this.clearCache();
        ExtensionPointListener[] listeners = this.listeners;
        if (listenerCallbacks == null || listeners.length == 0) {
            return;
        }
        List addedAdapters = Collections.emptyList();
        for (ExtensionPointListener<T> extensionPointListener : listeners) {
            if (extensionPointListener instanceof ExtensionPointAdapter) continue;
            List<ExtensionComponentAdapter> newlyAddedUnsortedList = adapters.subList(oldSize, newSize);
            Set newlyAddedSet = Collections.newSetFromMap(new IdentityHashMap(newlyAddedUnsortedList.size()));
            newlyAddedSet.addAll(newlyAddedUnsortedList);
            addedAdapters = new ArrayList(newlyAddedSet.size());
            for (ExtensionComponentAdapter adapter : this.getSortedAdapters()) {
                if (!newlyAddedSet.contains(adapter)) continue;
                addedAdapters.add(adapter);
            }
            break;
        }
        List finalAddedAdapters = addedAdapters;
        listenerCallbacks.add(() -> this.notifyListeners(false, finalAddedAdapters, listeners));
    }

    final synchronized void notifyAreaReplaced(@NotNull ExtensionsArea oldArea) {
        if (oldArea == null) {
            ExtensionPointImpl.$$$reportNull$$$0(65);
        }
        for (ExtensionPointListener<T> listener2 : this.listeners) {
            if (!(listener2 instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener2).areaReplaced(oldArea);
        }
    }

    @Nullable
    public final <V extends T> V findExtension(@NotNull Class<V> aClass, boolean isRequired, @NotNull ThreeState strictMatch) {
        T[] extensionCache;
        if (aClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(66);
        }
        if (strictMatch == null) {
            ExtensionPointImpl.$$$reportNull$$$0(67);
        }
        if (strictMatch != ThreeState.NO) {
            @Nullable V result2 = this.findExtensionByExactClass(aClass);
            if (result2 != null) {
                return result2;
            }
            if (strictMatch == ThreeState.YES) {
                return null;
            }
        }
        if ((extensionCache = this.cachedExtensionsAsArray) == null) {
            for (ExtensionComponentAdapter adapter : this.getSortedAdapters()) {
                try {
                    if (!aClass.isAssignableFrom(adapter.getImplementationClass(this.componentManager))) continue;
                    return (V)this.processAdapter(adapter);
                }
                catch (ClassNotFoundException e) {
                    this.componentManager.logError(e, adapter.pluginDescriptor.getPluginId());
                }
            }
        } else {
            for (T extension : extensionCache) {
                if (!aClass.isInstance(extension)) continue;
                return (V)extension;
            }
        }
        if (isRequired) {
            String message = "cannot find extension implementation " + aClass + "(epName=" + this.getName() + ", extensionCount=" + this.size();
            T[] cache2 = this.cachedExtensionsAsArray;
            if (cache2 != null) {
                message = message + ", cachedExtensions";
            }
            if (this.isInReadOnlyMode()) {
                message = message + ", point in read-only mode";
            }
            message = message + ")";
            throw this.componentManager.createError(message, this.getPluginDescriptor().getPluginId());
        }
        return null;
    }

    @Nullable
    private T findExtensionByExactClass(@NotNull Class<? extends T> aClass) {
        T[] cachedExtensions;
        if (aClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(71);
        }
        if ((cachedExtensions = this.cachedExtensionsAsArray) == null) {
            for (ExtensionComponentAdapter adapter : this.getSortedAdapters()) {
                Object classOrName = adapter.implementationClassOrName;
                if (!(classOrName instanceof String ? classOrName.equals(aClass.getName()) : classOrName == aClass)) continue;
                return this.processAdapter(adapter);
            }
        } else {
            for (T extension : cachedExtensions) {
                if (aClass != extension.getClass()) continue;
                return extension;
            }
        }
        return null;
    }

    private synchronized boolean isInReadOnlyMode() {
        return POINTS_IN_READONLY_MODE != null && POINTS_IN_READONLY_MODE.contains(this);
    }

    private static /* synthetic */ boolean lambda$unregisterExtension$7(String classNameToUnregister, String cls, ExtensionComponentAdapter adapter) {
        return !cls.equals(classNameToUnregister);
    }

    static {
        LISTENER_ARRAY_FACTORY = n -> n == 0 ? ExtensionPointListener.Companion.emptyArray() : new ExtensionPointListener[n];
        CHECK_CANCELED = EmptyRunnable.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 57: 
            case 61: 
            case 69: 
            case 70: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 57: 
            case 61: 
            case 69: 
            case 70: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: 
            case 11: 
            case 19: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 57: 
            case 61: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 24: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 9: 
            case 12: 
            case 16: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 20: 
            case 21: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 23: 
            case 42: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapters";
                break;
            }
            case 25: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 39: 
            case 40: 
            case 43: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClassForCheck";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newList";
                break;
            }
            case 47: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClassNameFilter";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityListenerCallbacks";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerCallbacks";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionToKeepFilter";
                break;
            }
            case 56: 
            case 58: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElements";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldArea";
                break;
            }
            case 66: 
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strictMatch";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkCanceled";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptor";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "doRegisterExtensions";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionList";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "extensions";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedAdapters";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "processAdapters";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "listenerArrayFactory";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionClass";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "findExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 57: 
            case 61: 
            case 69: 
            case 70: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterExtension";
                break;
            }
            case 20: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterExtensions";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findInsertionIndexForAnyOrder";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkExtensionType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processWithPluginDescriptor";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processImplementations";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkImplementations";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processAdapter";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "checkThatClassloaderIsActive";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "maskAll";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "doNotifyListeners";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtension";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensions";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "notifyListeners";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPointListener";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "removeExtensionPointListener";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionAdapter";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "notifyAreaReplaced";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "findExtension";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "findExtensions";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionByExactClass";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "setCheckCanceledAction";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isInsideClassInitializer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 57: 
            case 61: 
            case 69: 
            case 70: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ObjectComponentAdapter<T>
    extends ExtensionComponentAdapter {
        @NotNull
        private final T componentInstance;

        private ObjectComponentAdapter(@NotNull T extension, @NotNull PluginDescriptor pluginDescriptor, @NotNull LoadingOrder loadingOrder) {
            if (extension == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(1);
            }
            if (loadingOrder == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(2);
            }
            super(extension.getClass().getName(), pluginDescriptor, null, loadingOrder, (__, ___) -> extension.getClass());
            this.componentInstance = extension;
        }

        @Override
        public boolean isInstanceCreated$intellij_platform_extensions() {
            return true;
        }

        @NotNull
        public <I> I createInstance(@Nullable ComponentManager componentManager) {
            T t = this.componentInstance;
            if (t == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(3);
            }
            return (I)t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loadingOrder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

