/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPointDescriptor;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a>\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0013"}, d2={"DEBUG_REGISTRATION", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "createExtensionPoints", "", "points", "", "Lcom/intellij/openapi/extensions/ExtensionPointDescriptor;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "result", "", "", "Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "intellij.platform.extensions"})
public final class ExtensionsAreaImplKt {
    public static final void createExtensionPoints(@NotNull List<ExtensionPointDescriptor> points, @NotNull ComponentManager componentManager, @NotNull Map<String, ExtensionPointImpl<?>> result2, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter(points, "points");
        Intrinsics.checkNotNullParameter(componentManager, "componentManager");
        Intrinsics.checkNotNullParameter(result2, "result");
        Intrinsics.checkNotNullParameter(pluginDescriptor, "pluginDescriptor");
        for (ExtensionPointDescriptor descriptor2 : points) {
            ExtensionPointImpl point;
            Object object;
            ExtensionPointImpl extensionPointImpl;
            String name = descriptor2.getQualifiedName(pluginDescriptor);
            if (descriptor2.isBean) {
                extensionPointImpl = new BeanExtensionPoint(name, descriptor2.className, pluginDescriptor, componentManager, descriptor2.isDynamic);
            } else {
                object = descriptor2.className;
                boolean bl = descriptor2.hasAttributes;
                boolean bl2 = descriptor2.isDynamic;
                extensionPointImpl = new InterfaceExtensionPoint(name, (String)object, pluginDescriptor, componentManager, null, bl2, bl);
            }
            if ((object = result2.putIfAbsent(name, point = extensionPointImpl)) == null) continue;
            Object old = object;
            boolean bl = false;
            PluginDescriptor pluginDescriptor2 = ((ExtensionPointImpl)old).getPluginDescriptor();
            Intrinsics.checkNotNullExpressionValue(pluginDescriptor2, "getPluginDescriptor(...)");
            PluginDescriptor oldPluginDescriptor = pluginDescriptor2;
            RuntimeException runtimeException = componentManager.createError("Duplicate registration for EP " + name + " first in " + oldPluginDescriptor + ", second in " + pluginDescriptor, pluginDescriptor.getPluginId());
            Intrinsics.checkNotNullExpressionValue(runtimeException, "createError(...)");
            throw (Throwable)runtimeException;
        }
    }
}

