/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u0000 Z2\u00020\u0001:\u0002Z[B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H'J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H&J\b\u0010\u0017\u001a\u00020\u0013H&J1\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u0019\"\n\b\u0001\u0010\u001a*\u0004\u0018\u00010\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u001a0\u001d\u00a2\u0006\u0002\u0010\u001eJ%\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00190 \"\u0004\b\u0000\u0010\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00190\"\u00a2\u0006\u0002\u0010#J\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00190 \"\u0004\b\u0000\u0010\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u00190%H\u0007J\u0016\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.H\u0007J\u001f\u0010/\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u001900\u00a2\u0006\u0002\u00101J\u000e\u0010/\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.J\u0010\u00102\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020.H&J \u00103\u001a\u00020\u0013\"\n\b\u0000\u0010\u001a*\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a04J\b\u00105\u001a\u000206H'J+\u00107\u001a\u00020\u00132\u000b\u00108\u001a\u000709\u00a2\u0006\u0002\b:2\u0006\u0010;\u001a\u00020.2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002090 H&J\u0015\u0010=\u001a\u00020\u00132\u000b\u0010>\u001a\u000709\u00a2\u0006\u0002\b:H'J\u001f\u0010?\u001a\u00020\u00132\u000b\u0010>\u001a\u000709\u00a2\u0006\u0002\b:2\b\u0010@\u001a\u0004\u0018\u000109H&J\u001d\u0010A\u001a\u00020\u00132\u000b\u0010>\u001a\u000709\u00a2\u0006\u0002\b:2\u0006\u0010B\u001a\u00020CH&J\u0010\u0010D\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020.H&J\u0018\u0010D\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020.2\u0006\u0010E\u001a\u00020FH&J\u001d\u0010G\u001a\u00020\u00132\u000b\u0010H\u001a\u000709\u00a2\u0006\u0002\bI2\u0006\u0010J\u001a\u00020.H&J<\u0010G\u001a\u00020\u00132\u000b\u0010H\u001a\u000709\u00a2\u0006\u0002\bI2\u001c\u0010J\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130L\u0012\u0006\u0012\u0004\u0018\u00010\u00010KH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010MJ2\u0010N\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u0019002\r\u0010O\u001a\t\u0018\u000109\u00a2\u0006\u0002\b:H\u0007\u00a2\u0006\u0002\u0010PJ8\u0010N\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u0019002\r\u0010O\u001a\t\u0018\u000109\u00a2\u0006\u0002\b:2\u0006\u0010B\u001a\u00020C\u00a2\u0006\u0002\u0010QJ\u0010\u0010R\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020.H'J\b\u0010S\u001a\u00020\u0013H&J\u000e\u0010T\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020.J\u0018\u0010U\u001a\u00020(2\u0006\u0010V\u001a\u00020(2\u0006\u0010)\u001a\u00020*H&J \u0010W\u001a\u00020(2\u0006\u0010X\u001a\u00020(2\u0006\u0010Y\u001a\u00020.2\u0006\u0010)\u001a\u00020*H&R\"\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\\"}, d2={"Lcom/intellij/openapi/project/DumbService;", "", "()V", "<set-?>", "", "isAlternativeResolveEnabled", "()Z", "setAlternativeResolveEnabled", "(Z)V", "isDumb", "modificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getModificationTracker", "()Lcom/intellij/openapi/util/ModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "cancelAllTasksAndWait", "", "cancelTask", "task", "Lcom/intellij/openapi/project/DumbModeTask;", "completeJustSubmittedTasks", "computeWithAlternativeResolveEnabled", "T", "E", "", "runnable", "Lcom/intellij/openapi/util/ThrowableComputable;", "(Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "filterByDumbAwareness", "", "array", "", "([Ljava/lang/Object;)Ljava/util/List;", "collection", "", "makeDumbAware", "componentToDisable", "Ljavax/swing/JComponent;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "queueTask", "repeatUntilPassesInSmartMode", "r", "Ljava/lang/Runnable;", "runReadActionInSmartMode", "Lcom/intellij/openapi/util/Computable;", "(Lcom/intellij/openapi/util/Computable;)Ljava/lang/Object;", "runWhenSmart", "runWithAlternativeResolveEnabled", "Lcom/intellij/util/ThrowableRunnable;", "runWithWaitForSmartModeDisabled", "Lcom/intellij/openapi/application/AccessToken;", "showDumbModeActionBalloon", "balloonText", "", "Lcom/intellij/openapi/util/NlsContexts$PopupContent;", "runWhenSmartAndBalloonStillShowing", "actionIds", "showDumbModeNotification", "message", "showDumbModeNotificationForAction", "actionId", "showDumbModeNotificationForFunctionality", "functionality", "Lcom/intellij/openapi/project/DumbModeBlockedFunctionality;", "smartInvokeLater", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "suspendIndexingAndRun", "activityName", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "activity", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryRunReadActionInSmartMode", "notification", "(Lcom/intellij/openapi/util/Computable;Ljava/lang/String;)Ljava/lang/Object;", "(Lcom/intellij/openapi/util/Computable;Ljava/lang/String;Lcom/intellij/openapi/project/DumbModeBlockedFunctionality;)Ljava/lang/Object;", "unsafeRunWhenSmart", "waitForSmartMode", "withAlternativeResolveEnabled", "wrapGently", "dumbUnawareContent", "wrapWithSpoiler", "dumbAwareContent", "updateRunnable", "Companion", "DumbModeListener", "intellij.platform.core"})
public abstract class DumbService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final Topic<DumbModeListener> DUMB_MODE = new Topic<DumbModeListener>("dumb mode", DumbModeListener.class, Topic.BroadcastDirection.NONE);

    public abstract boolean isDumb();

    public abstract void waitForSmartMode();

    public final void runReadActionInSmartMode(@NotNull Runnable r) {
        Boolean success;
        Intrinsics.checkNotNullParameter(r, "r");
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            r.run();
            return;
        }
        do {
            this.waitForSmartMode();
            success = ReadAction.compute(() -> DumbService.runReadActionInSmartMode$lambda$2(this, r));
            Intrinsics.checkNotNull(success);
        } while (!success.booleanValue());
    }

    @NotNull
    public final <T> List<T> filterByDumbAwareness(@NotNull T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        return this.filterByDumbAwareness((Collection)CollectionsKt.listOf(Arrays.copyOf(array, array.length)));
    }

    @NotNull
    public final <T> List<T> filterByDumbAwareness(@NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, "collection");
        if (this.isDumb()) {
            List result2 = new ArrayList(collection.size());
            for (T element : collection) {
                if (!Companion.isDumbAware(element)) continue;
                result2.add(element);
            }
            return result2;
        }
        return collection instanceof List ? (List)collection : (List)new ArrayList<T>(collection);
    }

    public abstract void completeJustSubmittedTasks();

    @NotNull
    public abstract Project getProject();

    public abstract boolean isAlternativeResolveEnabled();

    private static final Boolean runReadActionInSmartMode$lambda$2(DumbService this$0, Runnable $r) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($r, "$r");
        if (this$0.getProject().isDisposed()) {
            throw new ProcessCanceledException();
        }
        if (this$0.isDumb()) {
            return false;
        }
        $r.run();
        return true;
    }

    public static final boolean isDumb(@NotNull Project project) {
        return Companion.isDumb(project);
    }

    @NotNull
    public static final DumbService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final boolean isDumbAware(@Nullable Object o) {
        return Companion.isDumbAware(o);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J.\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\b\b\u0000\u0010\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0007J.\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\b\b\u0000\u0010\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0018\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/project/DumbService$Companion;", "", "()V", "DUMB_MODE", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/openapi/project/DumbService$DumbModeListener;", "allowStartingDumbModeInside", "", "permission", "Lcom/intellij/openapi/project/DumbModePermission;", "runnable", "Ljava/lang/Runnable;", "getDumbAwareExtensions", "", "T", "project", "Lcom/intellij/openapi/project/Project;", "extensionPoint", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/extensions/ProjectExtensionPointName;", "getInstance", "Lcom/intellij/openapi/project/DumbService;", "isDumb", "", "isDumbAware", "o", "intellij.platform.core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isDumb(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            return this.getInstance(project).isDumb();
        }

        @NotNull
        public final DumbService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            DumbService dumbService = project.getService(DumbService.class);
            Intrinsics.checkNotNullExpressionValue(dumbService, "getService(...)");
            return dumbService;
        }

        public final boolean isDumbAware(@Nullable Object o) {
            return o instanceof PossiblyDumbAware ? ((PossiblyDumbAware)o).isDumbAware() : o instanceof DumbAware;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static interface DumbModeListener {
    }
}

