/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.text.StringUtilRt;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public final class Comparing {
    public static <T> boolean equal(@Nullable T arg1, @Nullable T arg2) {
        if (arg1 == arg2) {
            return true;
        }
        if (arg1 == null || arg2 == null) {
            return false;
        }
        if (arg1 instanceof Object[] && arg2 instanceof Object[]) {
            Object[] arr1 = (Object[])arg1;
            Object[] arr2 = (Object[])arg2;
            return Arrays.equals(arr1, arr2);
        }
        if (arg1 instanceof CharSequence && arg2 instanceof CharSequence) {
            return Comparing.equal((CharSequence)arg1, (CharSequence)arg2, true);
        }
        return arg1.equals(arg2);
    }

    public static boolean equal(CharSequence s1, CharSequence s2) {
        return StringUtilRt.equal(s1, s2, true);
    }

    public static boolean equal(@Nullable CharSequence s1, @Nullable CharSequence s2, boolean caseSensitive) {
        return StringUtilRt.equal(s1, s2, caseSensitive);
    }

    public static boolean equal(@Nullable String arg1, @Nullable String arg2, boolean caseSensitive) {
        return arg1 == null ? arg2 == null : (caseSensitive ? arg1.equals(arg2) : arg1.equalsIgnoreCase(arg2));
    }

    public static boolean strEqual(@Nullable String arg1, @Nullable String arg2) {
        return Comparing.strEqual(arg1, arg2, true);
    }

    public static boolean strEqual(@Nullable String arg1, @Nullable String arg2, boolean caseSensitive) {
        return Comparing.equal(arg1 == null ? "" : arg1, arg2 == null ? "" : arg2, caseSensitive);
    }

    public static int hashcode(@Nullable Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    public static <T extends Comparable<? super T>> int compare(@Nullable T o1, @Nullable T o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }
}

