/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.AddonlyKeylessHash;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchiveHandler {
    public static final FileAttributes DIRECTORY_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, -1L, false, FileAttributes.CaseSensitivity.SENSITIVE);
    private volatile File myPath;
    private final Object myLock;
    private volatile Reference<Map<String, EntryInfo>> myEntries;
    private volatile Reference<AddonlyKeylessHash<EntryInfo, Object>> myChildrenEntries;
    private boolean myCorrupted;
    private static final AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object> ourKeyValueMapper = new AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object>(){};

    protected ArchiveHandler(@NotNull String path) {
        if (path == null) {
            ArchiveHandler.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myEntries = new java.lang.ref.SoftReference<Object>(null);
        this.myChildrenEntries = new java.lang.ref.SoftReference<Object>(null);
        this.myPath = new File(path);
    }

    @NotNull
    public File getFile() {
        File file2 = this.myPath;
        if (file2 == null) {
            ArchiveHandler.$$$reportNull$$$0(1);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        Object object = this.myLock;
        synchronized (object) {
            this.myEntries.clear();
            this.myChildrenEntries.clear();
            this.myCorrupted = false;
        }
    }

    @Nullable
    protected EntryInfo getEntryInfo(@NotNull String relativePath) {
        if (relativePath == null) {
            ArchiveHandler.$$$reportNull$$$0(9);
        }
        return this.getEntriesMap().get(relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, EntryInfo> getEntriesMap() {
        Map<String, EntryInfo> map2 = SoftReference.dereference(this.myEntries);
        if (map2 == null) {
            Object object = this.myLock;
            synchronized (object) {
                map2 = SoftReference.dereference(this.myEntries);
                if (map2 == null) {
                    if (this.myCorrupted) {
                        map2 = Collections.emptyMap();
                    } else {
                        try {
                            map2 = this.createEntriesMap();
                        }
                        catch (Exception e) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e.getMessage() + ": " + this.myPath, e);
                            map2 = Collections.emptyMap();
                        }
                    }
                    this.myEntries = new java.lang.ref.SoftReference<Map<String, EntryInfo>>(map2);
                    this.myChildrenEntries = new java.lang.ref.SoftReference<Object>(null);
                }
            }
        }
        Map<String, EntryInfo> map3 = map2;
        if (map3 == null) {
            ArchiveHandler.$$$reportNull$$$0(10);
        }
        return map3;
    }

    @NotNull
    protected abstract Map<String, EntryInfo> createEntriesMap() throws IOException;

    @NotNull
    protected EntryInfo createRootEntry() {
        return new EntryInfo("", true, 0L, -1L, null);
    }

    protected final void processEntry(@NotNull Map<String, EntryInfo> map2, @Nullable Logger logger, @NotNull String entryName, @Nullable BiFunction<@NotNull EntryInfo, @NotNull String, ? extends @NotNull EntryInfo> entryFun) {
        String normalizedName;
        if (map2 == null) {
            ArchiveHandler.$$$reportNull$$$0(13);
        }
        if (entryName == null) {
            ArchiveHandler.$$$reportNull$$$0(14);
        }
        if ((normalizedName = this.normalizeName(entryName)).isEmpty() || normalizedName.contains("..") && ArrayUtil.contains("..", normalizedName.split("/"))) {
            if (logger != null) {
                logger.trace("invalid entry: " + this.getFile() + "!/" + entryName);
            }
            return;
        }
        if (entryFun == null) {
            this.directoryEntry(map2, logger, normalizedName);
            return;
        }
        EntryInfo existing = map2.get(normalizedName);
        if (existing != null) {
            if (logger != null) {
                logger.trace("duplicate entry: " + this.getFile() + "!/" + normalizedName);
            }
            return;
        }
        Pair<String, String> path = ArchiveHandler.split(normalizedName);
        EntryInfo parent2 = this.directoryEntry(map2, logger, (String)path.first);
        map2.put(normalizedName, entryFun.apply(parent2, (String)path.second));
    }

    @NotNull
    protected String normalizeName(@NotNull String entryName) {
        if (entryName == null) {
            ArchiveHandler.$$$reportNull$$$0(15);
        }
        String string2 = StringUtil.trimTrailing(StringUtil.trimLeading(FileUtil.normalize(entryName), '/'), '/');
        if (string2 == null) {
            ArchiveHandler.$$$reportNull$$$0(16);
        }
        return string2;
    }

    private EntryInfo directoryEntry(Map<String, EntryInfo> map2, @Nullable Logger logger, String normalizedName) {
        EntryInfo entry = map2.get(normalizedName);
        if (entry == null || !entry.isDirectory) {
            if (logger != null && entry != null) {
                logger.trace("duplicate entry: " + this.getFile() + "!/" + normalizedName);
            }
            if (normalizedName.isEmpty()) {
                entry = this.createRootEntry();
            } else {
                Pair<String, String> path = ArchiveHandler.split(normalizedName);
                EntryInfo parent2 = this.directoryEntry(map2, logger, (String)path.first);
                entry = new EntryInfo((CharSequence)path.second, true, 0L, -1L, parent2);
            }
            map2.put(normalizedName, entry);
        }
        return entry;
    }

    private static Pair<String, String> split(String normalizedName) {
        int p = normalizedName.lastIndexOf(47);
        String parentPath = p > 0 ? normalizedName.substring(0, p) : "";
        String shortName = p > 0 ? normalizedName.substring(p + 1) : normalizedName;
        return new Pair<String, String>(parentPath, shortName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/ArchiveHandler";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/ArchiveHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntriesMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEntryInfo";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processEntry";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "normalizeName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class EntryInfo {
        public final EntryInfo parent;
        public final CharSequence shortName;
        public final boolean isDirectory;
        public final long length;
        public final long timestamp;

        /*
         * WARNING - void declaration
         */
        public EntryInfo(@NotNull CharSequence shortName, boolean isDirectory, long length, long timestamp, @Nullable EntryInfo entryInfo) {
            void parent2;
            if (shortName == null) {
                EntryInfo.$$$reportNull$$$0(0);
            }
            this.parent = parent2;
            this.shortName = shortName;
            this.isDirectory = isDirectory;
            this.length = length;
            this.timestamp = timestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/openapi/vfs/impl/ArchiveHandler$EntryInfo", "<init>"));
        }
    }
}

