/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.LastComputedIconCache;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.ThreadLocalTypes;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.augment.PsiExtensionMethod;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.ScopedClassHierarchy;
import com.intellij.psi.impl.TypeCorrector;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.jvm.functions.Function1;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiClassImplUtil {
    private static final Logger LOG = Logger.getInstance(PsiClassImplUtil.class);
    private static final Function1<ClassIconRequest, Icon> FULL_ICON_EVALUATOR = r -> {
        if (!((ClassIconRequest)r).psiClass.isValid() || ((ClassIconRequest)r).psiClass.getProject().isDisposed()) {
            return null;
        }
        boolean isLocked = BitUtil.isSet(((ClassIconRequest)r).flags, 2) && !((ClassIconRequest)r).psiClass.isWritable();
        Icon symbolIcon = ((ClassIconRequest)r).symbolIcon != null ? ((ClassIconRequest)r).symbolIcon : ElementPresentationUtil.getClassIconOfKind(((ClassIconRequest)r).psiClass, ElementPresentationUtil.getClassKind(((ClassIconRequest)r).psiClass));
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon(((ClassIconRequest)r).psiClass, symbolIcon, ElementPresentationUtil.getFlags(((ClassIconRequest)r).psiClass, isLocked));
        Icon result2 = ElementPresentationUtil.addVisibilityIcon(((ClassIconRequest)r).psiClass, ((ClassIconRequest)r).flags, baseIcon);
        LastComputedIconCache.put(((ClassIconRequest)r).psiClass, result2, ((ClassIconRequest)r).flags);
        return result2;
    };

    private PsiClassImplUtil() {
    }

    public static PsiField @NotNull [] getAllFields(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(0);
        }
        List<PsiField> map2 = PsiClassImplUtil.getAllByMap(aClass, MemberType.FIELD);
        PsiField[] psiFieldArray = map2.toArray(PsiField.EMPTY_ARRAY);
        if (psiFieldArray == null) {
            PsiClassImplUtil.$$$reportNull$$$0(1);
        }
        return psiFieldArray;
    }

    public static PsiMethod @NotNull [] getAllMethods(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(2);
        }
        List<PsiMethod> methods2 = PsiClassImplUtil.getAllByMap(aClass, MemberType.METHOD);
        PsiMethod[] psiMethodArray = methods2.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            PsiClassImplUtil.$$$reportNull$$$0(3);
        }
        return psiMethodArray;
    }

    public static PsiClass @NotNull [] getAllInnerClasses(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(4);
        }
        List<PsiClass> classes2 = PsiClassImplUtil.getAllByMap(aClass, MemberType.CLASS);
        PsiClass[] psiClassArray = classes2.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            PsiClassImplUtil.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    @NotNull
    public static Collection<PsiClass> getAllSuperClassesRecursively(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(6);
        }
        List list = PsiClassImplUtil.getMap(aClass).myAllSupers;
        if (list == null) {
            PsiClassImplUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public static PsiField findFieldByName(@NotNull PsiClass aClass, String name, boolean checkBases) {
        List<PsiMember> byMap;
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(8);
        }
        return (byMap = PsiClassImplUtil.findByMap(aClass, name, checkBases, MemberType.FIELD)).isEmpty() ? null : (PsiField)byMap.get(0);
    }

    public static PsiMethod @NotNull [] findMethodsByName(@NotNull PsiClass aClass, String name, boolean checkBases) {
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(9);
        }
        List<PsiMember> methods2 = PsiClassImplUtil.findByMap(aClass, name, checkBases, MemberType.METHOD);
        PsiMethod[] psiMethodArray = methods2.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            PsiClassImplUtil.$$$reportNull$$$0(10);
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod patternMethod, boolean checkBases) {
        List<PsiMethod> result2;
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(11);
        }
        if (patternMethod == null) {
            PsiClassImplUtil.$$$reportNull$$$0(12);
        }
        return (result2 = PsiClassImplUtil.findMethodsBySignature(aClass, patternMethod, checkBases, true)).isEmpty() ? null : result2.get(0);
    }

    public static PsiMethod @NotNull [] findMethodsBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod patternMethod, boolean checkBases) {
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(13);
        }
        if (patternMethod == null) {
            PsiClassImplUtil.$$$reportNull$$$0(14);
        }
        List<PsiMethod> methods2 = PsiClassImplUtil.findMethodsBySignature(aClass, patternMethod, checkBases, false);
        PsiMethod[] psiMethodArray = methods2.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            PsiClassImplUtil.$$$reportNull$$$0(15);
        }
        return psiMethodArray;
    }

    @NotNull
    private static List<PsiMethod> findMethodsBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod patternMethod, boolean checkBases, boolean stopOnFirst) {
        PsiMethod[] methodsByName;
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(16);
        }
        if (patternMethod == null) {
            PsiClassImplUtil.$$$reportNull$$$0(17);
        }
        if ((methodsByName = aClass.findMethodsByName(patternMethod.getName(), checkBases)).length == 0) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                PsiClassImplUtil.$$$reportNull$$$0(18);
            }
            return list;
        }
        SmartList<PsiMethod> methods2 = new SmartList<PsiMethod>();
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : methodsByName) {
            PsiClass superClass = method.getContainingClass();
            PsiSubstitutor substitutor2 = checkBases && !aClass.equals(superClass) && superClass != null ? TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
            MethodSignature signature2 = method.getSignature(substitutor2);
            if (!signature2.equals(patternSignature)) continue;
            methods2.add(method);
            if (stopOnFirst) break;
        }
        SmartList<PsiMethod> smartList = methods2;
        if (smartList == null) {
            PsiClassImplUtil.$$$reportNull$$$0(19);
        }
        return smartList;
    }

    @Nullable
    public static PsiClass findInnerByName(@NotNull PsiClass aClass, String name, boolean checkBases) {
        List<PsiMember> byMap;
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(20);
        }
        return (byMap = PsiClassImplUtil.findByMap(aClass, name, checkBases, MemberType.CLASS)).isEmpty() ? null : (PsiClass)byMap.get(0);
    }

    public static boolean processAllMembersWithoutSubstitutors(@NotNull PsiClass psiClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        String name;
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(21);
        }
        if (processor == null) {
            PsiClassImplUtil.$$$reportNull$$$0(22);
        }
        if (state == null) {
            PsiClassImplUtil.$$$reportNull$$$0(23);
        }
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        NameHint nameHint = processor.getHint(NameHint.KEY);
        String string2 = name = nameHint == null ? null : nameHint.getName(state);
        if ((classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) && !PsiClassImplUtil.processMembers(state, processor, PsiClassImplUtil.getMap(psiClass).getAllMembers(MemberType.METHOD, name))) {
            return false;
        }
        if ((classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) && !PsiClassImplUtil.processMembers(state, processor, PsiClassImplUtil.getMap(psiClass).getAllMembers(MemberType.FIELD, name))) {
            return false;
        }
        return classHint != null && !classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS) || PsiClassImplUtil.processMembers(state, processor, PsiClassImplUtil.getMap(psiClass).getAllMembers(MemberType.CLASS, name));
    }

    private static boolean processMembers(ResolveState state, PsiScopeProcessor processor, PsiMember @NotNull [] members2) {
        if (members2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(24);
        }
        for (PsiMember member : members2) {
            if (processor.execute(member, state)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<PsiMember> findByMap(@NotNull PsiClass aClass, String name, boolean checkBases, @NotNull MemberType type2) {
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(25);
        }
        if (type2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(26);
        }
        if (name == null) {
            List<PsiMember> list = Collections.emptyList();
            if (list == null) {
                PsiClassImplUtil.$$$reportNull$$$0(27);
            }
            return list;
        }
        List<PsiMember> list = checkBases ? PsiClassImplUtil.getMap(aClass).calcMembersByName(type2, name, null, null) : ContainerUtil.filter(type2.getMembers(aClass), member -> name.equals(member.getName()));
        if (list == null) {
            PsiClassImplUtil.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    public static <T extends PsiMember> List<Pair<T, PsiSubstitutor>> getAllWithSubstitutorsByMap(@NotNull PsiClass aClass, @NotNull MemberType type2) {
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(29);
        }
        if (type2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(30);
        }
        return PsiClassImplUtil.withSubstitutors(aClass, PsiClassImplUtil.getMap(aClass).getAllMembers(type2, null));
    }

    @NotNull
    private static <T extends PsiMember> List<T> getAllByMap(@NotNull PsiClass aClass, @NotNull MemberType type2) {
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(31);
        }
        if (type2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(32);
        }
        List<PsiMember> list = Arrays.asList(PsiClassImplUtil.getMap(aClass).getAllMembers(type2, null));
        if (list == null) {
            PsiClassImplUtil.$$$reportNull$$$0(33);
        }
        return list;
    }

    private static MemberCache getMap(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(34);
        }
        return PsiClassImplUtil.getMap(aClass, aClass.getResolveScope());
    }

    private static MemberCache getMap(@NotNull PsiClass aClass, @NotNull GlobalSearchScope scope2) {
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(35);
        }
        if (scope2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(36);
        }
        return (MemberCache)CachedValuesManager.getProjectPsiDependentCache(aClass, c -> ConcurrentFactoryMap.createMap(s -> new MemberCache((PsiClass)c, (GlobalSearchScope)s))).get(scope2);
    }

    public static Icon getClassIcon(int flags, @NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(37);
        }
        return PsiClassImplUtil.getClassIcon(flags, aClass, null);
    }

    public static Icon getClassIcon(int flags, @NotNull PsiClass aClass, @Nullable Icon symbolIcon) {
        Icon base;
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(38);
        }
        if ((base = LastComputedIconCache.get(aClass, flags)) == null) {
            if (symbolIcon == null) {
                symbolIcon = ElementPresentationUtil.getClassIconOfKind(aClass, ElementPresentationUtil.getBasicClassKind(aClass));
            }
            RowIcon baseIcon = IconManager.getInstance().createLayeredIcon(aClass, symbolIcon, 0);
            base = ElementPresentationUtil.addVisibilityIcon(aClass, flags, baseIcon);
        }
        return IconManager.getInstance().createDeferredIcon(base, new ClassIconRequest(aClass, flags, symbolIcon), FULL_ICON_EVALUATOR);
    }

    @NotNull
    public static SearchScope getClassUseScope(@NotNull PsiClass aClass) {
        PsiDirectory dir2;
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(39);
        }
        if (aClass instanceof PsiAnonymousClass) {
            return new LocalSearchScope(aClass);
        }
        if (aClass instanceof StubBasedPsiElement) {
            PsiClassStub stub2;
            Object stubElement = ((StubBasedPsiElement)((Object)aClass)).getStub();
            if (stubElement instanceof PsiClassStub && (stub2 = (PsiClassStub)stubElement) instanceof PsiClassStubImpl && ((PsiClassStubImpl)stub2).isLocalClassInner()) {
                return new LocalSearchScope(aClass.getContainingFile());
            }
        } else {
            PsiElement grandParent;
            PsiElement parent2 = aClass.getParent();
            if (parent2 instanceof PsiDeclarationStatement && (grandParent = parent2.getParent()) instanceof PsiCodeBlock) {
                return new LocalSearchScope(grandParent);
            }
        }
        GlobalSearchScope maximalUseScope = ResolveScopeManager.getElementUseScope(aClass);
        PsiFile file2 = aClass.getContainingFile();
        if (PsiImplUtil.isInServerPage(file2)) {
            GlobalSearchScope globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) {
                PsiClassImplUtil.$$$reportNull$$$0(40);
            }
            return globalSearchScope;
        }
        SearchScope searchScope = PsiSearchScopeUtil.USE_SCOPE_KEY.get(file2);
        if (searchScope != null) {
            SearchScope searchScope2 = searchScope;
            if (searchScope2 == null) {
                PsiClassImplUtil.$$$reportNull$$$0(41);
            }
            return searchScope2;
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (aClass.hasModifierProperty("public") || aClass.hasModifierProperty("protected")) {
            SearchScope searchScope3 = containingClass == null ? maximalUseScope : containingClass.getUseScope();
            if (searchScope3 == null) {
                PsiClassImplUtil.$$$reportNull$$$0(42);
            }
            return searchScope3;
        }
        if (aClass.hasModifierProperty("private") || aClass instanceof PsiTypeParameter) {
            PsiClass topClass = PsiUtil.getTopLevelClass(aClass);
            return new LocalSearchScope(topClass == null ? aClass.getContainingFile() : topClass);
        }
        PsiPackage aPackage = null;
        if (file2 instanceof PsiJavaFile) {
            aPackage = JavaPsiFacade.getInstance(aClass.getProject()).findPackage(((PsiJavaFile)file2).getPackageName());
        }
        if (aPackage == null && (dir2 = file2.getContainingDirectory()) != null) {
            aPackage = JavaDirectoryService.getInstance().getPackage(dir2);
        }
        if (aPackage != null) {
            SearchScope scope2 = PackageScope.packageScope(aPackage, false);
            SearchScope searchScope4 = scope2 = ((SearchScope)scope2).intersectWith(maximalUseScope);
            if (searchScope4 == null) {
                PsiClassImplUtil.$$$reportNull$$$0(43);
            }
            return searchScope4;
        }
        return new LocalSearchScope(file2);
    }

    public static boolean isMainOrPremainMethod(@NotNull PsiMethod method) {
        if (method == null) {
            PsiClassImplUtil.$$$reportNull$$$0(44);
        }
        if ("main".equals(method.getName()) && PsiMethodUtil.isMainMethod(method)) {
            return true;
        }
        String name = method.getName();
        if ("premain".equals(name) || "agentmain".equals(name)) {
            return false;
        }
        if (!PsiTypes.voidType().equals(method.getReturnType())) {
            return false;
        }
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(method.getProject());
        MethodSignature signature2 = method.getSignature(PsiSubstitutor.EMPTY);
        try {
            MethodSignature main = PsiClassImplUtil.createSignatureFromText(factory2, "void main(String[] args);");
            if (MethodSignatureUtil.areSignaturesEqual(signature2, main)) {
                return true;
            }
            MethodSignature premain = PsiClassImplUtil.createSignatureFromText(factory2, "void premain(String args, java.lang.instrument.Instrumentation i);");
            if (MethodSignatureUtil.areSignaturesEqual(signature2, premain)) {
                return true;
            }
            MethodSignature agentmain = PsiClassImplUtil.createSignatureFromText(factory2, "void agentmain(String args, java.lang.instrument.Instrumentation i);");
            if (MethodSignatureUtil.areSignaturesEqual(signature2, agentmain)) {
                return true;
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        return false;
    }

    @NotNull
    private static MethodSignature createSignatureFromText(@NotNull PsiElementFactory factory2, @NotNull String text) {
        if (factory2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(45);
        }
        if (text == null) {
            PsiClassImplUtil.$$$reportNull$$$0(46);
        }
        MethodSignature methodSignature = factory2.createMethodFromText(text, null).getSignature(PsiSubstitutor.EMPTY);
        if (methodSignature == null) {
            PsiClassImplUtil.$$$reportNull$$$0(47);
        }
        return methodSignature;
    }

    private static boolean skipInvalid(@NotNull PsiElement element) {
        if (element == null) {
            PsiClassImplUtil.$$$reportNull$$$0(48);
        }
        try {
            PsiUtilCore.ensureValid(element);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return true;
        }
        return false;
    }

    public static boolean processDeclarationsInClass(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable Set<PsiClass> visited2, PsiElement last2, @NotNull PsiElement place, @NotNull LanguageLevel languageLevel, boolean isRaw) {
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(49);
        }
        if (processor == null) {
            PsiClassImplUtil.$$$reportNull$$$0(50);
        }
        if (state == null) {
            PsiClassImplUtil.$$$reportNull$$$0(51);
        }
        if (place == null) {
            PsiClassImplUtil.$$$reportNull$$$0(52);
        }
        if (languageLevel == null) {
            PsiClassImplUtil.$$$reportNull$$$0(53);
        }
        return PsiClassImplUtil.processDeclarationsInClass(aClass, processor, state, visited2, last2, place, languageLevel, isRaw, place.getResolveScope());
    }

    private static boolean processDeclarationsInClass(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable Set<PsiClass> visited2, PsiElement last2, @NotNull PsiElement place, @NotNull LanguageLevel languageLevel, boolean isRaw, @NotNull GlobalSearchScope resolveScope) {
        String name;
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(54);
        }
        if (processor == null) {
            PsiClassImplUtil.$$$reportNull$$$0(55);
        }
        if (state == null) {
            PsiClassImplUtil.$$$reportNull$$$0(56);
        }
        if (place == null) {
            PsiClassImplUtil.$$$reportNull$$$0(57);
        }
        if (languageLevel == null) {
            PsiClassImplUtil.$$$reportNull$$$0(58);
        }
        if (resolveScope == null) {
            PsiClassImplUtil.$$$reportNull$$$0(59);
        }
        if (last2 instanceof PsiTypeParameterList || last2 instanceof PsiModifierList && aClass.getModifierList() == last2) {
            return true;
        }
        if (visited2 != null && visited2.contains(aClass)) {
            return true;
        }
        PsiSubstitutor substitutor2 = state.get(PsiSubstitutor.KEY);
        isRaw = isRaw || PsiUtil.isRawSubstitutor(aClass, substitutor2);
        NameHint nameHint = processor.getHint(NameHint.KEY);
        String string2 = name = nameHint == null ? null : nameHint.getName(state);
        if (name != null) {
            return PsiClassImplUtil.processCachedMembersByName(aClass, processor, state, visited2, last2, place, isRaw, substitutor2, name, languageLevel, resolveScope);
        }
        return PsiClassImplUtil.processClassMembersWithAllNames(aClass, processor, state, visited2, last2, place, isRaw, languageLevel, resolveScope);
    }

    private static boolean processCachedMembersByName(final @NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable Set<? super PsiClass> visited2, PsiElement last2, @NotNull PsiElement place, final boolean isRaw, final @NotNull PsiSubstitutor substitutor2, String name, final @NotNull LanguageLevel languageLevel, final @NotNull GlobalSearchScope resolveScope) {
        List<PsiMember> list;
        PsiClass containingClass;
        boolean resolved;
        List<PsiMember> list2;
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(60);
        }
        if (processor == null) {
            PsiClassImplUtil.$$$reportNull$$$0(61);
        }
        if (state == null) {
            PsiClassImplUtil.$$$reportNull$$$0(62);
        }
        if (place == null) {
            PsiClassImplUtil.$$$reportNull$$$0(63);
        }
        if (substitutor2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(64);
        }
        if (languageLevel == null) {
            PsiClassImplUtil.$$$reportNull$$$0(65);
        }
        if (resolveScope == null) {
            PsiClassImplUtil.$$$reportNull$$$0(66);
        }
        Function<PsiMember, PsiSubstitutor> finalSubstitutor = new Function<PsiMember, PsiSubstitutor>(){
            final ScopedClassHierarchy hierarchy;
            final PsiElementFactory factory;
            {
                this.hierarchy = ScopedClassHierarchy.getHierarchy(aClass, resolveScope);
                this.factory = JavaPsiFacade.getElementFactory(aClass.getProject());
            }

            @Override
            public PsiSubstitutor apply(PsiMember member) {
                PsiSubstitutor finalSubstitutor = member.hasModifierProperty("static") ? substitutor2 : this.obtainSubstitutor(member);
                return member instanceof PsiMethod ? PsiClassImplUtil.checkRaw(isRaw, this.factory, (PsiMethod)member, finalSubstitutor) : finalSubstitutor;
            }

            private PsiSubstitutor obtainSubstitutor(PsiMember member) {
                PsiClass containingClass = Objects.requireNonNull(member.getContainingClass());
                PsiSubstitutor superSubstitutor = ObjectUtils.notNull(this.hierarchy.getSuperMembersSubstitutor(containingClass, languageLevel), PsiSubstitutor.EMPTY);
                return PsiClassImplUtil.obtainFinalSubstitutor(containingClass, superSubstitutor, aClass, substitutor2, this.factory, languageLevel);
            }
        };
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) {
            PsiField fieldByName = aClass.findFieldByName(name, false);
            if (fieldByName != null) {
                if (!PsiClassImplUtil.skipInvalid(fieldByName)) {
                    processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                    if (!processor.execute(fieldByName, state)) {
                        return false;
                    }
                }
            } else {
                list2 = PsiClassImplUtil.getMap(aClass, resolveScope).calcMembersByName(MemberType.FIELD, name, aClass, place);
                if (!list2.isEmpty()) {
                    resolved = false;
                    for (PsiMember candidateField : list2) {
                        containingClass = candidateField.getContainingClass();
                        if (PsiClassImplUtil.skipInvalid(candidateField)) continue;
                        if (containingClass == null) {
                            PsiElement parent2 = candidateField.getParent();
                            LOG.error("No class for field " + candidateField.getName() + " of " + candidateField.getClass() + ", parent " + parent2 + " of " + (parent2 == null ? null : parent2.getClass()));
                            continue;
                        }
                        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                        if (processor.execute(candidateField, state.put(PsiSubstitutor.KEY, (PsiSubstitutor)finalSubstitutor.apply(candidateField)))) continue;
                        resolved = true;
                    }
                    if (resolved) {
                        return false;
                    }
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            if (last2 != null && last2.getContext() == aClass) {
                if (last2 instanceof PsiClass && !processor.execute(last2, state)) {
                    return false;
                }
                list = aClass.getTypeParameterList();
                if (list != null && !list.processDeclarations(processor, state, last2, place)) {
                    return false;
                }
            }
            if (!(last2 instanceof PsiReferenceList)) {
                PsiClass classByName = aClass.findInnerClassByName(name, false);
                if (classByName != null) {
                    if (!PsiClassImplUtil.skipInvalid(classByName)) {
                        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                        if (!processor.execute(classByName, state)) {
                            return false;
                        }
                    }
                } else {
                    list2 = PsiClassImplUtil.getMap(aClass, resolveScope).calcMembersByName(MemberType.CLASS, name, aClass, place);
                    if (!list2.isEmpty()) {
                        resolved = false;
                        for (PsiMember inner : list2) {
                            if (PsiClassImplUtil.skipInvalid(inner) || (containingClass = inner.getContainingClass()) == null) continue;
                            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                            if (processor.execute(inner, state.put(PsiSubstitutor.KEY, (PsiSubstitutor)finalSubstitutor.apply(inner)))) continue;
                            resolved = true;
                        }
                        if (resolved) {
                            return false;
                        }
                    }
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            MethodResolverProcessor methodResolverProcessor;
            if (processor instanceof MethodResolverProcessor && (methodResolverProcessor = (MethodResolverProcessor)processor).isConstructor()) {
                PsiMethod[] constructors2 = aClass.getConstructors();
                methodResolverProcessor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                for (PsiMethod constructor : constructors2) {
                    if (PsiClassImplUtil.skipInvalid(constructor) || methodResolverProcessor.execute(constructor, state)) continue;
                    return false;
                }
                return true;
            }
            list = PsiClassImplUtil.getMap(aClass, resolveScope).calcMembersByName(MemberType.METHOD, name, aClass, place);
            if (!list.isEmpty()) {
                boolean resolved2 = false;
                for (PsiMember candidate : list) {
                    ProgressIndicatorProvider.checkCanceled();
                    PsiMethod candidateMethod = (PsiMethod)candidate;
                    if (PsiClassImplUtil.skipInvalid(candidateMethod) || processor instanceof MethodResolverProcessor && candidateMethod.isConstructor() != ((MethodResolverProcessor)processor).isConstructor() || (containingClass = candidateMethod.getContainingClass()) == null || visited2 != null && visited2.contains(containingClass)) continue;
                    processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                    if (processor.execute(candidateMethod, state.put(PsiSubstitutor.KEY, (PsiSubstitutor)finalSubstitutor.apply(candidateMethod)))) continue;
                    resolved2 = true;
                }
                if (resolved2) {
                    return false;
                }
                if (visited2 != null) {
                    for (PsiMember aList : list) {
                        visited2.add(aList.getContainingClass());
                    }
                }
            }
        }
        return true;
    }

    private static PsiSubstitutor checkRaw(boolean isRaw, @NotNull PsiElementFactory factory2, @NotNull PsiMethod candidateMethod, @NotNull PsiSubstitutor substitutor2) {
        PsiClass containingClass;
        if (factory2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(67);
        }
        if (candidateMethod == null) {
            PsiClassImplUtil.$$$reportNull$$$0(68);
        }
        if (substitutor2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(69);
        }
        if (isRaw && !candidateMethod.hasModifierProperty("static") && (containingClass = candidateMethod.getContainingClass()) != null && containingClass.hasTypeParameters()) {
            PsiTypeParameter[] methodTypeParameters = candidateMethod.getTypeParameters();
            substitutor2 = factory2.createRawSubstitutor(substitutor2, methodTypeParameters);
        }
        return substitutor2;
    }

    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass candidateClass, @NotNull PsiSubstitutor candidateSubstitutor, @NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor2, @NotNull PsiElementFactory elementFactory, @NotNull LanguageLevel languageLevel) {
        if (candidateClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(70);
        }
        if (candidateSubstitutor == null) {
            PsiClassImplUtil.$$$reportNull$$$0(71);
        }
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(72);
        }
        if (substitutor2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(73);
        }
        if (elementFactory == null) {
            PsiClassImplUtil.$$$reportNull$$$0(74);
        }
        if (languageLevel == null) {
            PsiClassImplUtil.$$$reportNull$$$0(75);
        }
        if (PsiUtil.isRawSubstitutor(aClass, substitutor2)) {
            return elementFactory.createRawSubstitutor(candidateClass).putAll(substitutor2);
        }
        PsiClassType containingType = elementFactory.createType(candidateClass, candidateSubstitutor, languageLevel);
        PsiType type2 = substitutor2.substitute(containingType);
        if (!(type2 instanceof PsiClassType)) {
            return candidateSubstitutor;
        }
        return ((PsiClassType)type2).resolveGenerics().getSubstitutor();
    }

    private static boolean processClassMembersWithAllNames(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable Set<PsiClass> visited2, PsiElement last2, @NotNull PsiElement place, boolean isRaw, @NotNull LanguageLevel languageLevel, @NotNull GlobalSearchScope resolveScope) {
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(76);
        }
        if (processor == null) {
            PsiClassImplUtil.$$$reportNull$$$0(77);
        }
        if (state == null) {
            PsiClassImplUtil.$$$reportNull$$$0(78);
        }
        if (place == null) {
            PsiClassImplUtil.$$$reportNull$$$0(79);
        }
        if (languageLevel == null) {
            PsiClassImplUtil.$$$reportNull$$$0(80);
        }
        if (resolveScope == null) {
            PsiClassImplUtil.$$$reportNull$$$0(81);
        }
        ProgressManager.checkCanceled();
        if (visited2 == null) {
            visited2 = new HashSet<PsiClass>();
        }
        if (!visited2.add(aClass)) {
            return true;
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        if ((classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) && !PsiClassImplUtil.processMembers(state, processor, aClass.getFields())) {
            return false;
        }
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(aClass.getProject());
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            PsiSubstitutor baseSubstitutor = state.get(PsiSubstitutor.KEY);
            for (PsiMethod method : aClass.getMethods()) {
                ResolveState methodState;
                PsiSubstitutor finalSubstitutor2 = PsiClassImplUtil.checkRaw(isRaw, factory2, method, baseSubstitutor);
                ResolveState resolveState = methodState = finalSubstitutor2 == baseSubstitutor ? state : state.put(PsiSubstitutor.KEY, finalSubstitutor2);
                if (processor.execute(method, methodState)) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiTypeParameterList list;
            if (last2 != null && last2.getContext() == aClass && (list = aClass.getTypeParameterList()) != null && !list.processDeclarations(processor, ResolveState.initial(), last2, place)) {
                return false;
            }
            if (!(last2 instanceof PsiReferenceList || last2 instanceof PsiModifierList || PsiClassImplUtil.processMembers(state, processor, aClass.getInnerClasses()))) {
                return false;
            }
        }
        if (last2 instanceof PsiReferenceList) {
            return true;
        }
        Set<PsiClass> visited1 = visited2;
        return PsiClassImplUtil.processSuperTypes(aClass, state.get(PsiSubstitutor.KEY), factory2, languageLevel, resolveScope, (superClass, finalSubstitutor) -> PsiClassImplUtil.processDeclarationsInClass(superClass, processor, state.put(PsiSubstitutor.KEY, finalSubstitutor), visited1, last2, place, languageLevel, isRaw, resolveScope));
    }

    @Nullable
    public static <T extends PsiType> T correctType(@Nullable T originalType, @NotNull GlobalSearchScope resolveScope) {
        if (resolveScope == null) {
            PsiClassImplUtil.$$$reportNull$$$0(82);
        }
        if (originalType == null || !Registry.is("java.correct.class.type.by.place.resolve.scope", true)) {
            return originalType;
        }
        return new TypeCorrector(resolveScope).correctType(originalType);
    }

    public static List<PsiClassType.ClassResolveResult> getScopeCorrectedSuperTypes(PsiClass aClass, GlobalSearchScope resolveScope) {
        if (PsiClassImplUtil.skipInvalid(aClass)) {
            return Collections.emptyList();
        }
        return ScopedClassHierarchy.getHierarchy(aClass, resolveScope).getImmediateSupersWithCapturing();
    }

    static boolean processSuperTypes(@NotNull PsiClass aClass, PsiSubstitutor substitutor2, @NotNull PsiElementFactory factory2, @NotNull LanguageLevel languageLevel, GlobalSearchScope resolveScope, PairProcessor<? super PsiClass, ? super PsiSubstitutor> processor) {
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(83);
        }
        if (factory2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(84);
        }
        if (languageLevel == null) {
            PsiClassImplUtil.$$$reportNull$$$0(85);
        }
        boolean resolved = false;
        for (PsiClassType.ClassResolveResult superTypeResolveResult : PsiClassImplUtil.getScopeCorrectedSuperTypes(aClass, resolveScope)) {
            PsiClass superClass = superTypeResolveResult.getElement();
            assert (superClass != null);
            PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(superClass, superTypeResolveResult.getSubstitutor(), aClass, substitutor2, factory2, languageLevel);
            if (processor.process(superClass, finalSubstitutor)) continue;
            resolved = true;
        }
        return !resolved;
    }

    @Nullable
    public static PsiClass getSuperClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(86);
        }
        if (psiClass.isInterface()) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
        }
        if (psiClass.isEnum()) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Enum");
        }
        if (psiClass.isRecord()) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Record");
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass == null || baseClass.isInterface()) {
                return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
            }
            return baseClass;
        }
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        PsiClassType[] referenceElements = psiClass.getExtendsListTypes();
        if (referenceElements.length == 0) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
        }
        PsiClass psiResolved = referenceElements[0].resolve();
        return psiResolved == null ? PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object") : psiResolved;
    }

    @Nullable
    private static PsiClass findSpecialSuperClass(@NotNull PsiClass psiClass, @NotNull String className) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(87);
        }
        if (className == null) {
            PsiClassImplUtil.$$$reportNull$$$0(88);
        }
        return JavaPsiFacade.getInstance(psiClass.getProject()).findClass(className, psiClass.getResolveScope());
    }

    public static PsiClass @NotNull [] getSupers(@NotNull PsiClass psiClass) {
        PsiClass[] supers;
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(89);
        }
        for (PsiClass aSuper : supers = PsiClassImplUtil.getSupersInner(psiClass)) {
            LOG.assertTrue(aSuper != null);
        }
        if (supers == null) {
            PsiClassImplUtil.$$$reportNull$$$0(90);
        }
        return supers;
    }

    private static PsiClass @NotNull [] getSupersInner(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(91);
        }
        PsiClassType[] extendsListTypes = psiClass.getExtendsListTypes();
        if (psiClass.isInterface()) {
            return PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass, true);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray;
            PsiAnonymousClass psiAnonymousClass = (PsiAnonymousClass)psiClass;
            PsiClassType baseClassReference = psiAnonymousClass.getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null) {
                if (baseClass.isInterface()) {
                    PsiClass[] psiClassArray2;
                    PsiClass objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
                    if (objectClass != null) {
                        PsiClass[] psiClassArray3 = new PsiClass[2];
                        psiClassArray3[0] = objectClass;
                        psiClassArray2 = psiClassArray3;
                        psiClassArray3[1] = baseClass;
                    } else {
                        PsiClass[] psiClassArray4 = new PsiClass[1];
                        psiClassArray2 = psiClassArray4;
                        psiClassArray4[0] = baseClass;
                    }
                    if (psiClassArray2 == null) {
                        PsiClassImplUtil.$$$reportNull$$$0(92);
                    }
                    return psiClassArray2;
                }
                PsiClass[] psiClassArray5 = new PsiClass[]{baseClass};
                if (psiClassArray5 == null) {
                    PsiClassImplUtil.$$$reportNull$$$0(93);
                }
                return psiClassArray5;
            }
            PsiClass objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
            if (objectClass != null) {
                PsiClass[] psiClassArray6 = new PsiClass[1];
                psiClassArray = psiClassArray6;
                psiClassArray6[0] = objectClass;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            if (psiClassArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(94);
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiTypeParameter) {
            if (extendsListTypes.length == 0) {
                PsiClass[] psiClassArray;
                PsiClass objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
                if (objectClass != null) {
                    PsiClass[] psiClassArray7 = new PsiClass[1];
                    psiClassArray = psiClassArray7;
                    psiClassArray7[0] = objectClass;
                } else {
                    psiClassArray = PsiClass.EMPTY_ARRAY;
                }
                if (psiClassArray == null) {
                    PsiClassImplUtil.$$$reportNull$$$0(95);
                }
                return psiClassArray;
            }
            return PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass, false);
        }
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        PsiClass[] interfaces = PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass, false);
        PsiClass superClass = PsiClassImplUtil.getSuperClass(psiClass);
        if (superClass == null) {
            if (interfaces == null) {
                PsiClassImplUtil.$$$reportNull$$$0(96);
            }
            return interfaces;
        }
        PsiClass[] types2 = new PsiClass[interfaces.length + 1];
        types2[0] = superClass;
        System.arraycopy(interfaces, 0, types2, 1, interfaces.length);
        if (types2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(97);
        }
        return types2;
    }

    public static PsiClassType @NotNull [] getSuperTypes(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(98);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass == null || !baseClass.isInterface()) {
                PsiClassType[] psiClassTypeArray = new PsiClassType[]{baseClassType};
                if (psiClassTypeArray == null) {
                    PsiClassImplUtil.$$$reportNull$$$0(99);
                }
                return psiClassTypeArray;
            }
            PsiClassType objectType = PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{objectType, baseClassType};
            if (psiClassTypeArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(100);
            }
            return psiClassTypeArray;
        }
        PsiClassType[] extendsTypes = psiClass.getExtendsListTypes();
        PsiClassType[] implementsTypes = psiClass.getImplementsListTypes();
        boolean hasExtends = extendsTypes.length != 0;
        int extendsListLength = extendsTypes.length + (hasExtends ? 0 : 1);
        PsiClassType[] result2 = new PsiClassType[extendsListLength + implementsTypes.length];
        System.arraycopy(extendsTypes, 0, result2, 0, extendsTypes.length);
        if (!hasExtends) {
            PsiClassType objectType;
            if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
                if (PsiClassType.EMPTY_ARRAY == null) {
                    PsiClassImplUtil.$$$reportNull$$$0(101);
                }
                return PsiClassType.EMPTY_ARRAY;
            }
            PsiManager manager = psiClass.getManager();
            result2[0] = objectType = PsiType.getJavaLangObject(manager, psiClass.getResolveScope());
        }
        System.arraycopy(implementsTypes, 0, result2, extendsListLength, implementsTypes.length);
        if (result2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(102);
        }
        return result2;
    }

    @NotNull
    private static PsiClassType getAnnotationSuperType(@NotNull PsiClass psiClass, @NotNull PsiElementFactory factory2) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(103);
        }
        if (factory2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(104);
        }
        PsiClassType psiClassType = factory2.createTypeByFQClassName("java.lang.annotation.Annotation", psiClass.getResolveScope());
        if (psiClassType == null) {
            PsiClassImplUtil.$$$reportNull$$$0(105);
        }
        return psiClassType;
    }

    private static PsiClassType getEnumSuperType(@NotNull PsiClass psiClass, @NotNull PsiElementFactory factory2) {
        PsiClassType superType;
        PsiClass enumClass;
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(106);
        }
        if (factory2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(107);
        }
        if ((enumClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Enum")) == null) {
            try {
                superType = (PsiClassType)factory2.createTypeFromText("java.lang.Enum", null);
            }
            catch (IncorrectOperationException e) {
                superType = null;
            }
        } else {
            PsiTypeParameter[] typeParameters2 = enumClass.getTypeParameters();
            PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
            if (typeParameters2.length == 1) {
                substitutor2 = substitutor2.put(typeParameters2[0], factory2.createType(psiClass));
            }
            superType = new PsiImmediateClassType(enumClass, substitutor2);
        }
        return superType;
    }

    public static PsiClass @NotNull [] getInterfaces(@NotNull PsiTypeParameter typeParameter) {
        PsiClassType[] referencedTypes;
        if (typeParameter == null) {
            PsiClassImplUtil.$$$reportNull$$$0(108);
        }
        if ((referencedTypes = typeParameter.getExtendsListTypes()).length == 0) {
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiClassImplUtil.$$$reportNull$$$0(109);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>(referencedTypes.length);
        for (PsiClassType referencedType : referencedTypes) {
            PsiClass psiClass = referencedType.resolve();
            if (psiClass == null || !psiClass.isInterface()) continue;
            result2.add(psiClass);
        }
        PsiClass[] psiClassArray = result2.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            PsiClassImplUtil.$$$reportNull$$$0(110);
        }
        return psiClassArray;
    }

    public static PsiClass @NotNull [] getInterfaces(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(111);
        }
        if (psiClass.isInterface()) {
            return PsiClassImplUtil.resolveClassReferenceList(psiClass.getExtendsListTypes(), psiClass, false);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray;
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null && baseClass.isInterface()) {
                PsiClass[] psiClassArray2 = new PsiClass[1];
                psiClassArray = psiClassArray2;
                psiClassArray2[0] = baseClass;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            if (psiClassArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(112);
            }
            return psiClassArray;
        }
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        return PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass, false);
    }

    private static PsiClass @NotNull [] resolveClassReferenceList(PsiClassType @NotNull [] listOfTypes, @NotNull PsiClass psiClass, boolean includeObject) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(113);
        }
        if (listOfTypes == null) {
            PsiClassImplUtil.$$$reportNull$$$0(114);
        }
        PsiClass objectClass = null;
        if (includeObject && (objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object")) == null) {
            includeObject = false;
        }
        if (listOfTypes.length == 0) {
            if (includeObject) {
                PsiClass[] psiClassArray = new PsiClass[]{objectClass};
                if (psiClassArray == null) {
                    PsiClassImplUtil.$$$reportNull$$$0(115);
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiClassImplUtil.$$$reportNull$$$0(116);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        int referenceCount = listOfTypes.length;
        if (includeObject) {
            ++referenceCount;
        }
        PsiClass[] resolved = new PsiClass[referenceCount];
        int resolvedCount = 0;
        if (includeObject) {
            resolved[resolvedCount++] = objectClass;
        }
        for (PsiClassType reference : listOfTypes) {
            PsiClass refResolved = reference.resolve();
            if (refResolved == null) continue;
            resolved[resolvedCount++] = refResolved;
        }
        if (resolvedCount < referenceCount) {
            resolved = ArrayUtil.realloc(resolved, resolvedCount, PsiClass.ARRAY_FACTORY);
        }
        if (resolved == null) {
            PsiClassImplUtil.$$$reportNull$$$0(117);
        }
        return resolved;
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(@NotNull PsiClass psiClass, @NotNull String name, boolean checkBases) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(118);
        }
        if (name == null) {
            PsiClassImplUtil.$$$reportNull$$$0(119);
        }
        if (!checkBases) {
            PsiMethod[] methodsByName = psiClass.findMethodsByName(name, false);
            ArrayList<Pair<PsiMethod, PsiSubstitutor>> ret = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>(methodsByName.length);
            for (PsiMethod method : methodsByName) {
                ret.add(Pair.create(method, PsiSubstitutor.EMPTY));
            }
            ArrayList<Pair<PsiMethod, PsiSubstitutor>> arrayList = ret;
            if (arrayList == null) {
                PsiClassImplUtil.$$$reportNull$$$0(120);
            }
            return arrayList;
        }
        List<PsiMember> list = PsiClassImplUtil.getMap(psiClass).calcMembersByName(MemberType.METHOD, name, null, null);
        if (list.isEmpty()) {
            List<Pair<PsiMethod, PsiSubstitutor>> list2 = Collections.emptyList();
            if (list2 == null) {
                PsiClassImplUtil.$$$reportNull$$$0(121);
            }
            return list2;
        }
        return PsiClassImplUtil.withSubstitutors(psiClass, list.toArray(PsiMember.EMPTY_ARRAY));
    }

    @NotNull
    private static <T extends PsiMember> List<Pair<T, PsiSubstitutor>> withSubstitutors(@NotNull PsiClass psiClass, PsiMember[] members2) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(122);
        }
        ScopedClassHierarchy hierarchy = ScopedClassHierarchy.getHierarchy(psiClass, psiClass.getResolveScope());
        LanguageLevel level = PsiUtil.getLanguageLevel(psiClass);
        List<Pair<T, PsiSubstitutor>> list = ContainerUtil.map(members2, member -> {
            PsiClass containingClass = member.getContainingClass();
            PsiSubstitutor substitutor2 = containingClass == null ? null : hierarchy.getSuperMembersSubstitutor(containingClass, level);
            return Pair.create(member, substitutor2 == null ? PsiSubstitutor.EMPTY : substitutor2);
        });
        if (list == null) {
            PsiClassImplUtil.$$$reportNull$$$0(123);
        }
        return list;
    }

    public static PsiClassType @NotNull [] getExtendsListTypes(@NotNull PsiClass psiClass) {
        PsiType upperBound;
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(124);
        }
        if (psiClass.isEnum()) {
            PsiClassType[] psiClassTypeArray;
            PsiClassType enumSuperType = PsiClassImplUtil.getEnumSuperType(psiClass, JavaPsiFacade.getElementFactory(psiClass.getProject()));
            if (enumSuperType == null) {
                psiClassTypeArray = PsiClassType.EMPTY_ARRAY;
            } else {
                PsiClassType[] psiClassTypeArray2 = new PsiClassType[1];
                psiClassTypeArray = psiClassTypeArray2;
                psiClassTypeArray2[0] = enumSuperType;
            }
            if (psiClassTypeArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(125);
            }
            return psiClassTypeArray;
        }
        if (psiClass.isRecord()) {
            PsiClass recordClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Record");
            if (recordClass != null) {
                PsiClassType[] psiClassTypeArray = new PsiClassType[]{new PsiImmediateClassType(recordClass, PsiSubstitutor.EMPTY)};
                if (psiClassTypeArray == null) {
                    PsiClassImplUtil.$$$reportNull$$$0(126);
                }
                return psiClassTypeArray;
            }
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(psiClass.getProject());
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{factory2.createTypeByFQClassName("java.lang.Record", psiClass.getResolveScope())};
            if (psiClassTypeArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(127);
            }
            return psiClassTypeArray;
        }
        if (psiClass.isAnnotationType()) {
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{PsiClassImplUtil.getAnnotationSuperType(psiClass, JavaPsiFacade.getElementFactory(psiClass.getProject()))};
            if (psiClassTypeArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(128);
            }
            return psiClassTypeArray;
        }
        PsiType psiType = upperBound = psiClass instanceof PsiTypeParameter ? TypeConversionUtil.getInferredUpperBoundForSynthetic((PsiTypeParameter)psiClass) : null;
        if (upperBound == null && psiClass instanceof PsiTypeParameter) {
            upperBound = ThreadLocalTypes.getElementType(psiClass);
        }
        if (upperBound instanceof PsiIntersectionType) {
            PsiType[] conjuncts = ((PsiIntersectionType)upperBound).getConjuncts();
            ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
            for (PsiType conjunct : conjuncts) {
                if (!(conjunct instanceof PsiClassType)) continue;
                result2.add((PsiClassType)conjunct);
            }
            PsiClassType[] psiClassTypeArray = result2.toArray(PsiClassType.EMPTY_ARRAY);
            if (psiClassTypeArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(129);
            }
            return psiClassTypeArray;
        }
        if (upperBound instanceof PsiClassType) {
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{(PsiClassType)upperBound};
            if (psiClassTypeArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(130);
            }
            return psiClassTypeArray;
        }
        PsiReferenceList extendsList = psiClass.getExtendsList();
        if (extendsList != null) {
            PsiClassType[] psiClassTypeArray = extendsList.getReferencedTypes();
            if (psiClassTypeArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(131);
            }
            return psiClassTypeArray;
        }
        if (PsiClassType.EMPTY_ARRAY == null) {
            PsiClassImplUtil.$$$reportNull$$$0(132);
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    public static PsiClassType @NotNull [] getImplementsListTypes(@NotNull PsiClass psiClass) {
        PsiReferenceList extendsList;
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(133);
        }
        if ((extendsList = psiClass.getImplementsList()) != null) {
            PsiClassType[] psiClassTypeArray = extendsList.getReferencedTypes();
            if (psiClassTypeArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(134);
            }
            return psiClassTypeArray;
        }
        if (PsiClassType.EMPTY_ARRAY == null) {
            PsiClassImplUtil.$$$reportNull$$$0(135);
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    static boolean isInExtendsList(@NotNull PsiClass psiClass, @NotNull PsiClass baseClass, @Nullable String baseName, @NotNull PsiManager manager) {
        PsiType upperBound;
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(136);
        }
        if (baseClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(137);
        }
        if (manager == null) {
            PsiClassImplUtil.$$$reportNull$$$0(138);
        }
        if (psiClass.isEnum()) {
            return "java.lang.Enum".equals(baseClass.getQualifiedName());
        }
        if (psiClass.isAnnotationType()) {
            return "java.lang.annotation.Annotation".equals(baseClass.getQualifiedName());
        }
        PsiType psiType = upperBound = psiClass instanceof PsiTypeParameter ? TypeConversionUtil.getInferredUpperBoundForSynthetic((PsiTypeParameter)psiClass) : null;
        if (upperBound == null && psiClass instanceof PsiTypeParameter) {
            upperBound = ThreadLocalTypes.getElementType(psiClass);
        }
        if (upperBound instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)upperBound).getConjuncts()) {
                if (!(conjunct instanceof PsiClassType) || !((PsiClassType)conjunct).getClassName().equals(baseName) || !baseClass.equals(((PsiClassType)conjunct).resolve())) continue;
                return true;
            }
            return false;
        }
        if (upperBound instanceof PsiClassType) {
            return ((PsiClassType)upperBound).getClassName().equals(baseName) && baseClass.equals(((PsiClassType)upperBound).resolve());
        }
        return PsiClassImplUtil.isInReferenceList(psiClass.getExtendsList(), baseClass, baseName, manager);
    }

    static boolean isInReferenceList(@Nullable PsiReferenceList list, @NotNull PsiClass baseClass, @Nullable String baseName, @NotNull PsiManager manager) {
        if (baseClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(139);
        }
        if (manager == null) {
            PsiClassImplUtil.$$$reportNull$$$0(140);
        }
        if (list == null) {
            return false;
        }
        if (list instanceof StubBasedPsiElement) {
            Object stub2 = ((StubBasedPsiElement)((Object)list)).getStub();
            if (stub2 instanceof PsiClassReferenceListStub && baseName != null) {
                PsiClassReferenceListStub classStub = (PsiClassReferenceListStub)stub2;
                String[] names = classStub.getReferencedNames();
                for (int i = 0; i < names.length; ++i) {
                    PsiClass resolved;
                    String name = PsiNameHelper.getShortClassName(names[i]);
                    if (!name.endsWith(baseName)) continue;
                    PsiClassType[] referencedTypes = classStub.getReferencedTypes();
                    PsiClassType type2 = i >= referencedTypes.length ? null : referencedTypes[i];
                    PsiClass psiClass = resolved = type2 == null ? null : type2.resolve();
                    if (!manager.areElementsEquivalent(baseClass, resolved)) continue;
                    return true;
                }
                return false;
            }
            if (stub2 != null) {
                for (PsiClassType type3 : list.getReferencedTypes()) {
                    if (!Objects.equals(type3.getClassName(), baseName) || !manager.areElementsEquivalent(baseClass, type3.resolve())) continue;
                    return true;
                }
                return false;
            }
        }
        if (list.getLanguage() == JavaLanguage.INSTANCE) {
            for (PsiJavaCodeReferenceElement referenceElement : list.getReferenceElements()) {
                if (!Comparing.strEqual(baseName, referenceElement.getReferenceName()) || !manager.areElementsEquivalent(baseClass, referenceElement.resolve())) continue;
                return true;
            }
            return false;
        }
        for (PsiClassType type4 : list.getReferencedTypes()) {
            if (!Objects.equals(type4.getClassName(), baseName) || !manager.areElementsEquivalent(baseClass, type4.resolve())) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassEquivalentTo(@NotNull PsiClass aClass, PsiElement another) {
        PsiFile original2;
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(141);
        }
        if (aClass == another) {
            return true;
        }
        if (!(another instanceof PsiClass)) {
            return false;
        }
        String name1 = aClass.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiClass)another).getName();
        if (name2 == null) {
            return false;
        }
        if (name1.hashCode() != name2.hashCode()) {
            return false;
        }
        if (!name1.equals(name2)) {
            return false;
        }
        String qName1 = aClass.getQualifiedName();
        String qName2 = ((PsiClass)another).getQualifiedName();
        if (qName1 == null || qName2 == null) {
            if (!Strings.areSameInstance(qName1, qName2)) {
                return false;
            }
            if (aClass instanceof PsiTypeParameter && another instanceof PsiTypeParameter) {
                PsiTypeParameter p1 = (PsiTypeParameter)aClass;
                PsiTypeParameter p2 = (PsiTypeParameter)another;
                if (p1.getIndex() != p2.getIndex()) {
                    return false;
                }
                if (TypeConversionUtil.areSameFreshVariables(p1, p2)) {
                    return true;
                }
                return !Boolean.FALSE.equals(RecursionManager.doPreventingRecursion(Pair.create(p1, p2), true, () -> aClass.getManager().areElementsEquivalent(p1.getOwner(), p2.getOwner())));
            }
            return false;
        }
        if (!qName1.equals(qName2)) {
            return false;
        }
        if (aClass.getOriginalElement().equals(another.getOriginalElement())) {
            return true;
        }
        PsiFile file1 = PsiClassImplUtil.getOriginalFile(aClass);
        PsiFile file2 = PsiClassImplUtil.getOriginalFile((PsiClass)another);
        PsiFile original1 = file1.getUserData(PsiFileFactory.ORIGINAL_FILE);
        if (original1 == (original2 = file2.getUserData(PsiFileFactory.ORIGINAL_FILE)) && original1 != null || original1 == file2 || original2 == file1 || file1 == file2) {
            return true;
        }
        FileIndexFacade fileIndex = FileIndexFacade.getInstance(file1.getProject());
        FileIndexFacade fileIndex2 = FileIndexFacade.getInstance(file2.getProject());
        VirtualFile vfile1 = file1.getViewProvider().getVirtualFile();
        VirtualFile vfile2 = file2.getViewProvider().getVirtualFile();
        boolean lib1 = fileIndex.isInLibraryClasses(vfile1);
        boolean lib2 = fileIndex2.isInLibraryClasses(vfile2);
        return !(!fileIndex.isInSource(vfile1) && !lib1 || !fileIndex2.isInSource(vfile2) && !lib2);
    }

    @NotNull
    private static PsiFile getOriginalFile(@NotNull PsiClass aClass) {
        PsiFile file2;
        if (aClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(142);
        }
        if ((file2 = aClass.getContainingFile()) == null) {
            PsiUtilCore.ensureValid(aClass);
            throw new IllegalStateException("No containing file for " + aClass.getLanguage() + " " + aClass.getClass());
        }
        PsiFile psiFile = file2.getOriginalFile();
        if (psiFile == null) {
            PsiClassImplUtil.$$$reportNull$$$0(143);
        }
        return psiFile;
    }

    public static boolean isFieldEquivalentTo(@NotNull PsiField field, PsiElement another) {
        if (field == null) {
            PsiClassImplUtil.$$$reportNull$$$0(144);
        }
        if (!(another instanceof PsiField)) {
            return false;
        }
        String name1 = field.getName();
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiField)another).getName();
        if (!name1.equals(name2)) {
            return false;
        }
        PsiClass aClass1 = field.getContainingClass();
        PsiClass aClass2 = ((PsiField)another).getContainingClass();
        return aClass1 != null && aClass2 != null && field.getManager().areElementsEquivalent(aClass1, aClass2);
    }

    public static boolean isMethodEquivalentTo(@NotNull PsiMethod method1, PsiElement another) {
        PsiParameter[] parameters2;
        if (method1 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(145);
        }
        if (method1 == another) {
            return true;
        }
        if (!(another instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)another;
        if (!another.isValid()) {
            return false;
        }
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        PsiClass aClass1 = method1.getContainingClass();
        PsiClass aClass2 = method2.getContainingClass();
        PsiManager manager = method1.getManager();
        if (aClass1 == null || aClass2 == null || !manager.areElementsEquivalent(aClass1, aClass2)) {
            return false;
        }
        PsiParameter[] parameters1 = method1.getParameterList().getParameters();
        if (parameters1.length != (parameters2 = method2.getParameterList().getParameters()).length) {
            return false;
        }
        for (int i = 0; i < parameters1.length; ++i) {
            PsiType type2;
            PsiParameter parameter1 = parameters1[i];
            PsiParameter parameter2 = parameters2[i];
            PsiType type1 = parameter1.getType();
            if (PsiClassImplUtil.compareParamTypes(manager, type1, type2 = parameter2.getType(), new HashSet())) continue;
            return false;
        }
        return true;
    }

    private static boolean compareParamTypes(@NotNull PsiManager manager, @NotNull PsiType type1, @NotNull PsiType type2, Set<? super String> visited2) {
        if (manager == null) {
            PsiClassImplUtil.$$$reportNull$$$0(146);
        }
        if (type1 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(147);
        }
        if (type2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(148);
        }
        if (type1 instanceof PsiArrayType) {
            PsiType componentType2;
            PsiType componentType1;
            return type2 instanceof PsiArrayType && PsiClassImplUtil.compareParamTypes(manager, componentType1 = ((PsiArrayType)type1).getComponentType(), componentType2 = ((PsiArrayType)type2).getComponentType(), visited2);
        }
        if (!(type1 instanceof PsiClassType) || !(type2 instanceof PsiClassType)) {
            return type1.equals(type2);
        }
        PsiClass class1 = ((PsiClassType)type1).resolve();
        PsiClass class2 = ((PsiClassType)type2).resolve();
        visited2.add(type1.getCanonicalText());
        visited2.add(type2.getCanonicalText());
        if (class1 instanceof PsiTypeParameter && class2 instanceof PsiTypeParameter) {
            PsiClassType[] eTypes2;
            if (!Objects.equals(class1.getName(), class2.getName()) || ((PsiTypeParameter)class1).getIndex() != ((PsiTypeParameter)class2).getIndex()) {
                return false;
            }
            PsiClassType[] eTypes1 = class1.getExtendsListTypes();
            if (eTypes1.length != (eTypes2 = class2.getExtendsListTypes()).length) {
                return false;
            }
            for (int i = 0; i < eTypes1.length; ++i) {
                PsiClassType eType1 = eTypes1[i];
                PsiClassType eType2 = eTypes2[i];
                if (visited2.contains(eType1.getCanonicalText()) || visited2.contains(eType2.getCanonicalText())) {
                    return false;
                }
                if (PsiClassImplUtil.compareParamTypes(manager, eType1, eType2, visited2)) continue;
                return false;
            }
            return true;
        }
        return manager.areElementsEquivalent(class1, class2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 15: 
            case 18: 
            case 19: 
            case 27: 
            case 28: 
            case 33: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 109: 
            case 110: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 134: 
            case 135: 
            case 143: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 15: 
            case 18: 
            case 19: 
            case 27: 
            case 28: 
            case 33: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 109: 
            case 110: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 134: 
            case 135: 
            case 143: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 15: 
            case 18: 
            case 19: 
            case 27: 
            case 28: 
            case 33: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 109: 
            case 110: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 134: 
            case 135: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiClassImplUtil";
                break;
            }
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternMethod";
                break;
            }
            case 21: 
            case 86: 
            case 87: 
            case 89: 
            case 91: 
            case 98: 
            case 103: 
            case 106: 
            case 111: 
            case 113: 
            case 118: 
            case 122: 
            case 124: 
            case 133: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 22: 
            case 50: 
            case 55: 
            case 61: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 23: 
            case 51: 
            case 56: 
            case 62: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 26: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 45: 
            case 67: 
            case 84: 
            case 104: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 52: 
            case 57: 
            case 63: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 53: 
            case 58: 
            case 65: 
            case 75: 
            case 80: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 59: 
            case 66: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 64: 
            case 69: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateMethod";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateClass";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateSubstitutor";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOfTypes";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 137: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 138: 
            case 140: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method1";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiClassImplUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInnerClasses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSuperClassesRecursively";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 15: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsBySignature";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findByMap";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllByMap";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassUseScope";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createSignatureFromText";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupersInner";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationSuperType";
                break;
            }
            case 109: 
            case 110: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaces";
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveClassReferenceList";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsAndTheirSubstitutorsByName";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "withSubstitutors";
                break;
            }
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsListTypes";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsListTypes";
                break;
            }
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllFields";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 15: 
            case 18: 
            case 19: 
            case 27: 
            case 28: 
            case 33: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 109: 
            case 110: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 134: 
            case 135: 
            case 143: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllMethods";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllInnerClasses";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllSuperClassesRecursively";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFieldByName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findMethodsByName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findMethodBySignature";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findMethodsBySignature";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findInnerByName";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processAllMembersWithoutSubstitutors";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findByMap";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAllWithSubstitutorsByMap";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAllByMap";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getClassIcon";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getClassUseScope";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isMainOrPremainMethod";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createSignatureFromText";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "skipInvalid";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInClass";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "processCachedMembersByName";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "checkRaw";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "obtainFinalSubstitutor";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "processClassMembersWithAllNames";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "correctType";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "processSuperTypes";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClass";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "findSpecialSuperClass";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getSupers";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getSupersInner";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getSuperTypes";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationSuperType";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getEnumSuperType";
                break;
            }
            case 108: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getInterfaces";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "resolveClassReferenceList";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "findMethodsAndTheirSubstitutorsByName";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "withSubstitutors";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getExtendsListTypes";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "getImplementsListTypes";
                break;
            }
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "isInExtendsList";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "isInReferenceList";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "isClassEquivalentTo";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalFile";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "isFieldEquivalentTo";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "isMethodEquivalentTo";
                break;
            }
            case 146: 
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "compareParamTypes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 15: 
            case 18: 
            case 19: 
            case 27: 
            case 28: 
            case 33: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 109: 
            case 110: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 134: 
            case 135: 
            case 143: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum MemberType {
        CLASS,
        FIELD,
        METHOD;


        PsiMember @NotNull [] getMembers(@NotNull PsiClass aClass) {
            if (aClass == null) {
                MemberType.$$$reportNull$$$0(0);
            }
            switch (this) {
                case METHOD: {
                    PsiMember[] psiMemberArray = aClass.getMethods();
                    if (psiMemberArray == null) {
                        MemberType.$$$reportNull$$$0(1);
                    }
                    return psiMemberArray;
                }
                case CLASS: {
                    PsiMember[] psiMemberArray = aClass.getInnerClasses();
                    if (psiMemberArray == null) {
                        MemberType.$$$reportNull$$$0(2);
                    }
                    return psiMemberArray;
                }
            }
            PsiMember[] psiMemberArray = aClass.getFields();
            if (psiMemberArray == null) {
                MemberType.$$$reportNull$$$0(3);
            }
            return psiMemberArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/PsiClassImplUtil$MemberType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/PsiClassImplUtil$MemberType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMembers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMembers";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MemberCache {
        @NotNull
        private final List<PsiClass> myAllSupers;
        private final ConcurrentMap<MemberType, PsiMember[]> myAllMembers;

        MemberCache(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope scope2) {
            if (psiClass == null) {
                MemberCache.$$$reportNull$$$0(0);
            }
            if (scope2 == null) {
                MemberCache.$$$reportNull$$$0(1);
            }
            this.myAllSupers = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(c -> ContainerUtil.mapNotNull(c.getSupers(), s -> PsiSuperMethodUtil.correctClassByScope(s, scope2))).unique()).withRoot(psiClass)).toList();
            this.myAllMembers = ConcurrentFactoryMap.createMap(type2 -> ((StreamEx)StreamEx.of(this.myAllSupers).flatArray(type2::getMembers).filter(e -> !PsiClassImplUtil.skipInvalid(e))).toArray(PsiMember.EMPTY_ARRAY));
        }

        @NotNull
        List<PsiMember> calcMembersByName(@NotNull MemberType type2, @NotNull String name, PsiClass psiClass, PsiElement context) {
            List<PsiExtensionMethod> methods2;
            if (type2 == null) {
                MemberCache.$$$reportNull$$$0(2);
            }
            if (name == null) {
                MemberCache.$$$reportNull$$$0(3);
            }
            ArrayList<PsiClass> result2 = null;
            for (PsiClass eachSuper : this.myAllSupers) {
                if (type2 == MemberType.METHOD) {
                    PsiMethod[] methods3 = eachSuper.findMethodsByName(name, false);
                    if (methods3.length <= 0) continue;
                    if (result2 == null) {
                        result2 = new ArrayList<PsiClass>();
                    }
                    Collections.addAll(result2, methods3);
                    continue;
                }
                PomRenameableTarget<PsiElement> member = type2 == MemberType.CLASS ? eachSuper.findInnerClassByName(name, false) : eachSuper.findFieldByName(name, false);
                if (member == null) continue;
                if (result2 == null) {
                    result2 = new ArrayList();
                }
                result2.add((PsiClass)member);
            }
            if (type2 == MemberType.METHOD && psiClass != null && context != null && !(methods2 = PsiAugmentProvider.collectExtensionMethods(psiClass, name, context)).isEmpty()) {
                if (result2 == null) {
                    result2 = new ArrayList();
                }
                result2.addAll(methods2);
            }
            List<PsiMember> list = result2 == null ? Collections.emptyList() : ContainerUtil.filter(result2, e -> !PsiClassImplUtil.skipInvalid(e));
            if (list == null) {
                MemberCache.$$$reportNull$$$0(4);
            }
            return list;
        }

        PsiMember[] getAllMembers(@NotNull MemberType type2, @Nullable String name) {
            if (type2 == null) {
                MemberCache.$$$reportNull$$$0(5);
            }
            return name == null ? (PsiMember[])this.myAllMembers.get((Object)type2) : this.calcMembersByName(type2, name, null, null).toArray(PsiMember.EMPTY_ARRAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/PsiClassImplUtil$MemberCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/PsiClassImplUtil$MemberCache";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcMembersByName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "calcMembersByName";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllMembers";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ClassIconRequest {
        @NotNull
        private final PsiClass psiClass;
        private final int flags;
        private final Icon symbolIcon;

        private ClassIconRequest(@NotNull PsiClass psiClass, int flags, Icon symbolIcon) {
            if (psiClass == null) {
                ClassIconRequest.$$$reportNull$$$0(0);
            }
            this.psiClass = psiClass;
            this.flags = flags;
            this.symbolIcon = symbolIcon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassIconRequest)) {
                return false;
            }
            ClassIconRequest that = (ClassIconRequest)o;
            return this.flags == that.flags && this.psiClass.equals(that.psiClass);
        }

        public int hashCode() {
            int result2 = this.psiClass.hashCode();
            result2 = 31 * result2 + this.flags;
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil$ClassIconRequest", "<init>"));
        }
    }
}

