/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.cls.ClsFormatException;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.TypeReference;

public final class SignatureParsing {
    private SignatureParsing() {
    }

    @NotNull
    static TypeParametersDeclaration parseTypeParametersDeclaration(CharIterator signature2, TypeInfoProvider mapping) throws ClsFormatException {
        if (signature2.current() != '<') {
            TypeParametersDeclaration typeParametersDeclaration = TypeParametersDeclaration.EMPTY;
            if (typeParametersDeclaration == null) {
                SignatureParsing.$$$reportNull$$$0(0);
            }
            return typeParametersDeclaration;
        }
        ArrayList<TypeParameterDeclaration> typeParameters2 = new ArrayList<TypeParameterDeclaration>();
        signature2.next();
        while (signature2.current() != '>') {
            typeParameters2.add(SignatureParsing.parseTypeParameter(signature2, mapping));
        }
        signature2.next();
        return new TypeParametersDeclaration(typeParameters2);
    }

    private static TypeParameterDeclaration parseTypeParameter(CharIterator signature2, TypeInfoProvider mapping) throws ClsFormatException {
        int from = signature2.pos();
        while (signature2.current() != ':' && signature2.current() != '\uffff') {
            signature2.next();
        }
        String name = signature2.substring(from);
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException();
        }
        String parameterName = mapping.toTypeInfo(name).text();
        SmartList<TypeInfo> bounds = new SmartList<TypeInfo>();
        while (signature2.current() == ':') {
            signature2.next();
            TypeInfo bound = SignatureParsing.parseTopLevelClassRefSignatureToTypeInfo(signature2, mapping);
            if (!bounds.isEmpty() && bound == null) continue;
            bounds.add(bound);
        }
        return new TypeParameterDeclaration(parameterName, bounds.toArray(TypeInfo.EMPTY_ARRAY));
    }

    @Nullable
    static TypeInfo parseTopLevelClassRefSignatureToTypeInfo(CharIterator signature2, TypeInfoProvider mapping) throws ClsFormatException {
        switch (signature2.current()) {
            case 'L': {
                return SignatureParsing.parseParameterizedClassRefSignatureToTypeInfo(signature2, mapping);
            }
            case 'T': {
                return new TypeInfo.RefTypeInfo(SignatureParsing.parseTypeVariableRefSignature(signature2));
            }
        }
        return null;
    }

    private static String parseTypeVariableRefSignature(CharIterator signature2) throws ClsFormatException {
        signature2.next();
        int from = signature2.pos();
        while (signature2.current() != ';' && signature2.current() != '>' && signature2.current() != '\uffff') {
            signature2.next();
        }
        String id = signature2.substring(from);
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException();
        }
        if (signature2.current() == ';') {
            signature2.next();
        }
        return id;
    }

    @NotNull
    private static TypeInfo parseParameterizedClassRefSignatureToTypeInfo(CharIterator signature2, TypeInfoProvider mapping) throws ClsFormatException {
        signature2.next();
        int start = signature2.pos();
        boolean hasSpace = false;
        while (true) {
            switch (signature2.current()) {
                case ';': {
                    String jvmName = signature2.substring(start);
                    if (hasSpace) {
                        jvmName = jvmName.replace(" ", "");
                    }
                    TypeInfo.RefTypeInfo type2 = mapping.toTypeInfo(jvmName);
                    signature2.next();
                    TypeInfo.RefTypeInfo refTypeInfo = type2;
                    if (refTypeInfo == null) {
                        SignatureParsing.$$$reportNull$$$0(1);
                    }
                    return refTypeInfo;
                }
                case '\uffff': {
                    throw new ClsFormatException("Malformed signature: " + signature2);
                }
                case '<': {
                    String jvmName = signature2.substring(start);
                    if (hasSpace) {
                        jvmName = jvmName.replace(" ", "");
                    }
                    TypeInfo.RefTypeInfo type3 = mapping.toTypeInfo(jvmName);
                    signature2.next();
                    ArrayList<TypeInfo> components = new ArrayList<TypeInfo>();
                    do {
                        components.add(SignatureParsing.parseClassOrTypeVariableElementToTypeInfo(signature2, mapping));
                    } while (signature2.current() != '>');
                    type3 = type3.withComponents(components);
                    signature2.next();
                    switch (signature2.current()) {
                        case ';': {
                            signature2.next();
                            TypeInfo.RefTypeInfo refTypeInfo = type3;
                            if (refTypeInfo == null) {
                                SignatureParsing.$$$reportNull$$$0(2);
                            }
                            return refTypeInfo;
                        }
                        case '.': {
                            TypeInfo inner = SignatureParsing.parseParameterizedClassRefSignatureToTypeInfo(signature2, mapping);
                            if (!(inner instanceof TypeInfo.RefTypeInfo)) {
                                throw new ClsFormatException("Malformed signature: " + signature2);
                            }
                            TypeInfo.RefTypeInfo refTypeInfo = ((TypeInfo.RefTypeInfo)inner).withOuter(type3);
                            if (refTypeInfo == null) {
                                SignatureParsing.$$$reportNull$$$0(3);
                            }
                            return refTypeInfo;
                        }
                    }
                    throw new ClsFormatException("Malformed signature: " + signature2);
                }
                case ' ': {
                    hasSpace = true;
                    break;
                }
            }
            signature2.next();
        }
    }

    @NotNull
    private static TypeInfo parseClassOrTypeVariableElementToTypeInfo(@NotNull CharIterator signature2, TypeInfoProvider mapping) throws ClsFormatException {
        char variance;
        if (signature2 == null) {
            SignatureParsing.$$$reportNull$$$0(4);
        }
        if ((variance = SignatureParsing.parseVariance(signature2)) == '*') {
            return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.WILDCARD);
        }
        int dimensions = SignatureParsing.parseDimensions(signature2);
        TypeInfo info = SignatureParsing.parseTypeWithoutVarianceToTypeInfo(signature2, mapping);
        if (info == null) {
            throw new ClsFormatException("Unable to parse signature: " + signature2);
        }
        while (dimensions > 0) {
            --dimensions;
            info = info.arrayOf();
        }
        switch (variance) {
            case '\u0000': {
                TypeInfo typeInfo = info;
                if (typeInfo == null) {
                    SignatureParsing.$$$reportNull$$$0(5);
                }
                return typeInfo;
            }
            case '+': {
                return new TypeInfo.DerivedTypeInfo(TypeInfo.TypeKind.EXTENDS, info);
            }
            case '-': {
                return new TypeInfo.DerivedTypeInfo(TypeInfo.TypeKind.SUPER, info);
            }
        }
        throw new ClsFormatException("Unable to parse signature: " + signature2);
    }

    private static char parseVariance(CharIterator signature2) {
        char variance;
        switch (signature2.current()) {
            case '*': 
            case '+': 
            case '-': {
                variance = signature2.current();
                signature2.next();
                break;
            }
            case '.': 
            case '=': {
                signature2.next();
            }
            default: {
                variance = '\u0000';
            }
        }
        return variance;
    }

    private static int parseDimensions(CharIterator signature2) {
        int dimensions = 0;
        while (signature2.current() == '[') {
            ++dimensions;
            signature2.next();
        }
        return dimensions;
    }

    @Deprecated
    @NotNull
    public static String parseTypeString(CharacterIterator signature2, Function<? super String, String> mapping) throws ClsFormatException {
        char ch;
        StringBuilder sb = new StringBuilder();
        int pos = signature2.getIndex();
        while ((ch = signature2.current()) != '\uffff') {
            sb.append(ch);
            signature2.next();
        }
        CharIterator iterator2 = new CharIterator(sb.toString());
        String result2 = SignatureParsing.parseTypeStringToTypeInfo(iterator2, TypeInfoProvider.from(mapping)).text();
        signature2.setIndex(iterator2.pos() + pos);
        String string2 = result2;
        if (string2 == null) {
            SignatureParsing.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @NotNull
    public static TypeInfo parseTypeStringToTypeInfo(@NotNull CharIterator signature2, @NotNull TypeInfoProvider mapping) throws ClsFormatException {
        if (signature2 == null) {
            SignatureParsing.$$$reportNull$$$0(7);
        }
        if (mapping == null) {
            SignatureParsing.$$$reportNull$$$0(8);
        }
        int dimensions = SignatureParsing.parseDimensions(signature2);
        TypeInfo type2 = SignatureParsing.parseTypeWithoutVarianceToTypeInfo(signature2, mapping);
        if (type2 == null) {
            throw new ClsFormatException();
        }
        while (dimensions > 0) {
            --dimensions;
            type2 = type2.arrayOf();
        }
        TypeInfo typeInfo = type2;
        if (typeInfo == null) {
            SignatureParsing.$$$reportNull$$$0(9);
        }
        return typeInfo;
    }

    @Nullable
    private static TypeInfo parseTypeWithoutVarianceToTypeInfo(CharIterator signature2, TypeInfoProvider mapping) throws ClsFormatException {
        switch (signature2.current()) {
            case 'L': {
                return SignatureParsing.parseParameterizedClassRefSignatureToTypeInfo(signature2, mapping);
            }
            case 'T': {
                return new TypeInfo.RefTypeInfo(SignatureParsing.parseTypeVariableRefSignature(signature2));
            }
            case 'B': {
                signature2.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.BYTE);
            }
            case 'C': {
                signature2.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.CHAR);
            }
            case 'D': {
                signature2.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.DOUBLE);
            }
            case 'F': {
                signature2.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.FLOAT);
            }
            case 'I': {
                signature2.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.INT);
            }
            case 'J': {
                signature2.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.LONG);
            }
            case 'S': {
                signature2.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.SHORT);
            }
            case 'Z': {
                signature2.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.BOOLEAN);
            }
            case 'V': {
                signature2.next();
                return new TypeInfo.SimpleTypeInfo(TypeInfo.TypeKind.VOID);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/SignatureParsing";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeParametersDeclaration";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseParameterizedClassRefSignatureToTypeInfo";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/SignatureParsing";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseClassOrTypeVariableElementToTypeInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeStringToTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseClassOrTypeVariableElementToTypeInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseTypeStringToTypeInfo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class CharIterator {
        private final String myData;
        private final int myEnd;
        private int myPos = 0;

        public CharIterator(String data2) {
            this.myData = data2;
            this.myEnd = data2.length();
        }

        char current() {
            if (this.myPos == this.myEnd) {
                return '\uffff';
            }
            return this.myData.charAt(this.myPos);
        }

        void next() {
            if (this.myPos < this.myEnd) {
                ++this.myPos;
            }
        }

        int pos() {
            return this.myPos;
        }

        String substring(int fromIndex) {
            return this.myData.substring(fromIndex, this.myPos);
        }

        public String toString() {
            return this.myData;
        }
    }

    static class TypeParametersDeclaration {
        static final TypeParametersDeclaration EMPTY = new TypeParametersDeclaration(Collections.emptyList());
        private final List<TypeParameterDeclaration> myDeclarations;

        private TypeParametersDeclaration(List<TypeParameterDeclaration> declarations2) {
            this.myDeclarations = declarations2;
        }

        TypeInfo getBoundType(TypeReference ref) {
            TypeParameterDeclaration typeParam;
            int typeParameterIndex = ref.getTypeParameterIndex();
            int boundIndex = ref.getTypeParameterBoundIndex();
            if (typeParameterIndex < this.myDeclarations.size() && boundIndex < (typeParam = this.myDeclarations.get(typeParameterIndex)).myBounds.length) {
                return typeParam.myBounds[boundIndex];
            }
            return null;
        }

        TypeInfo getParameterType(TypeReference ref) {
            int typeParameterIndex = ref.getTypeParameterIndex();
            if (typeParameterIndex < this.myDeclarations.size()) {
                return this.myDeclarations.get(typeParameterIndex).myTypeParameter;
            }
            return null;
        }

        void fillInTypeParameterList(StubElement<?> parent2) {
            List<TypeParameterDeclaration> declarations2 = this.myDeclarations;
            if (declarations2.isEmpty()) {
                return;
            }
            PsiTypeParameterListStub listStub = parent2.findChildStubByType(JavaStubElementTypes.TYPE_PARAMETER_LIST);
            if (listStub == null) {
                return;
            }
            for (TypeParameterDeclaration parameter : declarations2) {
                parameter.createTypeParameter(listStub);
            }
        }
    }

    @FunctionalInterface
    public static interface TypeInfoProvider {
        @NotNull
        public TypeInfo.RefTypeInfo toTypeInfo(@NotNull String var1);

        public static TypeInfoProvider from(Function<? super String, String> fn) {
            return internalName -> new TypeInfo.RefTypeInfo((String)fn.apply(internalName));
        }
    }

    private static class TypeParameterDeclaration {
        private final TypeInfo myTypeParameter;
        private final TypeInfo[] myBounds;

        private TypeParameterDeclaration(String parameter, TypeInfo[] bounds) {
            this.myTypeParameter = new TypeInfo.RefTypeInfo(parameter);
            this.myBounds = bounds;
        }

        private void createTypeParameter(PsiTypeParameterListStub listStub) {
            PsiTypeParameterStubImpl stub2 = new PsiTypeParameterStubImpl((StubElement)listStub, this.myTypeParameter.text());
            this.myTypeParameter.getTypeAnnotations().createAnnotationStubs(stub2);
            TypeInfo[] info = this.myBounds;
            if (info.length > 0 && info[0] == null) {
                info = Arrays.copyOfRange(info, 1, info.length);
            }
            new PsiClassReferenceListStubImpl(JavaStubElementTypes.EXTENDS_BOUND_LIST, (StubElement)stub2, info);
        }
    }
}

