/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.PsiAnonymousClassImpl;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.PsiEnumConstantInitializerImpl;
import com.intellij.psi.impl.source.PsiUnnamedClassImpl;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.AnonymousClassElement;
import com.intellij.psi.impl.source.tree.java.EnumConstantInitializerElement;
import com.intellij.psi.impl.source.tree.java.UnnamedClassElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class JavaClassElementType
extends JavaStubElementType<PsiClassStub<?>, PsiClass> {
    JavaClassElementType(@NotNull String id, @NotNull IElementType parentElementType) {
        if (id == null) {
            JavaClassElementType.$$$reportNull$$$0(0);
        }
        if (parentElementType == null) {
            JavaClassElementType.$$$reportNull$$$0(1);
        }
        super(id, parentElementType);
    }

    @Override
    public PsiClass createPsi(@NotNull PsiClassStub stub2) {
        if (stub2 == null) {
            JavaClassElementType.$$$reportNull$$$0(2);
        }
        return this.getPsiFactory(stub2).createClass(stub2);
    }

    @Override
    public PsiClass createPsi(@NotNull ASTNode node) {
        if (node == null) {
            JavaClassElementType.$$$reportNull$$$0(3);
        }
        if (node instanceof EnumConstantInitializerElement) {
            return new PsiEnumConstantInitializerImpl(node);
        }
        if (node instanceof AnonymousClassElement) {
            return new PsiAnonymousClassImpl(node);
        }
        if (node instanceof UnnamedClassElement) {
            return new PsiUnnamedClassImpl(node);
        }
        return new PsiClassImpl(node);
    }

    @Override
    @NotNull
    public PsiClassStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement<?> parentStub) {
        LighterASTNode parent2;
        IElementType type2;
        if (tree == null) {
            JavaClassElementType.$$$reportNull$$$0(4);
        }
        if (node == null) {
            JavaClassElementType.$$$reportNull$$$0(5);
        }
        if (parentStub == null) {
            JavaClassElementType.$$$reportNull$$$0(6);
        }
        boolean isDeprecatedByComment = false;
        boolean isInterface = false;
        boolean isEnum = false;
        boolean isRecord = false;
        boolean isEnumConst = false;
        boolean isAnonymous = false;
        boolean isAnnotation = false;
        boolean isInQualifiedNew = false;
        boolean classKindFound = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String qualifiedName2 = null;
        String name = null;
        String baseRef = null;
        if (node.getTokenType() == JavaElementType.ANONYMOUS_CLASS) {
            isAnonymous = true;
            classKindFound = true;
        } else if (node.getTokenType() == JavaElementType.ENUM_CONSTANT_INITIALIZER) {
            isEnumConst = true;
            isAnonymous = true;
            classKindFound = true;
            baseRef = ((PsiClassStub)parentStub.getParentStub()).getName();
        }
        for (LighterASTNode child : tree.getChildren(node)) {
            type2 = child.getTokenType();
            if (type2 == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type2 == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                continue;
            }
            if (type2 == JavaTokenType.AT) {
                isAnnotation = true;
                continue;
            }
            if (type2 == JavaTokenType.INTERFACE_KEYWORD && !classKindFound) {
                isInterface = true;
                classKindFound = true;
                continue;
            }
            if (type2 == JavaTokenType.ENUM_KEYWORD && !classKindFound) {
                isEnum = true;
                classKindFound = true;
                continue;
            }
            if (type2 == JavaTokenType.RECORD_KEYWORD && !classKindFound) {
                isRecord = true;
                classKindFound = true;
                continue;
            }
            if (type2 == JavaTokenType.CLASS_KEYWORD) {
                classKindFound = true;
                continue;
            }
            if (!isAnonymous && type2 == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (!isAnonymous || isEnumConst || type2 != JavaElementType.JAVA_CODE_REFERENCE) continue;
            baseRef = LightTreeUtil.toFilteredString(tree, child, null);
        }
        if (name != null) {
            if (parentStub instanceof PsiJavaFileStub) {
                String pkg = ((PsiJavaFileStub)parentStub).getPackageName();
                qualifiedName2 = !pkg.isEmpty() ? pkg + '.' + name : name;
            } else if (parentStub instanceof PsiClassStub) {
                String parentFqn = ((PsiClassStub)parentStub).getQualifiedName();
                String string2 = qualifiedName2 = parentFqn != null ? parentFqn + '.' + name : null;
            }
        }
        if (isAnonymous && (parent2 = tree.getParent(node)) != null && parent2.getTokenType() == JavaElementType.NEW_EXPRESSION) {
            isInQualifiedNew = LightTreeUtil.firstChildOfType(tree, parent2, JavaTokenType.DOT) != null;
        }
        boolean isUnnamed = node.getTokenType() == JavaElementType.UNNAMED_CLASS;
        short flags = PsiClassStubImpl.packFlags(isDeprecatedByComment, isInterface, isEnum, isEnumConst, isAnonymous, isAnnotation, isInQualifiedNew, hasDeprecatedAnnotation, false, false, hasDocComment, isRecord, isUnnamed);
        type2 = JavaClassElementType.typeForClass(isAnonymous, isEnumConst, isUnnamed);
        return new PsiClassStubImpl((JavaClassElementType)type2, parentStub, qualifiedName2, name, baseRef, flags);
    }

    @NotNull
    private static JavaClassElementType typeForClass(boolean anonymous, boolean enumConst, boolean unnamedClass) {
        JavaClassElementType javaClassElementType = enumConst ? JavaStubElementTypes.ENUM_CONSTANT_INITIALIZER : (unnamedClass ? JavaStubElementTypes.UNNAMED_CLASS : (anonymous ? JavaStubElementTypes.ANONYMOUS_CLASS : JavaStubElementTypes.CLASS));
        if (javaClassElementType == null) {
            JavaClassElementType.$$$reportNull$$$0(7);
        }
        return javaClassElementType;
    }

    public void serialize(@NotNull PsiClassStub stub2, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub2 == null) {
            JavaClassElementType.$$$reportNull$$$0(8);
        }
        if (dataStream == null) {
            JavaClassElementType.$$$reportNull$$$0(9);
        }
        dataStream.writeShort(((PsiClassStubImpl)stub2).getFlags());
        if (!stub2.isAnonymous()) {
            String name = stub2.getName();
            TypeInfo info = ((PsiClassStubImpl)stub2).getQualifiedNameTypeInfo();
            dataStream.writeName(info.getShortTypeText().equals(name) ? null : name);
            TypeInfo.writeTYPE(dataStream, info);
            dataStream.writeName(stub2.getSourceFileName());
        } else {
            dataStream.writeName(stub2.getBaseClassReferenceText());
        }
    }

    @NotNull
    public PsiClassStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JavaClassElementType.$$$reportNull$$$0(10);
        }
        short flags = dataStream.readShort();
        boolean isAnonymous = PsiClassStubImpl.isAnonymous(flags);
        boolean isEnumConst = PsiClassStubImpl.isEnumConstInitializer(flags);
        boolean isUnnamed = PsiClassStubImpl.isUnnamed(flags);
        JavaClassElementType type2 = JavaClassElementType.typeForClass(isAnonymous, isEnumConst, isUnnamed);
        if (!isAnonymous) {
            String name = dataStream.readNameString();
            TypeInfo typeInfo = TypeInfo.readTYPE(dataStream);
            if (name == null) {
                name = typeInfo.getShortTypeText();
            }
            String sourceFileName = dataStream.readNameString();
            PsiClassStubImpl classStub = new PsiClassStubImpl(type2, parentStub, typeInfo, name, null, flags);
            classStub.setSourceFileName(sourceFileName);
            PsiClassStubImpl psiClassStubImpl = classStub;
            if (psiClassStubImpl == null) {
                JavaClassElementType.$$$reportNull$$$0(11);
            }
            return psiClassStubImpl;
        }
        String baseRef = dataStream.readNameString();
        return new PsiClassStubImpl(type2, parentStub, TypeInfo.SimpleTypeInfo.NULL, null, baseRef, flags);
    }

    public void indexStub(@NotNull PsiClassStub stub2, @NotNull IndexSink sink) {
        boolean isAnonymous;
        if (stub2 == null) {
            JavaClassElementType.$$$reportNull$$$0(12);
        }
        if (sink == null) {
            JavaClassElementType.$$$reportNull$$$0(13);
        }
        if (isAnonymous = stub2.isAnonymous()) {
            String baseRef = stub2.getBaseClassReferenceText();
            if (baseRef != null) {
                sink.occurrence(JavaStubIndexKeys.ANONYMOUS_BASEREF, PsiNameHelper.getShortClassName(baseRef));
            }
        } else {
            String fqn;
            String shortName = stub2.getName();
            if (!(shortName == null || stub2 instanceof PsiClassStubImpl && ((PsiClassStubImpl)stub2).isAnonymousInner())) {
                sink.occurrence(JavaStubIndexKeys.CLASS_SHORT_NAMES, shortName);
            }
            if ((fqn = stub2.getQualifiedName()) != null) {
                sink.occurrence(JavaStubIndexKeys.CLASS_FQN, fqn);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElementType";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/JavaClassElementType";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/JavaClassElementType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "typeForClass";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

