/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.util.Key;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectStubTree<T extends Stub> {
    private static final Key<ObjectStubTree<?>> STUB_TO_TREE_REFERENCE = Key.create("stub to tree reference");
    protected final ObjectStubBase<?> myRoot;
    private String myDebugInfo;
    private boolean myHasBackReference;
    private final List<T> myPlainList;

    public ObjectStubTree(@NotNull ObjectStubBase<?> root, boolean withBackReference) {
        if (root == null) {
            ObjectStubTree.$$$reportNull$$$0(0);
        }
        this.myRoot = root;
        this.myPlainList = this.enumerateStubs(root);
        if (withBackReference) {
            this.myRoot.putUserData(STUB_TO_TREE_REFERENCE, this);
        }
    }

    @NotNull
    public Stub getRoot() {
        ObjectStubBase<?> objectStubBase = this.myRoot;
        if (objectStubBase == null) {
            ObjectStubTree.$$$reportNull$$$0(1);
        }
        return objectStubBase;
    }

    @NotNull
    public List<T> getPlainList() {
        List<T> list = this.myPlainList;
        if (list == null) {
            ObjectStubTree.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    List<T> getPlainListFromAllRoots() {
        List<T> list = this.getPlainList();
        if (list == null) {
            ObjectStubTree.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public Map<StubIndexKey<?, ?>, Map<Object, int[]>> indexStubTree(@Nullable Function<? super StubIndexKey<?, ?>, ? extends HashingStrategy<Object>> keyHashingStrategyFunction) {
        StubIndexSink sink = new StubIndexSink(keyHashingStrategyFunction);
        List<T> plainList = this.getPlainListFromAllRoots();
        int plainListSize = plainList.size();
        for (int i = 0; i < plainListSize; ++i) {
            Stub stub2 = (Stub)plainList.get(i);
            sink.myStubIdx = i;
            StubSerializationUtil.getSerializer(stub2).indexStub(stub2, sink);
        }
        Map<StubIndexKey<?, ?>, Map<Object, int[]>> map2 = sink.getResult();
        if (map2 == null) {
            ObjectStubTree.$$$reportNull$$$0(4);
        }
        return map2;
    }

    @NotNull
    protected List<T> enumerateStubs(@NotNull Stub root) {
        if (root == null) {
            ObjectStubTree.$$$reportNull$$$0(5);
        }
        ArrayList result2 = new ArrayList();
        ObjectStubTree.enumerateStubsInto(root, result2);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ObjectStubTree.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static void enumerateStubsInto(@NotNull Stub root, @NotNull List<? super Stub> result2) {
        if (root == null) {
            ObjectStubTree.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            ObjectStubTree.$$$reportNull$$$0(8);
        }
        ((ObjectStubBase)root).id = result2.size();
        result2.add(root);
        List<? extends Stub> childrenStubs = root.getChildrenStubs();
        for (int i = 0; i < childrenStubs.size(); ++i) {
            Stub child = childrenStubs.get(i);
            ObjectStubTree.enumerateStubsInto(child, result2);
        }
    }

    public void setDebugInfo(@NotNull String info) {
        ObjectStubTree ref;
        if (info == null) {
            ObjectStubTree.$$$reportNull$$$0(9);
        }
        if ((ref = ObjectStubTree.getStubTree(this.myRoot)) != null) assert (ref == this);
        this.myHasBackReference = ref != null;
        this.myDebugInfo = info;
    }

    @Nullable
    public static ObjectStubTree getStubTree(@NotNull ObjectStubBase root) {
        if (root == null) {
            ObjectStubTree.$$$reportNull$$$0(10);
        }
        return root.getUserData(STUB_TO_TREE_REFERENCE);
    }

    public String getDebugInfo() {
        return this.myHasBackReference ? this.myDebugInfo + "; with backReference" : this.myDebugInfo;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{myDebugInfo='" + this.getDebugInfo() + '\'' + ", myRoot=" + this.myRoot + '}' + this.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/ObjectStubTree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/ObjectStubTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainListFromAllRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "indexStubTree";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "enumerateStubs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "enumerateStubs";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "enumerateStubsInto";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDebugInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStubTree";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class StubIndexSink
    implements IndexSink {
        private final Map<StubIndexKey<?, ?>, Map<Object, int[]>> myResult = new HashMap();
        @Nullable
        private final Function<? super StubIndexKey<?, ?>, ? extends HashingStrategy<Object>> myHashingStrategyFunction;
        private int myStubIdx;

        private StubIndexSink(@Nullable Function<? super StubIndexKey<?, ?>, ? extends HashingStrategy<Object>> hashingStrategyFunction) {
            this.myHashingStrategyFunction = hashingStrategyFunction;
        }

        public void occurrence(@NotNull StubIndexKey indexKey, @NotNull Object value2) {
            int[] list;
            Map<Object, int[]> map2;
            if (indexKey == null) {
                StubIndexSink.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                StubIndexSink.$$$reportNull$$$0(1);
            }
            if ((map2 = this.myResult.get(indexKey)) == null) {
                map2 = this.myHashingStrategyFunction == null ? new HashMap<Object, int[]>() : CollectionFactory.createCustomHashingStrategyMap(this.myHashingStrategyFunction.apply(indexKey));
                this.myResult.put(indexKey, map2);
            }
            if ((list = map2.get(value2)) == null) {
                map2.put(value2, new int[]{this.myStubIdx});
            } else {
                int lastNonZero = ArrayUtil.lastIndexOfNot(list, 0);
                if (lastNonZero >= 0 && list[lastNonZero] == this.myStubIdx) {
                    return;
                }
                int lastZero = lastNonZero + 1;
                if (lastZero == list.length) {
                    list = ArrayUtil.realloc(list, Math.max(4, list.length << 1));
                    map2.put(value2, list);
                }
                list[lastZero] = this.myStubIdx;
            }
        }

        @NotNull
        public Map<StubIndexKey<?, ?>, Map<Object, int[]>> getResult() {
            for (Map<Object, int[]> map2 : this.myResult.values()) {
                for (Map.Entry<Object, int[]> entry : map2.entrySet()) {
                    int firstZero;
                    int[] ints = entry.getValue();
                    if (ints.length == 1 || (firstZero = ArrayUtil.indexOf(ints, 0)) == -1) continue;
                    map2.put(entry.getKey(), ArrayUtil.realloc(ints, firstZero));
                }
            }
            Map<StubIndexKey<?, ?>, Map<Object, int[]>> map3 = this.myResult;
            if (map3 == null) {
                StubIndexSink.$$$reportNull$$$0(2);
            }
            return map3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/stubs/ObjectStubTree$StubIndexSink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/stubs/ObjectStubTree$StubIndexSink";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "occurrence";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

