/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportsUtil {
    private ImportsUtil() {
    }

    public static List<PsiJavaCodeReferenceElement> collectReferencesThrough(PsiFile file2, final @Nullable PsiJavaCodeReferenceElement refExpr, final PsiImportStaticStatement staticImport) {
        final ArrayList<PsiJavaCodeReferenceElement> expressionToExpand = new ArrayList<PsiJavaCodeReferenceElement>();
        file2.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement expression) {
                PsiElement resolveScope;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (refExpr != expression && (resolveScope = expression.advancedResolve(true).getCurrentFileResolveScope()) == staticImport) {
                    expressionToExpand.add(expression);
                }
                super.visitElement(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/util/ImportsUtil$1", "visitReferenceElement"));
            }
        });
        return expressionToExpand;
    }

    public static void replaceAllAndDeleteImport(List<PsiJavaCodeReferenceElement> expressionToExpand, @Nullable PsiJavaCodeReferenceElement refExpr, PsiImportStaticStatement staticImport) {
        if (refExpr != null) {
            expressionToExpand.add(refExpr);
        }
        expressionToExpand.sort((o1, o2) -> o2.getTextOffset() - o1.getTextOffset());
        for (PsiJavaCodeReferenceElement expression : expressionToExpand) {
            ImportsUtil.expand(expression, staticImport);
        }
        staticImport.delete();
    }

    public static void expand(@NotNull PsiJavaCodeReferenceElement ref, PsiImportStaticStatement staticImport) {
        if (ref == null) {
            ImportsUtil.$$$reportNull$$$0(0);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(ref.getProject());
        PsiClass targetClass = staticImport.resolveTargetClass();
        assert (targetClass != null);
        if (ref instanceof PsiReferenceExpression) {
            ((PsiReferenceExpression)ref).setQualifierExpression(elementFactory.createReferenceExpression(targetClass));
        } else if (ref instanceof PsiImportStaticReferenceElement) {
            ref.replace(Objects.requireNonNull(elementFactory.createImportStaticStatement(targetClass, ref.getText()).getImportReference()));
        } else {
            ref.replace(elementFactory.createReferenceFromText(targetClass.getQualifiedName() + "." + ref.getText(), ref));
        }
    }

    public static boolean hasStaticImportOn(PsiElement expr, PsiMember member, boolean acceptOnDemand) {
        PsiImportList importList;
        if (expr.getContainingFile() instanceof PsiJavaFile && (importList = ((PsiJavaFile)expr.getContainingFile()).getImportList()) != null) {
            PsiImportStaticStatement[] importStaticStatements;
            for (PsiImportStaticStatement stmt : importStaticStatements = importList.getImportStaticStatements()) {
                PsiClass containingClass = member.getContainingClass();
                String referenceName = stmt.getReferenceName();
                if (containingClass == null || stmt.resolveTargetClass() != containingClass) continue;
                if (!stmt.isOnDemand() && Comparing.strEqual(referenceName, member.getName())) {
                    if (member instanceof PsiMethod) {
                        return containingClass.findMethodsByName(referenceName, false).length > 0;
                    }
                    return true;
                }
                if (!acceptOnDemand || !stmt.isOnDemand()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/util/ImportsUtil", "expand"));
    }
}

