/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class PsiExpressionTrimRenderer
extends JavaRecursiveElementWalkingVisitor {
    private final StringBuilder myBuf;

    public PsiExpressionTrimRenderer(StringBuilder buf) {
        this.myBuf = buf;
    }

    @Override
    public void visitExpression(@NotNull PsiExpression expression) {
        if (expression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(0);
        }
        this.myBuf.append(expression.getText());
    }

    @Override
    public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
        PsiPrimaryPattern pattern;
        if (expression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(1);
        }
        expression.getOperand().accept(this);
        this.myBuf.append(" ").append("instanceof").append(" ");
        PsiTypeElement checkType = expression.getCheckType();
        if (checkType != null) {
            this.myBuf.append(checkType.getText());
        }
        if ((pattern = expression.getPattern()) != null) {
            this.myBuf.append(pattern.getText());
        }
    }

    @Override
    public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression) {
        if (expression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(2);
        }
        this.myBuf.append("(");
        PsiExpression expr = expression.getExpression();
        if (expr != null) {
            expr.accept(this);
        }
        this.myBuf.append(")");
    }

    @Override
    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
        PsiExpression operand;
        PsiTypeElement castType;
        if (expression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(3);
        }
        if ((castType = expression.getCastType()) != null) {
            this.myBuf.append("(").append(castType.getText()).append(")");
        }
        if ((operand = expression.getOperand()) != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression) {
        if (expression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(4);
        }
        expression.getArrayExpression().accept(this);
        this.myBuf.append("[");
        PsiExpression indexExpression = expression.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept(this);
        }
        this.myBuf.append("]");
    }

    @Override
    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
        if (expression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(5);
        }
        this.myBuf.append(expression.getOperationSign().getText());
        PsiExpression operand = expression.getOperand();
        if (operand != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
        if (expression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(6);
        }
        expression.getOperand().accept(this);
        this.myBuf.append(expression.getOperationSign().getText());
    }

    @Override
    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
        if (expression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(7);
        }
        PsiExpression[] operands = expression.getOperands();
        for (int i = 0; i < operands.length; ++i) {
            PsiExpression operand = operands[i];
            if (i != 0) {
                PsiJavaToken token = expression.getTokenBeforeOperand(operand);
                assert (token != null);
                this.myBuf.append(" ").append(token.getText()).append(" ");
            }
            operand.accept(this);
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
        if (expression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(8);
        }
        PsiParameterList parameterList2 = expression.getParameterList();
        PsiParameter[] parameters2 = parameterList2.getParameters();
        PsiElement firstChild = parameterList2.getFirstChild();
        boolean addParenthesis = PsiUtil.isJavaToken(firstChild, JavaTokenType.LPARENTH);
        if (addParenthesis) {
            this.myBuf.append('(');
        }
        for (int i = 0; i < parameters2.length; ++i) {
            PsiTypeElement typeElement;
            PsiParameter parameter = parameters2[i];
            if (i != 0) {
                this.myBuf.append(", ");
            }
            int formatOptions = 1 | ((typeElement = parameter.getTypeElement()) == null ? 0 : 2);
            this.myBuf.append(PsiFormatUtil.formatVariable(parameter, formatOptions, PsiSubstitutor.EMPTY));
        }
        if (addParenthesis) {
            this.myBuf.append(')');
        }
        this.myBuf.append(" -> {...}");
    }

    @Override
    public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
        if (expression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(9);
        }
        expression.getCondition().accept(this);
        this.myBuf.append(" ? ");
        PsiExpression thenExpression = expression.getThenExpression();
        if (thenExpression != null) {
            thenExpression.accept(this);
        }
        this.myBuf.append(" : ");
        PsiExpression elseExpression = expression.getElseExpression();
        if (elseExpression != null) {
            elseExpression.accept(this);
        }
    }

    @Override
    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
        if (expression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(10);
        }
        expression.getLExpression().accept(this);
        this.myBuf.append(expression.getOperationSign().getText());
        PsiExpression rExpression = expression.getRExpression();
        if (rExpression != null) {
            rExpression.accept(this);
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull PsiReferenceExpression expr) {
        PsiExpression qualifierExpression;
        if (expr == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(11);
        }
        if ((qualifierExpression = expr.getQualifierExpression()) != null) {
            qualifierExpression.accept(this);
            this.myBuf.append(".");
        }
        this.myBuf.append(expr.getReferenceName());
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expr) {
        if (expr == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(12);
        }
        expr.getMethodExpression().accept(this);
        expr.getArgumentList().accept(this);
    }

    @Override
    public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
        PsiElement qualifier;
        if (expression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(13);
        }
        if ((qualifier = expression.getQualifier()) != null) {
            qualifier.accept(this);
        }
        this.myBuf.append("::");
        this.myBuf.append(expression.getReferenceName());
    }

    @Override
    public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expression) {
        PsiExpression[] initializers;
        if (expression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(14);
        }
        if ((initializers = expression.getInitializers()).length > 1) {
            this.myBuf.append("{...}");
        } else {
            this.myBuf.append("{");
            if (initializers.length > 0) {
                initializers[0].accept(this);
            }
            this.myBuf.append("}");
        }
    }

    @Override
    public void visitExpressionList(@NotNull PsiExpressionList list) {
        PsiExpression[] args;
        if (list == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(15);
        }
        if ((args = list.getExpressions()).length > 0) {
            this.myBuf.append("(...)");
        } else {
            this.myBuf.append("()");
        }
    }

    @Override
    public void visitSwitchExpression(@NotNull PsiSwitchExpression switchExpression) {
        if (switchExpression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(16);
        }
        this.myBuf.append("switch (");
        PsiExpression expression = switchExpression.getExpression();
        if (expression != null) {
            expression.accept(this);
        }
        this.myBuf.append(") {...}");
    }

    @Override
    public void visitNewExpression(@NotNull PsiNewExpression expr) {
        if (expr == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(17);
        }
        PsiAnonymousClass anonymousClass = expr.getAnonymousClass();
        PsiExpressionList argumentList = expr.getArgumentList();
        if (anonymousClass != null) {
            this.myBuf.append("new").append(" ").append(anonymousClass.getBaseClassType().getPresentableText());
            if (argumentList != null) {
                argumentList.accept(this);
            }
            this.myBuf.append(" {...}");
        } else {
            PsiJavaCodeReferenceElement reference = expr.getClassReference();
            if (reference != null) {
                PsiArrayInitializerExpression arrayInitializer;
                this.myBuf.append("new").append(" ").append(reference.getText());
                PsiExpression[] arrayDimensions = expr.getArrayDimensions();
                PsiType type2 = expr.getType();
                for (PsiExpression dimension : arrayDimensions) {
                    this.myBuf.append("[");
                    dimension.accept(this);
                    this.myBuf.append("]");
                }
                if (type2 != null) {
                    int dimensions = type2.getArrayDimensions() - arrayDimensions.length;
                    for (int i = 0; i < dimensions; ++i) {
                        this.myBuf.append("[]");
                    }
                }
                if (argumentList != null) {
                    argumentList.accept(this);
                }
                if ((arrayInitializer = expr.getArrayInitializer()) != null) {
                    this.myBuf.append(" ");
                    arrayInitializer.accept(this);
                }
            } else {
                this.myBuf.append(expr.getText());
            }
        }
    }

    public static String render(@NotNull PsiExpression expression) {
        if (expression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(18);
        }
        return PsiExpressionTrimRenderer.render(expression, 100);
    }

    public static String render(@NotNull PsiExpression expression, int maxLength) {
        if (expression == null) {
            PsiExpressionTrimRenderer.$$$reportNull$$$0(19);
        }
        StringBuilder buf = new StringBuilder();
        expression.accept(new PsiExpressionTrimRenderer(buf));
        String text = buf.toString();
        int firstNewLinePos = text.indexOf(10);
        String trimmedText = text.substring(0, firstNewLinePos != -1 ? firstNewLinePos : Math.min(maxLength, text.length()));
        if (trimmedText.length() != text.length()) {
            trimmedText = trimmedText + " ...";
        }
        return trimmedText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/util/PsiExpressionTrimRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInstanceOfExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitParenthesizedExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeCastExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayAccessExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrefixExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPostfixExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPolyadicExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLambdaExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConditionalExpression";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAssignmentExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodReferenceExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayInitializerExpression";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExpressionList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSwitchExpression";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNewExpression";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

