/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.LowMemoryWatcherManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.CountingThreadFactory;
import com.intellij.util.concurrency.Propagation;
import com.intellij.util.concurrency.SchedulingWrapper;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public final class AppScheduledExecutorService
extends SchedulingWrapper {
    @NotNull
    private final String myName;
    private final LowMemoryWatcherManager myLowMemoryWatcherManager;

    @NotNull
    static ScheduledExecutorService getInstance() {
        AppScheduledExecutorService appScheduledExecutorService = Holder.INSTANCE;
        if (appScheduledExecutorService == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(0);
        }
        return appScheduledExecutorService;
    }

    /*
     * WARNING - void declaration
     */
    AppScheduledExecutorService(@NotNull String name, long keepAliveTime, @NotNull TimeUnit timeUnit) {
        void unit;
        if (name == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(1);
        }
        if (timeUnit == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(2);
        }
        super(new BackendThreadPoolExecutor(new MyThreadFactory(), keepAliveTime, (TimeUnit)unit), new AppDelayQueue());
        this.myName = name;
        this.myLowMemoryWatcherManager = new LowMemoryWatcherManager(this);
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List<Runnable> list = AppScheduledExecutorService.notAllowedMethodCall();
        if (list == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.notAllowedMethodCall();
    }

    static List<Runnable> notAllowedMethodCall() {
        throw new IncorrectOperationException("You must not call this method on the global app pool");
    }

    @Override
    void onDelayQueuePurgedOnShutdown() {
        ((BackendThreadPoolExecutor)this.backendExecutorService).superShutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        void unit;
        long deadline;
        if (timeUnit == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(5);
        }
        if (!this.delayQueue.awaitTermination((deadline = System.nanoTime() + unit.toNanos(timeout)) - System.nanoTime(), TimeUnit.NANOSECONDS)) {
            return false;
        }
        return super.awaitTermination(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @NotNull
    public static Runnable capturePropagationAndCancellationContext(@NotNull Runnable command2) {
        if (command2 == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(9);
        }
        if (!AppExecutorUtil.propagateContextOrCancellation()) {
            Runnable runnable = command2;
            if (runnable == null) {
                AppScheduledExecutorService.$$$reportNull$$$0(10);
            }
            return runnable;
        }
        Runnable runnable = Propagation.capturePropagationAndCancellationContext(command2);
        if (runnable == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(11);
        }
        return runnable;
    }

    @NotNull
    public static <T> FutureTask<T> capturePropagationAndCancellationContext(@NotNull Callable<T> callable) {
        if (callable == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(12);
        }
        if (!AppExecutorUtil.propagateContextOrCancellation()) {
            return new FutureTask<T>(callable);
        }
        FutureTask<T> futureTask = Propagation.capturePropagationAndCancellationContext(callable);
        if (futureTask == null) {
            AppScheduledExecutorService.$$$reportNull$$$0(13);
        }
        return futureTask;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/AppScheduledExecutorService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadListener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/AppScheduledExecutorService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "shutdownNow";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "statistics";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPeriodicTasksThread";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "capturePropagationAndCancellationContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setNewThreadListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "awaitTermination";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "waitForLowMemoryWatcherManagerInit";
                break;
            }
            case 9: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "capturePropagationAndCancellationContext";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Holder {
        private static final AppScheduledExecutorService INSTANCE = new AppScheduledExecutorService("Global instance", 1L, TimeUnit.MINUTES);
    }

    static final class BackendThreadPoolExecutor
    extends ThreadPoolExecutor {
        /*
         * WARNING - void declaration
         */
        BackendThreadPoolExecutor(@NotNull ThreadFactory factory2, long keepAliveTime, @NotNull TimeUnit timeUnit) {
            void unit;
            if (factory2 == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(0);
            }
            if (timeUnit == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(1);
            }
            super(1, Integer.MAX_VALUE, keepAliveTime, (TimeUnit)unit, new SynchronousQueue<Runnable>(), factory2);
        }

        @Override
        public void execute(@NotNull Runnable command2) {
            if (command2 == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(2);
            }
            super.execute(AppScheduledExecutorService.capturePropagationAndCancellationContext(command2));
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value2) {
            return this.newTaskFor(Executors.callable(runnable, value2));
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
            return AppScheduledExecutorService.capturePropagationAndCancellationContext(callable);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (t != null && !(t instanceof ProcessCanceledException)) {
                Logger.getInstance(SchedulingWrapper.class).error("Worker exited due to exception", t);
            }
        }

        private void superShutdown() {
            super.shutdown();
        }

        @Override
        public void shutdown() {
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            List<Runnable> list = AppScheduledExecutorService.notAllowedMethodCall();
            if (list == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Override
        public void setCorePoolSize(int corePoolSize) {
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        @Override
        public void allowCoreThreadTimeOut(boolean value2) {
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        @Override
        public void setMaximumPoolSize(int maximumPoolSize) {
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        @Override
        public void setKeepAliveTime(long time, TimeUnit unit) {
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        @Override
        public void setThreadFactory(@NotNull ThreadFactory threadFactory) {
            if (threadFactory == null) {
                BackendThreadPoolExecutor.$$$reportNull$$$0(5);
            }
            AppScheduledExecutorService.notAllowedMethodCall();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "superShutdownNow";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shutdownNow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setThreadFactory";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyThreadFactory
    extends CountingThreadFactory {
        private BiConsumer<? super Thread, ? super Runnable> newThreadListener;
        private final ThreadFactory myThreadFactory = Executors.privilegedThreadFactory();

        private MyThreadFactory() {
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            if (r == null) {
                MyThreadFactory.$$$reportNull$$$0(0);
            }
            Thread thread = this.myThreadFactory.newThread(r);
            thread.setDaemon(true);
            Thread thread2 = thread;
            thread2.setName("ApplicationImpl pooled thread " + this.counter.incrementAndGet());
            thread2.setPriority(4);
            BiConsumer<? super Thread, ? super Runnable> listener2 = this.newThreadListener;
            if (listener2 != null) {
                listener2.accept(thread2, r);
            }
            Thread thread3 = thread2;
            if (thread3 == null) {
                MyThreadFactory.$$$reportNull$$$0(1);
            }
            return thread3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/concurrency/AppScheduledExecutorService$MyThreadFactory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/concurrency/AppScheduledExecutorService$MyThreadFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "newThread";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setNewThreadListener";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

