/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentIntObjectHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.IntKeyWeakValueHashMap;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import com.intellij.util.containers.SequenceIterator;
import com.intellij.util.containers.SoftValueHashMap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContainerUtil {
    @NotNull
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(15);
        }
        ArrayList<E> collection = new ArrayList<E>();
        for (E element : iterable) {
            collection.add(element);
        }
        ArrayList<E> arrayList = collection;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    public static <T> List<T> subArrayAsList(final T @NotNull [] elements, final int start, final int end) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(17);
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        return new AbstractList<T>(){

            @Override
            public T get(int index2) {
                if (index2 < 0 || index2 >= end - start) {
                    throw new IndexOutOfBoundsException("index:" + index2 + " size:" + (end - start));
                }
                return elements[start + index2];
            }

            @Override
            public int size() {
                return end - start;
            }
        };
    }

    @SafeVarargs
    @NotNull
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(29);
        }
        return new HashSet<T>(Arrays.asList(elements));
    }

    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(36);
        }
        LinkedHashSet<T> collection = new LinkedHashSet<T>();
        for (T element : elements) {
            collection.add(element);
        }
        LinkedHashSet<T> linkedHashSet = collection;
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(37);
        }
        return linkedHashSet;
    }

    @NotNull
    public static <T> @NotNull Set<@NotNull T> newConcurrentSet() {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        if (keySetView == null) {
            ContainerUtil.$$$reportNull$$$0(40);
        }
        return keySetView;
    }

    @NotNull
    public static <E> List<E> reverse(final @NotNull List<? extends E> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(41);
        }
        if (elements.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index2) {
                return elements.get(elements.size() - 1 - index2);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
    }

    @NotNull
    public static <T> Set<T> union(@NotNull Collection<? extends T> set, @NotNull Collection<? extends T> set2) {
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(47);
        }
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(48);
        }
        HashSet<T> result2 = new HashSet<T>(set.size() + set2.size());
        result2.addAll(set);
        result2.addAll(set2);
        HashSet<T> hashSet = result2;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(49);
        }
        return hashSet;
    }

    @SafeVarargs
    @Deprecated
    @NotNull
    public static <E> Set<E> immutableSet(E ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(50);
        }
        switch (elements.length) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(51);
                }
                return set;
            }
            case 1: {
                Set<E> set = Collections.singleton(elements[0]);
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(52);
                }
                return set;
            }
        }
        Set<E> set = Collections.unmodifiableSet(new HashSet<E>(Arrays.asList(elements)));
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(53);
        }
        return set;
    }

    @SafeVarargs
    @Deprecated
    @NotNull
    public static <E> ImmutableList<E> immutableList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(54);
        }
        return new ImmutableListBackedByArray(array);
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(84);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(85);
        }
        ContainerUtil.addAllNotNull(collection, elements.iterator());
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(86);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(87);
        }
        while (elements.hasNext()) {
            T o = elements.next();
            if (o == null) continue;
            collection.add(o);
        }
    }

    public static <T> T find(T @NotNull [] array, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(100);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(101);
        }
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<? super T> processor) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(102);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(103);
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull List<? extends T> list, @NotNull Processor<? super T> processor) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(104);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(105);
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T t = list.get(i);
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(T @NotNull [] iterable, @NotNull Processor<? super T> processor) {
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(106);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(107);
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T> T find(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(110);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(111);
        }
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    @Nullable
    public static <T> T find(@NotNull Iterator<? extends T> iterator2, @NotNull Condition<? super T> condition) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(116);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(117);
        }
        while (iterator2.hasNext()) {
            T value2 = iterator2.next();
            if (!condition.value(value2)) continue;
            return value2;
        }
        return null;
    }

    public static <T, V> V @NotNull [] map2Array(T @NotNull [] array, @NotNull Class<V> aClass, @NotNull Function<? super T, ? extends V> mapper) {
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(138);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(139);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(140);
        }
        V[] result2 = ArrayUtil.newArray(aClass, array.length);
        for (int i = 0; i < array.length; ++i) {
            result2[i] = mapper.fun(array[i]);
        }
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(141);
        }
        return result2;
    }

    public static <T, V> V @NotNull [] map2Array(@NotNull Collection<? extends T> collection, @NotNull Class<V> aClass, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(142);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(143);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(144);
        }
        V[] result2 = ArrayUtil.newArray(aClass, collection.size());
        int i = 0;
        for (T t : collection) {
            result2[i++] = mapper.fun(t);
        }
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(145);
        }
        return result2;
    }

    public static <T, V> V @NotNull [] map2Array(T @NotNull [] collection, V @NotNull [] to, @NotNull Function<? super T, ? extends V> mapper) {
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(150);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(151);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(152);
        }
        V[] VArray = ContainerUtil.map(collection, mapper).toArray(to);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(153);
        }
        return VArray;
    }

    @NotNull
    public static <T> List<T> filter(T @NotNull [] collection, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(154);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(155);
        }
        return ContainerUtil.findAll(collection, condition);
    }

    @NotNull
    public static <T> List<T> filterIsInstance(@NotNull Collection<?> collection, @NotNull Class<? extends T> aClass) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(156);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(157);
        }
        return ContainerUtil.filter(collection, Conditions.instanceOf(aClass));
    }

    @NotNull
    public static <T> List<T> filterIsInstance(Object @NotNull [] collection, @NotNull Class<? extends T> aClass) {
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(158);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(159);
        }
        return ContainerUtil.filter(collection, Conditions.instanceOf(aClass));
    }

    @NotNull
    public static <T> List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(160);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(161);
        }
        return ContainerUtil.findAll(collection, condition);
    }

    @NotNull
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(165);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(166);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(167);
        }
        return smartList;
    }

    @NotNull
    public static <T> List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(168);
        }
        return ContainerUtil.findAll(collection, Conditions.notNull());
    }

    @NotNull
    public static <T> List<T> findAll(T @NotNull [] collection, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(185);
        }
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(186);
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        List list = Collections.unmodifiableList(result2);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(187);
        }
        return list;
    }

    public static <T> boolean all(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(190);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(191);
        }
        for (T t : collection) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    public static void swapElements(@NotNull List<?> list, int index1, int index2) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(203);
        }
        Object e1 = list.get(index1);
        Object e2 = list.get(index2);
        list.set(index1, e2);
        list.set(index2, e1);
    }

    @SafeVarargs
    @NotNull
    public static <T, C extends Collection<? super T>> C addAll(@NotNull C collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(212);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(213);
        }
        for (T element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(214);
        }
        return c;
    }

    @SafeVarargs
    @NotNull
    public static <T, C extends Collection<T>> C addAllNotNull(@NotNull C collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(215);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(216);
        }
        for (T element : elements) {
            if (element == null) continue;
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(217);
        }
        return c;
    }

    @NotNull
    public static <T, V> List<T> concat(V @NotNull [] array, @NotNull Function<? super V, ? extends Collection<? extends T>> listGenerator) {
        if (listGenerator == null) {
            ContainerUtil.$$$reportNull$$$0(228);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(229);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (V v : array) {
            result2.addAll(listGenerator.fun(v));
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(230);
        }
        return list;
    }

    @NotNull
    public static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(239);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(240);
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(241);
            }
            return list;
        }
        if (list1.isEmpty()) {
            List<T> list = list2;
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(242);
            }
            return list;
        }
        if (list2.isEmpty()) {
            List<T> list = list1;
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(243);
            }
            return list;
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        return new AbstractList<T>(){

            @Override
            public T get(int index2) {
                return index2 < size1 ? list1.get(index2) : list2.get(index2 - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    @NotNull
    public static <T> Iterable<T> concat(final @NotNull Iterable<? extends T> it1, final @NotNull Iterable<? extends T> it2) {
        if (it1 == null) {
            ContainerUtil.$$$reportNull$$$0(244);
        }
        if (it2 == null) {
            ContainerUtil.$$$reportNull$$$0(245);
        }
        return new Iterable<T>(){

            @Override
            public void forEach(Consumer<? super T> action) {
                it1.forEach(action);
                it2.forEach(action);
            }

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends T> it;
                    boolean firstFinished;
                    {
                        this.it = it1.iterator();
                        this.advance();
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.firstFinished || this.it.hasNext();
                    }

                    @Override
                    public T next() {
                        Object value2 = this.it.next();
                        this.advance();
                        return value2;
                    }

                    private void advance() {
                        if (!this.firstFinished && !this.it.hasNext()) {
                            this.it = it2.iterator();
                            this.firstFinished = true;
                        }
                    }
                };
            }
        };
    }

    @SafeVarargs
    @NotNull
    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterables) {
        if (iterables == null) {
            ContainerUtil.$$$reportNull$$$0(246);
        }
        if (iterables.length == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(247);
            }
            return list;
        }
        if (iterables.length == 1) {
            Iterable<? extends T> iterable = iterables[0];
            if (iterable == null) {
                ContainerUtil.$$$reportNull$$$0(248);
            }
            return iterable;
        }
        Iterable iterable = () -> {
            Iterator[] iterators = new Iterator[iterables.length];
            for (int i = 0; i < iterables.length; ++i) {
                Iterable iterable = iterables[i];
                iterators[i] = iterable.iterator();
            }
            return ContainerUtil.concatIterators(iterators);
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(249);
        }
        return iterable;
    }

    @SafeVarargs
    @NotNull
    public static <T> Iterator<T> concatIterators(Iterator<? extends T> ... iterators) {
        if (iterators == null) {
            ContainerUtil.$$$reportNull$$$0(250);
        }
        return new SequenceIterator<T>(iterators);
    }

    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(259);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(260);
        }
        if (collection1.size() <= collection2.size()) {
            for (T t : collection1) {
                if (!collection2.contains(t)) continue;
                return true;
            }
        } else {
            for (T t : collection2) {
                if (!collection1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static <T> Collection<T> intersection(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(261);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(262);
        }
        if (collection1.isEmpty() || collection2.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            result2.add(t);
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(263);
        }
        return list;
    }

    public static <T> T getFirstItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    public static <T> T getFirstItem(@Nullable List<? extends T> items) {
        return items == null || items.isEmpty() ? null : (T)items.get(0);
    }

    public static <T> T getFirstItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.isEmpty() ? defaultResult : items.iterator().next();
    }

    public static <T> T getOnlyItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getOnlyItem(items, null);
    }

    public static <T> T getOnlyItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.size() != 1 ? defaultResult : items.iterator().next();
    }

    public static <T> T getLastItem(@Nullable List<? extends T> list, @Nullable T def) {
        return ContainerUtil.isEmpty(list) ? def : list.get(list.size() - 1);
    }

    public static <T> T getLastItem(@Nullable List<? extends T> list) {
        return ContainerUtil.getLastItem(list, null);
    }

    @NotNull
    public static <T> Collection<T> subtract(@NotNull Collection<? extends T> from, @NotNull Collection<? extends T> what) {
        if (from == null) {
            ContainerUtil.$$$reportNull$$$0(277);
        }
        if (what == null) {
            ContainerUtil.$$$reportNull$$$0(278);
        }
        HashSet<T> set = new HashSet<T>(from);
        set.removeAll(what);
        Collection<T> collection = set.isEmpty() ? ContainerUtil.emptyList() : set;
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(279);
        }
        return collection;
    }

    public static <T> T @NotNull [] toArray(@NotNull Collection<T> c, @NotNull ArrayFactory<? extends T> factory2) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(280);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(281);
        }
        T[] a = factory2.create(c.size());
        T[] TArray = c.toArray(a);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(282);
        }
        return TArray;
    }

    public static <T> void sort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        int size;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(288);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(289);
        }
        if ((size = list.size()) < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list.get(0);
            if (comparator.compare(t0, t1 = list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list.get(i);
                    if (comparator.compare(ti, tj = list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            list.sort(comparator);
        }
    }

    @NotNull
    public static <T extends Comparable<? super T>> List<T> sorted(@NotNull Collection<? extends T> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(296);
        }
        ArrayList<T> result2 = new ArrayList<T>(list);
        result2.sort(null);
        List<? extends T> list2 = Collections.unmodifiableList(result2);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(297);
        }
        return list2;
    }

    @NotNull
    public static <T, V> List<V> map(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends V> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(300);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(301);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : iterable) {
            result2.add(mapping.fun(t));
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(302);
        }
        return list;
    }

    @NotNull
    public static <T, V> List<V> map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(306);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(307);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapping.fun(t));
        }
        ArrayList<V> arrayList = list;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(308);
        }
        return arrayList;
    }

    @NotNull
    public static <T, V> @NotNull List<@NotNull V> mapNotNull(T @NotNull [] array, @NotNull Function<? super T, ? extends @Nullable V> mapping) {
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(309);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(310);
        }
        if (array.length == 0) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result2 = new ArrayList<T>(array.length);
        for (T t : array) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result2.add(o);
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(311);
        }
        return list;
    }

    @NotNull
    public static <T, V> @NotNull List<@NotNull V> mapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends @Nullable V> mapping) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(320);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(321);
        }
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> result2 = new ArrayList<T>(collection.size());
        for (T t : collection) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result2.add(o);
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(322);
        }
        return list;
    }

    @NotNull
    public static <T, V> List<V> map(T @NotNull [] array, @NotNull Function<? super T, ? extends V> mapping) {
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(325);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(326);
        }
        ArrayList<T> result2 = new ArrayList<T>(array.length);
        for (T t : array) {
            result2.add(mapping.fun(t));
        }
        List<T> list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(327);
        }
        return list;
    }

    @NotNull
    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        List list = element == null ? Collections.emptyList() : Collections.singletonList(element);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(341);
        }
        return list;
    }

    public static <T> boolean and(T @NotNull [] iterable, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(351);
        }
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(352);
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean and(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(353);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(354);
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean exists(T @NotNull [] array, @NotNull Condition<? super T> condition) {
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(355);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(356);
        }
        for (T t : array) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean exists(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(357);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(358);
        }
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean or(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(361);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(362);
        }
        return ContainerUtil.exists(iterable, condition);
    }

    public static <T> void quickSort(@NotNull List<? extends T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(367);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(368);
        }
        ContainerUtil.quickSort(list, comparator, 0, list.size());
    }

    private static <T> void quickSort(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(369);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(370);
        }
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecSwap(x, off, b - s, s);
        int n = off + len;
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int a, int b, int c) {
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(371);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(372);
        }
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecSwap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @NotNull
    public static <E> List<E> flatten(@NotNull Iterable<? extends Collection<? extends E>> collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(377);
        }
        int totalSize = 0;
        for (Collection<E> list : collections) {
            totalSize += list.size();
        }
        ArrayList result2 = new ArrayList(totalSize);
        for (Collection<E> collection : collections) {
            result2.addAll(collection);
        }
        List list = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(378);
        }
        return list;
    }

    public static <T> int indexOfIdentity(@NotNull List<? extends T> list, T element) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(387);
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            if (list.get(i) != element) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(390);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(391);
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            T t = list.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public static <T> List<T> emptyList() {
        List list = ContainerUtilRt.emptyList();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(398);
        }
        return list;
    }

    @NotNull
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        return new LockFreeCopyOnWriteArrayList();
    }

    @Deprecated
    @NotNull
    public static <V> @NotNull ConcurrentIntObjectMap<@NotNull V> createConcurrentIntObjectMap() {
        return new ConcurrentIntObjectHashMap();
    }

    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(400);
        }
        return concurrentMap;
    }

    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftKeySoftValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors());
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(401);
        }
        return concurrentMap;
    }

    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeySoftValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakKeySoftValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(402);
        }
        return concurrentMap;
    }

    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftValueMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftValueMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(406);
        }
        return concurrentMap;
    }

    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(407);
        }
        return concurrentMap;
    }

    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakMap() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap();
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(408);
        }
        return concurrentMap;
    }

    @NotNull
    public static <T> ConcurrentList<T> createConcurrentList() {
        return new LockFreeCopyOnWriteArrayList();
    }

    public static <T> void addIfNotNull(@NotNull Collection<? super T> result2, @Nullable T element) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(410);
        }
        if (element != null) {
            result2.add(element);
        }
    }

    @NotNull
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(417);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(418);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(419);
            }
            return set;
        }
        HashSet<V> set = new HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        HashSet<V> hashSet = set;
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(420);
        }
        return hashSet;
    }

    @NotNull
    public static <T, V> @NotNull Set<@NotNull V> map2SetNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(425);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(426);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(427);
            }
            return set;
        }
        HashSet set = new HashSet(collection.size());
        for (T t : collection) {
            V value2 = mapper.fun(t);
            if (value2 == null) continue;
            set.add(value2);
        }
        Set set2 = set.isEmpty() ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(428);
        }
        return set2;
    }

    public static <T> T @NotNull [] copyAndClear(@NotNull Collection<? extends T> collection, @NotNull ArrayFactory<? extends T> factory2, boolean clear2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(435);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(436);
        }
        int size = collection.size();
        T[] a = factory2.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear2) {
                collection.clear();
            }
        }
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(437);
        }
        return a;
    }

    public static <T> boolean isEmpty(@Nullable Collection<? extends T> collection) {
        return collection == null || collection.isEmpty();
    }

    @NotNull
    public static <T> List<T> notNullize(@Nullable List<T> list) {
        List<T> list2 = list == null ? ContainerUtil.emptyList() : list;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(446);
        }
        return list2;
    }

    @NotNull
    public static <T> Set<T> notNullize(@Nullable Set<T> set) {
        Set set2 = set == null ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(447);
        }
        return set2;
    }

    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftValueMap() {
        return new SoftValueHashMap();
    }

    @NotNull
    public static <T> @NotNull IntObjectMap<@NotNull T> createIntKeyWeakValueMap() {
        return new IntKeyWeakValueHashMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 69: 
            case 77: 
            case 79: 
            case 90: 
            case 93: 
            case 99: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 141: 
            case 145: 
            case 149: 
            case 153: 
            case 164: 
            case 167: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 181: 
            case 184: 
            case 187: 
            case 194: 
            case 196: 
            case 199: 
            case 202: 
            case 205: 
            case 214: 
            case 217: 
            case 230: 
            case 232: 
            case 235: 
            case 238: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 254: 
            case 258: 
            case 263: 
            case 266: 
            case 267: 
            case 268: 
            case 270: 
            case 279: 
            case 282: 
            case 286: 
            case 295: 
            case 297: 
            case 302: 
            case 305: 
            case 308: 
            case 311: 
            case 315: 
            case 316: 
            case 319: 
            case 322: 
            case 324: 
            case 327: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 341: 
            case 342: 
            case 345: 
            case 350: 
            case 366: 
            case 376: 
            case 378: 
            case 381: 
            case 385: 
            case 397: 
            case 398: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 415: 
            case 416: 
            case 419: 
            case 420: 
            case 423: 
            case 424: 
            case 427: 
            case 428: 
            case 431: 
            case 434: 
            case 437: 
            case 439: 
            case 442: 
            case 444: 
            case 445: 
            case 446: 
            case 447: 
            case 448: 
            case 456: 
            case 457: 
            case 458: 
            case 459: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 69: 
            case 77: 
            case 79: 
            case 90: 
            case 93: 
            case 99: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 141: 
            case 145: 
            case 149: 
            case 153: 
            case 164: 
            case 167: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 181: 
            case 184: 
            case 187: 
            case 194: 
            case 196: 
            case 199: 
            case 202: 
            case 205: 
            case 214: 
            case 217: 
            case 230: 
            case 232: 
            case 235: 
            case 238: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 254: 
            case 258: 
            case 263: 
            case 266: 
            case 267: 
            case 268: 
            case 270: 
            case 279: 
            case 282: 
            case 286: 
            case 295: 
            case 297: 
            case 302: 
            case 305: 
            case 308: 
            case 311: 
            case 315: 
            case 316: 
            case 319: 
            case 322: 
            case 324: 
            case 327: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 341: 
            case 342: 
            case 345: 
            case 350: 
            case 366: 
            case 376: 
            case 378: 
            case 381: 
            case 385: 
            case 397: 
            case 398: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 415: 
            case 416: 
            case 419: 
            case 420: 
            case 423: 
            case 424: 
            case 427: 
            case 428: 
            case 431: 
            case 434: 
            case 437: 
            case 439: 
            case 442: 
            case 444: 
            case 445: 
            case 446: 
            case 447: 
            case 448: 
            case 456: 
            case 457: 
            case 458: 
            case 459: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 69: 
            case 77: 
            case 79: 
            case 90: 
            case 93: 
            case 99: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 141: 
            case 145: 
            case 149: 
            case 153: 
            case 164: 
            case 167: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 181: 
            case 184: 
            case 187: 
            case 194: 
            case 196: 
            case 199: 
            case 202: 
            case 205: 
            case 214: 
            case 217: 
            case 230: 
            case 232: 
            case 235: 
            case 238: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 254: 
            case 258: 
            case 263: 
            case 266: 
            case 267: 
            case 268: 
            case 270: 
            case 279: 
            case 282: 
            case 286: 
            case 295: 
            case 297: 
            case 302: 
            case 305: 
            case 308: 
            case 311: 
            case 315: 
            case 316: 
            case 319: 
            case 322: 
            case 324: 
            case 327: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 341: 
            case 342: 
            case 345: 
            case 350: 
            case 366: 
            case 376: 
            case 378: 
            case 381: 
            case 385: 
            case 397: 
            case 398: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 415: 
            case 416: 
            case 419: 
            case 420: 
            case 423: 
            case 424: 
            case 427: 
            case 428: 
            case 431: 
            case 434: 
            case 437: 
            case 439: 
            case 442: 
            case 444: 
            case 445: 
            case 446: 
            case 447: 
            case 448: 
            case 456: 
            case 457: 
            case 458: 
            case 459: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 5: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 6: 
            case 91: 
            case 95: 
            case 234: 
            case 237: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 13: 
            case 54: 
            case 101: 
            case 135: 
            case 136: 
            case 140: 
            case 170: 
            case 189: 
            case 195: 
            case 227: 
            case 229: 
            case 299: 
            case 310: 
            case 313: 
            case 326: 
            case 356: 
            case 414: 
            case 430: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 14: 
            case 15: 
            case 30: 
            case 32: 
            case 38: 
            case 102: 
            case 107: 
            case 110: 
            case 112: 
            case 222: 
            case 300: 
            case 317: 
            case 352: 
            case 353: 
            case 357: 
            case 360: 
            case 361: 
            case 363: 
            case 379: 
            case 440: 
            case 441: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalList";
                break;
            }
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 33: 
            case 83: 
            case 97: 
            case 108: 
            case 114: 
            case 116: 
            case 204: 
            case 206: 
            case 208: 
            case 224: 
            case 273: 
            case 275: 
            case 303: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 42: 
            case 94: 
            case 162: 
            case 348: 
            case 396: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 43: 
            case 64: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map2";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
            case 58: 
            case 78: 
            case 104: 
            case 118: 
            case 198: 
            case 203: 
            case 231: 
            case 233: 
            case 236: 
            case 256: 
            case 287: 
            case 288: 
            case 291: 
            case 293: 
            case 296: 
            case 367: 
            case 374: 
            case 386: 
            case 387: 
            case 390: 
            case 392: 
            case 394: 
            case 438: 
            case 449: 
            case 460: 
            case 462: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 59: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 121: 
            case 123: 
            case 127: 
            case 129: 
            case 132: 
            case 142: 
            case 146: 
            case 151: 
            case 155: 
            case 156: 
            case 159: 
            case 160: 
            case 165: 
            case 168: 
            case 173: 
            case 175: 
            case 179: 
            case 182: 
            case 186: 
            case 190: 
            case 192: 
            case 210: 
            case 212: 
            case 215: 
            case 218: 
            case 220: 
            case 306: 
            case 320: 
            case 411: 
            case 417: 
            case 421: 
            case 425: 
            case 429: 
            case 435: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map1";
                break;
            }
            case 70: 
            case 74: 
            case 239: 
            case 388: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 71: 
            case 75: 
            case 240: 
            case 389: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 72: 
            case 76: 
            case 289: 
            case 292: 
            case 294: 
            case 298: 
            case 368: 
            case 370: 
            case 372: 
            case 375: 
            case 455: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 73: 
            case 103: 
            case 105: 
            case 106: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendix";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueConvertor";
                break;
            }
            case 92: 
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyConvertor";
                break;
            }
            case 100: 
            case 111: 
            case 117: 
            case 119: 
            case 154: 
            case 161: 
            case 166: 
            case 178: 
            case 185: 
            case 188: 
            case 191: 
            case 221: 
            case 351: 
            case 354: 
            case 355: 
            case 358: 
            case 359: 
            case 362: 
            case 364: 
            case 391: 
            case 393: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalTo";
                break;
            }
            case 120: 
            case 124: 
            case 126: 
            case 130: 
            case 134: 
            case 137: 
            case 139: 
            case 144: 
            case 147: 
            case 150: 
            case 274: 
            case 412: 
            case 413: 
            case 418: 
            case 422: 
            case 426: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 138: 
            case 143: 
            case 157: 
            case 158: 
            case 223: 
            case 225: 
            case 226: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 148: 
            case 152: 
            case 384: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 169: 
            case 172: 
            case 176: 
            case 183: 
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValues";
                break;
            }
            case 197: 
            case 211: 
            case 443: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeration";
                break;
            }
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable1";
                break;
            }
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable2";
                break;
            }
            case 209: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 228: 
            case 257: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listGenerator";
                break;
            }
            case 244: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it1";
                break;
            }
            case 245: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it2";
                break;
            }
            case 246: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterables";
                break;
            }
            case 250: 
            case 251: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterators";
                break;
            }
            case 253: 
            case 255: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 259: 
            case 261: 
            case 264: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection1";
                break;
            }
            case 260: 
            case 262: 
            case 265: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection2";
                break;
            }
            case 269: 
            case 271: 
            case 272: 
            case 335: 
            case 365: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 276: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 277: 
            case 383: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 278: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 280: 
            case 399: 
            case 409: 
            case 432: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 281: 
            case 285: 
            case 347: 
            case 436: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 283: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 284: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 290: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 301: 
            case 304: 
            case 307: 
            case 309: 
            case 312: 
            case 318: 
            case 321: 
            case 325: 
            case 328: 
            case 380: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 314: 
            case 330: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyArray";
                break;
            }
            case 329: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr";
                break;
            }
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 343: 
            case 346: 
            case 410: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 340: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 344: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 349: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defValue";
                break;
            }
            case 369: 
            case 371: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 373: 
            case 377: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collections";
                break;
            }
            case 382: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 395: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 404: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 433: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 450: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 451: 
            case 453: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 452: 
            case 454: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 461: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ar";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayList";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "newUnmodifiableList";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyList";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptySet";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyMap";
                break;
            }
            case 31: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashSet";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashOrEmptySet";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashSet";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "newConcurrentSet";
                break;
            }
            case 44: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSet";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableList";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSingletonList";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBy";
                break;
            }
            case 65: 
            case 66: 
            case 263: 
            case 266: 
            case 267: 
            case 268: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "diff";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSortedLists";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "subList";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromKeys";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromValues";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 122: 
            case 125: 
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Map";
                break;
            }
            case 128: 
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "map2MapNotNull";
                break;
            }
            case 141: 
            case 145: 
            case 149: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Array";
                break;
            }
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 167: 
            case 171: 
            case 184: 
            case 187: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 174: 
            case 177: 
            case 180: 
            case 181: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAsArray";
                break;
            }
            case 194: {
                objectArray = objectArray2;
                objectArray2[1] = "stringMap";
                break;
            }
            case 196: {
                objectArray = objectArray2;
                objectArray2[1] = "iterate";
                break;
            }
            case 199: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateBackward";
                break;
            }
            case 202: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 205: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 214: {
                objectArray = objectArray2;
                objectArray2[1] = "addAll";
                break;
            }
            case 217: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllNotNull";
                break;
            }
            case 230: 
            case 232: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 254: 
            case 258: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 235: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 238: {
                objectArray = objectArray2;
                objectArray2[1] = "prepend";
                break;
            }
            case 270: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstItems";
                break;
            }
            case 279: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
            case 282: 
            case 286: 
            case 431: 
            case 434: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 295: 
            case 297: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 302: 
            case 305: 
            case 308: 
            case 327: 
            case 331: 
            case 332: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 311: 
            case 315: 
            case 316: 
            case 319: 
            case 322: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotNull";
                break;
            }
            case 324: {
                objectArray = objectArray2;
                objectArray2[1] = "packNullables";
                break;
            }
            case 333: 
            case 334: {
                objectArray = objectArray2;
                objectArray2[1] = "set";
                break;
            }
            case 341: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonList";
                break;
            }
            case 342: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonSet";
                break;
            }
            case 345: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 350: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrElse";
                break;
            }
            case 366: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 376: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatesFromSorted";
                break;
            }
            case 378: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 381: {
                objectArray = objectArray2;
                objectArray2[1] = "flatMap";
                break;
            }
            case 385: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 397: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseMap";
                break;
            }
            case 398: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyList";
                break;
            }
            case 400: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakValueMap";
                break;
            }
            case 401: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftKeySoftValueMap";
                break;
            }
            case 402: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 403: 
            case 405: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 406: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftValueMap";
                break;
            }
            case 407: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftMap";
                break;
            }
            case 408: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakMap";
                break;
            }
            case 415: 
            case 416: 
            case 419: 
            case 420: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Set";
                break;
            }
            case 423: 
            case 424: {
                objectArray = objectArray2;
                objectArray2[1] = "map2LinkedSet";
                break;
            }
            case 427: 
            case 428: {
                objectArray = objectArray2;
                objectArray2[1] = "map2SetNotNull";
                break;
            }
            case 437: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAndClear";
                break;
            }
            case 439: {
                objectArray = objectArray2;
                objectArray2[1] = "copyList";
                break;
            }
            case 442: {
                objectArray = objectArray2;
                objectArray2[1] = "toCollection";
                break;
            }
            case 444: 
            case 445: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 446: 
            case 447: 
            case 448: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 456: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeySoftValueMap";
                break;
            }
            case 457: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeyWeakValueMap";
                break;
            }
            case 458: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftKeySoftValueMap";
                break;
            }
            case 459: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ar";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 69: 
            case 77: 
            case 79: 
            case 90: 
            case 93: 
            case 99: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 141: 
            case 145: 
            case 149: 
            case 153: 
            case 164: 
            case 167: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 181: 
            case 184: 
            case 187: 
            case 194: 
            case 196: 
            case 199: 
            case 202: 
            case 205: 
            case 214: 
            case 217: 
            case 230: 
            case 232: 
            case 235: 
            case 238: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 254: 
            case 258: 
            case 263: 
            case 266: 
            case 267: 
            case 268: 
            case 270: 
            case 279: 
            case 282: 
            case 286: 
            case 295: 
            case 297: 
            case 302: 
            case 305: 
            case 308: 
            case 311: 
            case 315: 
            case 316: 
            case 319: 
            case 322: 
            case 324: 
            case 327: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 341: 
            case 342: 
            case 345: 
            case 350: 
            case 366: 
            case 376: 
            case 378: 
            case 381: 
            case 385: 
            case 397: 
            case 398: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 415: 
            case 416: 
            case 419: 
            case 420: 
            case 423: 
            case 424: 
            case 427: 
            case 428: 
            case 431: 
            case 434: 
            case 437: 
            case 439: 
            case 442: 
            case 444: 
            case 445: 
            case 446: 
            case 447: 
            case 448: 
            case 456: 
            case 457: 
            case 458: 
            case 459: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newHashMap";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedList";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "newArrayList";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "subArrayAsList";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "newUnmodifiableList";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyList";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptySet";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyMap";
                break;
            }
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "newHashSet";
                break;
            }
            case 36: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashSet";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "reverse";
                break;
            }
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "immutableSet";
                break;
            }
            case 54: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "immutableList";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 62: 
            case 348: 
            case 349: {
                objectArray = objectArray;
                objectArray[2] = "getOrElse";
                break;
            }
            case 63: 
            case 64: 
            case 261: 
            case 262: 
            case 264: 
            case 265: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "processSortedListsInOrder";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "mergeSortedLists";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "subList";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 210: 
            case 211: 
            case 212: 
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 215: 
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "addAllNotNull";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromKeys";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromValues";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "fillMapWithValues";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 100: 
            case 101: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "findLast";
                break;
            }
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "map2Map";
                break;
            }
            case 126: 
            case 127: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "map2MapNotNull";
                break;
            }
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 146: 
            case 147: 
            case 148: 
            case 150: 
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "map2Array";
                break;
            }
            case 154: 
            case 155: 
            case 160: 
            case 161: 
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "filterIsInstance";
                break;
            }
            case 165: 
            case 166: 
            case 169: 
            case 170: 
            case 182: 
            case 183: 
            case 185: 
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "skipNulls";
                break;
            }
            case 172: 
            case 173: 
            case 175: 
            case 176: 
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "findAllAsArray";
                break;
            }
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "all";
                break;
            }
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "stringMap";
                break;
            }
            case 195: 
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "iterateBackward";
                break;
            }
            case 200: 
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "swapElements";
                break;
            }
            case 204: 
            case 206: 
            case 207: 
            case 208: 
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 218: 
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 220: 
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 228: 
            case 229: 
            case 231: 
            case 239: 
            case 240: 
            case 244: 
            case 245: 
            case 246: 
            case 253: 
            case 255: 
            case 256: 
            case 257: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 233: 
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 236: 
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 250: 
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "concatIterators";
                break;
            }
            case 259: 
            case 260: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 269: {
                objectArray = objectArray;
                objectArray[2] = "getFirstItems";
                break;
            }
            case 271: 
            case 272: {
                objectArray = objectArray;
                objectArray[2] = "iterateAndGetLastItem";
                break;
            }
            case 273: 
            case 274: {
                objectArray = objectArray;
                objectArray[2] = "mapIterator";
                break;
            }
            case 275: 
            case 276: {
                objectArray = objectArray;
                objectArray[2] = "filterIterator";
                break;
            }
            case 277: 
            case 278: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 280: 
            case 281: 
            case 283: 
            case 284: 
            case 285: 
            case 429: 
            case 430: 
            case 432: 
            case 433: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 298: 
            case 299: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 296: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 300: 
            case 301: 
            case 303: 
            case 304: 
            case 306: 
            case 307: 
            case 325: 
            case 326: 
            case 328: 
            case 329: 
            case 330: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 309: 
            case 310: 
            case 312: 
            case 313: 
            case 314: 
            case 317: 
            case 318: 
            case 320: 
            case 321: {
                objectArray = objectArray;
                objectArray[2] = "mapNotNull";
                break;
            }
            case 323: {
                objectArray = objectArray;
                objectArray[2] = "packNullables";
                break;
            }
            case 335: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 336: 
            case 337: 
            case 338: {
                objectArray = objectArray;
                objectArray[2] = "putIfNotNull";
                break;
            }
            case 339: 
            case 340: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 343: 
            case 344: 
            case 346: 
            case 347: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 351: 
            case 352: 
            case 353: 
            case 354: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 355: 
            case 356: 
            case 357: 
            case 358: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 359: 
            case 360: 
            case 361: 
            case 362: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 363: 
            case 364: {
                objectArray = objectArray;
                objectArray[2] = "count";
                break;
            }
            case 365: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 367: 
            case 368: 
            case 369: 
            case 370: {
                objectArray = objectArray;
                objectArray[2] = "quickSort";
                break;
            }
            case 371: 
            case 372: {
                objectArray = objectArray;
                objectArray[2] = "med3";
                break;
            }
            case 373: 
            case 377: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 374: 
            case 375: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatesFromSorted";
                break;
            }
            case 379: 
            case 380: {
                objectArray = objectArray;
                objectArray[2] = "flatMap";
                break;
            }
            case 382: 
            case 383: 
            case 384: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 386: {
                objectArray = objectArray;
                objectArray[2] = "containsIdentity";
                break;
            }
            case 387: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIdentity";
                break;
            }
            case 388: 
            case 389: {
                objectArray = objectArray;
                objectArray[2] = "equalsIdentity";
                break;
            }
            case 390: 
            case 391: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 392: 
            case 393: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 394: 
            case 395: {
                objectArray = objectArray;
                objectArray[2] = "findLastInstance";
                break;
            }
            case 396: {
                objectArray = objectArray;
                objectArray[2] = "reverseMap";
                break;
            }
            case 399: {
                objectArray = objectArray;
                objectArray[2] = "createLockFreeCopyOnWriteList";
                break;
            }
            case 404: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 409: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentList";
                break;
            }
            case 410: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 411: 
            case 412: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 413: 
            case 414: 
            case 417: 
            case 418: {
                objectArray = objectArray;
                objectArray[2] = "map2Set";
                break;
            }
            case 421: 
            case 422: {
                objectArray = objectArray;
                objectArray[2] = "map2LinkedSet";
                break;
            }
            case 425: 
            case 426: {
                objectArray = objectArray;
                objectArray[2] = "map2SetNotNull";
                break;
            }
            case 435: 
            case 436: {
                objectArray = objectArray;
                objectArray[2] = "copyAndClear";
                break;
            }
            case 438: {
                objectArray = objectArray;
                objectArray[2] = "copyList";
                break;
            }
            case 440: 
            case 441: {
                objectArray = objectArray;
                objectArray[2] = "toCollection";
                break;
            }
            case 443: {
                objectArray = objectArray;
                objectArray[2] = "toList";
                break;
            }
            case 449: 
            case 450: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 451: 
            case 452: 
            case 453: 
            case 454: 
            case 455: {
                objectArray = objectArray;
                objectArray[2] = "compareLexicographically";
                break;
            }
            case 460: 
            case 461: {
                objectArray = objectArray;
                objectArray[2] = "reduce";
                break;
            }
            case 462: {
                objectArray = objectArray;
                objectArray[2] = "splitListToChunks";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 44: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 69: 
            case 77: 
            case 79: 
            case 90: 
            case 93: 
            case 99: 
            case 122: 
            case 125: 
            case 128: 
            case 131: 
            case 133: 
            case 141: 
            case 145: 
            case 149: 
            case 153: 
            case 164: 
            case 167: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 181: 
            case 184: 
            case 187: 
            case 194: 
            case 196: 
            case 199: 
            case 202: 
            case 205: 
            case 214: 
            case 217: 
            case 230: 
            case 232: 
            case 235: 
            case 238: 
            case 241: 
            case 242: 
            case 243: 
            case 247: 
            case 248: 
            case 249: 
            case 252: 
            case 254: 
            case 258: 
            case 263: 
            case 266: 
            case 267: 
            case 268: 
            case 270: 
            case 279: 
            case 282: 
            case 286: 
            case 295: 
            case 297: 
            case 302: 
            case 305: 
            case 308: 
            case 311: 
            case 315: 
            case 316: 
            case 319: 
            case 322: 
            case 324: 
            case 327: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 341: 
            case 342: 
            case 345: 
            case 350: 
            case 366: 
            case 376: 
            case 378: 
            case 381: 
            case 385: 
            case 397: 
            case 398: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 415: 
            case 416: 
            case 419: 
            case 420: 
            case 423: 
            case 424: 
            case 427: 
            case 428: 
            case 431: 
            case 434: 
            case 437: 
            case 439: 
            case 442: 
            case 444: 
            case 445: 
            case 446: 
            case 447: 
            case 448: 
            case 456: 
            case 457: 
            case 458: 
            case 459: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    private static final class ImmutableListBackedByArray<E>
    extends ImmutableList<E> {
        private final E[] myStore;

        private ImmutableListBackedByArray(E @NotNull [] array) {
            if (array == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(0);
            }
            this.myStore = array;
        }

        @Override
        public E get(int index2) {
            return this.myStore[index2];
        }

        @Override
        public int size() {
            return this.myStore.length;
        }

        @Override
        public <T> T @NotNull [] toArray(T @NotNull [] a) {
            int size;
            if (a == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(1);
            }
            T[] result2 = a.length >= (size = this.size()) ? a : ArrayUtil.newArray(ArrayUtil.getComponentType(a), size);
            System.arraycopy(this.myStore, 0, result2, 0, size);
            if (result2.length > size) {
                result2[size] = null;
            }
            if (result2 == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(2);
            }
            return result2;
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            int length = this.myStore.length;
            for (int i = 0; i < length; ++i) {
                action.accept(this.myStore[i]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

