/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.IntFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IOUtil {
    public static final int KiB = 1024;
    public static final int MiB = 0x100000;
    public static final int GiB = 0x40000000;
    public static final ThreadLocal<Boolean> OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP = new ThreadLocal<Boolean>(){

        @Override
        public void set(Boolean value2) {
            if (this.get() != null) {
                throw new RuntimeException("Reentrant access");
            }
            super.set(value2);
        }
    };
    public static final String SHARED_CACHES_PROP = "idea.shared.caches";
    private static final ThreadLocalCachedValue<byte[]> ourReadWriteBuffersCache = new ThreadLocalCachedValue<byte[]>(){

        @Override
        protected byte @NotNull [] create() {
            byte[] byArray = IOUtil.allocReadWriteUTFBuffer();
            if (byArray == null) {
                2.$$$reportNull$$$0(0);
            }
            return byArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/IOUtil$2", "create"));
        }
    };
    private static final byte[] ZEROES = new byte[1024];

    public static boolean useNativeByteOrderForByteBuffers() {
        Boolean forced = OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP.get();
        return forced == null || forced != false;
    }

    public static boolean isSharedCachesEnabled() {
        return SystemProperties.getBooleanProperty(SHARED_CACHES_PROP, false);
    }

    private IOUtil() {
    }

    public static String readString(@NotNull DataInput stream) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(0);
        }
        try {
            int length = stream.readInt();
            if (length == -1) {
                return null;
            }
            if (length == 0) {
                return "";
            }
            byte[] bytes = new byte[length * 2];
            stream.readFully(bytes);
            return new String(bytes, 0, length * 2, StandardCharsets.UTF_16BE);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public static String readString(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(1);
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static void writeString(@Nullable String s, @NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(2);
        }
        IOUtil.writeCharSequence(s, stream);
    }

    public static void writeCharSequence(@Nullable CharSequence s, @NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(3);
        }
        if (s == null) {
            stream.writeInt(-1);
            return;
        }
        stream.writeInt(s.length());
        if (s.length() == 0) {
            return;
        }
        byte[] bytes = new byte[s.length() * 2];
        int i = 0;
        int i2 = 0;
        while (i < s.length()) {
            char aChar = s.charAt(i);
            bytes[i2] = (byte)(aChar >>> 8 & 0xFF);
            bytes[i2 + 1] = (byte)(aChar & 0xFF);
            ++i;
            i2 += 2;
        }
        stream.write(bytes);
    }

    public static void writeUTFTruncated(@NotNull DataOutput stream, @NotNull String text) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(4);
        }
        if (text == null) {
            IOUtil.$$$reportNull$$$0(5);
        }
        if (text.length() > 16383) {
            stream.writeUTF(text.substring(0, 16383));
        } else {
            stream.writeUTF(text);
        }
    }

    public static void writeUTF(@NotNull DataOutput storage2, @NotNull String value2) throws IOException {
        if (storage2 == null) {
            IOUtil.$$$reportNull$$$0(6);
        }
        if (value2 == null) {
            IOUtil.$$$reportNull$$$0(7);
        }
        IOUtil.writeUTFFast(ourReadWriteBuffersCache.getValue(), storage2, value2);
    }

    public static void writeUTF(@NotNull DataOutput storage2, @NotNull CharSequence value2) throws IOException {
        if (storage2 == null) {
            IOUtil.$$$reportNull$$$0(8);
        }
        if (value2 == null) {
            IOUtil.$$$reportNull$$$0(9);
        }
        IOUtil.writeUTFFast(ourReadWriteBuffersCache.getValue(), storage2, value2);
    }

    public static String readUTF(@NotNull DataInput storage2) throws IOException {
        if (storage2 == null) {
            IOUtil.$$$reportNull$$$0(10);
        }
        return IOUtil.readUTFFast(ourReadWriteBuffersCache.getValue(), storage2);
    }

    public static CharSequence readUTFCharSequence(@NotNull DataInput storage2) throws IOException {
        if (storage2 == null) {
            IOUtil.$$$reportNull$$$0(11);
        }
        return IOUtil.readUTFFastCharSequence(storage2);
    }

    public static byte @NotNull [] allocReadWriteUTFBuffer() {
        return new byte[256];
    }

    public static void writeUTFFast(byte @NotNull [] buffer, @NotNull DataOutput storage2, @NotNull String value2) throws IOException {
        if (storage2 == null) {
            IOUtil.$$$reportNull$$$0(12);
        }
        if (value2 == null) {
            IOUtil.$$$reportNull$$$0(13);
        }
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(14);
        }
        IOUtil.writeUTFFast(buffer, storage2, (CharSequence)value2);
    }

    public static void writeUTFFast(byte @NotNull [] buffer, @NotNull DataOutput storage2, @NotNull CharSequence value2) throws IOException {
        int len;
        if (storage2 == null) {
            IOUtil.$$$reportNull$$$0(15);
        }
        if (value2 == null) {
            IOUtil.$$$reportNull$$$0(16);
        }
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(17);
        }
        if ((len = value2.length()) < 255) {
            buffer[0] = (byte)len;
            boolean isAscii = true;
            for (int i = 0; i < len; ++i) {
                char c = value2.charAt(i);
                if (c >= '\u0080') {
                    isAscii = false;
                    break;
                }
                buffer[i + 1] = (byte)c;
            }
            if (isAscii) {
                storage2.write(buffer, 0, len + 1);
                return;
            }
        }
        storage2.writeByte(-1);
        try {
            storage2.writeUTF(value2.toString());
        }
        catch (UTFDataFormatException e) {
            storage2.writeUTF("LONGER_THAN_64K");
            IOUtil.writeCharSequence(value2, storage2);
        }
    }

    public static String readUTFFast(byte @NotNull [] buffer, @NotNull DataInput storage2) throws IOException {
        int len;
        if (storage2 == null) {
            IOUtil.$$$reportNull$$$0(18);
        }
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(19);
        }
        if ((len = 0xFF & storage2.readByte()) == 255) {
            return IOUtil.readLongString(storage2);
        }
        if (len == 0) {
            return "";
        }
        storage2.readFully(buffer, 0, len);
        return new String(buffer, 0, len, StandardCharsets.ISO_8859_1);
    }

    @Nullable
    private static String readLongString(@NotNull DataInput storage2) throws IOException {
        String result2;
        if (storage2 == null) {
            IOUtil.$$$reportNull$$$0(20);
        }
        if ("LONGER_THAN_64K".equals(result2 = storage2.readUTF())) {
            return IOUtil.readString(storage2);
        }
        return result2;
    }

    public static CharSequence readUTFFastCharSequence(@NotNull DataInput storage2) throws IOException {
        int len;
        if (storage2 == null) {
            IOUtil.$$$reportNull$$$0(21);
        }
        if ((len = 0xFF & storage2.readByte()) == 255) {
            return IOUtil.readLongString(storage2);
        }
        if (len == 0) {
            return "";
        }
        byte[] data2 = new byte[len];
        storage2.readFully(data2, 0, len);
        return new ByteArrayCharSequence(data2, 0, len);
    }

    public static boolean isAscii(@NotNull String str) {
        if (str == null) {
            IOUtil.$$$reportNull$$$0(22);
        }
        return IOUtil.isAscii((CharSequence)str);
    }

    public static boolean isAscii(@NotNull CharSequence str) {
        if (str == null) {
            IOUtil.$$$reportNull$$$0(23);
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) < '\u0080') continue;
            return false;
        }
        return true;
    }

    public static boolean isAscii(char c) {
        return c < '\u0080';
    }

    public static boolean deleteAllFilesStartingWith(@NotNull Path file2) {
        if (file2 == null) {
            IOUtil.$$$reportNull$$$0(24);
        }
        String baseName = file2.getFileName().toString();
        Path parentFile = file2.getParent();
        if (parentFile == null) {
            return true;
        }
        ArrayList<Path> files2 = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(parentFile);){
            for (Path path : directoryStream) {
                if (!path.getFileName().toString().startsWith(baseName)) continue;
                files2.add(path);
            }
        }
        catch (NoSuchFileException ignore) {
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
        boolean ok = true;
        for (Path f : files2) {
            try {
                FileUtil.delete(f);
            }
            catch (IOException ignore) {
                ok = false;
            }
        }
        return ok;
    }

    public static boolean deleteAllFilesStartingWith(@NotNull File file2) {
        if (file2 == null) {
            IOUtil.$$$reportNull$$$0(25);
        }
        String baseName = file2.getName();
        File parentFile = file2.getParentFile();
        File[] files2 = parentFile != null ? parentFile.listFiles(pathname -> pathname.getName().startsWith(baseName)) : null;
        boolean ok = true;
        if (files2 != null) {
            for (File f : files2) {
                ok &= FileUtil.delete(f);
            }
        }
        return ok;
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull Path file2) throws IOException {
        if (factoryComputable == null) {
            IOUtil.$$$reportNull$$$0(26);
        }
        if (file2 == null) {
            IOUtil.$$$reportNull$$$0(27);
        }
        return IOUtil.openCleanOrResetBroken(factoryComputable, () -> IOUtil.deleteAllFilesStartingWith(file2));
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull File file2) throws IOException {
        if (factoryComputable == null) {
            IOUtil.$$$reportNull$$$0(28);
        }
        if (file2 == null) {
            IOUtil.$$$reportNull$$$0(29);
        }
        return IOUtil.openCleanOrResetBroken(factoryComputable, () -> IOUtil.deleteAllFilesStartingWith(file2));
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull Runnable cleanupCallback) throws IOException {
        if (factoryComputable == null) {
            IOUtil.$$$reportNull$$$0(30);
        }
        if (cleanupCallback == null) {
            IOUtil.$$$reportNull$$$0(31);
        }
        try {
            return factoryComputable.compute();
        }
        catch (IOException ex) {
            cleanupCallback.run();
            return factoryComputable.compute();
        }
    }

    public static void writeStringList(@NotNull DataOutput out, @NotNull Collection<String> list) throws IOException {
        if (out == null) {
            IOUtil.$$$reportNull$$$0(32);
        }
        if (list == null) {
            IOUtil.$$$reportNull$$$0(33);
        }
        DataInputOutputUtil.writeINT(out, list.size());
        for (String s : list) {
            IOUtil.writeUTF(out, s);
        }
    }

    @NotNull
    public static <C extends Collection<String>> C readStringCollection(@NotNull DataInput in, @NotNull IntFunction<? extends C> collectionGenerator) throws IOException {
        if (in == null) {
            IOUtil.$$$reportNull$$$0(34);
        }
        if (collectionGenerator == null) {
            IOUtil.$$$reportNull$$$0(35);
        }
        int size = DataInputOutputUtil.readINT(in);
        Collection strings2 = (Collection)collectionGenerator.apply(size);
        for (int i = 0; i < size; ++i) {
            strings2.add(IOUtil.readUTF(in));
        }
        Collection collection = strings2;
        if (collection == null) {
            IOUtil.$$$reportNull$$$0(36);
        }
        return (C)collection;
    }

    @NotNull
    public static List<String> readStringList(@NotNull DataInput in) throws IOException {
        if (in == null) {
            IOUtil.$$$reportNull$$$0(37);
        }
        return IOUtil.readStringCollection(in, ArrayList::new);
    }

    public static void closeSafe(@NotNull Logger log2, Closeable ... closeables) {
        if (log2 == null) {
            IOUtil.$$$reportNull$$$0(38);
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                log2.error(e);
            }
        }
    }

    public static void closeSafe(@NotNull Logger log2, AutoCloseable ... closeables) {
        if (log2 == null) {
            IOUtil.$$$reportNull$$$0(39);
        }
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception e) {
                log2.error(e);
            }
        }
    }

    public static void allocateFileRegion(@NotNull FileChannel channel, long upUntilSize) throws IOException {
        long channelSize;
        if (channel == null) {
            IOUtil.$$$reportNull$$$0(40);
        }
        if ((channelSize = channel.size()) < upUntilSize) {
            int stride = ZEROES.length;
            ByteBuffer zeros = ByteBuffer.wrap(ZEROES);
            for (long pos = channelSize; pos < upUntilSize; pos += (long)stride) {
                int remainsToZero = Math.toIntExact(Math.min((long)stride, upUntilSize - pos));
                zeros.clear().limit(remainsToZero);
                channel.write(zeros, pos);
            }
        }
    }

    public static <T> byte[] toBytes(T object, @NotNull DataExternalizer<? super T> externalizer) throws IOException {
        if (externalizer == null) {
            IOUtil.$$$reportNull$$$0(41);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream(bos);){
            externalizer.save(dos, object);
        }
        return bos.toByteArray();
    }

    public static <T> T fromBytes(byte[] bytes, @NotNull DataExternalizer<? extends T> externalizer) throws IOException {
        if (externalizer == null) {
            IOUtil.$$$reportNull$$$0(42);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try (DataInputStream dis = new DataInputStream(bis);){
            T t = externalizer.read(dis);
            return t;
        }
    }

    public static String toString(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(43);
        }
        byte[] bytes = new byte[buffer.capacity()];
        ByteBuffer slice = buffer.duplicate();
        slice.position(0).limit(buffer.capacity());
        slice.get(bytes);
        return Arrays.toString(bytes);
    }

    @NotNull
    public static String toHexString(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(44);
        }
        return IOUtil.toHexString(buffer, -1);
    }

    @NotNull
    public static String toHexString(@NotNull ByteBuffer buffer, int pageSize) {
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(45);
        }
        byte[] bytes = new byte[buffer.capacity()];
        ByteBuffer slice = buffer.duplicate();
        slice.position(0).limit(buffer.capacity());
        slice.get(bytes);
        return IOUtil.toHexString(bytes, pageSize);
    }

    @NotNull
    public static String toHexString(byte[] bytes) {
        return IOUtil.toHexString(bytes, -1);
    }

    @NotNull
    public static String toHexString(byte[] bytes, int pageSize) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            int unsignedByte = Byte.toUnsignedInt(b);
            if (unsignedByte < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(unsignedByte));
            if (i >= bytes.length - 1) continue;
            if (pageSize > 0 && i % pageSize == pageSize - 1) {
                sb.append('\n');
                continue;
            }
            sb.append(' ');
        }
        String string2 = sb.toString();
        if (string2 == null) {
            IOUtil.$$$reportNull$$$0(46);
        }
        return string2;
    }

    public static int asciiToMagicWord(@NotNull String ascii) {
        if (ascii == null) {
            IOUtil.$$$reportNull$$$0(47);
        }
        if (ascii.length() != 4) {
            throw new IllegalArgumentException("ascii[" + ascii + "] must be 4 ASCII chars long");
        }
        byte[] bytes = ascii.getBytes(StandardCharsets.US_ASCII);
        if (bytes.length != 4) {
            throw new IllegalArgumentException("ascii bytes [" + IOUtil.toHexString(bytes) + "].length must be 4");
        }
        return Byte.toUnsignedInt(bytes[0]) << 24 | Byte.toUnsignedInt(bytes[1]) << 16 | Byte.toUnsignedInt(bytes[2]) << 8 | Byte.toUnsignedInt(bytes[3]);
    }

    public static String magicWordToASCII(int magicWord) {
        byte[] ascii = new byte[]{(byte)(magicWord >> 24 & 0xFF), (byte)(magicWord >> 16 & 0xFF), (byte)(magicWord >> 8 & 0xFF), (byte)(magicWord & 0xFF)};
        return new String(ascii, StandardCharsets.US_ASCII);
    }

    public static <Out extends AutoCloseable, In extends AutoCloseable, E extends Throwable> Out wrapSafely(@NotNull In storageToWrap, @NotNull ThrowableNotNullFunction<In, Out, E> wrapperer) throws E {
        if (storageToWrap == null) {
            IOUtil.$$$reportNull$$$0(48);
        }
        if (wrapperer == null) {
            IOUtil.$$$reportNull$$$0(49);
        }
        try {
            return (Out)((AutoCloseable)wrapperer.fun(storageToWrap));
        }
        catch (Throwable mainEx) {
            try {
                storageToWrap.close();
            }
            catch (Throwable closeEx) {
                mainEx.addSuppressed(closeEx);
            }
            throw mainEx;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 36: 
            case 46: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 36: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: 
            case 14: 
            case 17: 
            case 19: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 24: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryComputable";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupCallback";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionGenerator";
                break;
            }
            case 36: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/IOUtil";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ascii";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageToWrap";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapperer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/IOUtil";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "readStringCollection";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeCharSequence";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeUTFTruncated";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeUTF";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readUTF";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readUTFCharSequence";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writeUTFFast";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readUTFFast";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readLongString";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readUTFFastCharSequence";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAscii";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "deleteAllFilesStartingWith";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "openCleanOrResetBroken";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "writeStringList";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "readStringCollection";
                break;
            }
            case 36: 
            case 46: {
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "readStringList";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "closeSafe";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "allocateFileRegion";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "toBytes";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "fromBytes";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "asciiToMagicWord";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "wrapSafely";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 36: 
            case 46: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

