/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.CompositeMessageBusKt;
import com.intellij.util.messages.impl.DescriptorBasedMessageBusConnection;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusEx;
import com.intellij.util.messages.impl.MessageBusImpl;
import com.intellij.util.messages.impl.MessagePublisher;
import com.intellij.util.messages.impl.ToDirectChildrenMessagePublisher;
import com.intellij.util.messages.impl.ToParentMessagePublisher;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0001J\b\u0010\u0014\u001a\u00020\u0012H\u0017J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u001d\u0010\u0016\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0010\u00a2\u0006\u0004\b\u001a\u0010\u001bJ#\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0010\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\"\"\u0004\b\u0000\u0010#2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H#0\u001e2\u0006\u0010$\u001a\u00020%H\u0010\u00a2\u0006\u0002\b&J\u001a\u0010'\u001a\u00020\u00122\u0010\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0)H\u0016J\r\u0010+\u001a\u00020\u0012H\u0010\u00a2\u0006\u0002\b,J1\u0010-\u001a\u00020\u00122\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e2\u000e\u0010.\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00190\t2\u0006\u0010/\u001a\u000200H\u0010\u00a2\u0006\u0002\b1J\r\u00102\u001a\u000200H\u0010\u00a2\u0006\u0002\b3J\u001d\u00104\u001a\u0002002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0010\u00a2\u0006\u0004\b5\u00106J\u0019\u00107\u001a\u00020\u00122\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0010\u00a2\u0006\u0002\b8J\u000e\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u0001J\b\u0010;\u001a\u00020\u0012H\u0016J\"\u0010<\u001a\u00020\u00122\u0018\u0010=\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\t0>H\u0016J\u001c\u0010/\u001a\u00020\u0012\"\u0004\b\u0000\u0010#2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H#0\u001eH\u0002J\u001e\u0010?\u001a\u00020\u00122\u0006\u0010@\u001a\u00020A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016R:\u0010\b\u001a.\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00010\u0001 \n*\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00010\u00010\f\u00a2\u0006\u0002\b\u000b0\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\t0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/util/messages/impl/CompositeMessageBus;", "Lcom/intellij/util/messages/impl/MessageBusImpl;", "Lcom/intellij/util/messages/impl/MessageBusEx;", "owner", "Lcom/intellij/util/messages/MessageBusOwner;", "parentBus", "(Lcom/intellij/util/messages/MessageBusOwner;Lcom/intellij/util/messages/impl/CompositeMessageBus;)V", "(Lcom/intellij/util/messages/MessageBusOwner;)V", "childBuses", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "topicClassToListenerDescriptor", "", "", "Lcom/intellij/util/messages/ListenerDescriptor;", "addChild", "", "bus", "clearAllSubscriberCache", "clearPublisherCache", "clearSubscriberCache", "topicAndHandlerPairs", "", "", "clearSubscriberCache$intellij_platform_core", "([Ljava/lang/Object;)V", "computeSubscribers", "topic", "Lcom/intellij/util/messages/Topic;", "computeSubscribers$intellij_platform_core", "(Lcom/intellij/util/messages/Topic;)[Ljava/lang/Object;", "createPublisher", "Lcom/intellij/util/messages/impl/MessagePublisher;", "L", "direction", "Lcom/intellij/util/messages/Topic$BroadcastDirection;", "createPublisher$intellij_platform_core", "disconnectPluginConnections", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "disposeChildren", "disposeChildren$intellij_platform_core", "doComputeSubscribers", "result", "subscribeLazyListeners", "", "doComputeSubscribers$intellij_platform_core", "hasChildren", "hasChildren$intellij_platform_core", "notifyConnectionTerminated", "notifyConnectionTerminated$intellij_platform_core", "([Ljava/lang/Object;)Z", "notifyOnSubscriptionToTopicToChildren", "notifyOnSubscriptionToTopicToChildren$intellij_platform_core", "onChildBusDisposed", "childBus", "removeEmptyConnectionsRecursively", "setLazyListeners", "map", "Ljava/util/concurrent/ConcurrentMap;", "unsubscribeLazyListeners", "module", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "listenerDescriptors", "intellij.platform.core"})
public class CompositeMessageBus
extends MessageBusImpl
implements MessageBusEx {
    @NotNull
    private final List<MessageBusImpl> childBuses;
    @NotNull
    private volatile Map<String, List<ListenerDescriptor>> topicClassToListenerDescriptor;

    public CompositeMessageBus(@NotNull MessageBusOwner owner) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        super(owner);
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue(list, "createLockFreeCopyOnWriteList(...)");
        this.childBuses = list;
        this.topicClassToListenerDescriptor = CompositeMessageBusKt.access$getEMPTY_MAP$p();
    }

    @Override
    public void setLazyListeners(@NotNull ConcurrentMap<String, List<ListenerDescriptor>> map2) {
        Intrinsics.checkNotNullParameter(map2, "map");
        Map<String, List<ListenerDescriptor>> topicClassToListenerDescriptor = this.topicClassToListenerDescriptor;
        if (topicClassToListenerDescriptor == CompositeMessageBusKt.access$getEMPTY_MAP$p()) {
            this.topicClassToListenerDescriptor = map2;
        } else {
            topicClassToListenerDescriptor.putAll((Map<String, List<ListenerDescriptor>>)map2);
            if (this.rootBus != this) {
                this.rootBus.subscriberCache.clear();
            }
            this.subscriberCache.clear();
        }
    }

    @Override
    public boolean hasChildren$intellij_platform_core() {
        return !((Collection)this.childBuses).isEmpty();
    }

    public final void onChildBusDisposed(@NotNull MessageBusImpl childBus) {
        Intrinsics.checkNotNullParameter(childBus, "childBus");
        boolean removed = this.childBuses.remove(childBus);
        CompositeMessageBusKt.access$childrenListChanged(this);
        MessageBusImpl.LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    public <L> MessagePublisher<L> createPublisher$intellij_platform_core(@NotNull Topic<L> topic, @NotNull Topic.BroadcastDirection direction) {
        MessagePublisher messagePublisher;
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                messagePublisher = new ToParentMessagePublisher<L>(topic, this);
                break;
            }
            case 2: {
                if (!(this.parentBus == null)) {
                    boolean bl = false;
                    String string2 = "Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic " + topic.getListenerClass() + " broadcast direction to NONE or TO_PARENT";
                    throw new IllegalArgumentException(string2.toString());
                }
                messagePublisher = new ToDirectChildrenMessagePublisher<L>(topic, this, this.childBuses);
                break;
            }
            default: {
                messagePublisher = new MessagePublisher(topic, this);
            }
        }
        return messagePublisher;
    }

    @Override
    @NotNull
    public Object[] computeSubscribers$intellij_platform_core(@NotNull Topic<?> topic) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(topic, "topic");
        if (this.owner.isDisposed()) {
            objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            Intrinsics.checkNotNullExpressionValue(ArrayUtilRt.EMPTY_OBJECT_ARRAY, "EMPTY_OBJECT_ARRAY");
        } else {
            objectArray = super.computeSubscribers$intellij_platform_core(topic);
        }
        return objectArray;
    }

    @Override
    public void doComputeSubscribers$intellij_platform_core(@NotNull Topic<?> topic, @NotNull List<? super Object> result2, boolean subscribeLazyListeners2) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(result2, "result");
        if (subscribeLazyListeners2) {
            this.subscribeLazyListeners(topic);
        }
        super.doComputeSubscribers$intellij_platform_core(topic, result2, subscribeLazyListeners2);
        if (topic.getBroadcastDirection() == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.childBuses) {
                if (childBus.isDisposed()) continue;
                childBus.doComputeSubscribers$intellij_platform_core(topic, result2, !childBus.owner.isParentLazyListenersIgnored());
            }
        }
    }

    private final <L> void subscribeLazyListeners(Topic<L> topic) {
        if (topic.getListenerClass() == Runnable.class) {
            return;
        }
        Map<String, List<ListenerDescriptor>> topicClassToListenerDescriptor = this.topicClassToListenerDescriptor;
        if (topicClassToListenerDescriptor == CompositeMessageBusKt.access$getEMPTY_MAP$p()) {
            return;
        }
        Cancellation.computeInNonCancelableSection(() -> CompositeMessageBus.subscribeLazyListeners$lambda$3(topicClassToListenerDescriptor, topic, this));
    }

    @Override
    public void notifyOnSubscriptionToTopicToChildren$intellij_platform_core(@NotNull Topic<?> topic) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        for (MessageBusImpl childBus : this.childBuses) {
            childBus.subscriberCache.remove(topic);
            childBus.notifyOnSubscriptionToTopicToChildren$intellij_platform_core(topic);
        }
    }

    @Override
    public boolean notifyConnectionTerminated$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter(topicAndHandlerPairs, "topicAndHandlerPairs");
        boolean isChildClearingNeeded = super.notifyConnectionTerminated$intellij_platform_core(topicAndHandlerPairs);
        if (!isChildClearingNeeded) {
            return false;
        }
        for (MessageBusImpl bus : this.childBuses) {
            bus.clearSubscriberCache$intellij_platform_core(topicAndHandlerPairs);
        }
        this.rootBus.getQueue$intellij_platform_core().queue.removeIf(arg_0 -> CompositeMessageBus.notifyConnectionTerminated$lambda$4(new Function1<Message, Boolean>(topicAndHandlerPairs){
            final /* synthetic */ Object[] $topicAndHandlerPairs;
            {
                this.$topicAndHandlerPairs = $topicAndHandlerPairs;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Message it) {
                Intrinsics.checkNotNull(it);
                return CompositeMessageBusKt.access$nullizeHandlersFromMessage(it, this.$topicAndHandlerPairs);
            }
        }, arg_0));
        return false;
    }

    @Override
    public void clearSubscriberCache$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter(topicAndHandlerPairs, "topicAndHandlerPairs");
        super.clearSubscriberCache$intellij_platform_core(topicAndHandlerPairs);
        for (MessageBusImpl bus : this.childBuses) {
            bus.clearSubscriberCache$intellij_platform_core(topicAndHandlerPairs);
        }
    }

    @Override
    public void removeEmptyConnectionsRecursively() {
        super.removeEmptyConnectionsRecursively();
        for (MessageBusImpl bus : this.childBuses) {
            bus.removeEmptyConnectionsRecursively();
        }
    }

    @Override
    public void disposeChildren$intellij_platform_core() {
        Iterable $this$forEach$iv = this.childBuses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable p0 = (Disposable)element$iv;
            boolean bl = false;
            Disposer.dispose(p0);
        }
    }

    private static final List subscribeLazyListeners$lambda$3$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final void subscribeLazyListeners$lambda$3$lambda$2(CompositeMessageBus this$0, Topic $topic, PluginDescriptor key, List listeners) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($topic, "$topic");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(listeners, "listeners");
        this$0.subscribers.add(new DescriptorBasedMessageBusConnection(key, $topic, listeners));
    }

    private static final Unit subscribeLazyListeners$lambda$3(Map $topicClassToListenerDescriptor, Topic $topic, CompositeMessageBus this$0) {
        Intrinsics.checkNotNullParameter($topicClassToListenerDescriptor, "$topicClassToListenerDescriptor");
        Intrinsics.checkNotNullParameter($topic, "$topic");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        List list = (List)$topicClassToListenerDescriptor.remove($topic.getListenerClass().getName());
        if (list == null) {
            return Unit.INSTANCE;
        }
        List listenerDescriptors = list;
        LinkedHashMap<Object, List> listenerMap = new LinkedHashMap<Object, List>();
        for (ListenerDescriptor listenerDescriptor : listenerDescriptors) {
            try {
                Object object = this$0.owner.createListener(listenerDescriptor);
                Intrinsics.checkNotNullExpressionValue(object, "createListener(...)");
                listenerMap.computeIfAbsent(listenerDescriptor.pluginDescriptor, arg_0 -> CompositeMessageBus.subscribeLazyListeners$lambda$3$lambda$1(subscribeLazyListeners.1.1.INSTANCE, arg_0)).add(object);
            }
            catch (ExtensionNotApplicableException extensionNotApplicableException) {
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                MessageBusImpl.LOG.error("Cannot create listener", e);
            }
        }
        listenerMap.forEach((arg_0, arg_1) -> CompositeMessageBus.subscribeLazyListeners$lambda$3$lambda$2(this$0, $topic, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final boolean notifyConnectionTerminated$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Topic.BroadcastDirection.values().length];
            try {
                nArray[Topic.BroadcastDirection.TO_PARENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Topic.BroadcastDirection.TO_DIRECT_CHILDREN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

