/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.AbstractIterator;
import io.vavr.collection.Collections;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Iterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public final class Array<T>
implements IndexedSeq<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Array<?> EMPTY = new Array(new Object[0]);
    private final Object[] delegate;

    private Array(Object[] delegate) {
        this.delegate = delegate;
    }

    static <T> Array<T> wrap(Object[] array) {
        return array.length == 0 ? Array.empty() : new Array<T>(array);
    }

    public static <T> Array<T> empty() {
        return EMPTY;
    }

    @Override
    public Array<T> append(T element) {
        Object[] copy2 = Arrays.copyOf(this.delegate, this.delegate.length + 1);
        copy2[this.delegate.length] = element;
        return Array.wrap(copy2);
    }

    @Override
    public Array<T> appendAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (this.isEmpty() && elements instanceof Array) {
            Array array = (Array)elements;
            return array;
        }
        Object[] source = Array.toArray(elements);
        if (source.length == 0) {
            return this;
        }
        Object[] arr = Arrays.copyOf(this.delegate, this.delegate.length + source.length);
        System.arraycopy(source, 0, arr, this.delegate.length, source.length);
        return Array.wrap(arr);
    }

    @Override
    public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new AbstractIterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < Array.this.delegate.length;
            }

            @Override
            public T getNext() {
                return Array.this.delegate[this.index++];
            }
        };
    }

    @Override
    public T get(int index2) {
        if (index2 < 0 || index2 >= this.length()) {
            throw new IndexOutOfBoundsException("get(" + index2 + ")");
        }
        return (T)this.delegate[index2];
    }

    @Override
    public Array<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        ArrayList list = new ArrayList();
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            list.add(t);
        }
        if (list.isEmpty()) {
            return Array.empty();
        }
        if (list.size() == this.size()) {
            return this;
        }
        return Array.wrap(list.toArray());
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head on empty Array");
        }
        return (T)this.delegate[0];
    }

    @Override
    public int indexOf(T element, int from) {
        for (int i = from; i < this.length(); ++i) {
            if (!Objects.equals(this.get(i), element)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.length == 0;
    }

    private Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    @Override
    public Array<T> insert(int index2, T element) {
        if (index2 < 0 || index2 > this.length()) {
            throw new IndexOutOfBoundsException("insert(" + index2 + ", e) on Array of length " + this.length());
        }
        Object[] arr = new Object[this.delegate.length + 1];
        System.arraycopy(this.delegate, 0, arr, 0, index2);
        arr[index2] = element;
        System.arraycopy(this.delegate, index2, arr, index2 + 1, this.delegate.length - index2);
        return Array.wrap(arr);
    }

    @Override
    public Array<T> insertAll(int index2, Iterable<? extends T> elements) {
        if (index2 < 0 || index2 > this.length()) {
            throw new IndexOutOfBoundsException("insert(" + index2 + ", e) on Array of length " + this.length());
        }
        if (this.isEmpty() && elements instanceof Array) {
            Array array = (Array)elements;
            return array;
        }
        Object[] list = Array.toArray(elements);
        if (list.length == 0) {
            return this;
        }
        Object[] arr = new Object[this.delegate.length + list.length];
        System.arraycopy(this.delegate, 0, arr, 0, index2);
        System.arraycopy(list, 0, arr, index2, list.length);
        System.arraycopy(this.delegate, index2, arr, index2 + list.length, this.delegate.length - index2);
        return Array.wrap(arr);
    }

    @Override
    public int lastIndexOf(T element, int end) {
        for (int i = Math.min(end, this.length() - 1); i >= 0; --i) {
            if (!Objects.equals(this.get(i), element)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int length() {
        return this.delegate.length;
    }

    @Override
    public <U> Array<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        Object[] arr = new Object[this.length()];
        for (int i = 0; i < this.delegate.length; ++i) {
            arr[i] = mapper.apply(this.get(i));
        }
        return Array.wrap(arr);
    }

    @Override
    public Array<T> remove(T element) {
        int index2 = -1;
        for (int i = 0; i < this.length(); ++i) {
            T value2 = this.get(i);
            if (!Objects.equals(element, value2)) continue;
            index2 = i;
            break;
        }
        if (index2 < 0) {
            return this;
        }
        return this.removeAt(index2);
    }

    @Override
    public Array<T> removeAt(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("removeAt(" + index2 + ")");
        }
        if (index2 >= this.length()) {
            throw new IndexOutOfBoundsException("removeAt(" + index2 + ")");
        }
        Object[] arr = new Object[this.length() - 1];
        System.arraycopy(this.delegate, 0, arr, 0, index2);
        System.arraycopy(this.delegate, index2 + 1, arr, index2, this.length() - index2 - 1);
        return Array.wrap(arr);
    }

    @Override
    public Array<T> removeAll(Iterable<? extends T> elements) {
        return Collections.removeAll(this, elements);
    }

    @Override
    public Array<T> retainAll(Iterable<? extends T> elements) {
        return Collections.retainAll(this, elements);
    }

    @Override
    public Array<T> reverse() {
        if (this.size() <= 1) {
            return this;
        }
        int length = this.delegate.length;
        Object[] arr = new Object[length];
        int i = 0;
        int j = length - 1;
        while (i < length) {
            arr[j] = this.delegate[i];
            ++i;
            --j;
        }
        return Array.wrap(arr);
    }

    @Override
    public Array<T> sorted(Comparator<? super T> comparator) {
        Object[] arr = Arrays.copyOf(this.delegate, this.delegate.length);
        Arrays.sort(arr, (o1, o2) -> comparator.compare(o1, o2));
        return Array.wrap(arr);
    }

    @Override
    public Array<T> subSequence(int beginIndex, int endIndex) {
        Collections.subSequenceRangeCheck(beginIndex, endIndex, this.length());
        if (beginIndex == endIndex) {
            return Array.empty();
        }
        if (beginIndex == 0 && endIndex == this.length()) {
            return this;
        }
        Object[] arr = new Object[endIndex - beginIndex];
        System.arraycopy(this.delegate, beginIndex, arr, 0, arr.length);
        return Array.wrap(arr);
    }

    @Override
    public Array<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail() on empty Array");
        }
        Object[] arr = new Object[this.delegate.length - 1];
        System.arraycopy(this.delegate, 1, arr, 0, arr.length);
        return Array.wrap(arr);
    }

    @Override
    public Array<T> take(int n) {
        if (n >= this.length()) {
            return this;
        }
        if (n <= 0) {
            return Array.empty();
        }
        return Array.wrap(Arrays.copyOf(this.delegate, n));
    }

    @Override
    public Array<T> update(int index2, T element) {
        if (index2 < 0 || index2 >= this.length()) {
            throw new IndexOutOfBoundsException("update(" + index2 + ")");
        }
        Object[] arr = Arrays.copyOf(this.delegate, this.delegate.length);
        arr[index2] = element;
        return Array.wrap(arr);
    }

    public boolean equals(Object o) {
        return Collections.equals(this, o);
    }

    public int hashCode() {
        return Collections.hashOrdered(this);
    }

    @Override
    public String stringPrefix() {
        return "Array";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }

    private static <T> Object[] toArray(Iterable<T> elements) {
        if (elements instanceof Array) {
            Array array = (Array)elements;
            return array.delegate;
        }
        return Collections.withSize(elements).toArray();
    }
}

