/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.PartialFunction;
import io.vavr.Tuple2;
import io.vavr.collection.Iterator;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Map<K, V>
extends PartialFunction<K, V>,
Traversable<Tuple2<K, V>>,
Serializable {
    public static final long serialVersionUID = 1L;

    public static <K, V> Map<K, V> narrow(Map<? extends K, ? extends V> map2) {
        return map2;
    }

    @Override
    @Deprecated
    default public V apply(K key) {
        return this.get(key).getOrElseThrow(() -> new NoSuchElementException(String.valueOf(key)));
    }

    public <K2, V2> Map<K2, V2> bimap(Function<? super K, ? extends K2> var1, Function<? super V, ? extends V2> var2);

    @Override
    default public boolean contains(Tuple2<K, V> element) {
        return this.get(element._1).map((? super T v) -> Objects.equals(v, element._2)).getOrElse(false);
    }

    public Tuple2<V, ? extends Map<K, V>> computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

    public Tuple2<Option<V>, ? extends Map<K, V>> computeIfPresent(K var1, BiFunction<? super K, ? super V, ? extends V> var2);

    public boolean containsKey(K var1);

    public Map<K, V> filter(BiPredicate<? super K, ? super V> var1);

    public Map<K, V> reject(BiPredicate<? super K, ? super V> var1);

    public Map<K, V> filterKeys(Predicate<? super K> var1);

    public Map<K, V> rejectKeys(Predicate<? super K> var1);

    public Map<K, V> filterValues(Predicate<? super V> var1);

    public Map<K, V> rejectValues(Predicate<? super V> var1);

    public <K2, V2> Map<K2, V2> flatMap(BiFunction<? super K, ? super V, ? extends Iterable<Tuple2<K2, V2>>> var1);

    public Option<V> get(K var1);

    public V getOrElse(K var1, V var2);

    @Override
    default public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    default public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator();

    public Set<K> keySet();

    @Override
    default public int length() {
        return this.size();
    }

    default public <U> Seq<U> map(Function<? super Tuple2<K, V>, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.iterator().map(mapper).toStream();
    }

    public <K2, V2> Map<K2, V2> map(BiFunction<? super K, ? super V, Tuple2<K2, V2>> var1);

    public <K2> Map<K2, V> mapKeys(Function<? super K, ? extends K2> var1);

    public <K2> Map<K2, V> mapKeys(Function<? super K, ? extends K2> var1, BiFunction<? super V, ? super V, ? extends V> var2);

    public <V2> Map<K, V2> mapValues(Function<? super V, ? extends V2> var1);

    public Map<K, V> merge(Map<? extends K, ? extends V> var1);

    public <U extends V> Map<K, V> merge(Map<? extends K, U> var1, BiFunction<? super V, ? super U, ? extends V> var2);

    public Map<K, V> put(K var1, V var2);

    public Map<K, V> put(Tuple2<? extends K, ? extends V> var1);

    public <U extends V> Map<K, V> put(K var1, U var2, BiFunction<? super V, ? super U, ? extends V> var3);

    public <U extends V> Map<K, V> put(Tuple2<? extends K, U> var1, BiFunction<? super V, ? super U, ? extends V> var2);

    public Map<K, V> remove(K var1);

    @Deprecated
    public Map<K, V> removeAll(BiPredicate<? super K, ? super V> var1);

    public Map<K, V> removeAll(Iterable<? extends K> var1);

    @Deprecated
    public Map<K, V> removeKeys(Predicate<? super K> var1);

    @Deprecated
    public Map<K, V> removeValues(Predicate<? super V> var1);

    @Override
    public int size();

    public java.util.Map<K, V> toJavaMap();

    public Seq<V> values();

    public Map<K, V> distinct();

    public Map<K, V> distinctBy(Comparator<? super Tuple2<K, V>> var1);

    public <U> Map<K, V> distinctBy(Function<? super Tuple2<K, V>, ? extends U> var1);

    public Map<K, V> drop(int var1);

    public Map<K, V> dropRight(int var1);

    public Map<K, V> dropUntil(Predicate<? super Tuple2<K, V>> var1);

    public Map<K, V> dropWhile(Predicate<? super Tuple2<K, V>> var1);

    public Map<K, V> filter(Predicate<? super Tuple2<K, V>> var1);

    public Map<K, V> reject(Predicate<? super Tuple2<K, V>> var1);

    public <C> Map<C, ? extends Map<K, V>> groupBy(Function<? super Tuple2<K, V>, ? extends C> var1);

    public Iterator<? extends Map<K, V>> grouped(int var1);

    @Override
    default public boolean isDistinct() {
        return true;
    }

    public Map<K, V> init();

    public Option<? extends Map<K, V>> initOption();

    public Map<K, V> orElse(Iterable<? extends Tuple2<K, V>> var1);

    public Map<K, V> orElse(Supplier<? extends Iterable<? extends Tuple2<K, V>>> var1);

    public Tuple2<? extends Map<K, V>, ? extends Map<K, V>> partition(Predicate<? super Tuple2<K, V>> var1);

    public Map<K, V> peek(Consumer<? super Tuple2<K, V>> var1);

    public Map<K, V> replace(Tuple2<K, V> var1, Tuple2<K, V> var2);

    public Map<K, V> replaceValue(K var1, V var2);

    public Map<K, V> replace(K var1, V var2, V var3);

    public Map<K, V> replaceAll(BiFunction<? super K, ? super V, ? extends V> var1);

    public Map<K, V> replaceAll(Tuple2<K, V> var1, Tuple2<K, V> var2);

    public Map<K, V> retainAll(Iterable<? extends Tuple2<K, V>> var1);

    public Map<K, V> scan(Tuple2<K, V> var1, BiFunction<? super Tuple2<K, V>, ? super Tuple2<K, V>, ? extends Tuple2<K, V>> var2);

    public Iterator<? extends Map<K, V>> slideBy(Function<? super Tuple2<K, V>, ?> var1);

    public Iterator<? extends Map<K, V>> sliding(int var1);

    public Iterator<? extends Map<K, V>> sliding(int var1, int var2);

    public Tuple2<? extends Map<K, V>, ? extends Map<K, V>> span(Predicate<? super Tuple2<K, V>> var1);

    public Map<K, V> tail();

    public Option<? extends Map<K, V>> tailOption();

    public Map<K, V> take(int var1);

    public Map<K, V> takeRight(int var1);

    public Map<K, V> takeUntil(Predicate<? super Tuple2<K, V>> var1);

    public Map<K, V> takeWhile(Predicate<? super Tuple2<K, V>> var1);
}

