/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.builders.ListBuilder;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=5, xi=49, d1={"\u0000V\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\u001a#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00002\u0006\u0010\u0001\u001a\u00028\u0000H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a9\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00052\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001aA\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00052\u0006\u0010\r\u001a\u00020\f2\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\n\u0010\u000e\u001a\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\"\u0004\b\u0000\u0010\u0005H\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\"\u0004\b\u0000\u0010\u00052\u0006\u0010\r\u001a\u00020\fH\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0011\u001a)\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u0000*\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0086\b\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a%\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u0000*\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a-\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u0000*\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\u001c\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001d\u001a$\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0080\b\u00a2\u0006\u0004\b\"\u0010#\u001a6\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000 \"\u0004\b\u0000\u0010\u00002\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u001e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0080\b\u00a2\u0006\u0004\b\"\u0010%\u001a1\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000 \"\u0004\b\u0000\u0010\u00002\u0006\u0010&\u001a\u00020\f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0001\u00a2\u0006\u0004\b'\u0010(\u001a3\u0010+\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010!0 \"\u0004\b\u0000\u0010\u0000*\n\u0012\u0006\b\u0001\u0012\u00028\u00000 2\u0006\u0010*\u001a\u00020)H\u0001\u00a2\u0006\u0004\b+\u0010,\u001a\u0018\u0010.\u001a\u00020\f2\u0006\u0010-\u001a\u00020\fH\u0080\b\u00a2\u0006\u0004\b.\u0010/\u001a\u0018\u00101\u001a\u00020\f2\u0006\u00100\u001a\u00020\fH\u0080\b\u00a2\u0006\u0004\b1\u0010/\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"T", "element", "", "listOf", "(Ljava/lang/Object;)Ljava/util/List;", "E", "Lkotlin/Function1;", "", "", "builderAction", "buildListInternal", "(Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "", "capacity", "(ILkotlin/jvm/functions/Function1;)Ljava/util/List;", "createListBuilder", "()Ljava/util/List;", "(I)Ljava/util/List;", "builder", "build", "(Ljava/util/List;)Ljava/util/List;", "Ljava/util/Enumeration;", "toList", "(Ljava/util/Enumeration;)Ljava/util/List;", "", "shuffled", "(Ljava/lang/Iterable;)Ljava/util/List;", "Ljava/util/Random;", "random", "(Ljava/lang/Iterable;Ljava/util/Random;)Ljava/util/List;", "", "collection", "", "", "collectionToArray", "(Ljava/util/Collection;)[Ljava/lang/Object;", "array", "(Ljava/util/Collection;[Ljava/lang/Object;)[Ljava/lang/Object;", "collectionSize", "terminateCollectionToArray", "(I[Ljava/lang/Object;)[Ljava/lang/Object;", "", "isVarargs", "copyToArrayOfAny", "([Ljava/lang/Object;Z)[Ljava/lang/Object;", "index", "checkIndexOverflow", "(I)I", "count", "checkCountOverflow"}, xs="kotlin/collections/CollectionsKt")
class CollectionsKt__CollectionsJVMKt {
    @NotNull
    public static final <T> List<T> listOf(T element) {
        List<T> list = Collections.singletonList(element);
        Intrinsics.checkNotNullExpressionValue(list, "singletonList(...)");
        return list;
    }

    private static final <E> List<E> buildListInternal(Function1<? super List<E>, Unit> builderAction) {
        Intrinsics.checkNotNullParameter(builderAction, "builderAction");
        List<E> list = CollectionsKt.createListBuilder();
        builderAction.invoke(list);
        return CollectionsKt.build(list);
    }

    private static final <E> List<E> buildListInternal(int capacity, Function1<? super List<E>, Unit> builderAction) {
        Intrinsics.checkNotNullParameter(builderAction, "builderAction");
        List<E> list = CollectionsKt.createListBuilder(capacity);
        builderAction.invoke(list);
        return CollectionsKt.build(list);
    }

    @NotNull
    public static final <E> List<E> createListBuilder() {
        return new ListBuilder(0, 1, null);
    }

    @NotNull
    public static final <E> List<E> createListBuilder(int capacity) {
        return new ListBuilder(capacity);
    }

    @NotNull
    public static final <E> List<E> build(@NotNull List<E> builder2) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        return ((ListBuilder)builder2).build();
    }

    private static final <T> List<T> toList(Enumeration<T> $this$toList) {
        Intrinsics.checkNotNullParameter($this$toList, "<this>");
        ArrayList<T> arrayList = Collections.list($this$toList);
        Intrinsics.checkNotNullExpressionValue(arrayList, "list(...)");
        return arrayList;
    }

    @NotNull
    public static final <T> List<T> shuffled(@NotNull Iterable<? extends T> $this$shuffled) {
        List<T> list;
        Intrinsics.checkNotNullParameter($this$shuffled, "<this>");
        List<T> $this$shuffled_u24lambda_u240 = list = CollectionsKt.toMutableList($this$shuffled);
        boolean bl = false;
        Collections.shuffle($this$shuffled_u24lambda_u240);
        return list;
    }

    @NotNull
    public static final <T> List<T> shuffled(@NotNull Iterable<? extends T> $this$shuffled, @NotNull Random random) {
        List<T> list;
        Intrinsics.checkNotNullParameter($this$shuffled, "<this>");
        Intrinsics.checkNotNullParameter(random, "random");
        List<T> $this$shuffled_u24lambda_u241 = list = CollectionsKt.toMutableList($this$shuffled);
        boolean bl = false;
        Collections.shuffle($this$shuffled_u24lambda_u241, random);
        return list;
    }

    private static final Object[] collectionToArray(Collection<?> collection) {
        Intrinsics.checkNotNullParameter(collection, "collection");
        return CollectionToArray.toArray(collection);
    }

    private static final <T> T[] collectionToArray(Collection<?> collection, T[] array) {
        Intrinsics.checkNotNullParameter(collection, "collection");
        Intrinsics.checkNotNullParameter(array, "array");
        return CollectionToArray.toArray(collection, array);
    }

    @NotNull
    public static final <T> T[] terminateCollectionToArray(int collectionSize, @NotNull T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        if (collectionSize < array.length) {
            array[collectionSize] = null;
        }
        return array;
    }

    @NotNull
    public static final <T> Object[] copyToArrayOfAny(@NotNull T[] $this$copyToArrayOfAny, boolean isVarargs) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter($this$copyToArrayOfAny, "<this>");
        if (isVarargs && Intrinsics.areEqual($this$copyToArrayOfAny.getClass(), Object[].class)) {
            objectArray = $this$copyToArrayOfAny;
        } else {
            T[] TArray = Arrays.copyOf($this$copyToArrayOfAny, $this$copyToArrayOfAny.length, Object[].class);
            objectArray = TArray;
            Intrinsics.checkNotNullExpressionValue(TArray, "copyOf(...)");
        }
        return objectArray;
    }

    private static final int checkIndexOverflow(int index2) {
        if (index2 < 0) {
            CollectionsKt.throwIndexOverflow();
        }
        return index2;
    }

    private static final int checkCountOverflow(int count2) {
        if (count2 < 0) {
            CollectionsKt.throwCountOverflow();
        }
        return count2;
    }
}

