/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.collections.builders.SetBuilder;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=5, xi=49, d1={"\u0000>\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00002\u0006\u0010\u0001\u001a\u00028\u0000H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a9\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00052\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001aA\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00052\u0006\u0010\r\u001a\u00020\f2\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\n\u0010\u000e\u001a\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\"\u0004\b\u0000\u0010\u0005H\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\"\u0004\b\u0000\u0010\u00052\u0006\u0010\r\u001a\u00020\fH\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0011\u001a)\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\"\u0004\b\u0000\u0010\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a/\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017\"\u0004\b\u0000\u0010\u00002\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0015\"\u00028\u0000H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001aK\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017\"\u0004\b\u0000\u0010\u00002\u001a\u0010\u001c\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u00000\u001aj\n\u0012\u0006\b\u0000\u0012\u00028\u0000`\u001b2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0015\"\u00028\u0000H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u001d\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"T", "element", "", "setOf", "(Ljava/lang/Object;)Ljava/util/Set;", "E", "Lkotlin/Function1;", "", "", "builderAction", "buildSetInternal", "(Lkotlin/jvm/functions/Function1;)Ljava/util/Set;", "", "capacity", "(ILkotlin/jvm/functions/Function1;)Ljava/util/Set;", "createSetBuilder", "()Ljava/util/Set;", "(I)Ljava/util/Set;", "builder", "build", "(Ljava/util/Set;)Ljava/util/Set;", "", "elements", "Ljava/util/TreeSet;", "sortedSetOf", "([Ljava/lang/Object;)Ljava/util/TreeSet;", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "comparator", "(Ljava/util/Comparator;[Ljava/lang/Object;)Ljava/util/TreeSet;"}, xs="kotlin/collections/SetsKt")
class SetsKt__SetsJVMKt {
    @NotNull
    public static final <T> Set<T> setOf(T element) {
        Set<T> set = Collections.singleton(element);
        Intrinsics.checkNotNullExpressionValue(set, "singleton(...)");
        return set;
    }

    private static final <E> Set<E> buildSetInternal(Function1<? super Set<E>, Unit> builderAction) {
        Intrinsics.checkNotNullParameter(builderAction, "builderAction");
        Set<E> set = SetsKt.createSetBuilder();
        builderAction.invoke(set);
        return SetsKt.build(set);
    }

    private static final <E> Set<E> buildSetInternal(int capacity, Function1<? super Set<E>, Unit> builderAction) {
        Intrinsics.checkNotNullParameter(builderAction, "builderAction");
        Set<E> set = SetsKt.createSetBuilder(capacity);
        builderAction.invoke(set);
        return SetsKt.build(set);
    }

    @NotNull
    public static final <E> Set<E> createSetBuilder() {
        return new SetBuilder();
    }

    @NotNull
    public static final <E> Set<E> createSetBuilder(int capacity) {
        return new SetBuilder(capacity);
    }

    @NotNull
    public static final <E> Set<E> build(@NotNull Set<E> builder2) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        return ((SetBuilder)builder2).build();
    }

    @NotNull
    public static final <T> TreeSet<T> sortedSetOf(T ... elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return (TreeSet)ArraysKt.toCollection(elements, (Collection)new TreeSet());
    }

    @NotNull
    public static final <T> TreeSet<T> sortedSetOf(@NotNull Comparator<? super T> comparator, T ... elements) {
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        Intrinsics.checkNotNullParameter(elements, "elements");
        return (TreeSet)ArraysKt.toCollection(elements, (Collection)new TreeSet<T>(comparator));
    }
}

