/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections.builders;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\"\u0004\b\u0000\u0010\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a?\u0010\f\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u0006*\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00032\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0002\u00a2\u0006\u0004\b\f\u0010\r\u001a/\u0010\u000e\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a;\u0010\u0013\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a-\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0015\u001a\u00020\u0001H\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a'\u0010\u001a\u001a\u00020\u0019\"\u0004\b\u0000\u0010\u0000*\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0018\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a/\u0010\u001e\u001a\u00020\u0019\"\u0004\b\u0000\u0010\u0000*\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001f"}, d2={"E", "", "size", "", "arrayOfUninitializedElements", "(I)[Ljava/lang/Object;", "T", "offset", "length", "", "thisCollection", "", "subarrayContentToString", "([Ljava/lang/Object;IILjava/util/Collection;)Ljava/lang/String;", "subarrayContentHashCode", "([Ljava/lang/Object;II)I", "", "other", "", "subarrayContentEquals", "([Ljava/lang/Object;IILjava/util/List;)Z", "newSize", "copyOfUninitializedElements", "([Ljava/lang/Object;I)[Ljava/lang/Object;", "index", "", "resetAt", "([Ljava/lang/Object;I)V", "fromIndex", "toIndex", "resetRange", "([Ljava/lang/Object;II)V"})
public final class ListBuilderKt {
    @NotNull
    public static final <E> E[] arrayOfUninitializedElements(int size) {
        if (!(size >= 0)) {
            boolean bl = false;
            String string2 = "capacity must be non-negative.";
            throw new IllegalArgumentException(string2.toString());
        }
        return new Object[size];
    }

    private static final <T> String subarrayContentToString(T[] $this$subarrayContentToString, int offset, int length, Collection<? extends T> thisCollection) {
        StringBuilder sb = new StringBuilder(2 + length * 3);
        sb.append("[");
        for (int i = 0; i < length; ++i) {
            T nextElement;
            if (i > 0) {
                sb.append(", ");
            }
            StringBuilder stringBuilder = (nextElement = $this$subarrayContentToString[offset + i]) == thisCollection ? sb.append("(this Collection)") : sb.append(nextElement);
        }
        sb.append("]");
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    private static final <T> int subarrayContentHashCode(T[] $this$subarrayContentHashCode, int offset, int length) {
        int result2 = 1;
        for (int i = 0; i < length; ++i) {
            T nextElement;
            T t = nextElement = $this$subarrayContentHashCode[offset + i];
            result2 = result2 * 31 + (t != null ? t.hashCode() : 0);
        }
        return result2;
    }

    private static final <T> boolean subarrayContentEquals(T[] $this$subarrayContentEquals, int offset, int length, List<?> other) {
        if (length != other.size()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Intrinsics.areEqual($this$subarrayContentEquals[offset + i], other.get(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static final <T> T[] copyOfUninitializedElements(@NotNull T[] $this$copyOfUninitializedElements, int newSize) {
        Intrinsics.checkNotNullParameter($this$copyOfUninitializedElements, "<this>");
        T[] TArray = Arrays.copyOf($this$copyOfUninitializedElements, newSize);
        Intrinsics.checkNotNullExpressionValue(TArray, "copyOf(...)");
        return TArray;
    }

    public static final <E> void resetAt(@NotNull E[] $this$resetAt, int index2) {
        Intrinsics.checkNotNullParameter($this$resetAt, "<this>");
        $this$resetAt[index2] = null;
    }

    public static final <E> void resetRange(@NotNull E[] $this$resetRange, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter($this$resetRange, "<this>");
        for (int index2 = fromIndex; index2 < toIndex; ++index2) {
            ListBuilderKt.resetAt($this$resetRange, index2);
        }
    }

    public static final /* synthetic */ int access$subarrayContentHashCode(Object[] $receiver, int offset, int length) {
        return ListBuilderKt.subarrayContentHashCode($receiver, offset, length);
    }

    public static final /* synthetic */ String access$subarrayContentToString(Object[] $receiver, int offset, int length, Collection thisCollection) {
        return ListBuilderKt.subarrayContentToString($receiver, offset, length, thisCollection);
    }

    public static final /* synthetic */ boolean access$subarrayContentEquals(Object[] $receiver, int offset, int length, List other) {
        return ListBuilderKt.subarrayContentEquals($receiver, offset, length, other);
    }
}

