/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.calls;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.jvm.internal.calls.BoundCaller;
import kotlin.reflect.jvm.internal.calls.Caller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b0\u0018\u0000  *\n\b\u0000\u0010\u0002 \u0001*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003:\b!\"# $%&'B5\b\u0004\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011R \u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00078\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0004\u001a\u00028\u00008\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00188\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0006\u001a\u00020\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u0082\u0001\u0007()*+,-."}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl;", "Ljava/lang/reflect/Member;", "M", "Lkotlin/reflect/jvm/internal/calls/Caller;", "member", "Ljava/lang/reflect/Type;", "returnType", "Ljava/lang/Class;", "instanceClass", "", "valueParameterTypes", "<init>", "(Ljava/lang/reflect/Member;Ljava/lang/reflect/Type;Ljava/lang/Class;[Ljava/lang/reflect/Type;)V", "", "obj", "", "checkObjectInstance", "(Ljava/lang/Object;)V", "Ljava/lang/Class;", "getInstanceClass", "()Ljava/lang/Class;", "Ljava/lang/reflect/Member;", "getMember", "()Ljava/lang/reflect/Member;", "", "parameterTypes", "Ljava/util/List;", "getParameterTypes", "()Ljava/util/List;", "Ljava/lang/reflect/Type;", "getReturnType", "()Ljava/lang/reflect/Type;", "Companion", "AccessorForHiddenBoundConstructor", "AccessorForHiddenConstructor", "BoundConstructor", "Constructor", "FieldGetter", "FieldSetter", "Method", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$Constructor;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$BoundConstructor;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$AccessorForHiddenConstructor;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$AccessorForHiddenBoundConstructor;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter;"})
public abstract class CallerImpl<M extends Member>
implements Caller<M> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final M member;
    @NotNull
    private final Type returnType;
    @Nullable
    private final Class<?> instanceClass;
    @NotNull
    private final List<Type> parameterTypes;

    /*
     * WARNING - void declaration
     */
    private CallerImpl(M member, Type returnType, Class<?> instanceClass, Type[] valueParameterTypes) {
        List<Object> list;
        this.member = member;
        this.returnType = returnType;
        this.instanceClass = instanceClass;
        CallerImpl callerImpl = this;
        Class<?> clazz = this.instanceClass;
        if (clazz == null) {
            list = ArraysKt.toList(valueParameterTypes);
        } else {
            void it;
            Class<?> clazz2;
            Class<?> clazz3 = clazz2 = clazz;
            CallerImpl callerImpl2 = callerImpl;
            boolean bl = false;
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add(it);
            spreadBuilder.addSpread(valueParameterTypes);
            List<Object> list2 = CollectionsKt.listOf(spreadBuilder.toArray(new Type[spreadBuilder.size()]));
            callerImpl = callerImpl2;
            list = list2;
        }
        callerImpl.parameterTypes = list;
    }

    @Override
    @NotNull
    public final M getMember() {
        return this.member;
    }

    @Override
    @NotNull
    public final Type getReturnType() {
        return this.returnType;
    }

    @Nullable
    public final Class<?> getInstanceClass() {
        return this.instanceClass;
    }

    @Override
    @NotNull
    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    protected final void checkObjectInstance(@Nullable Object obj) {
        if (obj == null || !this.member.getDeclaringClass().isInstance(obj)) {
            throw new IllegalArgumentException("An object member requires the object instance passed as the first argument.");
        }
    }

    public void checkArguments(@NotNull Object[] args) {
        Caller.DefaultImpls.checkArguments(this, args);
    }

    public /* synthetic */ CallerImpl(Member member, Type returnType, Class instanceClass, Type[] valueParameterTypes, DefaultConstructorMarker $constructor_marker) {
        this(member, returnType, instanceClass, valueParameterTypes);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0013\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\t\u001a\u0004\u0018\u00010\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$Constructor;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl;", "Ljava/lang/reflect/Constructor;", "constructor", "<init>", "(Ljava/lang/reflect/Constructor;)V", "", "args", "", "call", "([Ljava/lang/Object;)Ljava/lang/Object;"})
    public static final class Constructor
    extends CallerImpl<java.lang.reflect.Constructor<?>> {
        /*
         * WARNING - void declaration
         */
        public Constructor(@NotNull java.lang.reflect.Constructor<?> constructor) {
            void klass;
            Intrinsics.checkNotNullParameter(constructor, "constructor");
            Member member = constructor;
            Type[] typeArray = constructor.getDeclaringClass();
            Intrinsics.checkNotNullExpressionValue(typeArray, "constructor.declaringClass");
            Type type2 = (Type)typeArray;
            Type[] typeArray2 = typeArray = constructor.getDeclaringClass();
            Type type3 = type2;
            Member member2 = member;
            Constructor constructor2 = this;
            boolean bl = false;
            Class<?> outerClass = klass.getDeclaringClass();
            Class<?> clazz = outerClass != null && !Modifier.isStatic(klass.getModifiers()) ? outerClass : null;
            typeArray = constructor.getGenericParameterTypes();
            Intrinsics.checkNotNullExpressionValue(typeArray, "constructor.genericParameterTypes");
            super(member2, type3, clazz, typeArray, null);
        }

        @Override
        @Nullable
        public Object call(@NotNull Object[] args) {
            Intrinsics.checkNotNullParameter(args, "args");
            this.checkArguments(args);
            return ((java.lang.reflect.Constructor)this.getMember()).newInstance(Arrays.copyOf(args, args.length));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002B\u001d\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\r"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$BoundConstructor;", "Lkotlin/reflect/jvm/internal/calls/BoundCaller;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl;", "Ljava/lang/reflect/Constructor;", "constructor", "", "boundReceiver", "<init>", "(Ljava/lang/reflect/Constructor;Ljava/lang/Object;)V", "", "args", "call", "([Ljava/lang/Object;)Ljava/lang/Object;", "Ljava/lang/Object;"})
    public static final class BoundConstructor
    extends CallerImpl<java.lang.reflect.Constructor<?>>
    implements BoundCaller {
        @Nullable
        private final Object boundReceiver;

        public BoundConstructor(@NotNull java.lang.reflect.Constructor<?> constructor, @Nullable Object boundReceiver) {
            Intrinsics.checkNotNullParameter(constructor, "constructor");
            Member member = constructor;
            Type[] typeArray = constructor.getDeclaringClass();
            Intrinsics.checkNotNullExpressionValue(typeArray, "constructor.declaringClass");
            Type type2 = (Type)typeArray;
            typeArray = constructor.getGenericParameterTypes();
            Intrinsics.checkNotNullExpressionValue(typeArray, "constructor.genericParameterTypes");
            super(member, type2, null, typeArray, null);
            this.boundReceiver = boundReceiver;
        }

        @Override
        @Nullable
        public Object call(@NotNull Object[] args) {
            Intrinsics.checkNotNullParameter(args, "args");
            this.checkArguments(args);
            java.lang.reflect.Constructor constructor = (java.lang.reflect.Constructor)this.getMember();
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add(this.boundReceiver);
            spreadBuilder.addSpread(args);
            return constructor.newInstance(spreadBuilder.toArray(new Object[spreadBuilder.size()]));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0013\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\t\u001a\u0004\u0018\u00010\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$AccessorForHiddenConstructor;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl;", "Ljava/lang/reflect/Constructor;", "constructor", "<init>", "(Ljava/lang/reflect/Constructor;)V", "", "args", "", "call", "([Ljava/lang/Object;)Ljava/lang/Object;"})
    public static final class AccessorForHiddenConstructor
    extends CallerImpl<java.lang.reflect.Constructor<?>> {
        public AccessorForHiddenConstructor(@NotNull java.lang.reflect.Constructor<?> constructor) {
            Object[] objectArray;
            Intrinsics.checkNotNullParameter(constructor, "constructor");
            Member member = constructor;
            Object object = constructor.getDeclaringClass();
            Intrinsics.checkNotNullExpressionValue(object, "constructor.declaringClass");
            Type type2 = (Type)object;
            object = Companion;
            Type[] typeArray = constructor.getGenericParameterTypes();
            Intrinsics.checkNotNullExpressionValue(typeArray, "constructor.genericParameterTypes");
            Object[] $this$dropLast$iv = typeArray;
            boolean $i$f$dropLast = false;
            if ($this$dropLast$iv.length <= 1) {
                boolean $i$f$emptyArray = false;
                objectArray = new Type[]{};
            } else {
                Object[] objectArray2 = $this$dropLast$iv;
                int n = 0;
                int n2 = $this$dropLast$iv.length - 1;
                objectArray = ArraysKt.copyOfRange(objectArray2, n, n2);
            }
            super(member, type2, null, (Type[])objectArray, null);
        }

        @Override
        @Nullable
        public Object call(@NotNull Object[] args) {
            Intrinsics.checkNotNullParameter(args, "args");
            this.checkArguments(args);
            java.lang.reflect.Constructor constructor = (java.lang.reflect.Constructor)this.getMember();
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.addSpread(args);
            spreadBuilder.add(null);
            return constructor.newInstance(spreadBuilder.toArray(new Object[spreadBuilder.size()]));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u00020\u0003B\u001d\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\r"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$AccessorForHiddenBoundConstructor;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl;", "Ljava/lang/reflect/Constructor;", "Lkotlin/reflect/jvm/internal/calls/BoundCaller;", "constructor", "", "boundReceiver", "<init>", "(Ljava/lang/reflect/Constructor;Ljava/lang/Object;)V", "", "args", "call", "([Ljava/lang/Object;)Ljava/lang/Object;", "Ljava/lang/Object;"})
    public static final class AccessorForHiddenBoundConstructor
    extends CallerImpl<java.lang.reflect.Constructor<?>>
    implements BoundCaller {
        @Nullable
        private final Object boundReceiver;

        public AccessorForHiddenBoundConstructor(@NotNull java.lang.reflect.Constructor<?> constructor, @Nullable Object boundReceiver) {
            Object[] objectArray;
            Intrinsics.checkNotNullParameter(constructor, "constructor");
            Member member = constructor;
            Object object = constructor.getDeclaringClass();
            Intrinsics.checkNotNullExpressionValue(object, "constructor.declaringClass");
            Type type2 = (Type)object;
            object = Companion;
            Type[] typeArray = constructor.getGenericParameterTypes();
            Intrinsics.checkNotNullExpressionValue(typeArray, "constructor.genericParameterTypes");
            Object[] $this$dropFirstAndLast$iv = typeArray;
            boolean $i$f$dropFirstAndLast = false;
            if ($this$dropFirstAndLast$iv.length <= 2) {
                boolean $i$f$emptyArray = false;
                objectArray = new Type[]{};
            } else {
                Object[] objectArray2 = $this$dropFirstAndLast$iv;
                int n = 1;
                int n2 = $this$dropFirstAndLast$iv.length - 1;
                objectArray = ArraysKt.copyOfRange(objectArray2, n, n2);
            }
            super(member, type2, null, (Type[])objectArray, null);
            this.boundReceiver = boundReceiver;
        }

        @Override
        @Nullable
        public Object call(@NotNull Object[] args) {
            Intrinsics.checkNotNullParameter(args, "args");
            this.checkArguments(args);
            java.lang.reflect.Constructor constructor = (java.lang.reflect.Constructor)this.getMember();
            SpreadBuilder spreadBuilder = new SpreadBuilder(3);
            spreadBuilder.add(this.boundReceiver);
            spreadBuilder.addSpread(args);
            spreadBuilder.add(null);
            return constructor.newInstance(spreadBuilder.toArray(new Object[spreadBuilder.size()]));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\u0012\u0013\u0014\u0015\u0016\u0017B+\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0005\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u0082\u0001\u0006\u0018\u0019\u001a\u001b\u001c\u001d"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl;", "Ljava/lang/reflect/Method;", "method", "", "requiresInstance", "", "Ljava/lang/reflect/Type;", "parameterTypes", "<init>", "(Ljava/lang/reflect/Method;Z[Ljava/lang/reflect/Type;)V", "", "instance", "args", "callMethod", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", "isVoidMethod", "Z", "BoundInstance", "BoundJvmStaticInObject", "BoundStatic", "Instance", "JvmStaticInObject", "Static", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method$Static;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method$Instance;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method$JvmStaticInObject;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method$BoundStatic;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method$BoundInstance;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method$BoundJvmStaticInObject;"})
    public static abstract class Method
    extends CallerImpl<java.lang.reflect.Method> {
        private final boolean isVoidMethod;

        private Method(java.lang.reflect.Method method, boolean requiresInstance, Type[] parameterTypes) {
            Member member = method;
            Type type2 = method.getGenericReturnType();
            Intrinsics.checkNotNullExpressionValue(type2, "method.genericReturnType");
            super(member, type2, requiresInstance ? method.getDeclaringClass() : null, parameterTypes, null);
            this.isVoidMethod = Intrinsics.areEqual(this.getReturnType(), Void.TYPE);
        }

        public /* synthetic */ Method(java.lang.reflect.Method method, boolean bl, Type[] typeArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                boolean bl2 = bl = !Modifier.isStatic(method.getModifiers());
            }
            if ((n & 4) != 0) {
                Type[] typeArray2 = method.getGenericParameterTypes();
                Intrinsics.checkNotNullExpressionValue(typeArray2, "class Method(\n        me\u2026        }\n        }\n    }");
                typeArray = typeArray2;
            }
            this(method, bl, typeArray, null);
        }

        @Nullable
        protected final Object callMethod(@Nullable Object instance, @NotNull Object[] args) {
            Intrinsics.checkNotNullParameter(args, "args");
            Object result2 = ((java.lang.reflect.Method)this.getMember()).invoke(instance, Arrays.copyOf(args, args.length));
            return this.isVoidMethod ? Unit.INSTANCE : result2;
        }

        public /* synthetic */ Method(java.lang.reflect.Method method, boolean requiresInstance, Type[] parameterTypes, DefaultConstructorMarker $constructor_marker) {
            this(method, requiresInstance, parameterTypes);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\t\u001a\u0004\u0018\u00010\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method$Static;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method;", "Ljava/lang/reflect/Method;", "method", "<init>", "(Ljava/lang/reflect/Method;)V", "", "args", "", "call", "([Ljava/lang/Object;)Ljava/lang/Object;"})
        public static final class Static
        extends Method {
            public Static(@NotNull java.lang.reflect.Method method) {
                Intrinsics.checkNotNullParameter(method, "method");
                super(method, false, null, 6, null);
            }

            @Override
            @Nullable
            public Object call(@NotNull Object[] args) {
                Intrinsics.checkNotNullParameter(args, "args");
                this.checkArguments(args);
                return this.callMethod(null, args);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\t\u001a\u0004\u0018\u00010\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method$Instance;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method;", "Ljava/lang/reflect/Method;", "method", "<init>", "(Ljava/lang/reflect/Method;)V", "", "args", "", "call", "([Ljava/lang/Object;)Ljava/lang/Object;"})
        public static final class Instance
        extends Method {
            public Instance(@NotNull java.lang.reflect.Method method) {
                Intrinsics.checkNotNullParameter(method, "method");
                super(method, false, null, 6, null);
            }

            @Override
            @Nullable
            public Object call(@NotNull Object[] args) {
                Object[] objectArray;
                Intrinsics.checkNotNullParameter(args, "args");
                this.checkArguments(args);
                Object object = args[0];
                Companion companion = Companion;
                Object[] $this$dropFirst$iv = args;
                boolean $i$f$dropFirst = false;
                if ($this$dropFirst$iv.length <= 1) {
                    boolean $i$f$emptyArray = false;
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = $this$dropFirst$iv;
                    int n = 1;
                    int n2 = $this$dropFirst$iv.length;
                    objectArray = ArraysKt.copyOfRange(objectArray2, n, n2);
                }
                return this.callMethod(object, objectArray);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\t\u001a\u0004\u0018\u00010\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method$JvmStaticInObject;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method;", "Ljava/lang/reflect/Method;", "method", "<init>", "(Ljava/lang/reflect/Method;)V", "", "args", "", "call", "([Ljava/lang/Object;)Ljava/lang/Object;"})
        public static final class JvmStaticInObject
        extends Method {
            public JvmStaticInObject(@NotNull java.lang.reflect.Method method) {
                Intrinsics.checkNotNullParameter(method, "method");
                super(method, true, null, 4, null);
            }

            @Override
            @Nullable
            public Object call(@NotNull Object[] args) {
                Object[] objectArray;
                Intrinsics.checkNotNullParameter(args, "args");
                this.checkArguments(args);
                this.checkObjectInstance(ArraysKt.firstOrNull(args));
                Companion companion = Companion;
                Object[] $this$dropFirst$iv = args;
                boolean $i$f$dropFirst = false;
                if ($this$dropFirst$iv.length <= 1) {
                    boolean $i$f$emptyArray = false;
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = $this$dropFirst$iv;
                    int n = 1;
                    int n2 = $this$dropFirst$iv.length;
                    objectArray = ArraysKt.copyOfRange(objectArray2, n, n2);
                }
                return this.callMethod(null, objectArray);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\r"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method$BoundStatic;", "Lkotlin/reflect/jvm/internal/calls/BoundCaller;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method;", "Ljava/lang/reflect/Method;", "method", "", "boundReceiver", "<init>", "(Ljava/lang/reflect/Method;Ljava/lang/Object;)V", "", "args", "call", "([Ljava/lang/Object;)Ljava/lang/Object;", "Ljava/lang/Object;"})
        public static final class BoundStatic
        extends Method
        implements BoundCaller {
            @Nullable
            private final Object boundReceiver;

            public BoundStatic(@NotNull java.lang.reflect.Method method, @Nullable Object boundReceiver) {
                Object[] objectArray;
                Intrinsics.checkNotNullParameter(method, "method");
                Companion companion = Companion;
                Type[] typeArray = method.getGenericParameterTypes();
                Intrinsics.checkNotNullExpressionValue(typeArray, "method.genericParameterTypes");
                Object[] $this$dropFirst$iv = typeArray;
                boolean $i$f$dropFirst = false;
                if ($this$dropFirst$iv.length <= 1) {
                    boolean $i$f$emptyArray = false;
                    objectArray = new Type[]{};
                } else {
                    Object[] objectArray2 = $this$dropFirst$iv;
                    int n = 1;
                    int n2 = $this$dropFirst$iv.length;
                    objectArray = ArraysKt.copyOfRange(objectArray2, n, n2);
                }
                super(method, false, (Type[])objectArray, null);
                this.boundReceiver = boundReceiver;
            }

            @Override
            @Nullable
            public Object call(@NotNull Object[] args) {
                Intrinsics.checkNotNullParameter(args, "args");
                this.checkArguments(args);
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                spreadBuilder.add(this.boundReceiver);
                spreadBuilder.addSpread(args);
                return this.callMethod(null, spreadBuilder.toArray(new Object[spreadBuilder.size()]));
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\r"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method$BoundInstance;", "Lkotlin/reflect/jvm/internal/calls/BoundCaller;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method;", "Ljava/lang/reflect/Method;", "method", "", "boundReceiver", "<init>", "(Ljava/lang/reflect/Method;Ljava/lang/Object;)V", "", "args", "call", "([Ljava/lang/Object;)Ljava/lang/Object;", "Ljava/lang/Object;"})
        public static final class BoundInstance
        extends Method
        implements BoundCaller {
            @Nullable
            private final Object boundReceiver;

            public BoundInstance(@NotNull java.lang.reflect.Method method, @Nullable Object boundReceiver) {
                Intrinsics.checkNotNullParameter(method, "method");
                super(method, false, null, 4, null);
                this.boundReceiver = boundReceiver;
            }

            @Override
            @Nullable
            public Object call(@NotNull Object[] args) {
                Intrinsics.checkNotNullParameter(args, "args");
                this.checkArguments(args);
                return this.callMethod(this.boundReceiver, args);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\n\u001a\u0004\u0018\u00010\t2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0017\u00a2\u0006\u0004\b\n\u0010\u000b"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method$BoundJvmStaticInObject;", "Lkotlin/reflect/jvm/internal/calls/BoundCaller;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$Method;", "Ljava/lang/reflect/Method;", "method", "<init>", "(Ljava/lang/reflect/Method;)V", "", "args", "", "call", "([Ljava/lang/Object;)Ljava/lang/Object;"})
        public static final class BoundJvmStaticInObject
        extends Method
        implements BoundCaller {
            public BoundJvmStaticInObject(@NotNull java.lang.reflect.Method method) {
                Intrinsics.checkNotNullParameter(method, "method");
                super(method, false, null, 4, null);
            }

            @Override
            @Nullable
            public Object call(@NotNull Object[] args) {
                Intrinsics.checkNotNullParameter(args, "args");
                this.checkArguments(args);
                return this.callMethod(null, args);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\r\u000e\u000f\u0010\u0011B\u0019\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\bH\u0017\u00a2\u0006\u0004\b\u000b\u0010\f\u0082\u0001\u0005\u0012\u0013\u0014\u0015\u0016"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl;", "Ljava/lang/reflect/Field;", "field", "", "requiresInstance", "<init>", "(Ljava/lang/reflect/Field;Z)V", "", "args", "", "call", "([Ljava/lang/Object;)Ljava/lang/Object;", "BoundInstance", "BoundJvmStaticInObject", "Instance", "JvmStaticInObject", "Static", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter$Static;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter$Instance;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter$JvmStaticInObject;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter$BoundInstance;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter$BoundJvmStaticInObject;"})
    public static abstract class FieldGetter
    extends CallerImpl<Field> {
        private FieldGetter(Field field, boolean requiresInstance) {
            Member member = field;
            Type type2 = field.getGenericType();
            Intrinsics.checkNotNullExpressionValue(type2, "field.genericType");
            boolean $i$f$emptyArray = false;
            super(member, type2, requiresInstance ? field.getDeclaringClass() : null, new Type[0], null);
        }

        @Override
        @Nullable
        public Object call(@NotNull Object[] args) {
            Intrinsics.checkNotNullParameter(args, "args");
            this.checkArguments(args);
            return ((Field)this.getMember()).get(this.getInstanceClass() != null ? ArraysKt.first(args) : null);
        }

        public /* synthetic */ FieldGetter(Field field, boolean requiresInstance, DefaultConstructorMarker $constructor_marker) {
            this(field, requiresInstance);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter$Static;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter;", "Ljava/lang/reflect/Field;", "field", "<init>", "(Ljava/lang/reflect/Field;)V"})
        public static final class Static
        extends FieldGetter {
            public Static(@NotNull Field field) {
                Intrinsics.checkNotNullParameter(field, "field");
                super(field, false, null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter$Instance;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter;", "Ljava/lang/reflect/Field;", "field", "<init>", "(Ljava/lang/reflect/Field;)V"})
        public static final class Instance
        extends FieldGetter {
            public Instance(@NotNull Field field) {
                Intrinsics.checkNotNullParameter(field, "field");
                super(field, true, null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\t\u001a\u00020\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter$JvmStaticInObject;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter;", "Ljava/lang/reflect/Field;", "field", "<init>", "(Ljava/lang/reflect/Field;)V", "", "args", "", "checkArguments", "([Ljava/lang/Object;)V"})
        public static final class JvmStaticInObject
        extends FieldGetter {
            public JvmStaticInObject(@NotNull Field field) {
                Intrinsics.checkNotNullParameter(field, "field");
                super(field, true, null);
            }

            @Override
            public void checkArguments(@NotNull Object[] args) {
                Intrinsics.checkNotNullParameter(args, "args");
                super.checkArguments(args);
                this.checkObjectInstance(ArraysKt.firstOrNull(args));
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\r"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter$BoundInstance;", "Lkotlin/reflect/jvm/internal/calls/BoundCaller;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter;", "Ljava/lang/reflect/Field;", "field", "", "boundReceiver", "<init>", "(Ljava/lang/reflect/Field;Ljava/lang/Object;)V", "", "args", "call", "([Ljava/lang/Object;)Ljava/lang/Object;", "Ljava/lang/Object;"})
        public static final class BoundInstance
        extends FieldGetter
        implements BoundCaller {
            @Nullable
            private final Object boundReceiver;

            public BoundInstance(@NotNull Field field, @Nullable Object boundReceiver) {
                Intrinsics.checkNotNullParameter(field, "field");
                super(field, false, null);
                this.boundReceiver = boundReceiver;
            }

            @Override
            @Nullable
            public Object call(@NotNull Object[] args) {
                Intrinsics.checkNotNullParameter(args, "args");
                this.checkArguments(args);
                return ((Field)this.getMember()).get(this.boundReceiver);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter$BoundJvmStaticInObject;", "Lkotlin/reflect/jvm/internal/calls/BoundCaller;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldGetter;", "Ljava/lang/reflect/Field;", "field", "<init>", "(Ljava/lang/reflect/Field;)V"})
        public static final class BoundJvmStaticInObject
        extends FieldGetter
        implements BoundCaller {
            public BoundJvmStaticInObject(@NotNull Field field) {
                Intrinsics.checkNotNullParameter(field, "field");
                super(field, false, null);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u0012\u0013\u0014\u0015\u0016B!\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\f\u001a\u0004\u0018\u00010\u000b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tH\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u000f\u001a\u00020\u000e2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0011\u0082\u0001\u0005\u0017\u0018\u0019\u001a\u001b"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl;", "Ljava/lang/reflect/Field;", "field", "", "notNull", "requiresInstance", "<init>", "(Ljava/lang/reflect/Field;ZZ)V", "", "args", "", "call", "([Ljava/lang/Object;)Ljava/lang/Object;", "", "checkArguments", "([Ljava/lang/Object;)V", "Z", "BoundInstance", "BoundJvmStaticInObject", "Instance", "JvmStaticInObject", "Static", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter$Static;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter$Instance;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter$JvmStaticInObject;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter$BoundInstance;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter$BoundJvmStaticInObject;"})
    public static abstract class FieldSetter
    extends CallerImpl<Field> {
        private final boolean notNull;

        private FieldSetter(Field field, boolean notNull, boolean requiresInstance) {
            Member member = field;
            Type[] typeArray = Void.TYPE;
            Intrinsics.checkNotNullExpressionValue(typeArray, "TYPE");
            Type type2 = (Type)typeArray;
            Class<?> clazz = requiresInstance ? field.getDeclaringClass() : null;
            typeArray = new Type[1];
            Type type3 = field.getGenericType();
            Intrinsics.checkNotNullExpressionValue(type3, "field.genericType");
            typeArray[0] = type3;
            super(member, type2, clazz, typeArray, null);
            this.notNull = notNull;
        }

        @Override
        public void checkArguments(@NotNull Object[] args) {
            Intrinsics.checkNotNullParameter(args, "args");
            super.checkArguments(args);
            if (this.notNull && ArraysKt.last(args) == null) {
                throw new IllegalArgumentException("null is not allowed as a value for this property.");
            }
        }

        @Override
        @Nullable
        public Object call(@NotNull Object[] args) {
            Intrinsics.checkNotNullParameter(args, "args");
            this.checkArguments(args);
            ((Field)this.getMember()).set(this.getInstanceClass() != null ? ArraysKt.first(args) : null, ArraysKt.last(args));
            return Unit.INSTANCE;
        }

        public /* synthetic */ FieldSetter(Field field, boolean notNull, boolean requiresInstance, DefaultConstructorMarker $constructor_marker) {
            this(field, notNull, requiresInstance);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter$Static;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter;", "Ljava/lang/reflect/Field;", "field", "", "notNull", "<init>", "(Ljava/lang/reflect/Field;Z)V"})
        public static final class Static
        extends FieldSetter {
            public Static(@NotNull Field field, boolean notNull) {
                Intrinsics.checkNotNullParameter(field, "field");
                super(field, notNull, false, null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter$Instance;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter;", "Ljava/lang/reflect/Field;", "field", "", "notNull", "<init>", "(Ljava/lang/reflect/Field;Z)V"})
        public static final class Instance
        extends FieldSetter {
            public Instance(@NotNull Field field, boolean notNull) {
                Intrinsics.checkNotNullParameter(field, "field");
                super(field, notNull, true, null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\u000b\u001a\u00020\n2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter$JvmStaticInObject;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter;", "Ljava/lang/reflect/Field;", "field", "", "notNull", "<init>", "(Ljava/lang/reflect/Field;Z)V", "", "args", "", "checkArguments", "([Ljava/lang/Object;)V"})
        public static final class JvmStaticInObject
        extends FieldSetter {
            public JvmStaticInObject(@NotNull Field field, boolean notNull) {
                Intrinsics.checkNotNullParameter(field, "field");
                super(field, notNull, true, null);
            }

            @Override
            public void checkArguments(@NotNull Object[] args) {
                Intrinsics.checkNotNullParameter(args, "args");
                super.checkArguments(args);
                this.checkObjectInstance(ArraysKt.firstOrNull(args));
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\r\u001a\u00020\u00072\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eR\u0016\u0010\b\u001a\u0004\u0018\u00010\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u000f"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter$BoundInstance;", "Lkotlin/reflect/jvm/internal/calls/BoundCaller;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter;", "Ljava/lang/reflect/Field;", "field", "", "notNull", "", "boundReceiver", "<init>", "(Ljava/lang/reflect/Field;ZLjava/lang/Object;)V", "", "args", "call", "([Ljava/lang/Object;)Ljava/lang/Object;", "Ljava/lang/Object;"})
        public static final class BoundInstance
        extends FieldSetter
        implements BoundCaller {
            @Nullable
            private final Object boundReceiver;

            public BoundInstance(@NotNull Field field, boolean notNull, @Nullable Object boundReceiver) {
                Intrinsics.checkNotNullParameter(field, "field");
                super(field, notNull, false, null);
                this.boundReceiver = boundReceiver;
            }

            @Override
            @NotNull
            public Object call(@NotNull Object[] args) {
                Intrinsics.checkNotNullParameter(args, "args");
                this.checkArguments(args);
                ((Field)this.getMember()).set(this.boundReceiver, ArraysKt.first(args));
                return Unit.INSTANCE;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\f\u001a\u00020\u000b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tH\u0017\u00a2\u0006\u0004\b\f\u0010\r"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter$BoundJvmStaticInObject;", "Lkotlin/reflect/jvm/internal/calls/BoundCaller;", "Lkotlin/reflect/jvm/internal/calls/CallerImpl$FieldSetter;", "Ljava/lang/reflect/Field;", "field", "", "notNull", "<init>", "(Ljava/lang/reflect/Field;Z)V", "", "args", "", "call", "([Ljava/lang/Object;)Ljava/lang/Object;"})
        public static final class BoundJvmStaticInObject
        extends FieldSetter
        implements BoundCaller {
            public BoundJvmStaticInObject(@NotNull Field field, boolean notNull) {
                Intrinsics.checkNotNullParameter(field, "field");
                super(field, notNull, false, null);
            }

            @Override
            @NotNull
            public Object call(@NotNull Object[] args) {
                Intrinsics.checkNotNullParameter(args, "args");
                this.checkArguments(args);
                ((Field)this.getMember()).set(null, ArraysKt.last(args));
                return Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0001\u0010\u0005\u0018\u0001*\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0001\u0010\u0005\u0018\u0001*\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u0006J(\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0001\u0010\u0005\u0018\u0001*\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\t"}, d2={"Lkotlin/reflect/jvm/internal/calls/CallerImpl$Companion;", "", "()V", "dropFirst", "", "T", "([Ljava/lang/Object;)[Ljava/lang/Object;", "dropFirstAndLast", "dropLast", "kotlin-reflection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

