/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpecialNames {
    @NotNull
    public static final SpecialNames INSTANCE = new SpecialNames();
    @NotNull
    public static final Name NO_NAME_PROVIDED;
    @NotNull
    public static final Name ROOT_PACKAGE;
    @NotNull
    public static final Name DEFAULT_NAME_FOR_COMPANION_OBJECT;
    @NotNull
    public static final Name SAFE_IDENTIFIER_FOR_NO_NAME;
    @NotNull
    public static final Name ANONYMOUS;
    @NotNull
    public static final Name UNARY;
    @NotNull
    public static final Name THIS;
    @NotNull
    public static final Name INIT;
    @NotNull
    public static final Name ITERATOR;
    @NotNull
    public static final Name DESTRUCT;
    @NotNull
    public static final Name LOCAL;
    @NotNull
    public static final Name UNDERSCORE_FOR_UNUSED_VAR;

    private SpecialNames() {
    }

    @NotNull
    public static final Name safeIdentifier(@Nullable Name name) {
        return name != null && !name.isSpecial() ? name : SAFE_IDENTIFIER_FOR_NO_NAME;
    }

    public final boolean isSafeIdentifier(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string2 = name.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "name.asString()");
        return ((CharSequence)string2).length() > 0 && !name.isSpecial();
    }

    static {
        Name name = Name.special("<no name provided>");
        Intrinsics.checkNotNullExpressionValue(name, "special(\"<no name provided>\")");
        NO_NAME_PROVIDED = name;
        name = Name.special("<root package>");
        Intrinsics.checkNotNullExpressionValue(name, "special(\"<root package>\")");
        ROOT_PACKAGE = name;
        name = Name.identifier("Companion");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(\"Companion\")");
        DEFAULT_NAME_FOR_COMPANION_OBJECT = name;
        name = Name.identifier("no_name_in_PSI_3d19d79d_1ba9_4cd0_b7f5_b46aa3cd5d40");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(\"no_name_in_P\u2026_4cd0_b7f5_b46aa3cd5d40\")");
        SAFE_IDENTIFIER_FOR_NO_NAME = name;
        name = Name.special("<anonymous>");
        Intrinsics.checkNotNullExpressionValue(name, "special(ANONYMOUS_STRING)");
        ANONYMOUS = name;
        name = Name.special("<unary>");
        Intrinsics.checkNotNullExpressionValue(name, "special(\"<unary>\")");
        UNARY = name;
        name = Name.special("<this>");
        Intrinsics.checkNotNullExpressionValue(name, "special(\"<this>\")");
        THIS = name;
        name = Name.special("<init>");
        Intrinsics.checkNotNullExpressionValue(name, "special(\"<init>\")");
        INIT = name;
        name = Name.special("<iterator>");
        Intrinsics.checkNotNullExpressionValue(name, "special(\"<iterator>\")");
        ITERATOR = name;
        name = Name.special("<destruct>");
        Intrinsics.checkNotNullExpressionValue(name, "special(\"<destruct>\")");
        DESTRUCT = name;
        name = Name.special("<local>");
        Intrinsics.checkNotNullExpressionValue(name, "special(\"<local>\")");
        LOCAL = name;
        name = Name.special("<unused var>");
        Intrinsics.checkNotNullExpressionValue(name, "special(\"<unused var>\")");
        UNDERSCORE_FOR_UNUSED_VAR = name;
    }
}

