/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationJvmKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.DurationUnitKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b+\b\u0086@\u0018\u0000 \u0085\u00012\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u0085\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\bJ\u0010\u0010\r\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\f\u0010\u0005J\u0018\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0010J\u0018\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0019H\u0086\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001eH\u0086\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001fJ\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0019H\u0086\u0002\u00a2\u0006\u0004\b \u0010\u001cJ\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001eH\u0086\u0002\u00a2\u0006\u0004\b \u0010\u001fJ\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010(\u001a\u00020\u00002\u0006\u0010%\u001a\u00020$H\u0000\u00a2\u0006\u0004\b&\u0010'J\r\u0010*\u001a\u00020\u0006\u00a2\u0006\u0004\b)\u0010\bJ\r\u0010,\u001a\u00020\u0006\u00a2\u0006\u0004\b+\u0010\bJ\r\u0010.\u001a\u00020\u0006\u00a2\u0006\u0004\b-\u0010\bJ\r\u00100\u001a\u00020\u0006\u00a2\u0006\u0004\b/\u0010\bJ\u0018\u00103\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b1\u00102JR\u00109\u001a\u00028\u0000\"\u0004\b\u0000\u001042*\u00106\u001a&\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00028\u000005H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0004\b7\u00108JL\u00109\u001a\u00028\u0000\"\u0004\b\u0000\u001042$\u00106\u001a \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00028\u00000:H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0004\b7\u0010;JF\u00109\u001a\u00028\u0000\"\u0004\b\u0000\u001042\u001e\u00106\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00028\u00000<H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0004\b7\u0010=J@\u00109\u001a\u00028\u0000\"\u0004\b\u0000\u001042\u0018\u00106\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00028\u00000>H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0004\b7\u0010?J\u0015\u0010B\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b@\u0010AJ\u0015\u0010D\u001a\u00020\u00022\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\bC\u0010'J\u0015\u0010G\u001a\u00020\u00192\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\bE\u0010FJ\u000f\u0010K\u001a\u00020HH\u0017\u00a2\u0006\u0004\bI\u0010JJ?\u0010U\u001a\u00020R*\u00060Lj\u0002`M2\u0006\u0010N\u001a\u00020\u00192\u0006\u0010O\u001a\u00020\u00192\u0006\u0010P\u001a\u00020\u00192\u0006\u0010%\u001a\u00020H2\u0006\u0010Q\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\bS\u0010TJ!\u0010K\u001a\u00020H2\u0006\u0010%\u001a\u00020$2\b\b\u0002\u0010V\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\bI\u0010WJ\u000f\u0010Y\u001a\u00020HH\u0007\u00a2\u0006\u0004\bX\u0010JJ\u001a\u0010[\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010ZH\u00d6\u0003\u00a2\u0006\u0004\b[\u0010\\J\u0010\u0010]\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b]\u0010^R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010_R\u0014\u0010a\u001a\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b`\u0010\u0005R\u0015\u0010d\u001a\u00020\u00198\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bb\u0010cR\u0014\u0010g\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\be\u0010fR\u0011\u0010i\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bh\u0010\u0005R\u001a\u0010m\u001a\u00020\u00198@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\bk\u0010l\u001a\u0004\bj\u0010cR\u001a\u0010p\u001a\u00020\u00198@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\bo\u0010l\u001a\u0004\bn\u0010cR\u001a\u0010s\u001a\u00020\u00198@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\br\u0010l\u001a\u0004\bq\u0010cR\u001a\u0010v\u001a\u00020\u00198@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\bu\u0010l\u001a\u0004\bt\u0010cR\u0011\u0010x\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\bw\u0010\u0005R\u0011\u0010z\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\by\u0010\u0005R\u0011\u0010|\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b{\u0010\u0005R\u0011\u0010~\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b}\u0010\u0005R\u0012\u0010\u0080\u0001\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u007f\u0010\u0005R\u0013\u0010\u0082\u0001\u001a\u00020\u00028F\u00a2\u0006\u0007\u001a\u0005\b\u0081\u0001\u0010\u0005R\u0013\u0010\u0084\u0001\u001a\u00020\u00028F\u00a2\u0006\u0007\u001a\u0005\b\u0083\u0001\u0010\u0005\u0088\u0001\u0003\u0092\u0001\u00020\u0002\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"Lkotlin/time/Duration;", "", "", "rawValue", "constructor-impl", "(J)J", "", "isInNanos-impl", "(J)Z", "isInNanos", "isInMillis-impl", "isInMillis", "unaryMinus-UwyO8pc", "unaryMinus", "other", "plus-LRDsOJo", "(JJ)J", "plus", "thisMillis", "otherNanos", "addValuesMixedRanges-UwyO8pc", "(JJJ)J", "addValuesMixedRanges", "minus-LRDsOJo", "minus", "", "scale", "times-UwyO8pc", "(JI)J", "times", "", "(JD)J", "div-UwyO8pc", "div", "div-LRDsOJo", "(JJ)D", "Lkotlin/time/DurationUnit;", "unit", "truncateTo-UwyO8pc$kotlin_stdlib", "(JLkotlin/time/DurationUnit;)J", "truncateTo", "isNegative-impl", "isNegative", "isPositive-impl", "isPositive", "isInfinite-impl", "isInfinite", "isFinite-impl", "isFinite", "compareTo-LRDsOJo", "(JJ)I", "compareTo", "T", "Lkotlin/Function5;", "action", "toComponents-impl", "(JLkotlin/jvm/functions/Function5;)Ljava/lang/Object;", "toComponents", "Lkotlin/Function4;", "(JLkotlin/jvm/functions/Function4;)Ljava/lang/Object;", "Lkotlin/Function3;", "(JLkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "Lkotlin/Function2;", "(JLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "toDouble-impl", "(JLkotlin/time/DurationUnit;)D", "toDouble", "toLong-impl", "toLong", "toInt-impl", "(JLkotlin/time/DurationUnit;)I", "toInt", "", "toString-impl", "(J)Ljava/lang/String;", "toString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "whole", "fractional", "fractionalSize", "isoZeroes", "", "appendFractional-impl", "(JLjava/lang/StringBuilder;IIILjava/lang/String;Z)V", "appendFractional", "decimals", "(JLkotlin/time/DurationUnit;I)Ljava/lang/String;", "toIsoString-impl", "toIsoString", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "J", "getValue-impl", "value", "getUnitDiscriminator-impl", "(J)I", "unitDiscriminator", "getStorageUnit-impl", "(J)Lkotlin/time/DurationUnit;", "storageUnit", "getAbsoluteValue-UwyO8pc", "absoluteValue", "getHoursComponent-impl", "getHoursComponent$annotations", "()V", "hoursComponent", "getMinutesComponent-impl", "getMinutesComponent$annotations", "minutesComponent", "getSecondsComponent-impl", "getSecondsComponent$annotations", "secondsComponent", "getNanosecondsComponent-impl", "getNanosecondsComponent$annotations", "nanosecondsComponent", "getInWholeDays-impl", "inWholeDays", "getInWholeHours-impl", "inWholeHours", "getInWholeMinutes-impl", "inWholeMinutes", "getInWholeSeconds-impl", "inWholeSeconds", "getInWholeMilliseconds-impl", "inWholeMilliseconds", "getInWholeMicroseconds-impl", "inWholeMicroseconds", "getInWholeNanoseconds-impl", "inWholeNanoseconds", "Companion"})
public final class Duration
implements Comparable<Duration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long rawValue;
    private static final long ZERO = Duration.constructor-impl(0L);
    private static final long INFINITE = DurationKt.access$durationOfMillis(0x3FFFFFFFFFFFFFFFL);
    private static final long NEG_INFINITE = DurationKt.access$durationOfMillis(-4611686018427387903L);

    private static final long getValue-impl(long arg0) {
        return arg0 >> 1;
    }

    private static final int getUnitDiscriminator-impl(long arg0) {
        boolean bl = false;
        return (int)arg0 & 1;
    }

    private static final boolean isInNanos-impl(long arg0) {
        boolean bl = false;
        return ((int)arg0 & 1) == 0;
    }

    private static final boolean isInMillis-impl(long arg0) {
        boolean bl = false;
        return ((int)arg0 & 1) == 1;
    }

    private static final DurationUnit getStorageUnit-impl(long arg0) {
        return Duration.isInNanos-impl(arg0) ? DurationUnit.NANOSECONDS : DurationUnit.MILLISECONDS;
    }

    public static final long unaryMinus-UwyO8pc(long arg0) {
        boolean bl = false;
        return DurationKt.access$durationOf(-Duration.getValue-impl(arg0), (int)arg0 & 1);
    }

    public static final long plus-LRDsOJo(long arg0, long other) {
        long l;
        if (Duration.isInfinite-impl(arg0)) {
            if (Duration.isFinite-impl(other) || (arg0 ^ other) >= 0L) {
                return arg0;
            }
            throw new IllegalArgumentException("Summing infinite durations of different signs yields an undefined result.");
        }
        if (Duration.isInfinite-impl(other)) {
            return other;
        }
        boolean bl = false;
        bl = false;
        if (((int)arg0 & 1) == ((int)other & 1)) {
            long result2 = Duration.getValue-impl(arg0) + Duration.getValue-impl(other);
            l = Duration.isInNanos-impl(arg0) ? DurationKt.access$durationOfNanosNormalized(result2) : DurationKt.access$durationOfMillisNormalized(result2);
        } else {
            l = Duration.isInMillis-impl(arg0) ? Duration.addValuesMixedRanges-UwyO8pc(arg0, Duration.getValue-impl(arg0), Duration.getValue-impl(other)) : Duration.addValuesMixedRanges-UwyO8pc(arg0, Duration.getValue-impl(other), Duration.getValue-impl(arg0));
        }
        return l;
    }

    private static final long addValuesMixedRanges-UwyO8pc(long arg0, long thisMillis, long otherNanos) {
        long l;
        long otherMillis = DurationKt.access$nanosToMillis(otherNanos);
        long resultMillis = thisMillis + otherMillis;
        boolean bl = -4611686018426L <= resultMillis ? resultMillis < 4611686018427L : false;
        if (bl) {
            long otherNanoRemainder = otherNanos - DurationKt.access$millisToNanos(otherMillis);
            l = DurationKt.access$durationOfNanos(DurationKt.access$millisToNanos(resultMillis) + otherNanoRemainder);
        } else {
            l = DurationKt.access$durationOfMillis(RangesKt.coerceIn(resultMillis, -4611686018427387903L, 0x3FFFFFFFFFFFFFFFL));
        }
        return l;
    }

    public static final long minus-LRDsOJo(long arg0, long other) {
        return Duration.plus-LRDsOJo(arg0, Duration.unaryMinus-UwyO8pc(other));
    }

    public static final long times-UwyO8pc(long arg0, int scale) {
        long l;
        if (Duration.isInfinite-impl(arg0)) {
            if (scale == 0) {
                throw new IllegalArgumentException("Multiplying infinite duration by zero yields an undefined result.");
            }
            return scale > 0 ? arg0 : Duration.unaryMinus-UwyO8pc(arg0);
        }
        if (scale == 0) {
            return ZERO;
        }
        long value2 = Duration.getValue-impl(arg0);
        long result2 = value2 * (long)scale;
        if (Duration.isInNanos-impl(arg0)) {
            boolean bl = -2147483647L <= value2 ? value2 < 0x80000000L : false;
            if (bl) {
                l = DurationKt.access$durationOfNanos(result2);
            } else if (result2 / (long)scale == value2) {
                l = DurationKt.access$durationOfNanosNormalized(result2);
            } else {
                long millis = DurationKt.access$nanosToMillis(value2);
                long remNanos = value2 - DurationKt.access$millisToNanos(millis);
                long resultMillis = millis * (long)scale;
                long totalMillis = resultMillis + DurationKt.access$nanosToMillis(remNanos * (long)scale);
                l = resultMillis / (long)scale == millis && (totalMillis ^ resultMillis) >= 0L ? DurationKt.access$durationOfMillis(RangesKt.coerceIn(totalMillis, new LongRange(-4611686018427387903L, 0x3FFFFFFFFFFFFFFFL))) : (MathKt.getSign(value2) * MathKt.getSign(scale) > 0 ? INFINITE : NEG_INFINITE);
            }
        } else {
            l = result2 / (long)scale == value2 ? DurationKt.access$durationOfMillis(RangesKt.coerceIn(result2, new LongRange(-4611686018427387903L, 0x3FFFFFFFFFFFFFFFL))) : (MathKt.getSign(value2) * MathKt.getSign(scale) > 0 ? INFINITE : NEG_INFINITE);
        }
        return l;
    }

    public static final long times-UwyO8pc(long arg0, double scale) {
        int intScale = MathKt.roundToInt(scale);
        if ((double)intScale == scale) {
            return Duration.times-UwyO8pc(arg0, intScale);
        }
        DurationUnit unit = Duration.getStorageUnit-impl(arg0);
        double result2 = Duration.toDouble-impl(arg0, unit) * scale;
        return DurationKt.toDuration(result2, unit);
    }

    public static final long div-UwyO8pc(long arg0, int scale) {
        if (scale == 0) {
            long l;
            if (Duration.isPositive-impl(arg0)) {
                l = INFINITE;
            } else if (Duration.isNegative-impl(arg0)) {
                l = NEG_INFINITE;
            } else {
                throw new IllegalArgumentException("Dividing zero duration by zero yields an undefined result.");
            }
            return l;
        }
        if (Duration.isInNanos-impl(arg0)) {
            return DurationKt.access$durationOfNanos(Duration.getValue-impl(arg0) / (long)scale);
        }
        if (Duration.isInfinite-impl(arg0)) {
            return Duration.times-UwyO8pc(arg0, MathKt.getSign(scale));
        }
        long result2 = Duration.getValue-impl(arg0) / (long)scale;
        boolean bl = -4611686018426L <= result2 ? result2 < 4611686018427L : false;
        if (bl) {
            long rem = DurationKt.access$millisToNanos(Duration.getValue-impl(arg0) - result2 * (long)scale) / (long)scale;
            return DurationKt.access$durationOfNanos(DurationKt.access$millisToNanos(result2) + rem);
        }
        return DurationKt.access$durationOfMillis(result2);
    }

    public static final long div-UwyO8pc(long arg0, double scale) {
        int intScale = MathKt.roundToInt(scale);
        if ((double)intScale == scale && intScale != 0) {
            return Duration.div-UwyO8pc(arg0, intScale);
        }
        DurationUnit unit = Duration.getStorageUnit-impl(arg0);
        double result2 = Duration.toDouble-impl(arg0, unit) / scale;
        return DurationKt.toDuration(result2, unit);
    }

    public static final double div-LRDsOJo(long arg0, long other) {
        DurationUnit coarserUnit = (DurationUnit)((Object)ComparisonsKt.maxOf((Comparable)((Object)Duration.getStorageUnit-impl(arg0)), (Comparable)((Object)Duration.getStorageUnit-impl(other))));
        return Duration.toDouble-impl(arg0, coarserUnit) / Duration.toDouble-impl(other, coarserUnit);
    }

    public static final long truncateTo-UwyO8pc$kotlin_stdlib(long arg0, @NotNull DurationUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        DurationUnit storageUnit = Duration.getStorageUnit-impl(arg0);
        if (unit.compareTo((Enum)storageUnit) <= 0 || Duration.isInfinite-impl(arg0)) {
            return arg0;
        }
        long scale = DurationUnitKt.convertDurationUnit(1L, unit, storageUnit);
        long result2 = Duration.getValue-impl(arg0) - Duration.getValue-impl(arg0) % scale;
        return DurationKt.toDuration(result2, storageUnit);
    }

    public static final boolean isNegative-impl(long arg0) {
        return arg0 < 0L;
    }

    public static final boolean isPositive-impl(long arg0) {
        return arg0 > 0L;
    }

    public static final boolean isInfinite-impl(long arg0) {
        return arg0 == INFINITE || arg0 == NEG_INFINITE;
    }

    public static final boolean isFinite-impl(long arg0) {
        return !Duration.isInfinite-impl(arg0);
    }

    public static final long getAbsoluteValue-UwyO8pc(long arg0) {
        return Duration.isNegative-impl(arg0) ? Duration.unaryMinus-UwyO8pc(arg0) : arg0;
    }

    public static int compareTo-LRDsOJo(long arg0, long other) {
        long compareBits = arg0 ^ other;
        if (compareBits < 0L || ((int)compareBits & 1) == 0) {
            return Intrinsics.compare(arg0, other);
        }
        boolean bl = false;
        bl = false;
        int r = ((int)arg0 & 1) - ((int)other & 1);
        return Duration.isNegative-impl(arg0) ? -r : r;
    }

    public int compareTo-LRDsOJo(long other) {
        return Duration.compareTo-LRDsOJo(this.rawValue, other);
    }

    public static final <T> T toComponents-impl(long arg0, @NotNull Function5<? super Long, ? super Integer, ? super Integer, ? super Integer, ? super Integer, ? extends T> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        boolean bl = false;
        return action.invoke(Duration.getInWholeDays-impl(arg0), Duration.getHoursComponent-impl(arg0), Duration.getMinutesComponent-impl(arg0), Duration.getSecondsComponent-impl(arg0), Duration.getNanosecondsComponent-impl(arg0));
    }

    public static final <T> T toComponents-impl(long arg0, @NotNull Function4<? super Long, ? super Integer, ? super Integer, ? super Integer, ? extends T> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        boolean bl = false;
        return action.invoke(Duration.getInWholeHours-impl(arg0), Duration.getMinutesComponent-impl(arg0), Duration.getSecondsComponent-impl(arg0), Duration.getNanosecondsComponent-impl(arg0));
    }

    public static final <T> T toComponents-impl(long arg0, @NotNull Function3<? super Long, ? super Integer, ? super Integer, ? extends T> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        boolean bl = false;
        return action.invoke(Duration.getInWholeMinutes-impl(arg0), Duration.getSecondsComponent-impl(arg0), Duration.getNanosecondsComponent-impl(arg0));
    }

    public static final <T> T toComponents-impl(long arg0, @NotNull Function2<? super Long, ? super Integer, ? extends T> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        boolean bl = false;
        return action.invoke(Duration.getInWholeSeconds-impl(arg0), Duration.getNanosecondsComponent-impl(arg0));
    }

    public static final int getHoursComponent-impl(long arg0) {
        return Duration.isInfinite-impl(arg0) ? 0 : (int)(Duration.getInWholeHours-impl(arg0) % (long)24);
    }

    public static /* synthetic */ void getHoursComponent$annotations() {
    }

    public static final int getMinutesComponent-impl(long arg0) {
        return Duration.isInfinite-impl(arg0) ? 0 : (int)(Duration.getInWholeMinutes-impl(arg0) % (long)60);
    }

    public static /* synthetic */ void getMinutesComponent$annotations() {
    }

    public static final int getSecondsComponent-impl(long arg0) {
        return Duration.isInfinite-impl(arg0) ? 0 : (int)(Duration.getInWholeSeconds-impl(arg0) % (long)60);
    }

    public static /* synthetic */ void getSecondsComponent$annotations() {
    }

    public static final int getNanosecondsComponent-impl(long arg0) {
        return Duration.isInfinite-impl(arg0) ? 0 : (Duration.isInMillis-impl(arg0) ? (int)DurationKt.access$millisToNanos(Duration.getValue-impl(arg0) % (long)1000) : (int)(Duration.getValue-impl(arg0) % (long)1000000000));
    }

    public static /* synthetic */ void getNanosecondsComponent$annotations() {
    }

    public static final double toDouble-impl(long arg0, @NotNull DurationUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        long l = arg0;
        return l == INFINITE ? Double.POSITIVE_INFINITY : (l == NEG_INFINITE ? Double.NEGATIVE_INFINITY : DurationUnitKt.convertDurationUnit((double)Duration.getValue-impl(arg0), Duration.getStorageUnit-impl(arg0), unit));
    }

    public static final long toLong-impl(long arg0, @NotNull DurationUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        long l = arg0;
        return l == INFINITE ? Long.MAX_VALUE : (l == NEG_INFINITE ? Long.MIN_VALUE : DurationUnitKt.convertDurationUnit(Duration.getValue-impl(arg0), Duration.getStorageUnit-impl(arg0), unit));
    }

    public static final int toInt-impl(long arg0, @NotNull DurationUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        return (int)RangesKt.coerceIn(Duration.toLong-impl(arg0, unit), Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static final long getInWholeDays-impl(long arg0) {
        return Duration.toLong-impl(arg0, DurationUnit.DAYS);
    }

    public static final long getInWholeHours-impl(long arg0) {
        return Duration.toLong-impl(arg0, DurationUnit.HOURS);
    }

    public static final long getInWholeMinutes-impl(long arg0) {
        return Duration.toLong-impl(arg0, DurationUnit.MINUTES);
    }

    public static final long getInWholeSeconds-impl(long arg0) {
        return Duration.toLong-impl(arg0, DurationUnit.SECONDS);
    }

    public static final long getInWholeMilliseconds-impl(long arg0) {
        return Duration.isInMillis-impl(arg0) && Duration.isFinite-impl(arg0) ? Duration.getValue-impl(arg0) : Duration.toLong-impl(arg0, DurationUnit.MILLISECONDS);
    }

    public static final long getInWholeMicroseconds-impl(long arg0) {
        return Duration.toLong-impl(arg0, DurationUnit.MICROSECONDS);
    }

    public static final long getInWholeNanoseconds-impl(long arg0) {
        long value2 = Duration.getValue-impl(arg0);
        return Duration.isInNanos-impl(arg0) ? value2 : (value2 > 9223372036854L ? Long.MAX_VALUE : (value2 < -9223372036854L ? Long.MIN_VALUE : DurationKt.access$millisToNanos(value2)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static String toString-impl(long arg0) {
        String string2;
        long l = arg0;
        if (l == 0L) {
            string2 = "0s";
        } else if (l == INFINITE) {
            string2 = "Infinity";
        } else if (l == NEG_INFINITE) {
            string2 = "-Infinity";
        } else {
            void nanoseconds;
            void seconds;
            void minutes;
            void hours;
            StringBuilder stringBuilder;
            boolean isNegative = Duration.isNegative-impl(arg0);
            StringBuilder $this$toString_impl_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (isNegative) {
                $this$toString_impl_u24lambda_u241.append('-');
            }
            long arg0$iv = Duration.getAbsoluteValue-UwyO8pc(arg0);
            boolean bl2 = false;
            int n = Duration.getNanosecondsComponent-impl(arg0$iv);
            int n2 = Duration.getSecondsComponent-impl(arg0$iv);
            int n3 = Duration.getMinutesComponent-impl(arg0$iv);
            int n4 = Duration.getHoursComponent-impl(arg0$iv);
            long days = Duration.getInWholeDays-impl(arg0$iv);
            boolean bl3 = false;
            boolean hasDays = days != 0L;
            boolean hasHours = hours != false;
            boolean hasMinutes = minutes != false;
            boolean hasSeconds = seconds != false || nanoseconds != false;
            int components = 0;
            if (hasDays) {
                $this$toString_impl_u24lambda_u241.append(days).append('d');
                ++components;
            }
            if (hasHours || hasDays && (hasMinutes || hasSeconds)) {
                if (components++ > 0) {
                    $this$toString_impl_u24lambda_u241.append(' ');
                }
                $this$toString_impl_u24lambda_u241.append((int)hours).append('h');
            }
            if (hasMinutes || hasSeconds && (hasHours || hasDays)) {
                if (components++ > 0) {
                    $this$toString_impl_u24lambda_u241.append(' ');
                }
                $this$toString_impl_u24lambda_u241.append((int)minutes).append('m');
            }
            if (hasSeconds) {
                if (components++ > 0) {
                    $this$toString_impl_u24lambda_u241.append(' ');
                }
                if (seconds != false || hasDays || hasHours || hasMinutes) {
                    Duration.appendFractional-impl(arg0, $this$toString_impl_u24lambda_u241, (int)seconds, (int)nanoseconds, 9, "s", false);
                } else if (nanoseconds >= 1000000) {
                    Duration.appendFractional-impl(arg0, $this$toString_impl_u24lambda_u241, (int)(nanoseconds / 1000000), (int)(nanoseconds % 1000000), 6, "ms", false);
                } else if (nanoseconds >= 1000) {
                    Duration.appendFractional-impl(arg0, $this$toString_impl_u24lambda_u241, (int)(nanoseconds / 1000), (int)(nanoseconds % 1000), 3, "us", false);
                } else {
                    $this$toString_impl_u24lambda_u241.append((int)nanoseconds).append("ns");
                }
            }
            if (isNegative && components > 1) {
                $this$toString_impl_u24lambda_u241.insert(1, '(').append(')');
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    @NotNull
    public String toString() {
        return Duration.toString-impl(this.rawValue);
    }

    private static final void appendFractional-impl(long arg0, StringBuilder $this$appendFractional, int whole, int fractional, int fractionalSize, String unit, boolean isoZeroes) {
        $this$appendFractional.append(whole);
        if (fractional != 0) {
            StringBuilder stringBuilder;
            int n;
            String fracString;
            block5: {
                $this$appendFractional.append('.');
                fracString = StringsKt.padStart(String.valueOf(fractional), fractionalSize, '0');
                CharSequence $this$indexOfLast$iv = fracString;
                boolean $i$f$indexOfLast = false;
                int n2 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n2) {
                    do {
                        int index$iv = n2--;
                        char it = $this$indexOfLast$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(it != '0')) continue;
                        n = index$iv;
                        break block5;
                    } while (0 <= n2);
                }
                n = -1;
            }
            int nonZeroDigits = n + 1;
            if (!isoZeroes && nonZeroDigits < 3) {
                StringBuilder stringBuilder2 = $this$appendFractional.append(fracString, 0, nonZeroDigits);
                stringBuilder = stringBuilder2;
                Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(...)");
            } else {
                StringBuilder stringBuilder3 = $this$appendFractional.append(fracString, 0, (nonZeroDigits + 2) / 3 * 3);
                stringBuilder = stringBuilder3;
                Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(...)");
            }
        }
        $this$appendFractional.append(unit);
    }

    @NotNull
    public static final String toString-impl(long arg0, @NotNull DurationUnit unit, int decimals) {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        if (!(decimals >= 0)) {
            boolean bl = false;
            String string2 = "decimals must be not negative, but was " + decimals;
            throw new IllegalArgumentException(string2.toString());
        }
        double number = Duration.toDouble-impl(arg0, unit);
        if (Double.isInfinite(number)) {
            return String.valueOf(number);
        }
        return DurationJvmKt.formatToExactDecimals(number, RangesKt.coerceAtMost(decimals, 12)) + DurationUnitKt.shortName(unit);
    }

    public static /* synthetic */ String toString-impl$default(long l, DurationUnit durationUnit, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return Duration.toString-impl(l, durationUnit, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toIsoString-impl(long arg0) {
        void minutes;
        boolean hasMinutes;
        void nanoseconds;
        void seconds;
        StringBuilder stringBuilder;
        StringBuilder $this$toIsoString_impl_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (Duration.isNegative-impl(arg0)) {
            $this$toIsoString_impl_u24lambda_u245.append('-');
        }
        $this$toIsoString_impl_u24lambda_u245.append("PT");
        long arg0$iv = Duration.getAbsoluteValue-UwyO8pc(arg0);
        boolean bl2 = false;
        int n = Duration.getNanosecondsComponent-impl(arg0$iv);
        int n2 = Duration.getSecondsComponent-impl(arg0$iv);
        int n3 = Duration.getMinutesComponent-impl(arg0$iv);
        long hours = Duration.getInWholeHours-impl(arg0$iv);
        boolean bl3 = false;
        long hours2 = hours;
        if (Duration.isInfinite-impl(arg0)) {
            hours2 = 9999999999999L;
        }
        boolean hasHours = hours2 != 0L;
        boolean hasSeconds = seconds != false || nanoseconds != false;
        boolean bl4 = hasMinutes = minutes != false || hasSeconds && hasHours;
        if (hasHours) {
            $this$toIsoString_impl_u24lambda_u245.append(hours2).append('H');
        }
        if (hasMinutes) {
            $this$toIsoString_impl_u24lambda_u245.append((int)minutes).append('M');
        }
        if (hasSeconds || !hasHours && !hasMinutes) {
            Duration.appendFractional-impl(arg0, $this$toIsoString_impl_u24lambda_u245, (int)seconds, (int)nanoseconds, 9, "S", true);
        }
        return stringBuilder.toString();
    }

    public static int hashCode-impl(long arg0) {
        return Long.hashCode(arg0);
    }

    public int hashCode() {
        return Duration.hashCode-impl(this.rawValue);
    }

    public static boolean equals-impl(long arg0, Object other) {
        if (!(other instanceof Duration)) {
            return false;
        }
        long l = ((Duration)other).unbox-impl();
        return arg0 == l;
    }

    public boolean equals(Object other) {
        return Duration.equals-impl(this.rawValue, other);
    }

    private /* synthetic */ Duration(long rawValue) {
        this.rawValue = rawValue;
    }

    public static long constructor-impl(long rawValue) {
        long l = rawValue;
        if (DurationJvmKt.getDurationAssertionsEnabled()) {
            if (Duration.isInNanos-impl(l)) {
                long l2 = Duration.getValue-impl(l);
                if (!(-4611686018426999999L <= l2 ? l2 < 4611686018427000000L : false)) {
                    throw new AssertionError((Object)(Duration.getValue-impl(l) + " ns is out of nanoseconds range"));
                }
            } else {
                long l3 = Duration.getValue-impl(l);
                if (!(-4611686018427387903L <= l3 ? l3 < 0x4000000000000000L : false)) {
                    throw new AssertionError((Object)(Duration.getValue-impl(l) + " ms is out of milliseconds range"));
                }
                l3 = Duration.getValue-impl(l);
                boolean bl = -4611686018426L <= l3 ? l3 < 4611686018427L : false;
                if (bl) {
                    throw new AssertionError((Object)(Duration.getValue-impl(l) + " ms is denormalized"));
                }
            }
        }
        return l;
    }

    public static final /* synthetic */ Duration box-impl(long v) {
        return new Duration(v);
    }

    public final /* synthetic */ long unbox-impl() {
        return this.rawValue;
    }

    public static final boolean equals-impl0(long p1, long p2) {
        return p1 == p2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0016\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0019\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0013R\u0017\u0010\u0017\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0018\u001a\u0004\b\u001c\u0010\u001aR\u001a\u0010\u001d\u001a\u00020\f8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0018\u001a\u0004\b\u001e\u0010\u001aR\u001c\u0010$\u001a\u00020\f*\u00020\u001f8\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b\"\u0010#\u001a\u0004\b \u0010!R\u001c\u0010$\u001a\u00020\f*\u00020%8\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b\"\u0010'\u001a\u0004\b \u0010&R\u001c\u0010$\u001a\u00020\f*\u00020\u00048\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b\"\u0010)\u001a\u0004\b \u0010(R\u001c\u0010,\u001a\u00020\f*\u00020\u001f8\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b+\u0010#\u001a\u0004\b*\u0010!R\u001c\u0010,\u001a\u00020\f*\u00020%8\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b+\u0010'\u001a\u0004\b*\u0010&R\u001c\u0010,\u001a\u00020\f*\u00020\u00048\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b+\u0010)\u001a\u0004\b*\u0010(R\u001c\u0010/\u001a\u00020\f*\u00020\u001f8\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b.\u0010#\u001a\u0004\b-\u0010!R\u001c\u0010/\u001a\u00020\f*\u00020%8\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b.\u0010'\u001a\u0004\b-\u0010&R\u001c\u0010/\u001a\u00020\f*\u00020\u00048\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b.\u0010)\u001a\u0004\b-\u0010(R\u001c\u00102\u001a\u00020\f*\u00020\u001f8\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b1\u0010#\u001a\u0004\b0\u0010!R\u001c\u00102\u001a\u00020\f*\u00020%8\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b1\u0010'\u001a\u0004\b0\u0010&R\u001c\u00102\u001a\u00020\f*\u00020\u00048\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b1\u0010)\u001a\u0004\b0\u0010(R\u001c\u00105\u001a\u00020\f*\u00020\u001f8\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b4\u0010#\u001a\u0004\b3\u0010!R\u001c\u00105\u001a\u00020\f*\u00020%8\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b4\u0010'\u001a\u0004\b3\u0010&R\u001c\u00105\u001a\u00020\f*\u00020\u00048\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b4\u0010)\u001a\u0004\b3\u0010(R\u001c\u00108\u001a\u00020\f*\u00020\u001f8\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b7\u0010#\u001a\u0004\b6\u0010!R\u001c\u00108\u001a\u00020\f*\u00020%8\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b7\u0010'\u001a\u0004\b6\u0010&R\u001c\u00108\u001a\u00020\f*\u00020\u00048\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b7\u0010)\u001a\u0004\b6\u0010(R\u001c\u0010;\u001a\u00020\f*\u00020\u001f8\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b:\u0010#\u001a\u0004\b9\u0010!R\u001c\u0010;\u001a\u00020\f*\u00020%8\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b:\u0010'\u001a\u0004\b9\u0010&R\u001c\u0010;\u001a\u00020\f*\u00020\u00048\u00c6\u0002\u00a2\u0006\f\u0012\u0004\b:\u0010)\u001a\u0004\b9\u0010("}, d2={"Lkotlin/time/Duration$Companion;", "", "<init>", "()V", "", "value", "Lkotlin/time/DurationUnit;", "sourceUnit", "targetUnit", "convert", "(DLkotlin/time/DurationUnit;Lkotlin/time/DurationUnit;)D", "", "Lkotlin/time/Duration;", "parse-UwyO8pc", "(Ljava/lang/String;)J", "parse", "parseIsoString-UwyO8pc", "parseIsoString", "parseOrNull-FghU774", "(Ljava/lang/String;)Lkotlin/time/Duration;", "parseOrNull", "parseIsoStringOrNull-FghU774", "parseIsoStringOrNull", "ZERO", "J", "getZERO-UwyO8pc", "()J", "INFINITE", "getINFINITE-UwyO8pc", "NEG_INFINITE", "getNEG_INFINITE-UwyO8pc$kotlin_stdlib", "", "getNanoseconds-UwyO8pc", "(I)J", "getNanoseconds-UwyO8pc$annotations", "(I)V", "nanoseconds", "", "(J)J", "(J)V", "(D)J", "(D)V", "getMicroseconds-UwyO8pc", "getMicroseconds-UwyO8pc$annotations", "microseconds", "getMilliseconds-UwyO8pc", "getMilliseconds-UwyO8pc$annotations", "milliseconds", "getSeconds-UwyO8pc", "getSeconds-UwyO8pc$annotations", "seconds", "getMinutes-UwyO8pc", "getMinutes-UwyO8pc$annotations", "minutes", "getHours-UwyO8pc", "getHours-UwyO8pc$annotations", "hours", "getDays-UwyO8pc", "getDays-UwyO8pc$annotations", "days"})
    public static final class Companion {
        private Companion() {
        }

        public final long getZERO-UwyO8pc() {
            return ZERO;
        }

        public final long getINFINITE-UwyO8pc() {
            return INFINITE;
        }

        public final long getNEG_INFINITE-UwyO8pc$kotlin_stdlib() {
            return NEG_INFINITE;
        }

        public final double convert(double value2, @NotNull DurationUnit sourceUnit, @NotNull DurationUnit targetUnit) {
            Intrinsics.checkNotNullParameter((Object)sourceUnit, "sourceUnit");
            Intrinsics.checkNotNullParameter((Object)targetUnit, "targetUnit");
            return DurationUnitKt.convertDurationUnit(value2, sourceUnit, targetUnit);
        }

        private final long getNanoseconds-UwyO8pc(int $this$nanoseconds) {
            return DurationKt.toDuration($this$nanoseconds, DurationUnit.NANOSECONDS);
        }

        public static /* synthetic */ void getNanoseconds-UwyO8pc$annotations(int n) {
        }

        private final long getNanoseconds-UwyO8pc(long $this$nanoseconds) {
            return DurationKt.toDuration($this$nanoseconds, DurationUnit.NANOSECONDS);
        }

        public static /* synthetic */ void getNanoseconds-UwyO8pc$annotations(long l) {
        }

        private final long getNanoseconds-UwyO8pc(double $this$nanoseconds) {
            return DurationKt.toDuration($this$nanoseconds, DurationUnit.NANOSECONDS);
        }

        public static /* synthetic */ void getNanoseconds-UwyO8pc$annotations(double d) {
        }

        private final long getMicroseconds-UwyO8pc(int $this$microseconds) {
            return DurationKt.toDuration($this$microseconds, DurationUnit.MICROSECONDS);
        }

        public static /* synthetic */ void getMicroseconds-UwyO8pc$annotations(int n) {
        }

        private final long getMicroseconds-UwyO8pc(long $this$microseconds) {
            return DurationKt.toDuration($this$microseconds, DurationUnit.MICROSECONDS);
        }

        public static /* synthetic */ void getMicroseconds-UwyO8pc$annotations(long l) {
        }

        private final long getMicroseconds-UwyO8pc(double $this$microseconds) {
            return DurationKt.toDuration($this$microseconds, DurationUnit.MICROSECONDS);
        }

        public static /* synthetic */ void getMicroseconds-UwyO8pc$annotations(double d) {
        }

        private final long getMilliseconds-UwyO8pc(int $this$milliseconds) {
            return DurationKt.toDuration($this$milliseconds, DurationUnit.MILLISECONDS);
        }

        public static /* synthetic */ void getMilliseconds-UwyO8pc$annotations(int n) {
        }

        private final long getMilliseconds-UwyO8pc(long $this$milliseconds) {
            return DurationKt.toDuration($this$milliseconds, DurationUnit.MILLISECONDS);
        }

        public static /* synthetic */ void getMilliseconds-UwyO8pc$annotations(long l) {
        }

        private final long getMilliseconds-UwyO8pc(double $this$milliseconds) {
            return DurationKt.toDuration($this$milliseconds, DurationUnit.MILLISECONDS);
        }

        public static /* synthetic */ void getMilliseconds-UwyO8pc$annotations(double d) {
        }

        private final long getSeconds-UwyO8pc(int $this$seconds) {
            return DurationKt.toDuration($this$seconds, DurationUnit.SECONDS);
        }

        public static /* synthetic */ void getSeconds-UwyO8pc$annotations(int n) {
        }

        private final long getSeconds-UwyO8pc(long $this$seconds) {
            return DurationKt.toDuration($this$seconds, DurationUnit.SECONDS);
        }

        public static /* synthetic */ void getSeconds-UwyO8pc$annotations(long l) {
        }

        private final long getSeconds-UwyO8pc(double $this$seconds) {
            return DurationKt.toDuration($this$seconds, DurationUnit.SECONDS);
        }

        public static /* synthetic */ void getSeconds-UwyO8pc$annotations(double d) {
        }

        private final long getMinutes-UwyO8pc(int $this$minutes) {
            return DurationKt.toDuration($this$minutes, DurationUnit.MINUTES);
        }

        public static /* synthetic */ void getMinutes-UwyO8pc$annotations(int n) {
        }

        private final long getMinutes-UwyO8pc(long $this$minutes) {
            return DurationKt.toDuration($this$minutes, DurationUnit.MINUTES);
        }

        public static /* synthetic */ void getMinutes-UwyO8pc$annotations(long l) {
        }

        private final long getMinutes-UwyO8pc(double $this$minutes) {
            return DurationKt.toDuration($this$minutes, DurationUnit.MINUTES);
        }

        public static /* synthetic */ void getMinutes-UwyO8pc$annotations(double d) {
        }

        private final long getHours-UwyO8pc(int $this$hours) {
            return DurationKt.toDuration($this$hours, DurationUnit.HOURS);
        }

        public static /* synthetic */ void getHours-UwyO8pc$annotations(int n) {
        }

        private final long getHours-UwyO8pc(long $this$hours) {
            return DurationKt.toDuration($this$hours, DurationUnit.HOURS);
        }

        public static /* synthetic */ void getHours-UwyO8pc$annotations(long l) {
        }

        private final long getHours-UwyO8pc(double $this$hours) {
            return DurationKt.toDuration($this$hours, DurationUnit.HOURS);
        }

        public static /* synthetic */ void getHours-UwyO8pc$annotations(double d) {
        }

        private final long getDays-UwyO8pc(int $this$days) {
            return DurationKt.toDuration($this$days, DurationUnit.DAYS);
        }

        public static /* synthetic */ void getDays-UwyO8pc$annotations(int n) {
        }

        private final long getDays-UwyO8pc(long $this$days) {
            return DurationKt.toDuration($this$days, DurationUnit.DAYS);
        }

        public static /* synthetic */ void getDays-UwyO8pc$annotations(long l) {
        }

        private final long getDays-UwyO8pc(double $this$days) {
            return DurationKt.toDuration($this$days, DurationUnit.DAYS);
        }

        public static /* synthetic */ void getDays-UwyO8pc$annotations(double d) {
        }

        public final long parse-UwyO8pc(@NotNull String value2) {
            long l;
            Intrinsics.checkNotNullParameter(value2, "value");
            try {
                l = DurationKt.access$parseDuration(value2, false);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid duration string format: '" + value2 + "'.", e);
            }
            return l;
        }

        public final long parseIsoString-UwyO8pc(@NotNull String value2) {
            long l;
            Intrinsics.checkNotNullParameter(value2, "value");
            try {
                l = DurationKt.access$parseDuration(value2, true);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid ISO duration string format: '" + value2 + "'.", e);
            }
            return l;
        }

        @Nullable
        public final Duration parseOrNull-FghU774(@NotNull String value2) {
            Duration duration;
            Intrinsics.checkNotNullParameter(value2, "value");
            try {
                duration = Duration.box-impl(DurationKt.access$parseDuration(value2, false));
            }
            catch (IllegalArgumentException e) {
                duration = null;
            }
            return duration;
        }

        @Nullable
        public final Duration parseIsoStringOrNull-FghU774(@NotNull String value2) {
            Duration duration;
            Intrinsics.checkNotNullParameter(value2, "value");
            try {
                duration = Duration.box-impl(DurationKt.access$parseDuration(value2, true));
            }
            catch (IllegalArgumentException e) {
                duration = null;
            }
            return duration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

