/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.DurationUnitKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u001a\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0007\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\t\u001a\u001c\u0010\r\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\n\u001a\u00020\u0003H\u0086\n\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u001c\u0010\r\u001a\u00020\u0003*\u00020\b2\u0006\u0010\n\u001a\u00020\u0003H\u0086\n\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u001f\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a0\u0010\u001c\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00002\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00120\u0019H\u0082\b\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a0\u0010\u001e\u001a\u00020\u0000*\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00002\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00120\u0019H\u0082\b\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a\u0017\u0010!\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b!\u0010\"\u001a\u0017\u0010$\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b$\u0010\"\u001a\u0017\u0010&\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b&\u0010\"\u001a\u0017\u0010(\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b(\u0010\"\u001a\u001f\u0010+\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b+\u0010,\u001a\u0017\u0010-\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b-\u0010\"\u001a\u0017\u0010.\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b.\u0010\"\"\u0014\u0010/\u001a\u00020\u00008\u0000X\u0081T\u00a2\u0006\u0006\n\u0004\b/\u00100\"\u0014\u00101\u001a\u00020\u00068\u0000X\u0081T\u00a2\u0006\u0006\n\u0004\b1\u00102\"\u0014\u00103\u001a\u00020\u00068\u0000X\u0081T\u00a2\u0006\u0006\n\u0004\b3\u00102\"\u0014\u00104\u001a\u00020\u00068\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b4\u00102"}, d2={"", "Lkotlin/time/DurationUnit;", "unit", "Lkotlin/time/Duration;", "toDuration", "(ILkotlin/time/DurationUnit;)J", "", "(JLkotlin/time/DurationUnit;)J", "", "(DLkotlin/time/DurationUnit;)J", "duration", "times-mvk6XK0", "(IJ)J", "times", "times-kIfJnKk", "(DJ)J", "", "value", "", "strictIso", "parseDuration", "(Ljava/lang/String;Z)J", "parseOverLongIsoComponent", "(Ljava/lang/String;)J", "startIndex", "Lkotlin/Function1;", "", "predicate", "substringWhile", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)Ljava/lang/String;", "skipWhile", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)I", "nanos", "nanosToMillis", "(J)J", "millis", "millisToNanos", "normalNanos", "durationOfNanos", "normalMillis", "durationOfMillis", "normalValue", "unitDiscriminator", "durationOf", "(JI)J", "durationOfNanosNormalized", "durationOfMillisNormalized", "NANOS_IN_MILLIS", "I", "MAX_NANOS", "J", "MAX_MILLIS", "MAX_NANOS_IN_MILLIS"})
public final class DurationKt {
    public static final int NANOS_IN_MILLIS = 1000000;
    public static final long MAX_NANOS = 4611686018426999999L;
    public static final long MAX_MILLIS = 0x3FFFFFFFFFFFFFFFL;
    private static final long MAX_NANOS_IN_MILLIS = 4611686018426L;

    public static final long toDuration(int $this$toDuration, @NotNull DurationUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        return unit.compareTo((Enum)DurationUnit.SECONDS) <= 0 ? DurationKt.durationOfNanos(DurationUnitKt.convertDurationUnitOverflow($this$toDuration, unit, DurationUnit.NANOSECONDS)) : DurationKt.toDuration((long)$this$toDuration, unit);
    }

    public static final long toDuration(long $this$toDuration, @NotNull DurationUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        long maxNsInUnit = DurationUnitKt.convertDurationUnitOverflow(4611686018426999999L, DurationUnit.NANOSECONDS, unit);
        boolean bl = -maxNsInUnit <= $this$toDuration ? $this$toDuration <= maxNsInUnit : false;
        if (bl) {
            return DurationKt.durationOfNanos(DurationUnitKt.convertDurationUnitOverflow($this$toDuration, unit, DurationUnit.NANOSECONDS));
        }
        long millis = DurationUnitKt.convertDurationUnit($this$toDuration, unit, DurationUnit.MILLISECONDS);
        return DurationKt.durationOfMillis(RangesKt.coerceIn(millis, -4611686018427387903L, 0x3FFFFFFFFFFFFFFFL));
    }

    public static final long toDuration(double $this$toDuration, @NotNull DurationUnit unit) {
        long l;
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        double valueInNs = DurationUnitKt.convertDurationUnit($this$toDuration, unit, DurationUnit.NANOSECONDS);
        if (!(!Double.isNaN(valueInNs))) {
            boolean bl = false;
            String string2 = "Duration value cannot be NaN.";
            throw new IllegalArgumentException(string2.toString());
        }
        long nanos = MathKt.roundToLong(valueInNs);
        boolean bl = -4611686018426999999L <= nanos ? nanos < 4611686018427000000L : false;
        if (bl) {
            l = DurationKt.durationOfNanos(nanos);
        } else {
            long millis = MathKt.roundToLong(DurationUnitKt.convertDurationUnit($this$toDuration, unit, DurationUnit.MILLISECONDS));
            l = DurationKt.durationOfMillisNormalized(millis);
        }
        return l;
    }

    private static final long times-mvk6XK0(int $this$times_u2dmvk6XK0, long duration) {
        return Duration.times-UwyO8pc(duration, $this$times_u2dmvk6XK0);
    }

    private static final long times-kIfJnKk(double $this$times_u2dkIfJnKk, long duration) {
        return Duration.times-UwyO8pc(duration, $this$times_u2dkIfJnKk);
    }

    private static final long parseDuration(String value2, boolean strictIso) {
        int length = value2.length();
        if (length == 0) {
            throw new IllegalArgumentException("The string is empty");
        }
        int index2 = 0;
        long result2 = Duration.Companion.getZERO-UwyO8pc();
        String infinityString = "Infinity";
        switch (value2.charAt(index2)) {
            case '+': 
            case '-': {
                ++index2;
            }
        }
        boolean hasSign = index2 > 0;
        boolean isNegative = hasSign && StringsKt.startsWith$default((CharSequence)value2, '-', false, 2, null);
        if (length <= index2) {
            throw new IllegalArgumentException("No components");
        }
        if (value2.charAt(index2) == 'P') {
            if (++index2 == length) {
                throw new IllegalArgumentException();
            }
            String nonDigitSymbols = "+-.";
            boolean isTimeComponent = false;
            DurationUnit prevUnit = null;
            while (index2 < length) {
                String component;
                int i$iv$iv;
                if (value2.charAt(index2) == 'T') {
                    if (isTimeComponent || ++index2 == length) {
                        throw new IllegalArgumentException();
                    }
                    isTimeComponent = true;
                    continue;
                }
                String $this$substringWhile$iv = value2;
                boolean $i$f$substringWhile22 = false;
                String string2 = $this$substringWhile$iv;
                String $this$skipWhile$iv$iv22 = $this$substringWhile$iv;
                boolean $i$f$skipWhile2 = false;
                for (i$iv$iv = index2; i$iv$iv < $this$skipWhile$iv$iv22.length(); ++i$iv$iv) {
                    char it = $this$skipWhile$iv$iv22.charAt(i$iv$iv);
                    boolean bl = false;
                    boolean bl2 = '0' <= it ? it < ':' : false;
                    if (!(bl2 || StringsKt.contains$default((CharSequence)nonDigitSymbols, it, false, 2, null))) break;
                }
                int $this$skipWhile$iv$iv22 = i$iv$iv;
                Intrinsics.checkNotNull(string2, "null cannot be cast to non-null type java.lang.String");
                Intrinsics.checkNotNullExpressionValue(string2.substring(index2, $this$skipWhile$iv$iv22), "substring(...)");
                if (((CharSequence)component).length() == 0) {
                    throw new IllegalArgumentException();
                }
                CharSequence $i$f$substringWhile22 = value2;
                if (!(0 <= (index2 += component.length()) ? index2 < $i$f$substringWhile22.length() : false)) {
                    int it = index2;
                    boolean bl = false;
                    throw new IllegalArgumentException("Missing unit for value " + component);
                }
                char unitChar = $i$f$substringWhile22.charAt(index2);
                ++index2;
                DurationUnit unit = DurationUnitKt.durationUnitByIsoChar(unitChar, isTimeComponent);
                if (prevUnit != null && prevUnit.compareTo((Enum)unit) <= 0) {
                    throw new IllegalArgumentException("Unexpected order of duration components");
                }
                prevUnit = unit;
                int dotIndex = StringsKt.indexOf$default((CharSequence)component, '.', 0, false, 6, null);
                if (unit == DurationUnit.SECONDS && dotIndex > 0) {
                    String whole;
                    String $i$f$skipWhile2 = component;
                    i$iv$iv = 0;
                    Intrinsics.checkNotNull($i$f$skipWhile2, "null cannot be cast to non-null type java.lang.String");
                    Intrinsics.checkNotNullExpressionValue($i$f$skipWhile2.substring(i$iv$iv, dotIndex), "substring(...)");
                    result2 = Duration.plus-LRDsOJo(result2, DurationKt.toDuration(DurationKt.parseOverLongIsoComponent(whole), unit));
                    String string3 = component;
                    Intrinsics.checkNotNull(string3, "null cannot be cast to non-null type java.lang.String");
                    String string4 = string3.substring(dotIndex);
                    Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                    result2 = Duration.plus-LRDsOJo(result2, DurationKt.toDuration(Double.parseDouble(string4), unit));
                    continue;
                }
                result2 = Duration.plus-LRDsOJo(result2, DurationKt.toDuration(DurationKt.parseOverLongIsoComponent(component), unit));
            }
        } else {
            if (strictIso) {
                throw new IllegalArgumentException();
            }
            if (StringsKt.regionMatches(value2, index2, infinityString, 0, Math.max(length - index2, infinityString.length()), true)) {
                result2 = Duration.Companion.getINFINITE-UwyO8pc();
            } else {
                boolean allowSpaces;
                DurationUnit prevUnit = null;
                boolean afterFirst = false;
                boolean bl = allowSpaces = !hasSign;
                if (hasSign && value2.charAt(index2) == '(' && StringsKt.last(value2) == ')') {
                    allowSpaces = true;
                    if (++index2 == --length) {
                        throw new IllegalArgumentException("No components");
                    }
                }
                while (index2 < length) {
                    String unitName;
                    int i$iv$iv;
                    String component;
                    int i$iv$iv2;
                    if (afterFirst && allowSpaces) {
                        int i$iv;
                        String $this$skipWhile$iv = value2;
                        boolean $i$f$skipWhile = false;
                        for (i$iv = index2; i$iv < $this$skipWhile$iv.length(); ++i$iv) {
                            char it = $this$skipWhile$iv.charAt(i$iv);
                            boolean bl3 = false;
                            if (!(it == ' ')) break;
                        }
                        index2 = i$iv;
                    }
                    afterFirst = true;
                    String $this$substringWhile$iv = value2;
                    boolean $i$f$substringWhile = false;
                    String it = $this$substringWhile$iv;
                    String $this$skipWhile$iv$iv422 = $this$substringWhile$iv;
                    boolean $i$f$skipWhile = false;
                    for (i$iv$iv2 = index2; i$iv$iv2 < $this$skipWhile$iv$iv422.length(); ++i$iv$iv2) {
                        char it2 = $this$skipWhile$iv$iv422.charAt(i$iv$iv2);
                        boolean bl4 = false;
                        boolean bl5 = '0' <= it2 ? it2 < ':' : false;
                        if (!(bl5 || it2 == '.')) break;
                    }
                    int $this$skipWhile$iv$iv422 = i$iv$iv2;
                    Intrinsics.checkNotNull(it, "null cannot be cast to non-null type java.lang.String");
                    Intrinsics.checkNotNullExpressionValue(it.substring(index2, $this$skipWhile$iv$iv422), "substring(...)");
                    if (((CharSequence)component).length() == 0) {
                        throw new IllegalArgumentException();
                    }
                    index2 += component.length();
                    String $this$substringWhile$iv2 = value2;
                    boolean $i$f$substringWhile2 = false;
                    String $this$skipWhile$iv$iv422 = $this$substringWhile$iv2;
                    String $this$skipWhile$iv$iv = $this$substringWhile$iv2;
                    boolean $i$f$skipWhile3 = false;
                    for (i$iv$iv = index2; i$iv$iv < $this$skipWhile$iv$iv.length(); ++i$iv$iv) {
                        char it3 = $this$skipWhile$iv$iv.charAt(i$iv$iv);
                        boolean bl6 = false;
                        boolean bl7 = 'a' <= it3 ? it3 < '{' : false;
                        if (!bl7) break;
                    }
                    int n = i$iv$iv;
                    Intrinsics.checkNotNull($this$skipWhile$iv$iv422, "null cannot be cast to non-null type java.lang.String");
                    Intrinsics.checkNotNullExpressionValue($this$skipWhile$iv$iv422.substring(index2, n), "substring(...)");
                    index2 += unitName.length();
                    DurationUnit unit = DurationUnitKt.durationUnitByShortName(unitName);
                    if (prevUnit != null && prevUnit.compareTo((Enum)unit) <= 0) {
                        throw new IllegalArgumentException("Unexpected order of duration components");
                    }
                    prevUnit = unit;
                    int dotIndex = StringsKt.indexOf$default((CharSequence)component, '.', 0, false, 6, null);
                    if (dotIndex > 0) {
                        String whole;
                        String string5 = component;
                        int n2 = 0;
                        Intrinsics.checkNotNull(string5, "null cannot be cast to non-null type java.lang.String");
                        Intrinsics.checkNotNullExpressionValue(string5.substring(n2, dotIndex), "substring(...)");
                        result2 = Duration.plus-LRDsOJo(result2, DurationKt.toDuration(Long.parseLong(whole), unit));
                        String string6 = component;
                        Intrinsics.checkNotNull(string6, "null cannot be cast to non-null type java.lang.String");
                        String string7 = string6.substring(dotIndex);
                        Intrinsics.checkNotNullExpressionValue(string7, "substring(...)");
                        result2 = Duration.plus-LRDsOJo(result2, DurationKt.toDuration(Double.parseDouble(string7), unit));
                        if (index2 >= length) continue;
                        throw new IllegalArgumentException("Fractional component must be last");
                    }
                    result2 = Duration.plus-LRDsOJo(result2, DurationKt.toDuration(Long.parseLong(component), unit));
                }
            }
        }
        return isNegative ? Duration.unaryMinus-UwyO8pc(result2) : result2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final long parseOverLongIsoComponent(String value2) {
        long l;
        int n;
        int length;
        block8: {
            length = value2.length();
            int startIndex = 0;
            if (length > 0 && StringsKt.contains$default((CharSequence)"+-", value2.charAt(0), false, 2, null)) {
                n = startIndex;
                startIndex = n + 1;
            }
            if (length - startIndex > 16) {
                boolean bl = false;
                int firstNonZero = startIndex;
                for (int index2 = startIndex; index2 < length; ++index2) {
                    char c = value2.charAt(index2);
                    if (c == '0') {
                        if (firstNonZero != index2) continue;
                        ++firstNonZero;
                        continue;
                    }
                    boolean bl2 = '1' <= c ? c < ':' : false;
                    if (bl2) {
                        continue;
                    }
                    break block8;
                }
                if (length - firstNonZero > 16) {
                    if (value2.charAt(0) != '-') return Long.MAX_VALUE;
                    return Long.MIN_VALUE;
                }
            }
        }
        if (StringsKt.startsWith$default(value2, "+", false, 2, null) && length > 1) {
            n = value2.charAt(1);
            boolean bl = 48 <= n ? n < 58 : false;
            if (bl) {
                l = Long.parseLong(StringsKt.drop(value2, 1));
                return l;
            }
        }
        l = Long.parseLong(value2);
        return l;
    }

    private static final String substringWhile(String $this$substringWhile, int startIndex, Function1<? super Character, Boolean> predicate) {
        int i$iv;
        boolean $i$f$substringWhile = false;
        String string2 = $this$substringWhile;
        String $this$skipWhile$iv = $this$substringWhile;
        boolean $i$f$skipWhile = false;
        for (i$iv = startIndex; i$iv < $this$skipWhile$iv.length() && predicate.invoke(Character.valueOf($this$skipWhile$iv.charAt(i$iv))).booleanValue(); ++i$iv) {
        }
        int n = i$iv;
        Intrinsics.checkNotNull(string2, "null cannot be cast to non-null type java.lang.String");
        String string3 = string2.substring(startIndex, n);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        return string3;
    }

    private static final int skipWhile(String $this$skipWhile, int startIndex, Function1<? super Character, Boolean> predicate) {
        int i;
        boolean $i$f$skipWhile = false;
        for (i = startIndex; i < $this$skipWhile.length() && predicate.invoke(Character.valueOf($this$skipWhile.charAt(i))).booleanValue(); ++i) {
        }
        return i;
    }

    private static final long nanosToMillis(long nanos) {
        return nanos / (long)1000000;
    }

    private static final long millisToNanos(long millis) {
        return millis * (long)1000000;
    }

    private static final long durationOfNanos(long normalNanos) {
        return Duration.constructor-impl(normalNanos << 1);
    }

    private static final long durationOfMillis(long normalMillis) {
        return Duration.constructor-impl((normalMillis << 1) + 1L);
    }

    private static final long durationOf(long normalValue, int unitDiscriminator) {
        return Duration.constructor-impl((normalValue << 1) + (long)unitDiscriminator);
    }

    private static final long durationOfNanosNormalized(long nanos) {
        return (-4611686018426999999L <= nanos ? nanos < 4611686018427000000L : false) ? DurationKt.durationOfNanos(nanos) : DurationKt.durationOfMillis(DurationKt.nanosToMillis(nanos));
    }

    private static final long durationOfMillisNormalized(long millis) {
        return (-4611686018426L <= millis ? millis < 4611686018427L : false) ? DurationKt.durationOfNanos(DurationKt.millisToNanos(millis)) : DurationKt.durationOfMillis(RangesKt.coerceIn(millis, -4611686018427387903L, 0x3FFFFFFFFFFFFFFFL));
    }

    public static final /* synthetic */ long access$parseDuration(String value2, boolean strictIso) {
        return DurationKt.parseDuration(value2, strictIso);
    }

    public static final /* synthetic */ long access$durationOf(long normalValue, int unitDiscriminator) {
        return DurationKt.durationOf(normalValue, unitDiscriminator);
    }

    public static final /* synthetic */ long access$durationOfNanosNormalized(long nanos) {
        return DurationKt.durationOfNanosNormalized(nanos);
    }

    public static final /* synthetic */ long access$durationOfMillisNormalized(long millis) {
        return DurationKt.durationOfMillisNormalized(millis);
    }

    public static final /* synthetic */ long access$nanosToMillis(long nanos) {
        return DurationKt.nanosToMillis(nanos);
    }

    public static final /* synthetic */ long access$millisToNanos(long millis) {
        return DurationKt.millisToNanos(millis);
    }

    public static final /* synthetic */ long access$durationOfNanos(long normalNanos) {
        return DurationKt.durationOfNanos(normalNanos);
    }

    public static final /* synthetic */ long access$durationOfMillis(long normalMillis) {
        return DurationKt.durationOfMillis(normalMillis);
    }
}

