/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableList;

import java.util.Arrays;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.implementations.immutableList.AbstractPersistentList;
import kotlinx.collections.immutable.implementations.immutableList.ObjectRef;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVectorIterator;
import kotlinx.collections.immutable.implementations.immutableList.SmallPersistentVector;
import kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import kotlinx.collections.immutable.internal.CommonFunctionsKt;
import kotlinx.collections.immutable.internal.ListImplementation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010*\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0003B7\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\r\u001a\u00028\u0000H\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00028\u0000H\u0017\u00a2\u0006\u0004\b\u000e\u0010\u0011J\u001f\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0018\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018JI\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ7\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u001e\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000!2\u0006\u0010\u0010\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\"\u0010#JA\u0010%\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b%\u0010&J5\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010'\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b(\u0010)JE\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004H\u0002\u00a2\u0006\u0004\b,\u0010-JA\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0010\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\b2\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004H\u0002\u00a2\u0006\u0004\b.\u0010/J)\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020100H\u0017\u00a2\u0006\u0004\b3\u00104J\u001d\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0010\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b5\u00106J?\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b7\u0010&J=\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010'\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b8\u00109J\u000f\u0010'\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b'\u0010:J%\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00028\u0000H\u0017\u00a2\u0006\u0004\b;\u0010\u0011JA\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\b\u0010<\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0004\b=\u0010>R\u001c\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010?R\u0014\u0010\n\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010@R\u001a\u0010\t\u001a\u00020\b8\u0016X\u0097\u0004\u00a2\u0006\f\n\u0004\b\t\u0010@\u001a\u0004\bA\u0010:R\u001c\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010?"}, d2={"Lkotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "E", "Lkotlinx/collections/immutable/PersistentList;", "Lkotlinx/collections/immutable/implementations/immutableList/AbstractPersistentList;", "", "", "root", "tail", "", "size", "rootShift", "<init>", "([Ljava/lang/Object;[Ljava/lang/Object;II)V", "element", "add", "(Ljava/lang/Object;)Lkotlinx/collections/immutable/PersistentList;", "index", "(ILjava/lang/Object;)Lkotlinx/collections/immutable/PersistentList;", "bufferFor", "(I)[Ljava/lang/Object;", "Lkotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;", "builder", "()Lkotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;", "get", "(I)Ljava/lang/Object;", "shift", "Lkotlinx/collections/immutable/implementations/immutableList/ObjectRef;", "elementCarry", "insertIntoRoot", "([Ljava/lang/Object;IILjava/lang/Object;Lkotlinx/collections/immutable/implementations/immutableList/ObjectRef;)[Ljava/lang/Object;", "tailIndex", "insertIntoTail", "([Ljava/lang/Object;ILjava/lang/Object;)Lkotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "", "listIterator", "(I)Ljava/util/ListIterator;", "tailCarry", "pullLastBuffer", "([Ljava/lang/Object;IILkotlinx/collections/immutable/implementations/immutableList/ObjectRef;)[Ljava/lang/Object;", "rootSize", "pullLastBufferFromRoot", "([Ljava/lang/Object;II)Lkotlinx/collections/immutable/PersistentList;", "filledTail", "newTail", "pushFilledTail", "([Ljava/lang/Object;[Ljava/lang/Object;[Ljava/lang/Object;)Lkotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "pushTail", "([Ljava/lang/Object;I[Ljava/lang/Object;)[Ljava/lang/Object;", "Lkotlin/Function1;", "", "predicate", "removeAll", "(Lkotlin/jvm/functions/Function1;)Lkotlinx/collections/immutable/PersistentList;", "removeAt", "(I)Lkotlinx/collections/immutable/PersistentList;", "removeFromRootAt", "removeFromTailAt", "([Ljava/lang/Object;III)Lkotlinx/collections/immutable/PersistentList;", "()I", "set", "e", "setInRoot", "([Ljava/lang/Object;IILjava/lang/Object;)[Ljava/lang/Object;", "[Ljava/lang/Object;", "I", "getSize"})
public final class PersistentVector<E>
extends AbstractPersistentList<E> {
    @NotNull
    private final Object[] root;
    @NotNull
    private final Object[] tail;
    private final int size;
    private final int rootShift;

    public PersistentVector(@NotNull Object[] root, @NotNull Object[] tail, int size, int rootShift) {
        Intrinsics.checkNotNullParameter(root, "root");
        Intrinsics.checkNotNullParameter(tail, "tail");
        this.root = root;
        this.tail = tail;
        this.size = size;
        this.rootShift = rootShift;
        if (!(this.size() > 32)) {
            boolean bl = false;
            String string2 = "Trie-based persistent vector should have at least 33 elements, got " + this.size();
            throw new IllegalArgumentException(string2.toString());
        }
        CommonFunctionsKt.assert(this.size() - UtilsKt.rootSize(this.size()) <= RangesKt.coerceAtMost(this.tail.length, 32));
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private final int rootSize() {
        return UtilsKt.rootSize(this.size());
    }

    @Override
    @NotNull
    public PersistentList<E> add(E element) {
        int tailSize = this.size() - this.rootSize();
        if (tailSize < 32) {
            Object[] objectArray = Arrays.copyOf(this.tail, 32);
            Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
            Object[] newTail = objectArray;
            newTail[tailSize] = element;
            return new PersistentVector<E>(this.root, newTail, this.size() + 1, this.rootShift);
        }
        Object[] newTail = UtilsKt.presizedBufferWith(element);
        return this.pushFilledTail(this.root, this.tail, newTail);
    }

    private final PersistentVector<E> pushFilledTail(Object[] root, Object[] filledTail, Object[] newTail) {
        if (this.size() >> 5 > 1 << this.rootShift) {
            Object[] newRoot = UtilsKt.presizedBufferWith(root);
            int newRootShift = this.rootShift + 5;
            newRoot = this.pushTail(newRoot, newRootShift, filledTail);
            return new PersistentVector<E>(newRoot, newTail, this.size() + 1, newRootShift);
        }
        Object[] newRoot = this.pushTail(root, this.rootShift, filledTail);
        return new PersistentVector<E>(newRoot, newTail, this.size() + 1, this.rootShift);
    }

    private final Object[] pushTail(Object[] root, int shift, Object[] tail) {
        Object[] objectArray;
        int bufferIndex;
        block3: {
            block2: {
                bufferIndex = UtilsKt.indexSegment(this.size() - 1, shift);
                objectArray = root;
                if (root == null) break block2;
                Object[] objectArray2 = Arrays.copyOf(objectArray, 32);
                Intrinsics.checkNotNullExpressionValue(objectArray2, "copyOf(...)");
                objectArray = objectArray2;
                if (objectArray2 != null) break block3;
            }
            objectArray = new Object[32];
        }
        Object[] newRootNode = objectArray;
        newRootNode[bufferIndex] = shift == 5 ? tail : this.pushTail((Object[])newRootNode[bufferIndex], shift - 5, tail);
        return newRootNode;
    }

    @Override
    @NotNull
    public PersistentList<E> add(int index2, E element) {
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index2, this.size());
        if (index2 == this.size()) {
            return this.add(element);
        }
        int rootSize = this.rootSize();
        if (index2 >= rootSize) {
            return this.insertIntoTail(this.root, index2 - rootSize, element);
        }
        ObjectRef elementCarry = new ObjectRef(null);
        Object[] newRoot = this.insertIntoRoot(this.root, this.rootShift, index2, element, elementCarry);
        return this.insertIntoTail(newRoot, 0, elementCarry.getValue());
    }

    private final PersistentVector<E> insertIntoTail(Object[] root, int tailIndex, Object element) {
        int tailSize = this.size() - this.rootSize();
        Object[] objectArray = Arrays.copyOf(this.tail, 32);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        Object[] newTail = objectArray;
        if (tailSize < 32) {
            ArraysKt.copyInto(this.tail, newTail, tailIndex + 1, tailIndex, tailSize);
            newTail[tailIndex] = element;
            return new PersistentVector<E>(root, newTail, this.size() + 1, this.rootShift);
        }
        Object lastElement = this.tail[31];
        ArraysKt.copyInto(this.tail, newTail, tailIndex + 1, tailIndex, tailSize - 1);
        newTail[tailIndex] = element;
        return this.pushFilledTail(root, newTail, UtilsKt.presizedBufferWith(lastElement));
    }

    private final Object[] insertIntoRoot(Object[] root, int shift, int index2, Object element, ObjectRef elementCarry) {
        int bufferIndex = UtilsKt.indexSegment(index2, shift);
        if (shift == 0) {
            Object[] objectArray;
            if (bufferIndex == 0) {
                objectArray = new Object[32];
            } else {
                Object[] objectArray2 = Arrays.copyOf(root, 32);
                objectArray = objectArray2;
                Intrinsics.checkNotNullExpressionValue(objectArray2, "copyOf(...)");
            }
            Object[] newRoot = objectArray;
            ArraysKt.copyInto(root, newRoot, bufferIndex + 1, bufferIndex, 31);
            elementCarry.setValue(root[31]);
            newRoot[bufferIndex] = element;
            return newRoot;
        }
        Object[] objectArray = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        Object[] newRoot = objectArray;
        int lowerLevelShift = shift - 5;
        Object object = root[bufferIndex];
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        newRoot[bufferIndex] = this.insertIntoRoot((Object[])object, lowerLevelShift, index2, element, elementCarry);
        for (int i = bufferIndex + 1; i < 32 && newRoot[i] != null; ++i) {
            Object object2 = root[i];
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            newRoot[i] = this.insertIntoRoot((Object[])object2, lowerLevelShift, 0, elementCarry.getValue(), elementCarry);
        }
        return newRoot;
    }

    @Override
    @NotNull
    public PersistentList<E> removeAt(int index2) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index2, this.size());
        int rootSize = this.rootSize();
        if (index2 >= rootSize) {
            return this.removeFromTailAt(this.root, rootSize, this.rootShift, index2 - rootSize);
        }
        Object[] newRoot = this.removeFromRootAt(this.root, this.rootShift, index2, new ObjectRef(this.tail[0]));
        return this.removeFromTailAt(newRoot, rootSize, this.rootShift, 0);
    }

    private final PersistentList<E> removeFromTailAt(Object[] root, int rootSize, int shift, int index2) {
        int tailSize = this.size() - rootSize;
        CommonFunctionsKt.assert(index2 < tailSize);
        if (tailSize == 1) {
            return this.pullLastBufferFromRoot(root, rootSize, shift);
        }
        Object[] objectArray = Arrays.copyOf(this.tail, 32);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        Object[] newTail = objectArray;
        if (index2 < tailSize - 1) {
            ArraysKt.copyInto(this.tail, newTail, index2, index2 + 1, tailSize);
        }
        newTail[tailSize - 1] = null;
        return new PersistentVector<E>(root, newTail, rootSize + tailSize - 1, shift);
    }

    private final PersistentList<E> pullLastBufferFromRoot(Object[] root, int rootSize, int shift) {
        if (shift == 0) {
            Object[] objectArray;
            if (root.length == 33) {
                Object[] objectArray2 = Arrays.copyOf(root, 32);
                objectArray = objectArray2;
                Intrinsics.checkNotNullExpressionValue(objectArray2, "copyOf(...)");
            } else {
                objectArray = root;
            }
            Object[] buffer = objectArray;
            return new SmallPersistentVector(buffer);
        }
        ObjectRef tailCarry = new ObjectRef(null);
        Object[] objectArray = this.pullLastBuffer(root, shift, rootSize - 1, tailCarry);
        Intrinsics.checkNotNull(objectArray);
        Object[] newRoot = objectArray;
        Object object = tailCarry.getValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        Object[] newTail = (Object[])object;
        if (newRoot[1] == null) {
            Object object2 = newRoot[0];
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            Object[] lowerLevelRoot = (Object[])object2;
            return new PersistentVector<E>(lowerLevelRoot, newTail, rootSize, shift - 5);
        }
        return new PersistentVector<E>(newRoot, newTail, rootSize, shift);
    }

    private final Object[] pullLastBuffer(Object[] root, int shift, int index2, ObjectRef tailCarry) {
        Object[] newBufferAtIndex;
        Object[] objectArray;
        int bufferIndex = UtilsKt.indexSegment(index2, shift);
        if (shift == 5) {
            tailCarry.setValue(root[bufferIndex]);
            objectArray = null;
        } else {
            Object object = root[bufferIndex];
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            objectArray = newBufferAtIndex = this.pullLastBuffer((Object[])object, shift - 5, index2, tailCarry);
        }
        if (newBufferAtIndex == null && bufferIndex == 0) {
            return null;
        }
        Object[] objectArray2 = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue(objectArray2, "copyOf(...)");
        Object[] newRoot = objectArray2;
        newRoot[bufferIndex] = newBufferAtIndex;
        return newRoot;
    }

    private final Object[] removeFromRootAt(Object[] root, int shift, int index2, ObjectRef tailCarry) {
        int bufferIndex = UtilsKt.indexSegment(index2, shift);
        if (shift == 0) {
            Object[] objectArray;
            if (bufferIndex == 0) {
                objectArray = new Object[32];
            } else {
                Object[] objectArray2 = Arrays.copyOf(root, 32);
                objectArray = objectArray2;
                Intrinsics.checkNotNullExpressionValue(objectArray2, "copyOf(...)");
            }
            Object[] newRoot = objectArray;
            ArraysKt.copyInto(root, newRoot, bufferIndex, bufferIndex + 1, 32);
            newRoot[31] = tailCarry.getValue();
            tailCarry.setValue(root[bufferIndex]);
            return newRoot;
        }
        int bufferLastIndex = 31;
        if (root[bufferLastIndex] == null) {
            bufferLastIndex = UtilsKt.indexSegment(this.rootSize() - 1, shift);
        }
        Object[] objectArray = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        Object[] newRoot = objectArray;
        int lowerLevelShift = shift - 5;
        int i = bufferLastIndex;
        int n = bufferIndex + 1;
        if (n <= i) {
            while (true) {
                Object object = newRoot[i];
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                newRoot[i] = this.removeFromRootAt((Object[])object, lowerLevelShift, 0, tailCarry);
                if (i == n) break;
                --i;
            }
        }
        Object object = newRoot[bufferIndex];
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        newRoot[bufferIndex] = this.removeFromRootAt((Object[])object, lowerLevelShift, index2, tailCarry);
        return newRoot;
    }

    @Override
    @NotNull
    public PersistentList<E> removeAll(@NotNull Function1<? super E, Boolean> predicate) {
        PersistentList.Builder builder2;
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        PersistentList.Builder it = builder2 = this.builder();
        boolean bl = false;
        ((PersistentVectorBuilder)it).removeAllWithPredicate(predicate);
        return ((PersistentVectorBuilder)builder2).build();
    }

    @Override
    @NotNull
    public PersistentVectorBuilder<E> builder() {
        return new PersistentVectorBuilder(this, this.root, this.tail, this.rootShift);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index2) {
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index2, this.size());
        return new PersistentVectorIterator<Object>(this.root, this.tail, index2, this.size(), this.rootShift / 5 + 1);
    }

    private final Object[] bufferFor(int index2) {
        if (this.rootSize() <= index2) {
            return this.tail;
        }
        Object[] buffer = this.root;
        for (int shift = this.rootShift; shift > 0; shift -= 5) {
            Object object = buffer[UtilsKt.indexSegment(index2, shift)];
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            buffer = (Object[])object;
        }
        return buffer;
    }

    @Override
    public E get(int index2) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index2, this.size());
        Object[] buffer = this.bufferFor(index2);
        return (E)buffer[index2 & 0x1F];
    }

    @Override
    @NotNull
    public PersistentList<E> set(int index2, E element) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index2, this.size());
        if (this.rootSize() <= index2) {
            Object[] objectArray = Arrays.copyOf(this.tail, 32);
            Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
            Object[] newTail = objectArray;
            newTail[index2 & 0x1F] = element;
            return new PersistentVector<E>(this.root, newTail, this.size(), this.rootShift);
        }
        Object[] newRoot = this.setInRoot(this.root, this.rootShift, index2, element);
        return new PersistentVector<E>(newRoot, this.tail, this.size(), this.rootShift);
    }

    private final Object[] setInRoot(Object[] root, int shift, int index2, Object e) {
        int bufferIndex = UtilsKt.indexSegment(index2, shift);
        Object[] objectArray = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
        Object[] newRoot = objectArray;
        if (shift == 0) {
            newRoot[bufferIndex] = e;
        } else {
            Object object = newRoot[bufferIndex];
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            newRoot[bufferIndex] = this.setInRoot((Object[])object, shift - 5, index2, e);
        }
        return newRoot;
    }
}

