/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableSet;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableSet;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.PersistentSet;
import kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSet;
import kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetMutableIterator;
import kotlinx.collections.immutable.implementations.immutableSet.TrieNode;
import kotlinx.collections.immutable.internal.DeltaCounter;
import kotlinx.collections.immutable.internal.MutabilityOwnership;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000e\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0015\u0010\u000bJ\u001d\u0010\u0016\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u000fJ\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0097\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\t2\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u000bJ\u001d\u0010\u001b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u000fJ\u001d\u0010\u001c\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u000fR$\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d8\u0000@BX\u0080\u000e\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R0\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000#2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000#8\u0001@BX\u0081\u000e\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R$\u0010)\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020(8\u0001@BX\u0081\u000e\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010-R*\u0010/\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u001d8\u0016@VX\u0097\u000e\u00a2\u0006\u0012\n\u0004\b/\u0010 \u001a\u0004\b0\u0010\"\"\u0004\b1\u00102"}, d2={"Lkotlinx/collections/immutable/implementations/immutableSet/PersistentHashSetBuilder;", "E", "Lkotlin/collections/AbstractMutableSet;", "Lkotlinx/collections/immutable/PersistentSet$Builder;", "Lkotlinx/collections/immutable/implementations/immutableSet/PersistentHashSet;", "set", "<init>", "(Lkotlinx/collections/immutable/implementations/immutableSet/PersistentHashSet;)V", "element", "", "add", "(Ljava/lang/Object;)Z", "", "elements", "addAll", "(Ljava/util/Collection;)Z", "build", "()Lkotlinx/collections/immutable/implementations/immutableSet/PersistentHashSet;", "", "clear", "()V", "contains", "containsAll", "", "iterator", "()Ljava/util/Iterator;", "remove", "removeAll", "retainAll", "", "<set-?>", "modCount", "I", "getModCount$kotlinx_collections_immutable", "()I", "Lkotlinx/collections/immutable/implementations/immutableSet/TrieNode;", "node", "Lkotlinx/collections/immutable/implementations/immutableSet/TrieNode;", "getNode$kotlinx_collections_immutable", "()Lkotlinx/collections/immutable/implementations/immutableSet/TrieNode;", "Lkotlinx/collections/immutable/internal/MutabilityOwnership;", "ownership", "Lkotlinx/collections/immutable/internal/MutabilityOwnership;", "getOwnership$kotlinx_collections_immutable", "()Lkotlinx/collections/immutable/internal/MutabilityOwnership;", "Lkotlinx/collections/immutable/implementations/immutableSet/PersistentHashSet;", "value", "size", "getSize", "setSize", "(I)V"})
public final class PersistentHashSetBuilder<E>
extends AbstractMutableSet<E>
implements PersistentSet.Builder<E> {
    @NotNull
    private PersistentHashSet<E> set;
    @NotNull
    private MutabilityOwnership ownership;
    @NotNull
    private TrieNode<E> node;
    private int modCount;
    private int size;

    public PersistentHashSetBuilder(@NotNull PersistentHashSet<E> set) {
        Intrinsics.checkNotNullParameter(set, "set");
        this.set = set;
        this.ownership = new MutabilityOwnership();
        this.node = this.set.getNode$kotlinx_collections_immutable();
        this.size = this.set.size();
    }

    @NotNull
    public final MutabilityOwnership getOwnership$kotlinx_collections_immutable() {
        return this.ownership;
    }

    @NotNull
    public final TrieNode<E> getNode$kotlinx_collections_immutable() {
        return this.node;
    }

    public final int getModCount$kotlinx_collections_immutable() {
        return this.modCount;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int value2) {
        this.size = value2;
        int n = this.modCount;
        this.modCount = n + 1;
    }

    @Override
    @NotNull
    public PersistentHashSet<E> build() {
        PersistentHashSet<E> persistentHashSet;
        if (this.node == this.set.getNode$kotlinx_collections_immutable()) {
            persistentHashSet = this.set;
        } else {
            this.ownership = new MutabilityOwnership();
            persistentHashSet = new PersistentHashSet<E>(this.node, this.size());
        }
        this.set = persistentHashSet;
        return this.set;
    }

    @Override
    public boolean contains(Object element) {
        Object object = element;
        return this.node.contains(object != null ? object.hashCode() : 0, element, 0);
    }

    @Override
    public boolean add(E element) {
        int size = this.size();
        E e = element;
        this.node = this.node.mutableAdd(e != null ? e.hashCode() : 0, element, 0, this);
        return size != this.size();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> elements) {
        PersistentHashSet set;
        Intrinsics.checkNotNullParameter(elements, "elements");
        PersistentSet persistentSet = elements instanceof PersistentHashSet ? (PersistentHashSet)elements : null;
        if (persistentSet == null) {
            PersistentHashSetBuilder persistentHashSetBuilder = elements instanceof PersistentHashSetBuilder ? (PersistentHashSetBuilder)elements : null;
            persistentSet = persistentHashSetBuilder != null ? persistentHashSetBuilder.build() : null;
        }
        if ((set = persistentSet) != null) {
            DeltaCounter deltaCounter = new DeltaCounter(0, 1, null);
            int size = this.size();
            TrieNode<E> result2 = this.node.mutableAddAll(set.getNode$kotlinx_collections_immutable(), 0, deltaCounter, this);
            int newSize = size + elements.size() - deltaCounter.getCount();
            if (size != newSize) {
                this.node = result2;
                this.setSize(newSize);
            }
            return size != this.size();
        }
        return super.addAll(elements);
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        PersistentHashSet set;
        Intrinsics.checkNotNullParameter(elements, "elements");
        PersistentSet persistentSet = elements instanceof PersistentHashSet ? (PersistentHashSet)elements : null;
        if (persistentSet == null) {
            PersistentHashSetBuilder persistentHashSetBuilder = elements instanceof PersistentHashSetBuilder ? (PersistentHashSetBuilder)elements : null;
            persistentSet = persistentHashSetBuilder != null ? persistentHashSetBuilder.build() : null;
        }
        if ((set = persistentSet) != null) {
            DeltaCounter deltaCounter = new DeltaCounter(0, 1, null);
            int size = this.size();
            Object result2 = this.node.mutableRetainAll(set.getNode$kotlinx_collections_immutable(), 0, deltaCounter, this);
            int newSize = deltaCounter.getCount();
            if (newSize == 0) {
                this.clear();
            } else if (newSize != size) {
                Intrinsics.checkNotNull(result2, "null cannot be cast to non-null type kotlinx.collections.immutable.implementations.immutableSet.TrieNode<E of kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetBuilder>");
                this.node = (TrieNode)result2;
                this.setSize(newSize);
            }
            return size != this.size();
        }
        return super.retainAll(elements);
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        PersistentHashSet set;
        Intrinsics.checkNotNullParameter(elements, "elements");
        PersistentSet persistentSet = elements instanceof PersistentHashSet ? (PersistentHashSet)elements : null;
        if (persistentSet == null) {
            PersistentHashSetBuilder persistentHashSetBuilder = elements instanceof PersistentHashSetBuilder ? (PersistentHashSetBuilder)elements : null;
            persistentSet = persistentHashSetBuilder != null ? persistentHashSetBuilder.build() : null;
        }
        if ((set = persistentSet) != null) {
            DeltaCounter counter = new DeltaCounter(0, 1, null);
            int size = this.size();
            Object result2 = this.node.mutableRemoveAll(set.getNode$kotlinx_collections_immutable(), 0, counter, this);
            int newSize = size - counter.getCount();
            if (newSize == 0) {
                this.clear();
            } else if (newSize != size) {
                Intrinsics.checkNotNull(result2, "null cannot be cast to non-null type kotlinx.collections.immutable.implementations.immutableSet.TrieNode<E of kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetBuilder>");
                this.node = (TrieNode)result2;
                this.setSize(newSize);
            }
            return size != this.size();
        }
        return super.removeAll(elements);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (elements instanceof PersistentHashSet) {
            return this.node.containsAll(((PersistentHashSet)elements).getNode$kotlinx_collections_immutable(), 0);
        }
        if (elements instanceof PersistentHashSetBuilder) {
            return this.node.containsAll(((PersistentHashSetBuilder)elements).node, 0);
        }
        return super.containsAll(elements);
    }

    @Override
    public boolean remove(Object element) {
        int size = this.size();
        Object object = element;
        this.node = this.node.mutableRemove(object != null ? object.hashCode() : 0, element, 0, this);
        return size != this.size();
    }

    @Override
    public void clear() {
        TrieNode trieNode = TrieNode.Companion.getEMPTY$kotlinx_collections_immutable();
        Intrinsics.checkNotNull(trieNode, "null cannot be cast to non-null type kotlinx.collections.immutable.implementations.immutableSet.TrieNode<E of kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetBuilder>");
        this.node = trieNode;
        this.setSize(0);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new PersistentHashSetMutableIterator(this);
    }
}

