/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamContext;

public class EntryStream<K, V>
extends AbstractStreamEx<Map.Entry<K, V>, EntryStream<K, V>> {
    EntryStream(Stream<? extends Map.Entry<K, V>> stream, StreamContext context) {
        super(stream, context);
    }

    @Override
    EntryStream<K, V> supply(Stream<Map.Entry<K, V>> stream) {
        return new EntryStream<K, V>(stream, this.context);
    }

    static <K, V, M extends Map<K, V>> Consumer<? super Map.Entry<K, V>> toMapConsumer(M map2) {
        return entry -> EntryStream.addToMap(map2, entry.getKey(), Objects.requireNonNull(entry.getValue()));
    }

    public EntryStream<K, V> nonNullKeys() {
        return (EntryStream)this.filter((T e) -> e.getKey() != null);
    }

    public Map<K, V> toMap() {
        AbstractMap map2 = this.isParallel() ? new ConcurrentHashMap() : new HashMap();
        this.forEach(EntryStream.toMapConsumer(map2));
        return map2;
    }

    public Map<K, V> toImmutableMap() {
        Map<K, V> map2 = this.toMap();
        return map2.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map2);
    }
}

