/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.jdom.CDATA;
import org.jdom.CloneBase;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.ContentList;
import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.IllegalAddException;
import org.jdom.Parent;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.Verifier;

public final class Document
extends CloneBase
implements Serializable,
Parent {
    private transient ContentList content = new ContentList(this);
    private String baseUri;
    private transient HashMap<String, Object> propertyMap = null;
    private static final long serialVersionUID = 200L;

    public boolean hasRootElement() {
        return this.content.indexOfFirstElement() >= 0;
    }

    public Element getRootElement() {
        int index2 = this.content.indexOfFirstElement();
        if (index2 < 0) {
            throw new IllegalStateException("Root element not set");
        }
        return (Element)this.content.get(index2);
    }

    public DocType getDocType() {
        int index2 = this.content.indexOfDocType();
        if (index2 < 0) {
            return null;
        }
        return (DocType)this.content.get(index2);
    }

    public Document addContent(Content child) {
        this.content.add(child);
        return this;
    }

    public Content getContent(int index2) {
        return this.content.get(index2);
    }

    public List<Content> getContent() {
        if (!this.hasRootElement()) {
            throw new IllegalStateException("Root element not set");
        }
        return this.content;
    }

    public String toString() {
        Element rootElement;
        StringBuilder stringForm = new StringBuilder().append("[Document: ");
        DocType docType = this.getDocType();
        if (docType != null) {
            stringForm.append(docType).append(", ");
        } else {
            stringForm.append(" No DOCTYPE declaration, ");
        }
        Element element = rootElement = this.hasRootElement() ? this.getRootElement() : null;
        if (rootElement != null) {
            stringForm.append("Root is ").append(rootElement);
        } else {
            stringForm.append(" No root element");
        }
        stringForm.append("]");
        return stringForm.toString();
    }

    public boolean equals(Object ob) {
        return ob == this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Document clone() {
        Document doc = (Document)super.clone();
        doc.content = new ContentList(doc);
        for (int i = 0; i < this.content.size(); ++i) {
            Content obj = this.content.get(i);
            if (obj instanceof Element) {
                Element element = ((Element)obj).clone();
                doc.content.add(element);
                continue;
            }
            if (obj instanceof Comment) {
                Comment comment = ((Comment)obj).clone();
                doc.content.add(comment);
                continue;
            }
            if (obj instanceof ProcessingInstruction) {
                ProcessingInstruction pi = ((ProcessingInstruction)obj).clone();
                doc.content.add(pi);
                continue;
            }
            if (!(obj instanceof DocType)) continue;
            DocType dt = ((DocType)obj).clone();
            doc.content.add(dt);
        }
        return doc;
    }

    @Override
    public Parent getParent() {
        return null;
    }

    @Override
    public void canContainContent(Content child, int index2, boolean replace) {
        if (child instanceof Element) {
            int cre = this.content.indexOfFirstElement();
            if (replace && cre == index2) {
                return;
            }
            if (cre >= 0) {
                throw new IllegalAddException("Cannot add a second root element, only one is allowed");
            }
            if (this.content.indexOfDocType() >= index2) {
                throw new IllegalAddException("A root element cannot be added before the DocType");
            }
        }
        if (child instanceof DocType) {
            int cdt = this.content.indexOfDocType();
            if (replace && cdt == index2) {
                return;
            }
            if (cdt >= 0) {
                throw new IllegalAddException("Cannot add a second doctype, only one is allowed");
            }
            int firstElt = this.content.indexOfFirstElement();
            if (firstElt != -1 && firstElt < index2) {
                throw new IllegalAddException("A DocType cannot be added after the root element");
            }
        }
        if (child instanceof CDATA) {
            throw new IllegalAddException("A CDATA is not allowed at the document root");
        }
        if (child instanceof Text) {
            if (Verifier.isAllXMLWhitespace(((Text)child).getText())) {
                return;
            }
            throw new IllegalAddException("A Text is not allowed at the document root");
        }
        if (child instanceof EntityRef) {
            throw new IllegalAddException("An EntityRef is not allowed at the document root");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int cs = this.content.size();
        out.writeInt(cs);
        for (int i = 0; i < cs; ++i) {
            out.writeObject(this.getContent(i));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.content = new ContentList(this);
        int cs = in.readInt();
        while (--cs >= 0) {
            this.addContent((Content)in.readObject());
        }
    }
}

