/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.stubs.elements.KtClassLiteralExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtCollectionLiteralExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStringTemplateExpressionElementType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u000b\u001a\u00020\n*\u00020\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\u000f\u001a\u00020\u000e*\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\f\u0012\b\u0012\u0006*\u00020\n0\n0\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/ElementTypeUtils;", "", "<init>", "()V", "", "seq", "", "getKotlinBlockImbalanceCount", "(Ljava/lang/CharSequence;)I", "", "Lcom/intellij/psi/tree/IElementType;", "getOperationSymbol", "(Ljava/lang/String;)Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/lang/LighterASTNode;", "", "isExpression", "(Lcom/intellij/lang/LighterASTNode;)Z", "", "expressionSet", "Ljava/util/List;"})
public final class ElementTypeUtils {
    @NotNull
    public static final ElementTypeUtils INSTANCE = new ElementTypeUtils();
    @NotNull
    private static final List<IElementType> expressionSet;

    private ElementTypeUtils() {
    }

    public static final int getKotlinBlockImbalanceCount(@NotNull CharSequence seq) {
        Intrinsics.checkNotNullParameter(seq, "seq");
        KotlinLexer lexer = new KotlinLexer();
        lexer.start(seq);
        if (lexer.getTokenType() != KtTokens.LBRACE) {
            return Integer.MIN_VALUE;
        }
        lexer.advance();
        int balance = 1;
        while (!Intrinsics.areEqual(lexer.getTokenType(), KtTokens.EOF) && lexer.getTokenType() != null) {
            IElementType type2;
            if (balance == 0) {
                return Integer.MIN_VALUE;
            }
            if (type2 == KtTokens.LBRACE) {
                ++balance;
            } else if (type2 == KtTokens.RBRACE) {
                --balance;
            }
            lexer.advance();
        }
        return balance;
    }

    @NotNull
    public final IElementType getOperationSymbol(@NotNull String $this$getOperationSymbol) {
        Intrinsics.checkNotNullParameter($this$getOperationSymbol, "<this>");
        IElementType[] iElementTypeArray = KotlinExpressionParsing.ALL_OPERATIONS.getTypes();
        Intrinsics.checkNotNullExpressionValue(iElementTypeArray, "getTypes(...)");
        Object[] $this$forEach$iv = iElementTypeArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IElementType it = (IElementType)element$iv;
            boolean bl = false;
            if (!(it instanceof KtSingleValueToken) || !Intrinsics.areEqual(((KtSingleValueToken)it).getValue(), $this$getOperationSymbol)) continue;
            return it;
        }
        if (Intrinsics.areEqual($this$getOperationSymbol, "as?")) {
            KtToken ktToken = KtTokens.AS_SAFE;
            Intrinsics.checkNotNullExpressionValue(ktToken, "AS_SAFE");
            return ktToken;
        }
        KtToken ktToken = KtTokens.IDENTIFIER;
        Intrinsics.checkNotNullExpressionValue(ktToken, "IDENTIFIER");
        return ktToken;
    }

    public final boolean isExpression(@NotNull LighterASTNode $this$isExpression) {
        Intrinsics.checkNotNullParameter($this$isExpression, "<this>");
        IElementType iElementType = $this$isExpression.getTokenType();
        return iElementType instanceof KtNodeType || iElementType instanceof KtConstantExpressionElementType || iElementType instanceof KtStringTemplateExpressionElementType || iElementType instanceof KtClassLiteralExpressionElementType || iElementType instanceof KtCollectionLiteralExpressionElementType || expressionSet.contains(iElementType);
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtNodeTypes.REFERENCE_EXPRESSION, KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.LAMBDA_EXPRESSION, KtNodeTypes.FUN};
        expressionSet = CollectionsKt.listOf(iElementTypeArray);
    }
}

