/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\n\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000e\u0010\tR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00128BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019"}, d2={"Lorg/jetbrains/kotlin/KtPsiSourceFileLinesMapping;", "Lorg/jetbrains/kotlin/KtSourceFileLinesMapping;", "Lcom/intellij/psi/PsiFile;", "psiFile", "<init>", "(Lcom/intellij/psi/PsiFile;)V", "", "line", "getLineStartOffset", "(I)I", "offset", "Lkotlin/Pair;", "getLineAndColumnByOffset", "(I)Lkotlin/Pair;", "getLineByOffset", "Lcom/intellij/psi/PsiFile;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "Lcom/intellij/openapi/editor/Document;", "document$delegate", "Lkotlin/Lazy;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "document", "getLastOffset", "()I", "lastOffset", "getLinesCount", "linesCount"})
public final class KtPsiSourceFileLinesMapping
implements KtSourceFileLinesMapping {
    @NotNull
    private final PsiFile psiFile;
    @NotNull
    private final Lazy document$delegate;

    public KtPsiSourceFileLinesMapping(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter(psiFile, "psiFile");
        this.psiFile = psiFile;
        this.document$delegate = LazyKt.lazy(() -> KtPsiSourceFileLinesMapping.document_delegate$lambda$0(this));
    }

    @NotNull
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    private final Document getDocument() {
        Lazy lazy = this.document$delegate;
        return (Document)lazy.getValue();
    }

    @Override
    public int getLineStartOffset(int line) {
        Document document = this.getDocument();
        return document != null ? document.getLineStartOffset(line) : -1;
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> getLineAndColumnByOffset(int offset) {
        Object object;
        block3: {
            block2: {
                object = this.getDocument();
                if (object == null) break block2;
                Document it = object;
                boolean bl = false;
                int lineNumber = it.getLineNumber(offset);
                int lineStartOffset = it.getLineStartOffset(lineNumber);
                Pair<Integer, Integer> pair = TuplesKt.to(lineNumber, offset - lineStartOffset);
                object = pair;
                if (pair != null) break block3;
            }
            object = TuplesKt.to(-1, -1);
        }
        return object;
    }

    @Override
    public int getLineByOffset(int offset) {
        Document document = this.getDocument();
        return document != null ? document.getLineNumber(offset) : -1;
    }

    @Override
    public int getLastOffset() {
        Document document = this.getDocument();
        return document != null ? document.getTextLength() : -1;
    }

    @Override
    public int getLinesCount() {
        Document document = this.getDocument();
        return document != null ? document.getLineCount() : 0;
    }

    private static final Document document_delegate$lambda$0(KtPsiSourceFileLinesMapping this$0) {
        return this$0.psiFile.getViewProvider().getDocument();
    }
}

