/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.annotations;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotation;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaNamedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.types.KaClassErrorType;
import org.jetbrains.kotlin.analysis.api.types.KaStarTypeProjection;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeArgumentWithVariance;
import org.jetbrains.kotlin.analysis.api.types.KaTypeProjection;
import org.jetbrains.kotlin.analysis.api.types.KaUsualClassType;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\f\u001a\u00020\u000b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000f\u001a\u00020\u000b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0013\u001a\u00020\u000b*\u00060\tj\u0002`\n2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0016\u001a\u00020\u000b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0019\u001a\u00020\u000b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001d\u001a\u00020\u000b*\u00060\tj\u0002`\n2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010 \u001a\u00020\u000b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b \u0010!J\u001f\u0010#\u001a\u00020\u000b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b#\u0010$J%\u0010'\u001a\u00020\u000b*\u00060\tj\u0002`\n2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040%H\u0002\u00a2\u0006\u0004\b'\u0010(J%\u0010*\u001a\u00020\u000b*\u00060\tj\u0002`\n2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020)0%H\u0002\u00a2\u0006\u0004\b*\u0010(JR\u0010/\u001a\u00020\u000b\"\u0004\b\u0000\u0010+*\u00060\tj\u0002`\n2\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000%2\u0006\u0010-\u001a\u00020\u00062\u001c\u0010\u0007\u001a\u0018\u0012\b\u0012\u00060\tj\u0002`\n\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0.H\u0082\b\u00a2\u0006\u0004\b/\u00100"}, d2={"Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValueRenderer;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue;", "value", "", "render", "(Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue;)Ljava/lang/String;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "renderConstantValue", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue;)V", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue$ClassLiteralValue;", "renderKClassAnnotationValue", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue$ClassLiteralValue;)V", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "type", "renderType", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/types/KaType;)V", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue$ConstantValue;", "renderConstantAnnotationValue", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue$ConstantValue;)V", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue$EnumEntryValue;", "renderEnumEntryConstantValue", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue$EnumEntryValue;)V", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue$NestedAnnotationValue;", "application", "renderAnnotationConstantValue", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue$NestedAnnotationValue;)V", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotation;", "renderAnnotationApplication", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotation;)V", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue$ArrayValue;", "renderArrayConstantValue", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue$ArrayValue;)V", "", "list", "renderConstantValueList", "(Ljava/lang/StringBuilder;Ljava/util/Collection;)V", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaNamedAnnotationValue;", "renderNamedConstantValueList", "E", "collection", "separator", "Lkotlin/Function2;", "renderWithSeparator", "(Ljava/lang/StringBuilder;Ljava/util/Collection;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V"})
public final class KaAnnotationValueRenderer {
    @NotNull
    public static final KaAnnotationValueRenderer INSTANCE = new KaAnnotationValueRenderer();

    private KaAnnotationValueRenderer() {
    }

    @NotNull
    public final String render(@NotNull KaAnnotationValue value2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(value2, "value");
        StringBuilder $this$render_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.renderConstantValue($this$render_u24lambda_u240, value2);
        return stringBuilder.toString();
    }

    private final void renderConstantValue(StringBuilder $this$renderConstantValue, KaAnnotationValue value2) {
        KaAnnotationValue kaAnnotationValue = value2;
        if (kaAnnotationValue instanceof KaAnnotationValue.NestedAnnotationValue) {
            this.renderAnnotationConstantValue($this$renderConstantValue, (KaAnnotationValue.NestedAnnotationValue)value2);
        } else if (kaAnnotationValue instanceof KaAnnotationValue.ArrayValue) {
            this.renderArrayConstantValue($this$renderConstantValue, (KaAnnotationValue.ArrayValue)value2);
        } else if (kaAnnotationValue instanceof KaAnnotationValue.EnumEntryValue) {
            this.renderEnumEntryConstantValue($this$renderConstantValue, (KaAnnotationValue.EnumEntryValue)value2);
        } else if (kaAnnotationValue instanceof KaAnnotationValue.ConstantValue) {
            this.renderConstantAnnotationValue($this$renderConstantValue, (KaAnnotationValue.ConstantValue)value2);
        } else if (kaAnnotationValue instanceof KaAnnotationValue.UnsupportedValue) {
            $this$renderConstantValue.append("error(\"non-annotation value\")");
        } else if (kaAnnotationValue instanceof KaAnnotationValue.ClassLiteralValue) {
            this.renderKClassAnnotationValue($this$renderConstantValue, (KaAnnotationValue.ClassLiteralValue)value2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void renderKClassAnnotationValue(StringBuilder $this$renderKClassAnnotationValue, KaAnnotationValue.ClassLiteralValue value2) {
        this.renderType($this$renderKClassAnnotationValue, value2.getType());
        $this$renderKClassAnnotationValue.append("::class");
    }

    /*
     * WARNING - void declaration
     */
    private final void renderType(StringBuilder $this$renderType, KaType type2) {
        Object object;
        Object object2;
        if (!((Collection)type2.getAnnotations()).isEmpty()) {
            object2 = type2.getAnnotations().iterator();
            while (object2.hasNext()) {
                KaAnnotation annotation = (KaAnnotation)object2.next();
                $this$renderType.append('@');
                this.renderAnnotationApplication($this$renderType, annotation);
                $this$renderType.append(' ');
            }
        }
        if ((object2 = type2) instanceof KaUsualClassType) {
            ClassId classId = ((KaUsualClassType)type2).getClassId();
            StringBuilder stringBuilder = classId.isLocal() ? $this$renderType.append(RenderingUtilsKt.render(classId.getShortClassName())) : $this$renderType.append(RenderingUtilsKt.render(classId.asSingleFqName()));
            if (!((Collection)((KaUsualClassType)type2).getTypeArguments()).isEmpty()) {
                void collection$iv;
                $this$renderType.append('<');
                KaAnnotationValueRenderer kaAnnotationValueRenderer = this;
                StringBuilder stringBuilder2 = $this$renderType;
                Collection collection = ((KaUsualClassType)type2).getTypeArguments();
                String separator$iv = ", ";
                boolean $i$f$renderWithSeparator = false;
                Iterable $this$forEachIndexed$iv$iv = (Iterable)collection$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                    void typeProjection;
                    void $this$renderWithSeparator$iv;
                    void element$iv;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv$iv;
                    int index$iv = n;
                    boolean bl = false;
                    KaTypeProjection kaTypeProjection = (KaTypeProjection)element$iv;
                    void $this$renderType_u24lambda_u241 = $this$renderWithSeparator$iv;
                    boolean bl2 = false;
                    void var22_22 = typeProjection;
                    if (var22_22 instanceof KaStarTypeProjection) {
                        $this$renderType_u24lambda_u241.append('*');
                    } else if (var22_22 instanceof KaTypeArgumentWithVariance) {
                        INSTANCE.renderType((StringBuilder)$this$renderType_u24lambda_u241, ((KaTypeArgumentWithVariance)typeProjection).getType());
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    if (index$iv == collection$iv.size() - 1) continue;
                    $this$renderWithSeparator$iv.append(separator$iv);
                }
                $this$renderType.append('>');
            }
            object = Unit.INSTANCE;
        } else {
            object = object2 instanceof KaClassErrorType ? $this$renderType.append("UNRESOLVED_CLASS") : $this$renderType.append(type2);
        }
    }

    private final void renderConstantAnnotationValue(StringBuilder $this$renderConstantAnnotationValue, KaAnnotationValue.ConstantValue value2) {
        $this$renderConstantAnnotationValue.append(value2.getValue().render());
    }

    private final void renderEnumEntryConstantValue(StringBuilder $this$renderEnumEntryConstantValue, KaAnnotationValue.EnumEntryValue value2) {
        Object object = value2.getCallableId();
        $this$renderEnumEntryConstantValue.append(object != null && (object = ((CallableId)object).asSingleFqName()) != null ? ((FqName)object).asString() : null);
    }

    private final void renderAnnotationConstantValue(StringBuilder $this$renderAnnotationConstantValue, KaAnnotationValue.NestedAnnotationValue application) {
        this.renderAnnotationApplication($this$renderAnnotationConstantValue, application.getAnnotation());
    }

    private final void renderAnnotationApplication(StringBuilder $this$renderAnnotationApplication, KaAnnotation value2) {
        $this$renderAnnotationApplication.append(value2.getClassId());
        if (!((Collection)value2.getArguments()).isEmpty()) {
            $this$renderAnnotationApplication.append("(");
            this.renderNamedConstantValueList($this$renderAnnotationApplication, (Collection<? extends KaNamedAnnotationValue>)value2.getArguments());
            $this$renderAnnotationApplication.append(")");
        }
    }

    private final void renderArrayConstantValue(StringBuilder $this$renderArrayConstantValue, KaAnnotationValue.ArrayValue value2) {
        $this$renderArrayConstantValue.append("[");
        this.renderConstantValueList($this$renderArrayConstantValue, value2.getValues());
        $this$renderArrayConstantValue.append("]");
    }

    /*
     * WARNING - void declaration
     */
    private final void renderConstantValueList(StringBuilder $this$renderConstantValueList, Collection<? extends KaAnnotationValue> list) {
        KaAnnotationValueRenderer kaAnnotationValueRenderer = this;
        StringBuilder stringBuilder = $this$renderConstantValueList;
        String separator$iv = ", ";
        boolean $i$f$renderWithSeparator = false;
        Iterable $this$forEachIndexed$iv$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            void constantValue;
            void $this$renderWithSeparator$iv;
            void element$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int index$iv = n;
            boolean bl = false;
            KaAnnotationValue kaAnnotationValue = (KaAnnotationValue)element$iv;
            void $this$renderConstantValueList_u24lambda_u242 = $this$renderWithSeparator$iv;
            boolean bl2 = false;
            INSTANCE.renderConstantValue((StringBuilder)$this$renderConstantValueList_u24lambda_u242, (KaAnnotationValue)constantValue);
            if (index$iv == list.size() - 1) continue;
            $this$renderWithSeparator$iv.append(separator$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderNamedConstantValueList(StringBuilder $this$renderNamedConstantValueList, Collection<? extends KaNamedAnnotationValue> list) {
        KaAnnotationValueRenderer kaAnnotationValueRenderer = this;
        StringBuilder stringBuilder = $this$renderNamedConstantValueList;
        String separator$iv = ", ";
        boolean $i$f$renderWithSeparator = false;
        Iterable $this$forEachIndexed$iv$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            void namedValue;
            void $this$renderWithSeparator$iv;
            void element$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int index$iv = n;
            boolean bl = false;
            KaNamedAnnotationValue kaNamedAnnotationValue = (KaNamedAnnotationValue)element$iv;
            void $this$renderNamedConstantValueList_u24lambda_u243 = $this$renderWithSeparator$iv;
            boolean bl2 = false;
            $this$renderNamedConstantValueList_u24lambda_u243.append(namedValue.getName());
            $this$renderNamedConstantValueList_u24lambda_u243.append(" = ");
            INSTANCE.renderConstantValue((StringBuilder)$this$renderNamedConstantValueList_u24lambda_u243, namedValue.getExpression());
            $this$renderNamedConstantValueList_u24lambda_u243.append(", ");
            if (index$iv == list.size() - 1) continue;
            $this$renderWithSeparator$iv.append(separator$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <E> void renderWithSeparator(StringBuilder $this$renderWithSeparator, Collection<? extends E> collection, String separator, Function2<? super StringBuilder, ? super E, Unit> render2) {
        boolean $i$f$renderWithSeparator = false;
        Iterable $this$forEachIndexed$iv = collection;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int index2 = n;
            boolean bl = false;
            render2.invoke($this$renderWithSeparator, element);
            if (index2 == collection.size() - 1) continue;
            $this$renderWithSeparator.append(separator);
        }
    }
}

